/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.MouseInputAdapter;
import org.geotools.gui.swing.ExceptionMonitor;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.XMath;

class MouseReshapeTracker
extends MouseInputAdapter
implements Shape {
    private static final int MIN_WIDTH = 12;
    private static final int MIN_HEIGHT = 12;
    private static final int RESIZE_POS = 4;
    private static final double MINSIZE_RATIO = 1.25;
    private double xmin = Double.NEGATIVE_INFINITY;
    private double ymin = Double.NEGATIVE_INFINITY;
    private double xmax = Double.POSITIVE_INFINITY;
    private double ymax = Double.POSITIVE_INFINITY;
    private final RectangularShape logicalShape;
    private transient RectangularShape drawnShape;
    private final AffineTransform transform = new AffineTransform();
    private transient double mouseDX;
    private transient double mouseDY;
    private transient int x;
    private transient int y;
    private transient int width;
    private transient int height;
    private transient boolean mouseOverRect;
    private final transient Point2D.Double tmp = new Point2D.Double();
    private transient boolean isDragging;
    private transient int adjustingLogicalSides;
    private transient int adjustingSides;
    private int adjustableSides;
    private boolean moveable = true;
    private boolean synchronizeX;
    private boolean synchronizeY;
    private static final int NORTH = 1;
    private static final int SOUTH = 2;
    private static final int EAST = 4;
    private static final int WEST = 8;
    private static final int[] CURSORS = new int[]{13, 8, 9, 0, 11, 7, 5, 0, 10, 6, 4};
    private static final int[] SWING_TO_CUSTOM = new int[]{1, 1, 5, 2, 3, 4, 7, 8, 2, 5, 4, 6, 8, 9, 6, 10};
    private Control[] editors;

    public MouseReshapeTracker() {
        this(new Rectangle2D.Double());
    }

    public MouseReshapeTracker(RectangularShape shape) {
        this.logicalShape = shape;
        this.drawnShape = shape;
        this.update();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.drawnShape = this.logicalShape;
        this.update();
    }

    private void update() {
        this.adjustingLogicalSides = this.inverseTransform(this.adjustingSides);
        this.tmp.x = this.logicalShape.getWidth();
        this.tmp.y = this.logicalShape.getHeight();
        this.transform.deltaTransform(this.tmp, this.tmp);
        if (Math.abs(this.tmp.x) < 12.0 || Math.abs(this.tmp.y) < 12.0) {
            if (Math.abs(this.tmp.x) < 12.0) {
                double d = this.tmp.x = this.tmp.x < 0.0 ? -12.0 : 12.0;
            }
            if (Math.abs(this.tmp.y) < 12.0) {
                this.tmp.y = this.tmp.y < 0.0 ? -12.0 : 12.0;
            }
            try {
                XAffineTransform.inverseDeltaTransform((AffineTransform)this.transform, (Point2D)this.tmp, (Point2D)this.tmp);
                double x = this.logicalShape.getX();
                double y = this.logicalShape.getY();
                if ((this.adjustingLogicalSides & 8) != 0) {
                    x += this.logicalShape.getWidth() - this.tmp.x;
                }
                if ((this.adjustingLogicalSides & 1) != 0) {
                    y += this.logicalShape.getHeight() - this.tmp.y;
                }
                if (this.drawnShape == this.logicalShape) {
                    this.drawnShape = (RectangularShape)this.logicalShape.clone();
                }
                this.drawnShape.setFrame(x, y, this.tmp.x, this.tmp.y);
            }
            catch (NoninvertibleTransformException exception) {
                this.drawnShape = this.logicalShape;
            }
        } else {
            this.drawnShape = this.logicalShape;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 4; ++i) {
            this.tmp.x = (i & 1) == 0 ? this.drawnShape.getMinX() : this.drawnShape.getMaxX();
            this.tmp.y = (i & 2) == 0 ? this.drawnShape.getMinY() : this.drawnShape.getMaxY();
            this.transform.transform(this.tmp, this.tmp);
            if (this.tmp.x < xmin) {
                xmin = this.tmp.x;
            }
            if (this.tmp.x > xmax) {
                xmax = this.tmp.x;
            }
            if (this.tmp.y < ymin) {
                ymin = this.tmp.y;
            }
            if (!(this.tmp.y > ymax)) continue;
            ymax = this.tmp.y;
        }
        this.x = (int)Math.floor(xmin) - 1;
        this.y = (int)Math.floor(ymin) - 1;
        this.width = (int)Math.ceil(xmax - xmin) + 2;
        this.height = (int)Math.ceil(ymax - ymin) + 2;
    }

    private int inverseTransform(int adjusting) {
        switch (adjusting & 0xC) {
            case 8: {
                this.tmp.x = -1.0;
                break;
            }
            case 4: {
                this.tmp.x = 1.0;
                break;
            }
            default: {
                this.tmp.x = 0.0;
            }
        }
        switch (adjusting & 3) {
            case 1: {
                this.tmp.y = -1.0;
                break;
            }
            case 2: {
                this.tmp.y = 1.0;
                break;
            }
            default: {
                this.tmp.y = 0.0;
            }
        }
        try {
            XAffineTransform.inverseDeltaTransform((AffineTransform)this.transform, (Point2D)this.tmp, (Point2D)this.tmp);
            double normalize = 0.25 * XMath.hypot((double)this.tmp.x, (double)this.tmp.y);
            this.tmp.x /= normalize;
            this.tmp.y /= normalize;
            adjusting = 0;
            switch (XMath.sgn((double)Math.rint(this.tmp.x))) {
                case -1: {
                    adjusting |= 8;
                    break;
                }
                case 1: {
                    adjusting |= 4;
                }
            }
            switch (XMath.sgn((double)Math.rint(this.tmp.y))) {
                case -1: {
                    adjusting |= 1;
                    break;
                }
                case 1: {
                    adjusting |= 2;
                }
            }
            return adjusting;
        }
        catch (NoninvertibleTransformException exception) {
            return adjusting;
        }
    }

    public void setTransform(AffineTransform newTransform) {
        if (!this.transform.equals(newTransform)) {
            this.fireStateWillChange();
            this.transform.setTransform(newTransform);
            this.update();
            this.fireStateChanged();
        }
    }

    public Rectangle getBounds() {
        return this.drawnShape.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.drawnShape.getBounds2D();
    }

    public Rectangle2D getFrame() {
        return this.logicalShape.getFrame();
    }

    public final boolean setFrame(Rectangle2D frame) {
        return this.setFrame(frame.getX(), frame.getY(), frame.getWidth(), frame.getHeight());
    }

    public boolean setFrame(double x, double y, double width, double height) {
        double oldX = this.logicalShape.getX();
        double oldY = this.logicalShape.getY();
        double oldW = this.logicalShape.getWidth();
        double oldH = this.logicalShape.getHeight();
        if (x < this.xmin) {
            x = this.xmin;
        }
        if (y < this.ymin) {
            y = this.ymin;
        }
        if (x + width > this.xmax) {
            x = Math.max(this.xmin, this.xmax - width);
            width = this.xmax - x;
        }
        if (y + height > this.ymax) {
            y = Math.max(this.ymin, this.ymax - height);
            height = this.ymax - y;
        }
        this.fireStateWillChange();
        this.logicalShape.setFrame(x, y, width, height);
        if (oldX != this.logicalShape.getX() || oldY != this.logicalShape.getY() || oldW != this.logicalShape.getWidth() || oldH != this.logicalShape.getHeight()) {
            this.update();
            this.fireStateChanged();
            return true;
        }
        return false;
    }

    public final void setX(double min, double max) {
        this.setFrame(Math.min(min, max), this.logicalShape.getY(), Math.abs(max - min), this.logicalShape.getHeight());
    }

    public final void setY(double min, double max) {
        this.setFrame(this.logicalShape.getX(), Math.min(min, max), this.logicalShape.getWidth(), Math.abs(max - min));
    }

    public double getMinX() {
        return this.logicalShape.getMinX();
    }

    public double getMinY() {
        return this.logicalShape.getMinY();
    }

    public double getMaxX() {
        return this.logicalShape.getMaxX();
    }

    public double getMaxY() {
        return this.logicalShape.getMaxY();
    }

    public double getWidth() {
        return this.logicalShape.getWidth();
    }

    public double getHeight() {
        return this.logicalShape.getHeight();
    }

    public double getCenterX() {
        return this.logicalShape.getCenterX();
    }

    public double getCenterY() {
        return this.logicalShape.getCenterY();
    }

    public boolean isEmpty() {
        return this.logicalShape.isEmpty();
    }

    public boolean contains(Point2D point) {
        return this.logicalShape.contains(point);
    }

    public boolean contains(double x, double y) {
        return this.logicalShape.contains(x, y);
    }

    public boolean contains(Rectangle2D rect) {
        return this.logicalShape.contains(rect);
    }

    public boolean contains(double x, double y, double width, double height) {
        return this.logicalShape.contains(x, y, width, height);
    }

    public boolean intersects(Rectangle2D rect) {
        return this.drawnShape.intersects(rect);
    }

    public boolean intersects(double x, double y, double width, double height) {
        return this.drawnShape.intersects(x, y, width, height);
    }

    public PathIterator getPathIterator(AffineTransform transform) {
        return this.drawnShape.getPathIterator(transform);
    }

    public PathIterator getPathIterator(AffineTransform transform, double flatness) {
        return this.drawnShape.getPathIterator(transform, flatness);
    }

    public Rectangle2D getClip() {
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public final void setClip(Rectangle2D rect) {
        this.setClipMinMax(rect.getMinX(), rect.getMaxX(), rect.getMinY(), rect.getMaxY());
    }

    public final void setClip(double x, double y, double width, double height) {
        this.setClipMinMax(x, x + width, y, y + height);
    }

    public void setClipMinMax(double xmin, double xmax, double ymin, double ymax) {
        double tmp;
        if (xmin > xmax) {
            tmp = xmin;
            xmin = xmax;
            xmax = tmp;
        }
        if (ymin > ymax) {
            tmp = ymin;
            ymin = ymax;
            ymax = tmp;
        }
        if (!Double.isNaN(xmin)) {
            this.xmin = xmin;
        }
        if (!Double.isNaN(xmax)) {
            this.xmax = xmax;
        }
        if (!Double.isNaN(ymin)) {
            this.ymin = ymin;
        }
        if (!Double.isNaN(ymax)) {
            this.ymax = ymax;
        }
        this.setFrame(this.logicalShape.getX(), this.logicalShape.getY(), this.logicalShape.getWidth(), this.logicalShape.getHeight());
    }

    protected void clipChangeRequested(double xmin, double xmax, double ymin, double ymax) {
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean moveable) {
        this.moveable = moveable;
    }

    public boolean isAdjustable(int side) {
        return (this.adjustableSides & (side = this.convertSwingConstant(side))) == side;
    }

    public void setAdjustable(int side, boolean adjustable) {
        side = this.convertSwingConstant(side);
        this.adjustableSides = adjustable ? (this.adjustableSides |= side) : (this.adjustableSides &= ~side);
    }

    private int convertSwingConstant(int side) {
        for (int i = 0; i < SWING_TO_CUSTOM.length; i += 2) {
            if (SWING_TO_CUSTOM[i] != side) continue;
            return SWING_TO_CUSTOM[i + 1];
        }
        throw new IllegalArgumentException(String.valueOf(side));
    }

    public void mouseMoved(MouseEvent event) {
        Component source;
        if (!this.isDragging && (source = event.getComponent()) != null) {
            boolean mouseOverRectChanged;
            boolean mouseOverRect;
            int x = event.getX();
            this.tmp.x = x;
            int y = event.getY();
            this.tmp.y = y;
            try {
                mouseOverRect = this.drawnShape.contains(this.transform.inverseTransform(this.tmp, this.tmp));
            }
            catch (NoninvertibleTransformException exception) {
                return;
            }
            boolean bl = mouseOverRectChanged = mouseOverRect != this.mouseOverRect;
            if (mouseOverRect) {
                int old = this.adjustingSides;
                this.adjustingSides = 0;
                if (Math.abs(x -= this.x) <= 4) {
                    this.adjustingSides |= 8;
                }
                if (Math.abs(y -= this.y) <= 4) {
                    this.adjustingSides |= 1;
                }
                if (Math.abs(x - this.width) <= 4) {
                    this.adjustingSides |= 4;
                }
                if (Math.abs(y - this.height) <= 4) {
                    this.adjustingSides |= 2;
                }
                this.adjustingSides &= this.adjustableSides;
                if (this.adjustingSides != old || mouseOverRectChanged) {
                    if (this.adjustingSides == 0 && !this.moveable) {
                        source.setCursor(null);
                    } else {
                        this.adjustingLogicalSides = this.inverseTransform(this.adjustingSides);
                        source.setCursor(Cursor.getPredefinedCursor(this.adjustingSides < CURSORS.length ? CURSORS[this.adjustingSides] : 0));
                    }
                }
                if (mouseOverRectChanged) {
                    this.mouseOverRect = mouseOverRect;
                }
            } else if (mouseOverRectChanged) {
                this.adjustingSides = 0;
                source.setCursor(null);
                this.mouseOverRect = mouseOverRect;
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!e.isConsumed() && (e.getModifiers() & 0x10) != 0 && (this.adjustingSides != 0 || this.moveable)) {
            this.tmp.x = e.getX();
            this.tmp.y = e.getY();
            try {
                if (this.drawnShape.contains(this.transform.inverseTransform(this.tmp, this.tmp))) {
                    this.mouseDX = this.tmp.x - this.drawnShape.getX();
                    this.mouseDY = this.tmp.y - this.drawnShape.getY();
                    this.isDragging = true;
                    e.consume();
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isDragging) {
            int adjustingLogicalSides = this.adjustingLogicalSides;
            Component source = e.getComponent();
            if (source != null) {
                try {
                    double limit;
                    this.tmp.x = e.getX();
                    this.tmp.y = e.getY();
                    this.transform.inverseTransform(this.tmp, this.tmp);
                    double x0 = this.tmp.x - this.mouseDX;
                    double y0 = this.tmp.y - this.mouseDY;
                    double dx = this.drawnShape.getWidth();
                    double dy = this.drawnShape.getHeight();
                    double oldWidth = dx;
                    double oldHeight = dy;
                    switch (adjustingLogicalSides & 0xC) {
                        case 8: {
                            if (x0 < this.xmin) {
                                x0 = this.xmin;
                            }
                            if ((dx += this.drawnShape.getX() - x0) > 0.0) break;
                            dx = this.drawnShape.getWidth();
                            x0 = this.drawnShape.getX();
                            break;
                        }
                        case 4: {
                            double d = x0;
                            x0 = this.drawnShape.getX();
                            dx += d - x0;
                            limit = this.xmax - x0;
                            if (dx > limit) {
                                dx = limit;
                            }
                            if (dx > 0.0) break;
                            dx = this.drawnShape.getWidth();
                            x0 = this.drawnShape.getX();
                            break;
                        }
                    }
                    switch (adjustingLogicalSides & 3) {
                        case 1: {
                            if (y0 < this.ymin) {
                                y0 = this.ymin;
                            }
                            if ((dy += this.drawnShape.getY() - y0) > 0.0) break;
                            dy = this.drawnShape.getHeight();
                            y0 = this.drawnShape.getY();
                            break;
                        }
                        case 2: {
                            double d = y0;
                            y0 = this.drawnShape.getY();
                            dy += d - y0;
                            limit = this.ymax - y0;
                            if (dy > limit) {
                                dy = limit;
                            }
                            if (dy > 0.0) break;
                            dy = this.drawnShape.getHeight();
                            y0 = this.drawnShape.getY();
                            break;
                        }
                    }
                    if ((adjustingLogicalSides & 3) != 0 && (adjustingLogicalSides & 0xC) == 0) {
                        x0 = this.drawnShape.getX();
                        dx = this.drawnShape.getWidth();
                    }
                    if ((adjustingLogicalSides & 3) == 0 && (adjustingLogicalSides & 0xC) != 0) {
                        y0 = this.drawnShape.getY();
                        dy = this.drawnShape.getHeight();
                    }
                    if (adjustingLogicalSides == 0) {
                        double old_dx = this.logicalShape.getWidth();
                        double old_dy = this.logicalShape.getHeight();
                        x0 += (dx - old_dx) / 2.0;
                        y0 += (dy - old_dy) / 2.0;
                        dx = old_dx;
                        dy = old_dy;
                    }
                    source.repaint(this.x, this.y, this.width, this.height);
                    try {
                        this.setFrame(x0, y0, dx, dy);
                    }
                    catch (RuntimeException exception) {
                        exception.printStackTrace();
                    }
                    source.repaint(this.x, this.y, this.width, this.height);
                    if ((adjustingLogicalSides & 4) != 0) {
                        this.mouseDX += this.drawnShape.getWidth() - oldWidth;
                    }
                    if ((adjustingLogicalSides & 2) != 0) {
                        this.mouseDY += this.drawnShape.getHeight() - oldHeight;
                    }
                }
                catch (NoninvertibleTransformException exception) {
                    // empty catch block
                }
            }
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.isDragging && (event.getModifiers() & 0x10) != 0) {
            this.isDragging = false;
            Component source = event.getComponent();
            try {
                this.tmp.x = event.getX();
                this.tmp.y = event.getY();
                this.mouseOverRect = this.drawnShape.contains(this.transform.inverseTransform(this.tmp, this.tmp));
                if (!this.mouseOverRect && source != null) {
                    source.setCursor(null);
                }
                event.consume();
            }
            catch (NoninvertibleTransformException exception) {
                // empty catch block
            }
            try {
                this.fireStateChanged();
            }
            catch (RuntimeException exception) {
                ExceptionMonitor.show(source, exception);
            }
        }
    }

    protected void stateWillChange(boolean isAdjusting) {
    }

    protected void stateChanged(boolean isAdjusting) {
    }

    private void fireStateWillChange() {
        this.stateWillChange(this.isDragging);
    }

    private void fireStateChanged() {
        this.updateEditors();
        this.stateChanged(this.isDragging);
    }

    public void updateEditors() {
        if (this.editors != null) {
            for (int i = 0; i < this.editors.length; ++i) {
                this.editors[i].updateText();
            }
        }
    }

    public synchronized JComponent addEditor(Format format, int side, Component toRepaint) throws IllegalArgumentException {
        JComponent component;
        JFormattedTextField editor;
        JSpinner spinner;
        AbstractSpinnerModel model;
        if (format instanceof DecimalFormat) {
            model = new SpinnerNumberModel();
            spinner = new JSpinner(model);
            JSpinner.NumberEditor sedt = (JSpinner.NumberEditor)spinner.getEditor();
            DecimalFormat targetFormat = sedt.getFormat();
            DecimalFormat sourceFormat = (DecimalFormat)format;
            targetFormat.setDecimalFormatSymbols(sourceFormat.getDecimalFormatSymbols());
            targetFormat.applyPattern(sourceFormat.toPattern());
            editor = sedt.getTextField();
            component = spinner;
        } else if (format instanceof SimpleDateFormat) {
            model = new SpinnerDateModel();
            spinner = new JSpinner(model);
            JSpinner.DateEditor sedt = (JSpinner.DateEditor)spinner.getEditor();
            SimpleDateFormat targetFormat = sedt.getFormat();
            SimpleDateFormat sourceFormat = (SimpleDateFormat)format;
            targetFormat.setDateFormatSymbols(sourceFormat.getDateFormatSymbols());
            targetFormat.applyPattern(sourceFormat.toPattern());
            editor = sedt.getTextField();
            component = spinner;
        } else {
            component = editor = new JFormattedTextField(format);
        }
        editor.setColumns(5);
        editor.setHorizontalAlignment(4);
        Insets insets = editor.getMargin();
        insets.right += 2;
        editor.setMargin(insets);
        Control control = new Control(editor, format instanceof DateFormat, this.convertSwingConstant(side), toRepaint);
        this.editors = this.editors == null ? new Control[1] : (Control[])XArray.resize((Object[])this.editors, (int)(this.editors.length + 1));
        this.editors[this.editors.length - 1] = control;
        return component;
    }

    public synchronized void removeEditor(JComponent editor) {
        if (this.editors != null) {
            for (int i = 0; i < this.editors.length; ++i) {
                if (this.editors[i].editor != editor) continue;
                this.editors = (Control[])XArray.remove((Object[])this.editors, (int)i, (int)1);
            }
            if (this.editors.length == 0) {
                this.editors = null;
            }
        }
    }

    public void setEditorsSynchronized(int axis, boolean state) throws IllegalArgumentException {
        switch (axis) {
            case 0: {
                this.synchronizeX = state;
                break;
            }
            case 1: {
                this.synchronizeY = state;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean isEditorsSynchronized(int axis) throws IllegalArgumentException {
        switch (axis) {
            case 0: {
                return this.synchronizeX;
            }
            case 1: {
                return this.synchronizeY;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return Utilities.getShortClassName((Object)this) + '[' + Utilities.getShortClassName((Object)this.logicalShape) + ']';
    }

    private final class Control
    implements PropertyChangeListener {
        public final JFormattedTextField editor;
        private final boolean isDate;
        private final int side;
        private final Component toRepaint;

        public Control(JFormattedTextField editor, boolean isDate, int side, Component toRepaint) {
            this.editor = editor;
            this.isDate = isDate;
            this.side = side;
            this.toRepaint = toRepaint;
            this.updateText(editor);
            editor.addPropertyChangeListener("value", this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            Object source = event.getSource();
            if (source instanceof JFormattedTextField) {
                JFormattedTextField editor = (JFormattedTextField)source;
                Object value = editor.getValue();
                if (value != null) {
                    double v;
                    double d = v = value instanceof Date ? (double)((Date)value).getTime() : ((Number)value).doubleValue();
                    if (!Double.isNaN(v)) {
                        double margin;
                        double dy;
                        double dx;
                        double Vymax;
                        int side = MouseReshapeTracker.this.inverseTransform(this.side);
                        double Vxmin = (side & 8) == 0 ? MouseReshapeTracker.this.logicalShape.getMinX() : v;
                        double Vxmax = (side & 4) == 0 ? MouseReshapeTracker.this.logicalShape.getMaxX() : v;
                        double Vymin = (side & 1) == 0 ? MouseReshapeTracker.this.logicalShape.getMinY() : v;
                        double d2 = Vymax = (side & 2) == 0 ? MouseReshapeTracker.this.logicalShape.getMaxY() : v;
                        if (MouseReshapeTracker.this.synchronizeX || Vxmin > Vxmax) {
                            dx = MouseReshapeTracker.this.logicalShape.getWidth();
                            if ((side & 8) != 0) {
                                Vxmax = Vxmin + dx;
                            }
                            if ((side & 4) != 0) {
                                Vxmin = Vxmax - dx;
                            }
                        }
                        if (MouseReshapeTracker.this.synchronizeY || Vymin > Vymax) {
                            dy = MouseReshapeTracker.this.logicalShape.getHeight();
                            if ((side & 1) != 0) {
                                Vymax = Vymin + dy;
                            }
                            if ((side & 2) != 0) {
                                Vymin = Vymax - dy;
                            }
                        }
                        if (Vxmin < MouseReshapeTracker.this.xmin) {
                            dx = Math.max(MouseReshapeTracker.this.xmax - MouseReshapeTracker.this.xmin, 1.25 * (Vxmax - Vxmin));
                            margin = Vxmax + dx * 0.125;
                            MouseReshapeTracker.this.clipChangeRequested(margin - dx, margin, MouseReshapeTracker.this.ymin, MouseReshapeTracker.this.ymax);
                        } else if (Vxmax > MouseReshapeTracker.this.xmax) {
                            dx = Math.max(MouseReshapeTracker.this.xmax - MouseReshapeTracker.this.xmin, 1.25 * (Vxmax - Vxmin));
                            margin = Vxmin - dx * 0.125;
                            MouseReshapeTracker.this.clipChangeRequested(margin, margin + dx, MouseReshapeTracker.this.ymin, MouseReshapeTracker.this.ymax);
                        }
                        if (Vymin < MouseReshapeTracker.this.ymin) {
                            dy = Math.max(MouseReshapeTracker.this.ymax - MouseReshapeTracker.this.ymin, 1.25 * (Vymax - Vymin));
                            margin = Vymax + dy * 0.125;
                            MouseReshapeTracker.this.clipChangeRequested(MouseReshapeTracker.this.xmin, MouseReshapeTracker.this.xmax, margin - dy, margin);
                        } else if (Vymax > MouseReshapeTracker.this.ymax) {
                            dy = Math.max(MouseReshapeTracker.this.ymax - MouseReshapeTracker.this.ymin, 1.25 * (Vymax - Vymin));
                            margin = Vymin - dy * 0.125;
                            MouseReshapeTracker.this.clipChangeRequested(MouseReshapeTracker.this.xmin, MouseReshapeTracker.this.xmax, margin, margin + dy);
                        }
                        if (MouseReshapeTracker.this.setFrame(Vxmin, Vymin, Vxmax - Vxmin, Vymax - Vymin) && this.toRepaint != null) {
                            this.toRepaint.repaint();
                        }
                    }
                }
                this.updateText(editor);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void updateText(JFormattedTextField editor) {
            String text;
            if (!MouseReshapeTracker.this.logicalShape.isEmpty() || (text = editor.getText()) != null && text.trim().length() != 0) {
                void var3_3;
                switch (MouseReshapeTracker.this.inverseTransform(this.side)) {
                    case 1: {
                        double value = MouseReshapeTracker.this.logicalShape.getMinY();
                        break;
                    }
                    case 2: {
                        double value = MouseReshapeTracker.this.logicalShape.getMaxY();
                        break;
                    }
                    case 8: {
                        double value = MouseReshapeTracker.this.logicalShape.getMinX();
                        break;
                    }
                    case 4: {
                        double value = MouseReshapeTracker.this.logicalShape.getMaxX();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                editor.setValue(this.isDate ? new Date(Math.round((double)var3_3)) : new Double((double)var3_3));
            }
        }

        public void updateText() {
            this.updateText(this.editor);
        }
    }
}

