/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.event.MouseInputAdapter;

abstract class MouseSelectionTracker
extends MouseInputAdapter {
    private transient RectangularShape mouseSelectedArea;
    private Color backXORColor = Color.white;
    private Color lineXORColor = Color.black;
    private transient int ox;
    private transient int oy;
    private transient int px;
    private transient int py;
    private transient boolean isDragging;

    public void setXORColors(Color a, Color b) {
        this.backXORColor = a;
        this.lineXORColor = b;
    }

    protected Shape getModel(MouseEvent event) {
        return new Rectangle();
    }

    protected abstract void selectionPerformed(int var1, int var2, int var3, int var4);

    public Shape getSelectedArea(AffineTransform transform) throws NoninvertibleTransformException {
        if (this.ox == this.px && this.oy == this.py) {
            return null;
        }
        RectangularShape shape = this.mouseSelectedArea;
        if (transform != null && !transform.isIdentity()) {
            if (shape == null) {
                Point2D.Float po = new Point2D.Float(this.ox, this.oy);
                Point2D.Float pp = new Point2D.Float(this.px, this.py);
                transform.inverseTransform(po, po);
                transform.inverseTransform(pp, pp);
                return new Line2D.Float(po, pp);
            }
            if (MouseSelectionTracker.canReshape(shape, transform)) {
                Point2D.Double point = new Point2D.Double();
                double xmin = Double.POSITIVE_INFINITY;
                double ymin = Double.POSITIVE_INFINITY;
                double xmax = Double.NEGATIVE_INFINITY;
                double ymax = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < 4; ++i) {
                    point.x = (i & 1) == 0 ? shape.getMinX() : shape.getMaxX();
                    point.y = (i & 2) == 0 ? shape.getMinY() : shape.getMaxY();
                    transform.inverseTransform(point, point);
                    if (point.x < xmin) {
                        xmin = point.x;
                    }
                    if (point.x > xmax) {
                        xmax = point.x;
                    }
                    if (point.y < ymin) {
                        ymin = point.y;
                    }
                    if (!(point.y > ymax)) continue;
                    ymax = point.y;
                }
                if (shape instanceof Rectangle) {
                    return new Rectangle2D.Float((float)xmin, (float)ymin, (float)(xmax - xmin), (float)(ymax - ymin));
                }
                shape = (RectangularShape)shape.clone();
                shape.setFrame(xmin, ymin, xmax - xmin, ymax - ymin);
                return shape;
            }
            return transform.createInverse().createTransformedShape(shape);
        }
        return shape != null ? (Shape)shape.clone() : new Line2D.Float(this.ox, this.oy, this.px, this.py);
    }

    private static boolean canReshape(RectangularShape shape, AffineTransform transform) {
        int type = transform.getType();
        if ((type & 0x20) != 0) {
            return false;
        }
        if ((type & 0x18) != 0) {
            return false;
        }
        if ((type & 0x40) != 0) {
            if (shape instanceof Rectangle2D) {
                return true;
            }
            if (shape instanceof Ellipse2D) {
                return true;
            }
            return shape instanceof RoundRectangle2D;
        }
        return true;
    }

    private Graphics2D getGraphics(Component c) {
        Graphics2D graphics = (Graphics2D)c.getGraphics();
        graphics.setXORMode(this.lineXORColor);
        graphics.setColor(this.backXORColor);
        return graphics;
    }

    public void mousePressed(MouseEvent event) throws ClassCastException {
        Component source;
        if (!event.isConsumed() && (event.getModifiers() & 0x10) != 0 && (source = event.getComponent()) != null) {
            Shape model = this.getModel(event);
            if (model != null) {
                this.isDragging = true;
                this.ox = this.px = event.getX();
                this.oy = this.py = event.getY();
                if (model instanceof Line2D) {
                    model = null;
                }
                this.mouseSelectedArea = (RectangularShape)model;
                if (this.mouseSelectedArea != null) {
                    this.mouseSelectedArea.setFrame(this.ox, this.oy, 0.0, 0.0);
                }
                source.addMouseMotionListener(this);
            }
            source.requestFocus();
            event.consume();
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (this.isDragging) {
            Graphics2D graphics = this.getGraphics(event.getComponent());
            if (this.mouseSelectedArea == null) {
                graphics.drawLine(this.ox, this.oy, this.px, this.py);
                this.px = event.getX();
                this.py = event.getY();
                graphics.drawLine(this.ox, this.oy, this.px, this.py);
            } else {
                graphics.draw(this.mouseSelectedArea);
                int xmin = this.ox;
                int ymin = this.oy;
                int xmax = this.px = event.getX();
                int ymax = this.py = event.getY();
                if (xmin > xmax) {
                    int xtmp = xmin;
                    xmin = xmax;
                    xmax = xtmp;
                }
                if (ymin > ymax) {
                    int ytmp = ymin;
                    ymin = ymax;
                    ymax = ytmp;
                }
                this.mouseSelectedArea.setFrame(xmin, ymin, xmax - xmin, ymax - ymin);
                graphics.draw(this.mouseSelectedArea);
            }
            graphics.dispose();
            event.consume();
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.isDragging && (event.getModifiers() & 0x10) != 0) {
            this.isDragging = false;
            Component component = event.getComponent();
            component.removeMouseMotionListener(this);
            Graphics2D graphics = this.getGraphics(event.getComponent());
            if (this.mouseSelectedArea == null) {
                graphics.drawLine(this.ox, this.oy, this.px, this.py);
            } else {
                graphics.draw(this.mouseSelectedArea);
            }
            graphics.dispose();
            this.px = event.getX();
            this.py = event.getY();
            this.selectionPerformed(this.ox, this.oy, this.px, this.py);
            event.consume();
        }
    }

    public void mouseMoved(MouseEvent event) {
        event.getComponent().removeMouseMotionListener(this);
    }
}

