/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationNode;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.PerspectiveTransform;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.util.Range;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.JTextComponent;
import org.geotools.gui.swing.image.KernelEditor;
import org.geotools.measure.Angle;
import org.geotools.measure.AngleFormat;
import org.geotools.resources.Utilities;
import org.geotools.resources.XMath;
import org.geotools.resources.i18n.Vocabulary;

public class ParameterEditor
extends JPanel {
    private static final String STRING = "String";
    private static final String BOOLEAN = "Boolean";
    private static final String NUMBER = "Number";
    private static final String ANGLE = "Angle";
    private static final String DATE = "Date";
    private static final String KERNEL = "Kernel";
    private static final String TABLE = "Table";
    private static final String DEFAULT = "Default";
    private final Map editors = new HashMap();
    private final Container cards = new JPanel(new CardLayout());
    private final JLabel description = new JLabel(" ", 0);
    private Object value;
    private Component editor;
    private Editor model;
    private static final boolean editable = false;
    static /* synthetic */ Class class$java$lang$Integer;

    public ParameterEditor() {
        super(new BorderLayout());
        this.description.setBorder(BorderFactory.createCompoundBorder(this.description.getBorder(), BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 9, 6, 9), BorderFactory.createLineBorder(this.description.getForeground())), BorderFactory.createEmptyBorder(6, 0, 6, 0))));
        this.add((Component)this.description, "North");
        this.add((Component)this.cards, "Center");
        this.setPreferredSize(new Dimension(400, 250));
    }

    public Object getParameterValue() {
        return this.model != null ? this.model.getValue() : this.value;
    }

    public void setParameterValue(Object value) {
        Object oldValue = this.value;
        if (!Utilities.equals((Object)value, (Object)oldValue)) {
            this.value = value;
            this.updateEditor();
            this.firePropertyChange("value", oldValue, value);
        }
    }

    public String getDescription() {
        String text = this.description.getText();
        if (text != null && (text = text.trim()).length() == 0) {
            text = null;
        }
        return text;
    }

    public void setDescription(String description) {
        if (description == null || description.length() == 0) {
            description = " ";
        }
        this.description.setText(description);
        if (this.model != null) {
            this.model.setValueRange(null, null);
        }
    }

    public void setDescription(OperationNode operation, int index) {
        String description = null;
        Class type = null;
        Range range = null;
        if (operation != null) {
            String name = operation.getOperationName();
            String mode = operation.getRegistryModeName();
            RegistryElementDescriptor element = operation.getRegistry().getDescriptor(mode, name);
            ParameterListDescriptor param = element.getParameterListDescriptor(mode);
            if (index >= 0 && index < param.getNumParameters()) {
                type = param.getParamClasses()[index];
                range = param.getParamValueRange(param.getParamNames()[index]);
            }
            if (element instanceof OperationDescriptor) {
                OperationDescriptor descriptor = (OperationDescriptor)element;
                ResourceBundle resources = descriptor.getResourceBundle(this.getLocale());
                String key = index >= 0 ? "arg" + index + "Desc" : "Description";
                try {
                    description = resources.getString(key);
                }
                catch (MissingResourceException ignore) {
                    try {
                        description = resources.getString("Description");
                    }
                    catch (MissingResourceException exception) {
                        Logger.getLogger("org.geotools.gui.swing").log(Level.FINE, exception.getLocalizedMessage(), exception);
                    }
                }
            }
        }
        this.setDescription(description);
        if (this.model != null) {
            this.model.setValueRange(type, range);
        }
    }

    public Component getEditor() {
        return this.editor;
    }

    private Component getEditor(String name) {
        Component panel = (Component)this.editors.get(name);
        ((CardLayout)this.cards.getLayout()).show(this.cards, name);
        return panel;
    }

    private void addEditor(String name, Component editor, boolean scroll) {
        if (this.editors.put(name, editor) != null) {
            throw new IllegalStateException(name);
        }
        if (scroll) {
            editor = new JScrollPane(editor);
        }
        this.cards.add(editor, name);
        ((CardLayout)this.cards.getLayout()).show(this.cards, name);
    }

    /*
     * WARNING - void declaration
     */
    private void updateEditor() {
        JComponent editor;
        Class<?> elementClass;
        Object value = this.value;
        while (value != null && value.getClass().isArray() && Array.getLength(value) == 1) {
            value = Array.get(value, 0);
        }
        if (value instanceof String) {
            Singleton editor2 = (Singleton)this.getEditor(STRING);
            if (editor2 == null) {
                editor2 = new Singleton(null);
                this.addEditor(STRING, editor2, false);
            }
            editor2.setValue(value);
            this.editor = editor2.field;
            this.model = editor2;
            return;
        }
        if (value instanceof Boolean) {
            Singleton editor3 = (Singleton)this.getEditor(BOOLEAN);
            if (editor3 == null) {
                editor3 = new Singleton(null);
                this.addEditor(BOOLEAN, editor3, false);
            }
            editor3.setValue(value);
            this.editor = editor3.field;
            this.model = editor3;
            return;
        }
        if (value instanceof Number) {
            Singleton editor4 = (Singleton)this.getEditor(NUMBER);
            if (editor4 == null) {
                editor4 = new Singleton(NumberFormat.getInstance(this.getLocale()));
                this.addEditor(NUMBER, editor4, false);
            }
            editor4.setValue(value);
            this.editor = editor4.field;
            this.model = editor4;
            return;
        }
        if (value instanceof Date) {
            Singleton editor5 = (Singleton)this.getEditor(DATE);
            if (editor5 == null) {
                editor5 = new Singleton(DateFormat.getDateTimeInstance(1, 1, this.getLocale()));
                this.addEditor(DATE, editor5, false);
            }
            editor5.setValue(value);
            this.editor = editor5.field;
            this.model = editor5;
            return;
        }
        if (value instanceof Angle) {
            Singleton editor6 = (Singleton)this.getEditor(ANGLE);
            if (editor6 == null) {
                editor6 = new Singleton((Format)new AngleFormat("D\u00b0MM.mm'", this.getLocale()));
                this.addEditor(ANGLE, editor6, false);
            }
            editor6.setValue(value);
            this.editor = editor6.field;
            this.model = editor6;
            return;
        }
        if (value instanceof AffineTransform) {
            AffineTransform transform = (AffineTransform)value;
            value = new double[][]{{transform.getScaleX(), transform.getShearX(), transform.getTranslateX()}, {transform.getShearY(), transform.getScaleY(), transform.getTranslateY()}, {0.0, 0.0, 1.0}};
        }
        if (value instanceof PerspectiveTransform) {
            double[][] matrix = new double[][]{new double[3], new double[3], new double[3]};
            ((PerspectiveTransform)value).getMatrix((double[][])matrix);
            value = matrix;
        }
        if (value != null && (elementClass = value.getClass().getComponentType()) != null) {
            AbstractTableModel model = elementClass.isArray() ? new Matrix((Object[])value) : new Table(new Object[]{value}, 0, false);
            JTable editor7 = (JTable)this.getEditor(TABLE);
            if (editor7 == null) {
                editor7 = new JTable(model);
                this.addEditor(TABLE, editor7, true);
            } else {
                editor7.setModel(model);
            }
            this.editor = editor7;
            this.model = model;
            return;
        }
        if (value instanceof LookupTableJAI) {
            void var3_9;
            LookupTableJAI table = (LookupTableJAI)value;
            boolean unsigned = false;
            switch (table.getDataType()) {
                case 0: {
                    Object data = table.getByteData();
                    unsigned = true;
                    break;
                }
                case 1: {
                    unsigned = true;
                }
                case 2: {
                    Object data = table.getShortData();
                    break;
                }
                case 3: {
                    Object data = table.getIntData();
                    break;
                }
                case 4: {
                    Object data = table.getFloatData();
                    break;
                }
                case 5: {
                    Object data = table.getDoubleData();
                    break;
                }
                default: {
                    this.editor = null;
                    this.model = null;
                    return;
                }
            }
            Table model = new Table((Object[])var3_9, table.getOffset(), unsigned);
            JTable editor8 = (JTable)this.getEditor(TABLE);
            if (editor8 == null) {
                editor8 = new JTable(model);
                this.addEditor(TABLE, editor8, true);
            } else {
                editor8.setModel(model);
            }
            this.editor = editor8;
            this.model = model;
            return;
        }
        if (value instanceof KernelJAI) {
            editor = (KernelEditor)this.getEditor(KERNEL);
            if (editor == null) {
                editor = new KernelEditor();
                ((KernelEditor)editor).addDefaultKernels();
                this.addEditor(KERNEL, editor, false);
            }
            ((KernelEditor)editor).setKernel((KernelJAI)value);
            this.editor = editor;
            this.model = null;
            return;
        }
        editor = (JTextArea)this.getEditor(DEFAULT);
        if (editor == null) {
            editor = new JTextArea();
            this.addEditor(DEFAULT, editor, true);
            ((JTextComponent)editor).setEditable(false);
        }
        ((JTextComponent)editor).setText(String.valueOf(value));
        this.editor = editor;
        this.model = null;
    }

    private static final class Matrix
    extends AbstractTableModel
    implements Editor {
        private final Object[] matrix;

        public Matrix(Object[] matrix) {
            this.matrix = matrix;
        }

        public int getRowCount() {
            return this.matrix.length;
        }

        public int getColumnCount() {
            int count = 0;
            for (int i = 0; i < this.matrix.length; ++i) {
                int length = Array.getLength(this.matrix[i]);
                if (length <= count) continue;
                count = length;
            }
            return count;
        }

        public String getColumnName(int index) {
            return Integer.toString(index);
        }

        public Class getColumnClass(int index) {
            return XMath.primitiveToWrapper(this.matrix.getClass().getComponentType().getComponentType());
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            Object array = this.matrix[row];
            return column < Array.getLength(array) ? Array.get(array, column) : null;
        }

        public void setValueAt(Object value, int row, int column) {
            Array.set(this.matrix[row], column, value);
        }

        public Object getValue() {
            return this.matrix;
        }

        public void setValueRange(Class type, Range range) {
        }
    }

    private static final class Table
    extends AbstractTableModel
    implements Editor {
        private final Object[] table;
        private final int offset;
        private final boolean unsigned;

        public Table(Object[] table, int offset, boolean unsigned) {
            this.table = table;
            this.offset = offset;
            this.unsigned = unsigned;
        }

        public int getRowCount() {
            int count = 0;
            for (int i = 0; i < this.table.length; ++i) {
                int length = Array.getLength(this.table[i]);
                if (length <= count) continue;
                count = length;
            }
            return count;
        }

        public int getColumnCount() {
            return Array.getLength(this.table) + 1;
        }

        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return Vocabulary.format((int)76);
                }
            }
            return Vocabulary.format((int)182);
        }

        public Class getColumnClass(int index) {
            if (index == 0 || this.unsigned) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterEditor.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            return XMath.primitiveToWrapper(this.table[index - 1].getClass().getComponentType());
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return new Integer(row + this.offset);
            }
            Object array = this.table[column - 1];
            if (this.unsigned) {
                return new Integer(Array.getInt(array, row) & Integer.MAX_VALUE);
            }
            return Array.get(array, row);
        }

        public void setValueAt(Object value, int row, int column) {
            Array.set(this.table[column - 1], row, value);
        }

        public Object getValue() {
            return this.table;
        }

        public void setValueRange(Class type, Range range) {
        }
    }

    private static final class Singleton
    extends JPanel
    implements Editor {
        private final JLabel type = new JLabel();
        private final JLabel minimum = new JLabel();
        private final JLabel maximum = new JLabel();
        private final JTextField field;

        public Singleton(Format format) {
            super(new GridBagLayout());
            this.field = format != null ? new JFormattedTextField(format) : new JTextField();
            this.field.setEditable(false);
            Vocabulary resources = Vocabulary.getResources((Locale)this.getLocale());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridwidth = 1;
            c.insets.left = 9;
            c.fill = 2;
            c.gridy = 0;
            this.add((Component)new JLabel(resources.getLabel(174)), c);
            ++c.gridy;
            this.add((Component)new JLabel(resources.getLabel(106)), c);
            ++c.gridy;
            this.add((Component)new JLabel(resources.getLabel(101)), c);
            ++c.gridy;
            this.add((Component)new JLabel(resources.getLabel(182)), c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.insets.right = 9;
            c.gridy = 0;
            this.add((Component)this.type, c);
            ++c.gridy;
            this.add((Component)this.minimum, c);
            ++c.gridy;
            this.add((Component)this.maximum, c);
            ++c.gridy;
            this.add((Component)this.field, c);
        }

        public void setValue(Object value) {
            if (this.field instanceof JFormattedTextField) {
                ((JFormattedTextField)this.field).setValue(value);
            } else {
                this.field.setText(String.valueOf(value));
            }
        }

        public Object getValue() {
            if (this.field instanceof JFormattedTextField) {
                return ((JFormattedTextField)this.field).getValue();
            }
            return this.field.getText();
        }

        public void setValueRange(Class classe, Range range) {
            String type = null;
            String minimum = null;
            String maximum = null;
            if (classe != null) {
                while (classe.isArray()) {
                    classe = classe.getComponentType();
                }
                classe = XMath.primitiveToWrapper((Class)classe);
                boolean isInteger = false;
                type = XMath.isReal((Class)classe) || (isInteger = XMath.isInteger((Class)classe)) ? Vocabulary.format((int)(isInteger ? 150 : 136), (Object)new Integer(XMath.getBitCount((Class)classe))) : Utilities.getShortName((Class)classe);
            }
            if (range != null) {
                minimum = this.format(range.getMinValue());
                maximum = this.format(range.getMaxValue());
            }
            this.type.setText(type);
            this.minimum.setText(minimum);
            this.maximum.setText(maximum);
        }

        private String format(Comparable value) {
            if (value == null) {
                return null;
            }
            if (this.field instanceof JFormattedTextField) {
                try {
                    return ((JFormattedTextField)this.field).getFormatter().valueToString(value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return value.toString();
        }
    }

    private static interface Editor {
        public Object getValue();

        public void setValueRange(Class var1, Range var2);
    }
}

