/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.geotools.gui.swing.DeformableViewer;
import org.geotools.gui.swing.MouseReshapeTracker;
import org.geotools.gui.swing.MouseSelectionTracker;
import org.geotools.gui.swing.event.ZoomChangeEvent;
import org.geotools.gui.swing.event.ZoomChangeListener;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.Utilities;
import org.geotools.resources.geometry.XDimension2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;

public abstract class ZoomPane
extends JComponent
implements DeformableViewer {
    private static final int MINIMUM_SIZE = 10;
    private static final int DEFAULT_SIZE = 400;
    private static final int DEFAULT_MAGNIFIER_SIZE = 150;
    private static final Paint DEFAULT_MAGNIFIER_GLASS = new Color(197, 204, 221);
    private static final Paint DEFAULT_MAGNIFIER_BORDER = new Color(102, 102, 153);
    public static final int SCALE_X = 1;
    public static final int SCALE_Y = 2;
    public static final int UNIFORM_SCALE = 7;
    public static final int TRANSLATE_X = 8;
    public static final int TRANSLATE_Y = 16;
    public static final int ROTATE = 32;
    public static final int RESET = 64;
    public static final int DEFAULT_ZOOM = 128;
    private static final int MASK = 255;
    private static final double AMOUNT_TRANSLATE = 10.0;
    private static final double AMOUNT_SCALE = 1.03125;
    private static final double AMOUNT_ROTATE = Math.PI / 90;
    private static final double ENHANCEMENT_FACTOR = 7.5;
    private static final int IS_PAINTING = 0;
    private static final int IS_PAINTING_MAGNIFIER = 1;
    private static final int IS_PRINTING = 2;
    private static final String[] ACTION_ID = new String[]{"Left", "Right", "Up", "Down", "ZoomIn", "ZoomOut", "ZoomMax", "Reset", "RotateLeft", "RotateRight"};
    private static final int[] RESOURCE_ID = new int[]{86, 140, 179, 33, 190, 192, 191, 139, 141, 142};
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gui.swing");
    private static final int[] ACTION_KEY = new int[]{37, 0, 39, 0, 38, 0, 40, 0, 33, 0, 34, 0, 35, 0, 36, 0, 37, 2, 39, 2};
    private static final short[] ACTION_TYPE = new short[]{8, 8, 16, 16, 3, 3, 128, 64, 32, 32};
    private static final double[] ACTION_AMOUNT = new double[]{10.0, -10.0, 10.0, -10.0, 1.03125, 0.9696969696969697, Double.NaN, Double.NaN, -Math.PI / 90, Math.PI / 90};
    private static final int[] GROUP = new int[]{24, 195, 32};
    private static final ComponentUI UI = new ComponentUI(){

        public Dimension getMinimumSize(JComponent c) {
            return new Dimension(10, 10);
        }

        public Dimension getMaximumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        public Dimension getPreferredSize(JComponent c) {
            return ((ZoomPane)c).getDefaultSize();
        }

        public void update(Graphics g, JComponent c) {
            switch (((ZoomPane)c).flag) {
                case 1: {
                    this.paint(g, c);
                    break;
                }
                default: {
                    super.update(g, c);
                }
            }
        }

        public void paint(Graphics g, JComponent c) {
            ZoomPane pane = (ZoomPane)c;
            Graphics2D gr = (Graphics2D)g;
            switch (pane.flag) {
                case 0: {
                    pane.paintComponent(gr);
                    break;
                }
                case 1: {
                    pane.paintMagnifier(gr);
                    break;
                }
                case 2: {
                    pane.printComponent(gr);
                    break;
                }
                default: {
                    throw new IllegalStateException(Integer.toString(pane.flag));
                }
            }
        }
    };
    private final MouseListener mouseSelectionTracker = new MouseSelectionTracker(){

        protected Shape getModel(MouseEvent event) {
            Point2D.Double point = new Point2D.Double(event.getX(), event.getY());
            if (ZoomPane.this.getZoomableBounds().contains(point)) {
                try {
                    return ZoomPane.this.getMouseSelectionShape(ZoomPane.this.zoom.inverseTransform(point, point));
                }
                catch (NoninvertibleTransformException exception) {
                    ZoomPane.this.unexpectedException("getModel", exception);
                }
            }
            return null;
        }

        protected void selectionPerformed(int ox, int oy, int px, int py) {
            try {
                Shape selection = this.getSelectedArea(ZoomPane.this.zoom);
                if (selection != null) {
                    ZoomPane.this.mouseSelectionPerformed(selection);
                }
            }
            catch (NoninvertibleTransformException exception) {
                ZoomPane.this.unexpectedException("selectionPerformed", exception);
            }
        }
    };
    protected final AffineTransform zoom = new AffineTransform();
    private boolean zoomIsReset;
    private final int type;
    private boolean fillPanel = false;
    private final Rectangle2D visibleArea = new Rectangle2D.Double();
    private Rectangle2D preferredArea;
    private transient PointPopupMenu navigationPopupMenu;
    private transient int flag;
    private boolean paintingWhileAdjusting;
    private transient Rectangle cachedBounds;
    private transient Insets cachedInsets;
    private boolean magnifierEnabled = true;
    private double magnifierPower = 4.0;
    private transient MouseReshapeTracker magnifier;
    private Paint magnifierGlass = DEFAULT_MAGNIFIER_GLASS;
    private Paint magnifierBorder = DEFAULT_MAGNIFIER_BORDER;

    public ZoomPane(final int type) throws IllegalArgumentException {
        if ((type & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        Vocabulary resources = Vocabulary.getResources(null);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        for (int i = 0; i < ACTION_ID.length; ++i) {
            final short actionType = ACTION_TYPE[i];
            if ((actionType & type) == 0) continue;
            String actionID = ACTION_ID[i];
            final double amount = ACTION_AMOUNT[i];
            int keyboard = ACTION_KEY[(i << 1) + 0];
            int modifier = ACTION_KEY[(i << 1) + 1];
            KeyStroke stroke = KeyStroke.getKeyStroke(keyboard, modifier);
            AbstractAction action = new AbstractAction(){

                public void actionPerformed(ActionEvent event) {
                    Point point = null;
                    Object source = event.getSource();
                    boolean button = source instanceof AbstractButton;
                    if (button) {
                        for (Container c = (Container)source; c != null; c = c.getParent()) {
                            if (!(c instanceof PointPopupMenu)) continue;
                            point = ((PointPopupMenu)c).point;
                            break;
                        }
                    }
                    double m = amount;
                    if (button || (event.getModifiers() & 1) != 0) {
                        m = (actionType & 7) != 0 ? (m >= 1.0 ? 2.0 : 0.5) : (m *= 7.5);
                    }
                    ZoomPane.this.transform(actionType & type, m, point);
                }
            };
            action.putValue("Name", resources.getString(RESOURCE_ID[i]));
            action.putValue("ActionCommandKey", actionID);
            action.putValue("AcceleratorKey", stroke);
            actionMap.put(actionID, action);
            inputMap.put(stroke, actionID);
            inputMap.put(KeyStroke.getKeyStroke(keyboard, modifier | 1), actionID);
        }
        Listeners listeners = new Listeners();
        this.addComponentListener(listeners);
        super.addMouseListener(listeners);
        if ((type & 3) != 0) {
            super.addMouseWheelListener(listeners);
        }
        super.addMouseListener(this.mouseSelectionTracker);
        this.setAutoscrolls(true);
        this.setFocusable(true);
        this.setOpaque(true);
        this.setUI(UI);
    }

    public void reset() {
        this.reset(this.getZoomableBounds(), true);
    }

    protected final void reset(Rectangle zoomableBounds, boolean yAxisUpward) {
        Rectangle2D preferredArea;
        if (!zoomableBounds.isEmpty() && ZoomPane.isValid(preferredArea = this.getPreferredArea())) {
            AffineTransform change;
            try {
                change = this.zoom.createInverse();
            }
            catch (NoninvertibleTransformException exception) {
                this.unexpectedException("reset", exception);
                return;
            }
            if (yAxisUpward) {
                this.zoom.setToScale(1.0, -1.0);
            } else {
                this.zoom.setToIdentity();
            }
            AffineTransform transform = this.setVisibleArea(preferredArea, zoomableBounds, 27);
            change.concatenate(this.zoom);
            this.zoom.concatenate(transform);
            change.concatenate(transform);
            this.getVisibleArea(zoomableBounds);
            if (!change.isIdentity()) {
                this.fireZoomChanged0(change);
                this.repaint(zoomableBounds);
            }
            this.zoomIsReset = true;
            ZoomPane.log("reset", this.visibleArea);
        }
    }

    protected void setResetPolicy(boolean fill) {
        this.fillPanel = fill;
    }

    public abstract Rectangle2D getArea();

    public final boolean hasPreferredArea() {
        return this.preferredArea != null;
    }

    public final Rectangle2D getPreferredArea() {
        return this.preferredArea != null ? (Rectangle2D)this.preferredArea.clone() : this.getArea();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setPreferredArea(Rectangle2D area) {
        if (area != null) {
            Object oldArea;
            if (!ZoomPane.isValid(area)) throw new IllegalArgumentException(Errors.format((int)14, (Object)area));
            if (this.preferredArea == null) {
                oldArea = null;
                this.preferredArea = new Rectangle2D.Double();
            } else {
                oldArea = this.preferredArea.clone();
            }
            this.preferredArea.setRect(area);
            this.firePropertyChange("preferredArea", oldArea, area);
            ZoomPane.log("setPreferredArea", area);
            return;
        } else {
            this.preferredArea = null;
        }
    }

    public final Rectangle2D getVisibleArea() {
        return this.getVisibleArea(this.getZoomableBounds());
    }

    private Rectangle2D getVisibleArea(Rectangle zoomableBounds) {
        Rectangle2D visible;
        if (zoomableBounds.isEmpty()) {
            return (Rectangle2D)this.visibleArea.clone();
        }
        try {
            visible = XAffineTransform.inverseTransform((AffineTransform)this.zoom, (Rectangle2D)zoomableBounds, null);
        }
        catch (NoninvertibleTransformException exception) {
            this.unexpectedException("getVisibleArea", exception);
            visible = new Rectangle2D.Double(zoomableBounds.getCenterX(), zoomableBounds.getCenterY(), 0.0, 0.0);
        }
        this.visibleArea.setRect(visible);
        return visible;
    }

    public void setVisibleArea(Rectangle2D logicalBounds) throws IllegalArgumentException {
        ZoomPane.log("setVisibleArea", logicalBounds);
        this.transform(this.setVisibleArea(logicalBounds, this.getZoomableBounds(), 0));
    }

    private AffineTransform setVisibleArea(Rectangle2D source, Rectangle2D dest, int mask) throws IllegalArgumentException {
        if (!ZoomPane.isValid(source)) {
            throw new IllegalArgumentException(Errors.format((int)14, (Object)source));
        }
        if (!ZoomPane.isValid(dest)) {
            return new AffineTransform();
        }
        try {
            dest = XAffineTransform.inverseTransform((AffineTransform)this.zoom, (Rectangle2D)dest, null);
        }
        catch (NoninvertibleTransformException exception) {
            this.unexpectedException("setVisibleArea", exception);
            return new AffineTransform();
        }
        double sourceWidth = source.getWidth();
        double sourceHeight = source.getHeight();
        double destWidth = dest.getWidth();
        double destHeight = dest.getHeight();
        double sx = destWidth / sourceWidth;
        double sy = destHeight / sourceHeight;
        if (((mask |= this.type) & 7) == 7) {
            if (this.fillPanel) {
                if (sy * sourceWidth > destWidth) {
                    sx = sy;
                } else if (sx * sourceHeight > destHeight) {
                    sy = sx;
                }
            } else if (sy * sourceWidth < destWidth) {
                sx = sy;
            } else if (sx * sourceHeight < destHeight) {
                sy = sx;
            }
        }
        AffineTransform change = AffineTransform.getTranslateInstance((mask & 8) != 0 ? dest.getCenterX() : 0.0, (mask & 0x10) != 0 ? dest.getCenterY() : 0.0);
        change.scale((mask & 1) != 0 ? sx : 1.0, (mask & 2) != 0 ? sy : 1.0);
        change.translate((mask & 8) != 0 ? -source.getCenterX() : 0.0, (mask & 0x10) != 0 ? -source.getCenterY() : 0.0);
        XAffineTransform.round((AffineTransform)change);
        return change;
    }

    private final Rectangle getZoomableBounds() {
        this.cachedBounds = this.getZoomableBounds(this.cachedBounds);
        return this.cachedBounds;
    }

    protected Rectangle getZoomableBounds(Rectangle bounds) {
        bounds = this.getBounds(bounds);
        Insets insets = this.cachedInsets;
        this.cachedInsets = insets = this.getInsets(insets);
        if (bounds.isEmpty()) {
            Dimension size = this.getPreferredSize();
            bounds.width = size.width;
            bounds.height = size.height;
        }
        bounds.x = insets.left;
        bounds.y = insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    protected Dimension getDefaultSize() {
        return this.getViewSize();
    }

    protected Dimension2D getPreferredPixelSize() {
        Rectangle2D area = this.getArea();
        if (ZoomPane.isValid(area)) {
            return new XDimension2D.Double(area.getWidth() / (double)(10 * this.getWidth()), area.getHeight() / (double)(10 * this.getHeight()));
        }
        return new Dimension(1, 1);
    }

    public double getScaleFactor() {
        double m00 = this.zoom.getScaleX();
        double m11 = this.zoom.getScaleY();
        double m01 = this.zoom.getShearX();
        double m10 = this.zoom.getShearY();
        return Math.sqrt(m00 * m00 + m11 * m11 + m01 * m01 + m10 * m10);
    }

    public void transform(AffineTransform change) {
        if (!change.isIdentity()) {
            this.zoom.concatenate(change);
            XAffineTransform.round((AffineTransform)this.zoom);
            this.fireZoomChanged(change);
            this.repaint(this.getZoomableBounds());
            this.zoomIsReset = false;
        }
    }

    public void transformPixels(AffineTransform change) {
        if (!change.isIdentity()) {
            AffineTransform logical;
            try {
                logical = this.zoom.createInverse();
            }
            catch (NoninvertibleTransformException exception) {
                throw new IllegalStateException();
            }
            logical.concatenate(change);
            logical.concatenate(this.zoom);
            XAffineTransform.round((AffineTransform)logical);
            this.transform(logical);
        }
    }

    private void transform(int operation, double amount, Point2D center) throws UnsupportedOperationException {
        AffineTransform change;
        if ((operation & 0x40) != 0) {
            if ((operation & 0xFFFFFFBF) != 0) {
                throw new UnsupportedOperationException();
            }
            this.reset();
            return;
        }
        try {
            change = this.zoom.createInverse();
        }
        catch (NoninvertibleTransformException exception) {
            this.unexpectedException("transform", exception);
            return;
        }
        if ((operation & 0x18) != 0) {
            if ((operation & 0xFFFFFFE7) != 0) {
                throw new UnsupportedOperationException();
            }
            change.translate((operation & 8) != 0 ? amount : 0.0, (operation & 0x10) != 0 ? amount : 0.0);
        } else {
            double centerY;
            double centerX;
            if (center != null) {
                centerX = center.getX();
                centerY = center.getY();
            } else {
                Rectangle bounds = this.getZoomableBounds();
                if (bounds.width >= 0 && bounds.height >= 0) {
                    centerX = bounds.getCenterX();
                    centerY = bounds.getCenterY();
                } else {
                    return;
                }
            }
            if ((operation & 0x20) != 0) {
                if ((operation & 0xFFFFFFDF) != 0) {
                    throw new UnsupportedOperationException();
                }
                change.rotate(amount, centerX, centerY);
            } else if ((operation & 3) != 0) {
                if ((operation & 0xFFFFFFF8) != 0) {
                    throw new UnsupportedOperationException();
                }
                change.translate(centerX, centerY);
                change.scale((operation & 1) != 0 ? amount : 1.0, (operation & 2) != 0 ? amount : 1.0);
                change.translate(-centerX, -centerY);
            } else if ((operation & 0x80) != 0) {
                if ((operation & 0xFFFFFF7F) != 0) {
                    throw new UnsupportedOperationException();
                }
                Dimension2D size = this.getPreferredPixelSize();
                double sx = 1.0 / (size.getWidth() * XAffineTransform.getScaleX0((AffineTransform)this.zoom));
                double sy = 1.0 / (size.getHeight() * XAffineTransform.getScaleY0((AffineTransform)this.zoom));
                if ((this.type & 7) == 7) {
                    if (sx > sy) {
                        sx = sy;
                    }
                    if (sy > sx) {
                        sy = sx;
                    }
                }
                if ((this.type & 1) == 0) {
                    sx = 1.0;
                }
                if ((this.type & 2) == 0) {
                    sy = 1.0;
                }
                change.translate(centerX, centerY);
                change.scale(sx, sy);
                change.translate(-centerX, -centerY);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        change.concatenate(this.zoom);
        XAffineTransform.round((AffineTransform)change);
        this.transform(change);
    }

    public void addZoomChangeListener(ZoomChangeListener listener) {
        this.listenerList.add(ZoomChangeListener.class, listener);
    }

    public void removeZoomChangeListener(ZoomChangeListener listener) {
        this.listenerList.remove(ZoomChangeListener.class, listener);
    }

    public void addMouseListener(MouseListener listener) {
        super.removeMouseListener(this.mouseSelectionTracker);
        super.addMouseListener(listener);
        super.addMouseListener(this.mouseSelectionTracker);
    }

    protected void fireZoomChanged(AffineTransform change) {
        this.visibleArea.setRect(this.getVisibleArea());
        this.fireZoomChanged0(change);
    }

    private void fireZoomChanged0(AffineTransform change) {
        if (change == null) {
            throw new NullPointerException();
        }
        ZoomChangeEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length;
        while ((i -= 2) >= 0) {
            if (listeners[i] != (class$org$geotools$gui$swing$event$ZoomChangeListener == null ? ZoomPane.class$("org.geotools.gui.swing.event.ZoomChangeListener") : class$org$geotools$gui$swing$event$ZoomChangeListener)) continue;
            if (event == null) {
                event = new ZoomChangeEvent(this, change);
            }
            try {
                ((ZoomChangeListener)listeners[i + 1]).zoomChanged(event);
            }
            catch (RuntimeException exception) {
                ZoomPane.unexpectedException("fireZoomChanged", exception);
            }
        }
    }

    protected void mouseSelectionPerformed(Shape area) {
        Rectangle2D rect;
        Rectangle2D rectangle2D = rect = area instanceof Rectangle2D ? (Rectangle2D)area : area.getBounds2D();
        if (ZoomPane.isValid(rect)) {
            this.setVisibleArea(rect);
        }
    }

    protected Shape getMouseSelectionShape(Point2D point) {
        return new Rectangle2D.Float();
    }

    public boolean isMagnifierEnabled() {
        return this.magnifierEnabled;
    }

    public void setMagnifierEnabled(boolean enabled) {
        this.magnifierEnabled = enabled;
        this.navigationPopupMenu = null;
        if (!enabled) {
            this.setMagnifierVisible(false);
        }
    }

    public boolean isMagnifierVisible() {
        return this.magnifier != null;
    }

    public void setMagnifierVisible(boolean visible) {
        this.setMagnifierVisible(visible, null);
    }

    public Paint getMagnifierGlass() {
        return this.magnifierGlass;
    }

    public void setMagnifierGlass(Paint color) {
        Paint old = this.magnifierGlass;
        this.magnifierGlass = color;
        this.firePropertyChange("magnifierGlass", old, color);
    }

    public Paint getMagnifierBorder() {
        return this.magnifierBorder;
    }

    public void setMagnifierBorder(Paint color) {
        Paint old = this.magnifierBorder;
        this.magnifierBorder = color;
        this.firePropertyChange("magnifierBorder", old, color);
    }

    public final void correctApparentPixelPosition(Point2D point) {
        if (this.magnifier != null && this.magnifier.contains(point)) {
            double centerX = this.magnifier.getCenterX();
            double centerY = this.magnifier.getCenterY();
            point.setLocation((point.getX() - centerX) / this.magnifierPower + centerX, (point.getY() - centerY) / this.magnifierPower + centerY);
        }
    }

    private void setMagnifierVisible(boolean visible, Point center) {
        if (visible && this.magnifierEnabled) {
            if (this.magnifier == null) {
                int centerY;
                int centerX;
                Rectangle bounds = this.getZoomableBounds();
                if (bounds.isEmpty()) {
                    bounds = new Rectangle(0, 0, 400, 400);
                }
                int size = Math.min(Math.min(bounds.width, bounds.height), 150);
                if (center != null) {
                    centerX = center.x - size / 2;
                    centerY = center.y - size / 2;
                } else {
                    centerX = bounds.x + (bounds.width - size) / 2;
                    centerY = bounds.y + (bounds.height - size) / 2;
                }
                this.magnifier = new MouseReshapeTracker(new Ellipse2D.Float(centerX, centerY, size, size)){

                    protected void stateWillChange(boolean isAdjusting) {
                        ZoomPane.this.repaintMagnifier();
                    }

                    protected void stateChanged(boolean isAdjusting) {
                        ZoomPane.this.repaintMagnifier();
                    }
                };
                this.magnifier.setClip(bounds);
                this.magnifier.setAdjustable(1, true);
                this.magnifier.setAdjustable(5, true);
                this.magnifier.setAdjustable(3, true);
                this.magnifier.setAdjustable(7, true);
                this.addMouseListener(this.magnifier);
                this.addMouseMotionListener(this.magnifier);
                this.firePropertyChange("magnifierVisible", Boolean.FALSE, Boolean.TRUE);
                this.repaintMagnifier();
            } else if (center != null) {
                Rectangle2D frame = this.magnifier.getFrame();
                double width = frame.getWidth();
                double height = frame.getHeight();
                this.magnifier.setFrame((double)center.x - 0.5 * width, (double)center.y - 0.5 * height, width, height);
            }
        } else if (this.magnifier != null) {
            this.repaintMagnifier();
            this.removeMouseMotionListener(this.magnifier);
            this.removeMouseListener(this.magnifier);
            this.setCursor(null);
            this.magnifier = null;
            this.firePropertyChange("magnifierVisible", Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void buildNavigationMenu(JMenu menu) {
        this.buildNavigationMenu(menu, null);
    }

    private void buildNavigationMenu(JMenu menu, JPopupMenu popup) {
        int groupIndex = 0;
        boolean firstMenu = true;
        ActionMap actionMap = this.getActionMap();
        for (int i = 0; i < ACTION_ID.length; ++i) {
            JMenuItem item;
            Action action = actionMap.get(ACTION_ID[i]);
            if (action == null || action.getValue("Name") == null) continue;
            int lastGroupIndex = groupIndex;
            while ((ACTION_TYPE[i] & GROUP[groupIndex]) == 0 && (groupIndex = (groupIndex + 1) % GROUP.length) != lastGroupIndex) {
            }
            if (menu != null) {
                if (groupIndex != lastGroupIndex && !firstMenu) {
                    menu.addSeparator();
                }
                item = new JMenuItem(action);
                item.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
                menu.add(item);
            }
            if (popup != null) {
                if (groupIndex != lastGroupIndex && !firstMenu) {
                    popup.addSeparator();
                }
                item = new JMenuItem(action);
                item.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
                popup.add(item);
            }
            firstMenu = false;
        }
    }

    protected JPopupMenu getPopupMenu(MouseEvent event) {
        if (this.getZoomableBounds().contains(event.getX(), event.getY())) {
            if (this.navigationPopupMenu == null) {
                this.navigationPopupMenu = new PointPopupMenu(event.getPoint());
                if (this.magnifierEnabled) {
                    Vocabulary resources = Vocabulary.getResources((Locale)this.getLocale());
                    JMenuItem item = new JMenuItem(resources.getString(149));
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            ZoomPane.this.setMagnifierVisible(true, ((ZoomPane)ZoomPane.this).navigationPopupMenu.point);
                        }
                    });
                    this.navigationPopupMenu.add(item);
                    this.navigationPopupMenu.addSeparator();
                }
                this.buildNavigationMenu(null, this.navigationPopupMenu);
            } else {
                this.navigationPopupMenu.point.x = event.getX();
                this.navigationPopupMenu.point.y = event.getY();
            }
            return this.navigationPopupMenu;
        }
        return null;
    }

    protected JPopupMenu getMagnifierMenu(MouseEvent event) {
        Vocabulary resources = Vocabulary.getResources((Locale)this.getLocale());
        JPopupMenu menu = new JPopupMenu(resources.getString(100));
        JMenuItem item = new JMenuItem(resources.getString(67));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ZoomPane.this.setMagnifierVisible(false);
            }
        });
        menu.add(item);
        return menu;
    }

    private void mayShowPopupMenu(MouseEvent event) {
        if (event.getID() == 501 && (event.getModifiers() & 0x10) != 0) {
            this.requestFocus();
        }
        if (event.isPopupTrigger()) {
            Component source;
            Window window;
            JPopupMenu popup;
            Point point = event.getPoint();
            JPopupMenu jPopupMenu = popup = this.magnifier != null && this.magnifier.contains(point) ? this.getMagnifierMenu(event) : this.getPopupMenu(event);
            if (popup != null && (window = SwingUtilities.getWindowAncestor(source = event.getComponent())) != null) {
                Toolkit toolkit = source.getToolkit();
                Insets insets = toolkit.getScreenInsets(window.getGraphicsConfiguration());
                Dimension screen = toolkit.getScreenSize();
                Dimension size = popup.getPreferredSize();
                SwingUtilities.convertPointToScreen(point, source);
                screen.width -= size.width + insets.right;
                screen.height -= size.height + insets.bottom;
                if (point.x > screen.width) {
                    point.x = screen.width;
                }
                if (point.y > screen.height) {
                    point.y = screen.height;
                }
                if (point.x < insets.left) {
                    point.x = insets.left;
                }
                if (point.y < insets.top) {
                    point.y = insets.top;
                }
                SwingUtilities.convertPointFromScreen(point, source);
                popup.show(source, point.x, point.y);
            }
        }
    }

    private final void mouseWheelMoved(MouseWheelEvent event) {
        if (event.getScrollType() == 0) {
            int rotation = event.getUnitsToScroll();
            double scale = 1.0 + 0.03125 * (double)Math.abs(rotation);
            Point2D.Double point = new Point2D.Double(event.getX(), event.getY());
            if (rotation > 0) {
                scale = 1.0 / scale;
            }
            if (this.magnifier != null && this.magnifier.contains(point)) {
                this.magnifierPower *= scale;
                this.repaintMagnifier();
            } else {
                this.correctApparentPixelPosition(point);
                this.transform(7 & this.type, scale, point);
            }
            event.consume();
        }
    }

    private final void processSizeEvent(ComponentEvent event) {
        if (!ZoomPane.isValid(this.visibleArea) || this.zoomIsReset) {
            this.reset();
        }
        if (this.magnifier != null) {
            this.magnifier.setClip(this.getZoomableBounds());
        }
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length;
        while ((i -= 2) >= 0) {
            if (listeners[i] != (class$org$geotools$gui$swing$event$ZoomChangeListener == null ? ZoomPane.class$("org.geotools.gui.swing.event.ZoomChangeListener") : class$org$geotools$gui$swing$event$ZoomChangeListener) || !(listeners[i + 1] instanceof Synchronizer)) continue;
            try {
                ((ZoomChangeListener)listeners[i + 1]).zoomChanged(null);
            }
            catch (RuntimeException exception) {
                ZoomPane.unexpectedException("processSizeEvent", exception);
            }
        }
    }

    public JComponent createScrollPane() {
        return new ScrollPane();
    }

    public void tieModels(BoundedRangeModel x, BoundedRangeModel y) {
        if (x != null || y != null) {
            Synchronizer listener = new Synchronizer(x, y);
            this.addZoomChangeListener(listener);
            if (x != null) {
                x.addChangeListener(listener);
            }
            if (y != null) {
                y.addChangeListener(listener);
            }
        }
    }

    public void untieModels(BoundedRangeModel x, BoundedRangeModel y) {
        EventListener[] listeners = this.getListeners(ZoomChangeListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof Synchronizer)) continue;
            Synchronizer s = (Synchronizer)listeners[i];
            if (s.xm != x || s.ym != y) continue;
            this.removeZoomChangeListener(s);
            if (x != null) {
                x.removeChangeListener(s);
            }
            if (y == null) continue;
            y.removeChangeListener(s);
        }
    }

    private static void setRangeProperties(BoundedRangeModel model, double value, int extent, double max) {
        if (model != null) {
            int pos = (int)Math.round(-value);
            model.setRangeProperties(pos, extent, Math.min(0, pos), Math.max((int)Math.round(max), pos + extent), false);
        }
    }

    public void scrollRectToVisible(Rectangle rect) {
        Rectangle2D area = this.getArea();
        if (ZoomPane.isValid(area)) {
            area = XAffineTransform.transform((AffineTransform)this.zoom, (Rectangle2D)area, null);
            area.setRect(area.getX() + rect.getX(), area.getY() + rect.getY(), rect.getWidth(), rect.getHeight());
            try {
                this.setVisibleArea(XAffineTransform.inverseTransform((AffineTransform)this.zoom, (Rectangle2D)area, (Rectangle2D)area));
            }
            catch (NoninvertibleTransformException exception) {
                this.unexpectedException("scrollRectToVisible", exception);
            }
        }
    }

    public boolean isPaintingWhileAdjusting() {
        return this.paintingWhileAdjusting;
    }

    public void setPaintingWhileAdjusting(boolean flag) {
        this.paintingWhileAdjusting = flag;
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        super.repaint(tm, x, y, width, height);
        if (this.magnifier != null && this.magnifier.intersects(x, y, width, height)) {
            this.repaintMagnifier();
        }
    }

    private void repaintMagnifier() {
        Rectangle bounds = this.magnifier.getBounds();
        bounds.x -= 4;
        bounds.y -= 4;
        bounds.width += 8;
        bounds.height += 8;
        super.repaint(0L, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    protected void paintMagnifier(Graphics2D graphics) {
        double centerX = this.magnifier.getCenterX();
        double centerY = this.magnifier.getCenterY();
        Stroke stroke = graphics.getStroke();
        Paint paint = graphics.getPaint();
        graphics.setStroke(new BasicStroke(6.0f));
        graphics.setPaint(this.magnifierBorder);
        graphics.draw(this.magnifier);
        graphics.setStroke(stroke);
        graphics.clip(this.magnifier);
        graphics.setPaint(this.magnifierGlass);
        graphics.fill(this.magnifier.getBounds2D());
        graphics.setPaint(paint);
        graphics.translate(centerX, centerY);
        graphics.scale(this.magnifierPower, this.magnifierPower);
        graphics.translate(-centerX, -centerY);
        this.paintComponent(graphics);
    }

    protected abstract void paintComponent(Graphics2D var1);

    protected void printComponent(Graphics2D graphics) {
        this.paintComponent(graphics);
    }

    protected final void paintComponent(Graphics graphics) {
        this.flag = 0;
        super.paintComponent(graphics);
        if (this.magnifier != null) {
            this.flag = 1;
            super.paintComponent(graphics);
        }
    }

    protected final void printComponent(Graphics graphics) {
        this.flag = 2;
        super.paintComponent(graphics);
    }

    private final Dimension getViewSize() {
        if (!this.visibleArea.isEmpty()) {
            Rectangle2D area = this.getArea();
            if (ZoomPane.isValid(area)) {
                area = XAffineTransform.transform((AffineTransform)this.zoom, (Rectangle2D)area, null);
                return new Dimension((int)Math.rint(area.getWidth()), (int)Math.rint(area.getHeight()));
            }
            return this.getSize();
        }
        return new Dimension(400, 400);
    }

    public Insets getInsets(Insets insets) {
        return super.getInsets(insets != null ? insets : new Insets(0, 0, 0, 0));
    }

    public final Insets getInsets() {
        return this.getInsets(null);
    }

    public void updateUI() {
        this.navigationPopupMenu = null;
        super.updateUI();
        this.setUI(UI);
    }

    private void unexpectedException(String methodName, NoninvertibleTransformException exception) {
        this.zoom.setToIdentity();
        Utilities.unexpectedException((String)"org.geotools.gui", (String)"org.geotools.swing.ZoomPane", (String)methodName, (Throwable)exception);
    }

    private static void unexpectedException(String methodName, RuntimeException exception) {
        Utilities.unexpectedException((String)"org.geotools.gui", (String)"org.geotools.swing.ZoomPane", (String)methodName, (Throwable)exception);
    }

    private static void log(String methodName, Rectangle2D area) {
        ZoomPane.log("ZoomPane", methodName, area);
    }

    static void log(String className, String methodName, Rectangle2D area) {
        if (LOGGER.isLoggable(Level.FINER)) {
            Object[] areaBounds;
            if (area != null) {
                areaBounds = new Double[]{new Double(area.getMinX()), new Double(area.getMaxX()), new Double(area.getMinY()), new Double(area.getMaxY())};
            } else {
                areaBounds = new Double[4];
                Arrays.fill(areaBounds, new Double(Double.NaN));
            }
            Vocabulary resources = Vocabulary.getResources(null);
            LogRecord record = resources.getLogRecord(Level.FINER, 137, (Object)areaBounds);
            record.setSourceClassName(className);
            record.setSourceMethodName(methodName);
            LOGGER.log(record);
        }
    }

    private static boolean isValid(Rectangle2D rect) {
        if (rect == null) {
            return false;
        }
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        return x > Double.NEGATIVE_INFINITY && x < Double.POSITIVE_INFINITY && y > Double.NEGATIVE_INFINITY && y < Double.POSITIVE_INFINITY && w > 0.0 && w < Double.POSITIVE_INFINITY && h > 0.0 && h < Double.POSITIVE_INFINITY;
    }

    private final class Synchronizer
    implements ChangeListener,
    ZoomChangeListener {
        public final BoundedRangeModel xm;
        public final BoundedRangeModel ym;
        private transient boolean isAdjusting;
        private transient Rectangle bounds;

        public Synchronizer(BoundedRangeModel xm, BoundedRangeModel ym) {
            this.xm = xm;
            this.ym = ym;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent event) {
            if (!this.isAdjusting) {
                Rectangle2D area;
                boolean valueIsAdjusting = ((BoundedRangeModel)event.getSource()).getValueIsAdjusting();
                if ((ZoomPane.this.paintingWhileAdjusting || !valueIsAdjusting) && ZoomPane.isValid(area = ZoomPane.this.getArea())) {
                    double height;
                    double width;
                    area = XAffineTransform.transform((AffineTransform)ZoomPane.this.zoom, (Rectangle2D)area, null);
                    double x = area.getX();
                    double y = area.getY();
                    if (this.xm != null) {
                        x += (double)this.xm.getValue();
                        width = this.xm.getExtent();
                    } else {
                        width = area.getWidth();
                    }
                    if (this.ym != null) {
                        y += (double)this.ym.getValue();
                        height = this.ym.getExtent();
                    } else {
                        height = area.getHeight();
                    }
                    area.setRect(x, y, width, height);
                    this.bounds = ZoomPane.this.getBounds(this.bounds);
                    try {
                        area = XAffineTransform.inverseTransform((AffineTransform)ZoomPane.this.zoom, (Rectangle2D)area, (Rectangle2D)area);
                        try {
                            this.isAdjusting = true;
                            this.bounds = ZoomPane.this.getBounds(this.bounds);
                            ZoomPane.this.transform(ZoomPane.this.setVisibleArea(area, this.bounds, 0));
                        }
                        finally {
                            this.isAdjusting = false;
                        }
                    }
                    catch (NoninvertibleTransformException exception) {
                        ZoomPane.this.unexpectedException("stateChanged", exception);
                    }
                }
                if (!valueIsAdjusting) {
                    this.zoomChanged(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zoomChanged(ZoomChangeEvent change) {
            Rectangle2D area;
            if (!this.isAdjusting && ZoomPane.isValid(area = ZoomPane.this.getArea())) {
                area = XAffineTransform.transform((AffineTransform)ZoomPane.this.zoom, (Rectangle2D)area, null);
                try {
                    this.isAdjusting = true;
                    ZoomPane.setRangeProperties(this.xm, area.getX(), ZoomPane.this.getWidth(), area.getWidth());
                    ZoomPane.setRangeProperties(this.ym, area.getY(), ZoomPane.this.getHeight(), area.getHeight());
                }
                finally {
                    this.isAdjusting = false;
                }
            }
        }
    }

    private final class ScrollPane
    extends JComponent
    implements PropertyChangeListener {
        private final JScrollBar scrollbarX;
        private final JScrollBar scrollbarY;

        public ScrollPane() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            if ((ZoomPane.this.type & 8) != 0) {
                this.scrollbarX = new JScrollBar(0);
                this.scrollbarX.setUnitIncrement(10);
                this.scrollbarX.setBlockIncrement(75);
            } else {
                this.scrollbarX = null;
            }
            if ((ZoomPane.this.type & 0x10) != 0) {
                this.scrollbarY = new JScrollBar(1);
                this.scrollbarY.setUnitIncrement(10);
                this.scrollbarY.setBlockIncrement(75);
            } else {
                this.scrollbarY = null;
            }
            GridBagConstraints c = new GridBagConstraints();
            if (this.scrollbarX != null) {
                c.gridx = 0;
                c.weightx = 1.0;
                c.gridy = 1;
                c.weighty = 0.0;
                c.fill = 2;
                this.add((Component)this.scrollbarX, c);
            }
            if (this.scrollbarY != null) {
                c.gridx = 1;
                c.weightx = 0.0;
                c.gridy = 0;
                c.weighty = 1.0;
                c.fill = 3;
                this.add((Component)this.scrollbarY, c);
            }
            if (this.scrollbarX != null && this.scrollbarY != null) {
                JPanel corner = new JPanel();
                corner.setOpaque(true);
                c.gridx = 1;
                c.weightx = 0.0;
                c.gridy = 1;
                c.weighty = 0.0;
                c.fill = 1;
                this.add((Component)corner, c);
            }
            c.fill = 1;
            c.gridx = 0;
            c.weightx = 1.0;
            c.gridy = 0;
            c.weighty = 1.0;
            this.add((Component)ZoomPane.this, c);
        }

        private BoundedRangeModel getModel(JScrollBar bar) {
            return bar != null ? bar.getModel() : null;
        }

        public void addNotify() {
            super.addNotify();
            ZoomPane.this.tieModels(this.getModel(this.scrollbarX), this.getModel(this.scrollbarY));
            ZoomPane.this.addPropertyChangeListener("zoom.insets", this);
        }

        public void removeNotify() {
            ZoomPane.this.removePropertyChangeListener("zoom.insets", this);
            ZoomPane.this.untieModels(this.getModel(this.scrollbarX), this.getModel(this.scrollbarY));
            super.removeNotify();
        }

        public void propertyChange(PropertyChangeEvent event) {
            GridBagConstraints c;
            Insets old = (Insets)event.getOldValue();
            Insets insets = (Insets)event.getNewValue();
            GridBagLayout layout = (GridBagLayout)this.getLayout();
            if (this.scrollbarX != null && (old.left != insets.left || old.right != insets.right)) {
                c = layout.getConstraints(this.scrollbarX);
                c.insets.left = insets.left;
                c.insets.right = insets.right;
                layout.setConstraints(this.scrollbarX, c);
                this.scrollbarX.invalidate();
            }
            if (this.scrollbarY != null && (old.top != insets.top || old.bottom != insets.bottom)) {
                c = layout.getConstraints(this.scrollbarY);
                c.insets.top = insets.top;
                c.insets.bottom = insets.bottom;
                layout.setConstraints(this.scrollbarY, c);
                this.scrollbarY.invalidate();
            }
        }
    }

    private static final class PointPopupMenu
    extends JPopupMenu {
        public final Point point;

        public PointPopupMenu(Point point) {
            this.point = point;
        }
    }

    private final class Listeners
    extends MouseAdapter
    implements MouseWheelListener,
    ComponentListener,
    Serializable {
        private Listeners() {
        }

        public void mouseWheelMoved(MouseWheelEvent event) {
            ZoomPane.this.mouseWheelMoved(event);
        }

        public void mousePressed(MouseEvent event) {
            ZoomPane.this.mayShowPopupMenu(event);
        }

        public void mouseReleased(MouseEvent event) {
            ZoomPane.this.mayShowPopupMenu(event);
        }

        public void componentResized(ComponentEvent event) {
            ZoomPane.this.processSizeEvent(event);
        }

        public void componentMoved(ComponentEvent event) {
        }

        public void componentShown(ComponentEvent event) {
        }

        public void componentHidden(ComponentEvent event) {
        }
    }
}

