/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.units.Unit;
import org.geotools.axis.AbstractGraduation;
import org.geotools.axis.Graduation;
import org.geotools.axis.LogarithmicNumberGraduation;
import org.geotools.axis.NumberGraduation;
import org.geotools.axis.TickIterator;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.geotools.resources.image.CoverageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.PaletteInterpretation;
import org.opengis.coverage.SampleDimension;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;

public class ColorRamp
extends JComponent {
    private static final int MARGIN = 10;
    private static final Color[] EMPTY = new Color[0];
    private Graduation graduation;
    private String units;
    private Color[] colors = EMPTY;
    private boolean labelVisibles = true;
    private boolean autoForeground = true;
    private boolean horizontal = true;
    private transient RenderingHints hints;
    private transient TickIterator reuse;
    private transient float[] HSB;
    private final UI ui = new UI();

    public ColorRamp() {
        this.setOpaque(true);
        this.setUI(this.ui);
    }

    public ColorRamp(Coverage coverage) {
        this();
        this.setColors(coverage);
    }

    public Graduation getGraduation() {
        return this.graduation;
    }

    public boolean setGraduation(Graduation graduation) {
        boolean changed;
        Graduation oldGraduation = this.graduation;
        if (graduation != oldGraduation) {
            Unit unit;
            if (oldGraduation != null) {
                oldGraduation.removePropertyChangeListener(this.ui);
            }
            if (graduation != null) {
                graduation.addPropertyChangeListener(this.ui);
            }
            this.graduation = graduation;
            this.units = null;
            if (graduation != null && (unit = graduation.getUnit()) != null) {
                this.units = unit.toString();
            }
        }
        boolean bl = changed = !Utilities.equals((Object)graduation, (Object)oldGraduation);
        if (changed) {
            this.repaint();
        }
        this.firePropertyChange("graduation", oldGraduation, graduation);
        return changed;
    }

    public Color[] getColors() {
        return this.colors.length != 0 ? (Color[])this.colors.clone() : this.colors;
    }

    public boolean setColors(Color[] colors) {
        boolean changed;
        Object[] oldColors = this.colors;
        this.colors = colors != null && colors.length != 0 ? (Color[])colors.clone() : EMPTY;
        boolean bl = changed = !Arrays.equals(oldColors, this.colors);
        if (changed) {
            this.repaint();
        }
        this.firePropertyChange("colors", oldColors, colors);
        return changed;
    }

    public boolean setColors(IndexColorModel model) {
        Color[] colors;
        if (model == null) {
            colors = EMPTY;
        } else {
            colors = new Color[model.getMapSize()];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = new Color(model.getRed(i), model.getGreen(i), model.getBlue(i), model.getAlpha(i));
            }
        }
        return this.setColors(colors);
    }

    public boolean setColors(SampleDimension band) {
        Color[] colors = EMPTY;
        Graduation graduation = null;
        if (band != null) {
            int[][] palette;
            if (band instanceof GridSampleDimension) {
                band = ((GridSampleDimension)band).geophysics(false);
            }
            if ((palette = band.getPalette()) != null) {
                double max;
                double min;
                int i;
                int lower = 0;
                int upper = 0;
                double[] nodata = band.getNoDataValues();
                double[] sorted = new double[nodata != null ? nodata.length + 2 : 2];
                sorted[0] = -1.0;
                sorted[sorted.length - 1] = palette.length;
                if (nodata != null) {
                    System.arraycopy(nodata, 0, sorted, 1, nodata.length);
                }
                Arrays.sort(sorted);
                for (i = 1; i < sorted.length; ++i) {
                    double lo = Math.floor(sorted[i - 1]) + 1.0;
                    double hi = Math.ceil(sorted[i]);
                    if (!(lo >= 0.0) || !(hi <= (double)palette.length) || !(hi - lo > (double)(upper - lower))) continue;
                    lower = (int)lo;
                    upper = (int)hi;
                }
                if (PaletteInterpretation.RGB.equals(band.getPaletteInterpretation())) {
                    colors = new Color[upper - lower];
                    for (i = 0; i < colors.length; ++i) {
                        int r = 0;
                        int g = 0;
                        int b = 0;
                        int a = 255;
                        int[] c = palette[i + lower];
                        if (c != null) {
                            switch (c.length) {
                                default: {
                                    a = c[3];
                                }
                                case 3: {
                                    b = c[2];
                                }
                                case 2: {
                                    g = c[1];
                                }
                                case 1: {
                                    r = c[0];
                                }
                                case 0: 
                            }
                        }
                        colors[i] = new Color(r, g, b, a);
                    }
                }
                try {
                    MathTransform1D tr = band.getSampleToGeophysics();
                    min = tr.transform((double)lower);
                    max = tr.transform((double)upper);
                }
                catch (TransformException cause) {
                    IllegalArgumentException e = new IllegalArgumentException(Errors.format((int)42, (Object)"band", (Object)band));
                    e.initCause(cause);
                    throw e;
                }
                if (min > max) {
                    min = -min;
                    max = -max;
                }
                if (!(min <= max)) {
                    throw new IllegalArgumentException(Errors.format((int)42, (Object)"band", (Object)band));
                }
                graduation = this.createGraduation(this.graduation, band, min, max);
            }
        }
        return this.setGraduation(graduation) | this.setColors(colors);
    }

    public boolean setColors(Coverage coverage) {
        SampleDimension band = null;
        if (coverage != null) {
            band = coverage.getSampleDimension(CoverageUtilities.getVisibleBand(band));
        }
        return this.setColors(band);
    }

    public int getOrientation() {
        return this.horizontal ? 0 : 1;
    }

    public void setOrientation(int orient) {
        switch (orient) {
            case 0: {
                this.horizontal = true;
                break;
            }
            case 1: {
                this.horizontal = false;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(orient));
            }
        }
    }

    public boolean isLabelVisibles() {
        return this.labelVisibles;
    }

    public void setLabelVisibles(boolean visible) {
        this.labelVisibles = visible;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.autoForeground = color == null;
    }

    private Color getForeground(int colorIndex) {
        Color color = this.colors[colorIndex];
        this.HSB = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.HSB);
        return this.HSB[2] >= 0.5f ? Color.black : Color.white;
    }

    private Rectangle2D paint(Graphics2D graphics, Rectangle bounds) {
        int length = this.colors.length;
        if (length != 0) {
            int B;
            int G;
            int R;
            Color color;
            int i = 0;
            int lastIndex = 0;
            Color nextColor = color = this.colors[i];
            int nR = R = color.getRed();
            int nG = G = color.getGreen();
            int nB = B = color.getBlue();
            int ox = bounds.x + 10;
            int oy = bounds.y + bounds.height - 10;
            double dx = (double)(bounds.width - 20) / (double)length;
            double dy = (double)(bounds.height - 20) / (double)length;
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setRect(bounds);
            while (++i <= length) {
                if (i != length) {
                    nextColor = this.colors[i];
                    nR = nextColor.getRed();
                    nG = nextColor.getGreen();
                    nB = nextColor.getBlue();
                    if (R == nR && G == nG && B == nB) continue;
                }
                if (this.horizontal) {
                    rect.x = (double)ox + dx * (double)lastIndex;
                    rect.width = dx * (double)(i - lastIndex);
                    if (lastIndex == 0) {
                        rect.x -= 10.0;
                        rect.width += 10.0;
                    }
                    if (i == length) {
                        rect.width += 10.0;
                    }
                } else {
                    rect.y = (double)oy - dy * (double)i;
                    rect.height = dy * (double)(i - lastIndex);
                    if (lastIndex == 0) {
                        rect.height += 10.0;
                    }
                    if (i == length) {
                        rect.y -= 10.0;
                        rect.height += 10.0;
                    }
                }
                graphics.setColor(color);
                graphics.fill(rect);
                lastIndex = i;
                color = nextColor;
                R = nR;
                G = nG;
                B = nB;
            }
        }
        RectangularShape labelBounds = null;
        if (this.labelVisibles && this.graduation != null) {
            double offset;
            double scale;
            double visualLength;
            double x = bounds.getCenterX();
            double y = bounds.getCenterY();
            double axisRange = this.graduation.getRange();
            double axisMinimum = this.graduation.getMinimum();
            if (this.horizontal) {
                visualLength = bounds.getWidth() - 20.0;
                scale = visualLength / axisRange;
                offset = bounds.getMinX() + 10.0 - scale * axisMinimum;
            } else {
                visualLength = bounds.getHeight() - 20.0;
                scale = -visualLength / axisRange;
                offset = bounds.getMaxY() - 10.0 + scale * axisMinimum;
            }
            if (this.hints == null) {
                this.hints = new RenderingHints(null);
            }
            RenderingHints hints = this.hints;
            double ratio = (double)length / axisRange;
            Font font = this.getFont();
            FontRenderContext context = graphics.getFontRenderContext();
            hints.put(Graduation.VISUAL_AXIS_LENGTH, new Float((float)visualLength));
            graphics.setColor(this.getForeground());
            TickIterator ticks = this.reuse = this.graduation.getTickIterator(hints, this.reuse);
            while (ticks.hasNext()) {
                if (ticks.isMajorTick()) {
                    GlyphVector glyph = font.createGlyphVector(context, ticks.currentLabel());
                    Rectangle2D rectg = glyph.getVisualBounds();
                    double width = rectg.getWidth();
                    double height = rectg.getHeight();
                    double value = ticks.currentPosition();
                    double position = value * scale + offset;
                    int colorIndex = Math.min(Math.max((int)Math.round((value - axisMinimum) * ratio), 0), length - 1);
                    if (this.horizontal) {
                        x = position;
                    } else {
                        y = position;
                    }
                    rectg.setRect(x - 0.5 * width, y - 0.5 * height, width, height);
                    if (this.autoForeground) {
                        graphics.setColor(this.getForeground(colorIndex));
                    }
                    graphics.drawGlyphVector(glyph, (float)rectg.getMinX(), (float)rectg.getMaxY());
                    if (labelBounds != null) {
                        ((Rectangle2D)labelBounds).add(rectg);
                    } else {
                        labelBounds = rectg;
                    }
                }
                ticks.nextMajor();
            }
            if (this.units != null) {
                GlyphVector glyph = font.createGlyphVector(context, this.units);
                Rectangle2D rectg = glyph.getVisualBounds();
                double width = rectg.getWidth();
                double height = rectg.getHeight();
                if (this.horizontal) {
                    double check;
                    double left = bounds.getMaxX() - width;
                    if (labelBounds != null && (check = labelBounds.getMaxX() + 4.0) < left) {
                        left = check;
                    }
                    rectg.setRect(left, y - 0.5 * height, width, height);
                } else {
                    rectg.setRect(x - 0.5 * width, bounds.getMinY() + height, width, height);
                }
                if (this.autoForeground) {
                    graphics.setColor(this.getForeground(length - 1));
                }
                if (labelBounds == null || !labelBounds.intersects(rectg)) {
                    graphics.drawGlyphVector(glyph, (float)rectg.getMinX(), (float)rectg.getMaxY());
                }
            }
        }
        return labelBounds;
    }

    protected Graduation createGraduation(Graduation reuse, SampleDimension band, double minimum, double maximum) {
        AbstractGraduation graduation;
        MathTransform1D tr = band.getSampleToGeophysics();
        boolean linear = false;
        boolean logarithmic = false;
        try {
            tr = (MathTransform1D)tr.inverse();
            double EPS = 1.0E-6;
            double ratio = tr.derivative(minimum) / tr.derivative(maximum);
            if (Math.abs(ratio - 1.0) <= 1.0E-6) {
                linear = true;
            }
            if (Math.abs(ratio * (minimum / maximum) - 1.0) <= 1.0E-6) {
                logarithmic = true;
            }
        }
        catch (TransformException exception) {
            // empty catch block
        }
        Unit units = band.getUnits();
        AbstractGraduation abstractGraduation = graduation = reuse instanceof AbstractGraduation ? (AbstractGraduation)reuse : null;
        if (linear) {
            if (graduation == null || !graduation.getClass().equals(NumberGraduation.class)) {
                graduation = new NumberGraduation(units);
            }
        } else if (logarithmic) {
            if (graduation == null || !graduation.getClass().equals(LogarithmicNumberGraduation.class)) {
                graduation = new LogarithmicNumberGraduation(units);
            }
        } else {
            Logger.getLogger("org.geotools.gui.swing").log(Logging.format((Level)Level.WARNING, (int)23, (Object)Utilities.getShortClassName((Object)tr)));
            graduation = new NumberGraduation(units);
        }
        if (graduation == reuse) {
            graduation.setUnit(units);
        }
        graduation.setMinimum(minimum);
        graduation.setMaximum(maximum);
        return graduation;
    }

    public String toString() {
        int count = 0;
        int i = 0;
        if (i < this.colors.length) {
            Color last = this.colors[i];
            while (++i < this.colors.length) {
                Color c = this.colors[i];
                if (c.equals(last)) continue;
                last = c;
                ++count;
            }
        }
        return Utilities.getShortClassName((Object)this) + '[' + count + " colors]";
    }

    public void addNotify() {
        super.addNotify();
        if (this.graduation != null) {
            this.graduation.removePropertyChangeListener(this.ui);
            this.graduation.addPropertyChangeListener(this.ui);
        }
    }

    public void removeNotify() {
        if (this.graduation != null) {
            this.graduation.removePropertyChangeListener(this.ui);
        }
        super.removeNotify();
    }

    private final class UI
    extends ComponentUI
    implements PropertyChangeListener {
        private UI() {
        }

        public Dimension getMinimumSize(JComponent c) {
            return ((ColorRamp)c).horizontal ? new Dimension(20, 16) : new Dimension(16, 20);
        }

        public Dimension getPreferredSize(JComponent c) {
            return ((ColorRamp)c).horizontal ? new Dimension(256, 16) : new Dimension(16, 256);
        }

        public void paint(Graphics graphics, JComponent component) {
            ColorRamp ramp = (ColorRamp)component;
            if (ramp.colors != null) {
                Rectangle bounds = ramp.getBounds();
                bounds.x = 0;
                bounds.y = 0;
                ramp.paint((Graphics2D)graphics, bounds);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            ColorRamp.this.repaint();
        }
    }
}

