/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.image;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Locale;
import javax.media.jai.KernelJAI;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import org.geotools.gui.swing.image.KernelEditor;
import org.geotools.resources.SwingUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;

public class GradientKernelEditor
extends JComponent {
    private static final float SQRT2 = 1.4142135f;
    public static final KernelJAI PREWITT_HORIZONTAL = new KernelJAI(3, 3, new float[]{-1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f});
    public static final KernelJAI PREWITT_VERTICAL = new KernelJAI(3, 3, new float[]{-1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    public static final KernelJAI ISOTROPIC_HORIZONTAL = new KernelJAI(3, 3, new float[]{-1.0f, 0.0f, 1.0f, -1.4142135f, 0.0f, 1.4142135f, -1.0f, 0.0f, 1.0f});
    public static final KernelJAI ISOTROPIC_VERTICAL = new KernelJAI(3, 3, new float[]{-1.0f, -1.4142135f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.4142135f, 1.0f});
    public static final KernelJAI SOBEL_HORIZONTAL = KernelJAI.GRADIENT_MASK_SOBEL_HORIZONTAL;
    public static final KernelJAI SOBEL_VERTICAL = KernelJAI.GRADIENT_MASK_SOBEL_VERTICAL;
    public static final KernelJAI KIRSCH_HORIZONTAL = new KernelJAI(3, 3, new float[]{-3.0f, -3.0f, 5.0f, -3.0f, 0.0f, 5.0f, -3.0f, -3.0f, 5.0f});
    public static final KernelJAI KIRSCH_VERTICAL = new KernelJAI(3, 3, new float[]{5.0f, 5.0f, 5.0f, -3.0f, 0.0f, -3.0f, -3.0f, -3.0f, -3.0f});
    private final KernelEditor kernelH = new Editor(true);
    private final KernelEditor kernelV = new Editor(false);

    public GradientKernelEditor() {
        this.setLayout(new GridBagLayout());
        Vocabulary resources = Vocabulary.getResources((Locale)GradientKernelEditor.getDefaultLocale());
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.kernelH.setBorder(border);
        this.kernelV.setBorder(border);
        JLabel labelH = new JLabel(resources.getString(69), 0);
        JLabel labelV = new JLabel(resources.getString(185), 0);
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 6;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.gridx = 0;
        this.add((Component)labelH, c);
        c.gridx = 1;
        this.add((Component)labelV, c);
        c.gridy = 1;
        c.weighty = 1.0;
        c.insets.bottom = 6;
        c.gridx = 0;
        c.insets.left = 6;
        c.insets.right = 3;
        this.add((Component)this.kernelH, c);
        c.gridx = 1;
        c.insets.left = 3;
        c.insets.right = 6;
        this.add((Component)this.kernelV, c);
    }

    public void addDefaultKernels() {
        this.kernelH.addDefaultKernels();
        this.kernelV.addDefaultKernels();
    }

    public KernelEditor getHorizontalEditor() {
        return this.kernelH;
    }

    public KernelEditor getVerticalEditor() {
        return this.kernelV;
    }

    public boolean showDialog(Component owner, String title) {
        return SwingUtilities.showOptionDialog((Component)owner, (Object)this, (String)title);
    }

    public static void main(String[] args) {
        GradientKernelEditor editor = new GradientKernelEditor();
        editor.addDefaultKernels();
        editor.showDialog(null, Utilities.getShortClassName((Object)editor));
    }

    private static final class Editor
    extends KernelEditor {
        private final boolean horizontal;

        public Editor(boolean horizontal) {
            this.horizontal = horizontal;
        }

        public void addDefaultKernels() {
            KernelJAI sobel;
            KernelJAI kirsch;
            KernelJAI isotropic;
            KernelJAI prewitt;
            String GRADIENT_MASKS = this.getResources().getString(63);
            if (this.horizontal) {
                prewitt = PREWITT_HORIZONTAL;
                isotropic = ISOTROPIC_HORIZONTAL;
                kirsch = KIRSCH_HORIZONTAL;
                sobel = SOBEL_HORIZONTAL;
            } else {
                prewitt = PREWITT_VERTICAL;
                isotropic = ISOTROPIC_VERTICAL;
                kirsch = KIRSCH_VERTICAL;
                sobel = SOBEL_VERTICAL;
            }
            this.addKernel(GRADIENT_MASKS, "Prewitt", prewitt);
            this.addKernel(GRADIENT_MASKS, "Isotropic", isotropic);
            this.addKernel(GRADIENT_MASKS, "Kirsch", kirsch);
            this.addKernel(GRADIENT_MASKS, "Sobel 3\u00d73", sobel);
            StringBuffer buffer = new StringBuffer("Sobel ");
            int base = buffer.length();
            for (int i = 5; i <= 15; i += 2) {
                buffer.setLength(base);
                buffer.append(i).append('\u00d7').append(i);
                this.addKernel(GRADIENT_MASKS, buffer.toString(), Editor.getSobel(i, this.horizontal));
            }
            this.setKernel(sobel);
        }

        private static KernelJAI getSobel(int size, boolean horizontal) {
            int key = size / 2;
            float[] data = new float[size * size];
            for (int y = key; y >= 0; --y) {
                int row1 = (key - y) * size + key;
                int row2 = (key + y) * size + key;
                int y2 = y * y;
                for (int x = key; x != 0; --x) {
                    int x2 = x * x;
                    float v = (float)(2.0 * (double)x / (double)(x2 + y2));
                    if (horizontal) {
                        float f = -v;
                        data[row2 - x] = f;
                        data[row1 - x] = f;
                        float f2 = v;
                        data[row2 + x] = f2;
                        data[row1 + x] = f2;
                        continue;
                    }
                    row1 = (key - x) * size + key;
                    row2 = (key + x) * size + key;
                    float f = -v;
                    data[row1 + y] = f;
                    data[row1 - y] = f;
                    float f3 = v;
                    data[row2 + y] = f3;
                    data[row2 - y] = f3;
                }
            }
            return new KernelJAI(size, size, key, key, data);
        }
    }
}

