/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.image;

import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import org.geotools.gui.swing.ZoomPane;

public class ImagePane
extends ZoomPane
implements Runnable {
    private final int renderedSize;
    private RenderableImage renderable;
    private RenderedImage rendered;
    private volatile boolean running;

    public ImagePane() {
        this(512);
    }

    public ImagePane(int renderedSize) {
        super(255);
        this.setResetPolicy(true);
        this.renderedSize = renderedSize;
    }

    public void setImage(RenderableImage image) {
        this.renderable = image;
        this.rendered = null;
        this.running = false;
        this.reset();
        this.repaint();
    }

    public void setImage(RenderedImage image) {
        float scale;
        if (image != null && (scale = Math.min((float)this.renderedSize / (float)image.getWidth(), (float)this.renderedSize / (float)image.getHeight())) < 1.0f) {
            Float sc = new Float(scale);
            image = JAI.create((String)"Scale", (ParameterBlock)new ParameterBlock().addSource(image).add(sc).add(sc));
        }
        this.renderable = null;
        this.rendered = image;
        this.running = false;
        this.reset();
        this.repaint();
    }

    public void reset() {
        this.reset(this.getZoomableBounds(null), false);
    }

    public Rectangle2D getArea() {
        RenderedImage rendered = this.rendered;
        if (rendered != null) {
            return new Rectangle(rendered.getMinX(), rendered.getMinY(), rendered.getWidth(), rendered.getHeight());
        }
        return null;
    }

    protected void paintComponent(Graphics2D graphics) {
        RenderedImage rendered = this.rendered;
        if (rendered == null) {
            if (this.renderable != null && !this.running) {
                this.running = true;
                Thread runner = new Thread((Runnable)this, "Renderer");
                runner.setPriority(3);
                runner.start();
            }
        } else {
            graphics.drawRenderedImage(rendered, this.zoom);
        }
    }

    public void run() {
        this.running = true;
        final RenderableImage producer = this.renderable;
        if (producer != null) {
            final RenderedImage image = producer.createScaledRendering(this.renderedSize, 0, null);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (producer == ImagePane.this.renderable) {
                        ImagePane.this.setImage(image);
                    }
                }
            });
        }
    }
}

