/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.image;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderableImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationNode;
import javax.media.jai.PropertyChangeEmitter;
import javax.media.jai.PropertySource;
import javax.media.jai.RegistryElementDescriptor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.geotools.gui.swing.image.ColorRamp;
import org.geotools.gui.swing.image.ImagePane;
import org.geotools.gui.swing.image.ImageSampleValues;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;

public class ImageProperties
extends JPanel {
    private final JLabel operationName = new JLabel(" ");
    private final JLabel operationDescription = new JLabel(" ");
    private final JLabel operationVersion = new JLabel(" ");
    private final JLabel imageSize = new JLabel();
    private final JLabel tileSize = new JLabel();
    private final JLabel dataType = new JLabel();
    private final JLabel sampleModel = new JLabel();
    private final JLabel colorModel = new JLabel();
    private final ColorRamp colorRamp = new ColorRamp();
    private final Table properties;
    private final ImageSampleValues samples;
    private final ImagePane viewer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public ImageProperties() {
        super(new BorderLayout());
        Vocabulary resources = Vocabulary.getResources((Locale)this.getLocale());
        JTabbedPane tabs = new JTabbedPane();
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        c.anchor = 17;
        c.fill = 2;
        c.insets.left = 9;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.gridy = 0;
        panel.add((Component)this.operationName, c);
        ++c.gridy;
        panel.add((Component)this.operationDescription, c);
        c.insets.bottom = 15;
        ++c.gridy;
        panel.add((Component)this.operationVersion, c);
        int ytop = c.gridy++;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets.bottom = 0;
        panel.add((Component)ImageProperties.getLabel(73, resources), c);
        ++c.gridy;
        panel.add((Component)ImageProperties.getLabel(163, resources), c);
        ++c.gridy;
        panel.add((Component)ImageProperties.getLabel(26, resources), c);
        ++c.gridy;
        panel.add((Component)ImageProperties.getLabel(145, resources), c);
        ++c.gridy;
        panel.add((Component)ImageProperties.getLabel(17, resources), c);
        ++c.gridy;
        panel.add((Component)ImageProperties.getLabel(15, resources), c);
        c.gridx = 1;
        c.gridy = ytop;
        c.weightx = 1.0;
        ++c.gridy;
        panel.add((Component)this.imageSize, c);
        ++c.gridy;
        panel.add((Component)this.tileSize, c);
        ++c.gridy;
        panel.add((Component)this.dataType, c);
        ++c.gridy;
        panel.add((Component)this.sampleModel, c);
        ++c.gridy;
        panel.add((Component)this.colorModel, c);
        ++c.gridy;
        c.anchor = 10;
        c.insets.right = 6;
        panel.add((Component)this.colorRamp, c);
        tabs.addTab(resources.getString(78), panel);
        this.properties = new Table(resources);
        JTable table = new JTable(this.properties);
        tabs.addTab(resources.getString(135), new JScrollPane(table));
        this.samples = new ImageSampleValues();
        tabs.addTab(resources.getString(194), this.samples);
        this.viewer = new ImagePane();
        this.viewer.setPaintingWhileAdjusting(true);
        tabs.addTab(resources.getString(133), this.viewer.createScrollPane());
        this.add((Component)tabs, "Center");
        this.setPreferredSize(new Dimension(400, 250));
    }

    private static JLabel getLabel(int key, Vocabulary resources) {
        return new JLabel(resources.getLabel(key));
    }

    public ImageProperties(RenderedImage image) {
        this();
        if (image != null) {
            this.setImage(image);
        }
    }

    private void setDescription(Object image) {
        String name = " ";
        String description = " ";
        String version = " ";
        Locale locale = this.getLocale();
        Vocabulary resources = Vocabulary.getResources((Locale)locale);
        if (image instanceof OperationNode) {
            OperationNode operation = (OperationNode)image;
            name = operation.getOperationName();
            String mode = operation.getRegistryModeName();
            RegistryElementDescriptor descriptor = operation.getRegistry().getDescriptor(mode, name);
            if (descriptor instanceof OperationDescriptor) {
                ResourceBundle bundle = ((OperationDescriptor)descriptor).getResourceBundle(locale);
                name = bundle.getString("LocalName");
                description = bundle.getString("Description");
                version = resources.getString(183, (Object)bundle.getString("Version")) + ", " + bundle.getString("Vendor");
                name = resources.getString(118, (Object)name);
            }
        } else if (image != null) {
            name = Utilities.getShortClassName((Object)image);
            name = resources.getString(72, (Object)name);
        }
        this.operationName.setText(name);
        this.operationDescription.setText(description);
        this.operationVersion.setText(version);
    }

    private void clear() {
        this.imageSize.setText(null);
        this.tileSize.setText(null);
        this.dataType.setText(null);
        this.sampleModel.setText(null);
        this.colorModel.setText(null);
        this.colorRamp.setColors((IndexColorModel)null);
    }

    public void setImage(PropertySource image) {
        if (image instanceof RenderedImage) {
            this.setImage((RenderedImage)image);
            return;
        }
        if (image instanceof RenderableImage) {
            this.setImage((RenderableImage)image);
            return;
        }
        this.clear();
        this.setDescription(image);
        this.properties.setSource(image);
        this.viewer.setImage((RenderedImage)null);
        this.samples.setImage(null);
    }

    public void setImage(RenderableImage image) {
        this.clear();
        if (image != null) {
            Vocabulary resources = Vocabulary.getResources((Locale)this.getLocale());
            this.imageSize.setText(resources.getString(152, (Object)new Float(image.getWidth()), (Object)new Float(image.getHeight())));
        }
        this.setDescription(image);
        this.properties.setSource(image);
        this.viewer.setImage(image);
        this.samples.setImage(null);
    }

    public void setImage(RenderedImage image) {
        if (image == null) {
            this.clear();
        } else {
            Vocabulary resources = Vocabulary.getResources((Locale)this.getLocale());
            ColorModel cm = image.getColorModel();
            SampleModel sm = image.getSampleModel();
            this.imageSize.setText(resources.getString(74, (Object)new Integer(image.getWidth()), (Object)new Integer(image.getHeight()), (Object)new Integer(sm.getNumBands())));
            this.tileSize.setText(resources.getString(165, (Object)new Integer(image.getNumXTiles()), (Object)new Integer(image.getNumYTiles()), (Object)new Integer(image.getTileWidth()), (Object)new Integer(image.getTileHeight())));
            this.dataType.setText(ImageProperties.getDataType(sm.getDataType(), cm, resources));
            this.sampleModel.setText(ImageProperties.formatClassName(sm, resources));
            this.colorModel.setText(ImageProperties.formatClassName(cm, resources));
            if (cm instanceof IndexColorModel) {
                this.colorRamp.setColors((IndexColorModel)cm);
            } else {
                this.colorRamp.setColors((IndexColorModel)null);
            }
        }
        this.setDescription(image);
        this.properties.setSource(image);
        this.viewer.setImage(image);
        this.samples.setImage(image);
    }

    /*
     * WARNING - void declaration
     */
    private static String getDataType(int type, ColorModel cm, Vocabulary resources) {
        void var3_3;
        switch (type) {
            case 0: 
            case 1: {
                int key = 177;
                break;
            }
            case 2: 
            case 3: {
                int key = 150;
                break;
            }
            case 4: 
            case 5: {
                int key = 136;
                break;
            }
            default: {
                return resources.getString(175);
            }
        }
        Integer typeSize = new Integer(DataBuffer.getDataTypeSize(type));
        Integer pixelSize = cm != null ? new Integer(cm.getPixelSize()) : typeSize;
        return resources.getString((int)var3_3, (Object)typeSize, (Object)pixelSize);
    }

    private static String formatClassName(Object object, Vocabulary resources) {
        if (object == null) {
            return resources.getString(175);
        }
        String name = Utilities.getShortClassName((Object)object);
        int length = name.length();
        StringBuffer buffer = new StringBuffer(length + 8);
        int last = 0;
        for (int i = 1; i <= length; ++i) {
            if (i != length && (!Character.isUpperCase(name.charAt(i)) || !Character.isLowerCase(name.charAt(i - 1)))) continue;
            int pos = buffer.length();
            buffer.append(name.substring(last, i));
            buffer.append(' ');
            if (pos != 0 && last < length - 1 && Character.isLowerCase(name.charAt(last + 1))) {
                buffer.setCharAt(pos, Character.toLowerCase(buffer.charAt(pos)));
            }
            last = i;
        }
        if (object instanceof IndexColorModel) {
            IndexColorModel cm = (IndexColorModel)object;
            buffer.append(" (");
            buffer.append(resources.getString(16, (Object)new Integer(cm.getMapSize())));
            buffer.append(')');
        }
        return buffer.toString().trim();
    }

    private static final class Table
    extends AbstractTableModel
    implements PropertyChangeListener {
        private final Vocabulary resources;
        private PropertySource source;
        private PropertyChangeEmitter changeEmitter;
        private String[] names;

        public Table(Vocabulary resources) {
            this.resources = resources;
        }

        private static PropertySource wrap(RenderedImage image) {
            return new PropertySource(image){
                private final /* synthetic */ RenderedImage val$image;
                {
                    this.val$image = val$image;
                }

                public String[] getPropertyNames() {
                    return this.val$image.getPropertyNames();
                }

                public String[] getPropertyNames(String prefix) {
                    return this.getPropertyNames();
                }

                public Class getPropertyClass(String name) {
                    return null;
                }

                public Object getProperty(String name) {
                    return this.val$image.getProperty(name);
                }
            };
        }

        private static PropertySource wrap(RenderableImage image) {
            return new PropertySource(image){
                private final /* synthetic */ RenderableImage val$image;
                {
                    this.val$image = val$image;
                }

                public String[] getPropertyNames() {
                    return this.val$image.getPropertyNames();
                }

                public String[] getPropertyNames(String prefix) {
                    return this.getPropertyNames();
                }

                public Class getPropertyClass(String name) {
                    return null;
                }

                public Object getProperty(String name) {
                    return this.val$image.getProperty(name);
                }
            };
        }

        public void setSource(Object image) {
            if (image == this.source) {
                return;
            }
            if (this.changeEmitter != null) {
                this.changeEmitter.removePropertyChangeListener((PropertyChangeListener)this);
                this.changeEmitter = null;
            }
            this.source = image instanceof PropertySource ? (PropertySource)image : (image instanceof RenderedImage ? Table.wrap((RenderedImage)image) : (image instanceof RenderableImage ? Table.wrap((RenderableImage)image) : null));
            String[] stringArray = this.names = this.source != null ? this.source.getPropertyNames() : null;
            if (image instanceof PropertyChangeEmitter) {
                this.changeEmitter = (PropertyChangeEmitter)image;
                this.changeEmitter.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.names != null ? this.names.length : 0;
        }

        public int getColumnCount() {
            return 2;
        }

        /*
         * WARNING - void declaration
         */
        public String getColumnName(int column) {
            void var2_2;
            switch (column) {
                case 0: {
                    int key = 109;
                    break;
                }
                case 1: {
                    int key = 182;
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(String.valueOf(column));
                }
            }
            return this.resources.getString((int)var2_2);
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return class$java$lang$String == null ? (class$java$lang$String = ImageProperties.class$("java.lang.String")) : class$java$lang$String;
                }
                case 1: {
                    return class$java$lang$Object == null ? (class$java$lang$Object = ImageProperties.class$("java.lang.Object")) : class$java$lang$Object;
                }
            }
            throw new IndexOutOfBoundsException(String.valueOf(column));
        }

        public Object getValueAt(int row, int column) throws IndexOutOfBoundsException {
            String name = this.names[row];
            switch (column) {
                case 0: {
                    return name;
                }
                case 1: {
                    Object value = this.source.getProperty(name);
                    if (value == Image.UndefinedProperty) {
                        value = this.resources.getString(175);
                    }
                    return Table.expandArray(value);
                }
            }
            throw new IndexOutOfBoundsException(String.valueOf(column));
        }

        private static Object expandArray(Object array) {
            if (array != null && array.getClass().isArray()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append('{');
                int length = Array.getLength(array);
                for (int i = 0; i < length; ++i) {
                    if (i != 0) {
                        buffer.append(", ");
                    }
                    buffer.append(Table.expandArray(Array.get(array, i)));
                }
                buffer.append('}');
                return buffer.toString();
            }
            return array;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(this, event){
                    private final /* synthetic */ PropertyChangeEvent val$event;
                    private final /* synthetic */ Table this$0;
                    {
                        this.this$0 = this$0;
                        this.val$event = val$event;
                    }

                    public void run() {
                        this.this$0.propertyChange(this.val$event);
                    }
                });
                return;
            }
            String name = event.getPropertyName();
            int first = this.getRowCount();
            int last = -1;
            if (name == null) {
                last = first - 1;
                first = 0;
            } else {
                int i = first;
                while (--i >= 0) {
                    if (!this.names[i].equalsIgnoreCase(name)) continue;
                    first = i;
                    if (last >= 0) continue;
                    last = i;
                }
            }
            if (first <= last) {
                this.fireTableRowsUpdated(first, last);
            }
        }
    }
}

