/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.geotools.gui.swing.image.ImageTableModel;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;

public class ImageSampleValues
extends JPanel {
    private final JTable table;
    private final CellRenderer renderer;
    private final SpinnerNumberModel band;
    private final JLabel comments = new JLabel();
    private final CurrentColor current = new CurrentColor();

    public ImageSampleValues() {
        super(new GridBagLayout());
        this.current.setBorder(BorderFactory.createLoweredBevelBorder());
        Dimension size = new Dimension(this.current.getMinimumSize());
        size.width = 60;
        this.current.setMinimumSize(size);
        this.current.setPreferredSize(size);
        ImageTableModel model = new ImageTableModel();
        this.renderer = new CellRenderer();
        this.table = new JTable(model);
        this.table.setDefaultRenderer(Float.class, null);
        this.table.setDefaultRenderer(Double.class, null);
        this.table.setDefaultRenderer(Number.class, this.renderer);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(0);
        this.table.getSelectionModel().addListSelectionListener(this.current);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this.current);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setRowHeaderView(new RowHeaders(model, this.table));
        this.band = new SpinnerNumberModel(1, 1, 1, 1);
        JSpinner spinner = new JSpinner(this.band);
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(3);
        this.band.addChangeListener(this.current);
        Vocabulary resources = Vocabulary.getResources((Locale)ImageSampleValues.getDefaultLocale());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 1;
        c.insets.bottom = 6;
        c.gridx = 0;
        c.insets.left = 9;
        this.add((Component)new JLabel(resources.getLabel(193)), c);
        c.gridx = 1;
        c.insets.left = 0;
        this.add((Component)spinner, c);
        c.fill = 1;
        c.gridx = 3;
        c.insets.right = 9;
        this.add((Component)this.current, c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.insets.right = 15;
        c.insets.left = 15;
        this.add((Component)this.comments, c);
        c.gridx = 0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.gridy = 0;
        c.insets.right = 0;
        c.insets.left = 0;
        this.add((Component)scroll, c);
    }

    public ImageSampleValues(RenderedImage image) {
        this();
        this.setImage(image);
    }

    public void setImage(RenderedImage image) {
        ImageTableModel samples = (ImageTableModel)this.table.getModel();
        boolean isFirst = samples.getRenderedImage() == null;
        samples.setRenderedImage(image);
        this.renderer.formatter = samples.getNumberFormat();
        SampleModel model = image.getSampleModel();
        int numBands = model.getNumBands();
        Integer maximum = new Integer(numBands);
        if (this.band.getNumber().intValue() >= numBands) {
            this.band.setValue(maximum);
        }
        this.band.setMaximum(maximum);
        if (isFirst && model.getDataType() == 0) {
            TableColumnModel columns = this.table.getColumnModel();
            int i = columns.getColumnCount();
            while (--i >= 0) {
                TableColumn column = columns.getColumn(i);
                column.setPreferredWidth(40);
            }
        }
    }

    private final class CurrentColor
    extends JPanel
    implements ChangeListener,
    ListSelectionListener {
        private Color color;

        private CurrentColor() {
        }

        public void paintComponent(Graphics graphics) {
            if (this.color == null) {
                super.paintComponent(graphics);
                return;
            }
            Color oldColor = graphics.getColor();
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(oldColor);
        }

        public void valueChanged(ListSelectionEvent event) {
            ImageTableModel samples;
            Color c;
            if (!event.getValueIsAdjusting() && !Utilities.equals((Object)(c = (samples = (ImageTableModel)ImageSampleValues.this.table.getModel()).getColorAt(ImageSampleValues.this.table.getSelectedRow(), ImageSampleValues.this.table.getSelectedColumn())), (Object)this.color)) {
                this.color = c;
                this.repaint();
            }
        }

        public void stateChanged(ChangeEvent event) {
            ImageTableModel samples = (ImageTableModel)ImageSampleValues.this.table.getModel();
            samples.setBand(ImageSampleValues.this.band.getNumber().intValue() - 1);
        }
    }

    private static final class CellRenderer
    extends DefaultTableCellRenderer {
        NumberFormat formatter;

        public CellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public void setValue(Object value) {
            String text = value == null ? "" : (this.formatter == null ? value.toString() : this.formatter.format(value));
            this.setText(text);
        }
    }

    private static final class RowHeaders
    extends JTable {
        private final JTable table;

        public RowHeaders(ImageTableModel model, JTable table) {
            super(model.new ImageTableModel.RowHeaders());
            this.table = table;
            TableColumn column = this.getColumnModel().getColumn(0);
            column.setCellRenderer(table.getTableHeader().getDefaultRenderer());
            column.setPreferredWidth(50);
            this.setPreferredScrollableViewportSize(this.getPreferredSize());
        }

        public int getRowHeight(int row) {
            return this.table.getRowHeight(row);
        }
    }
}

