/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.image;

import java.awt.Color;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class ImageTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -408603520054548181L;
    private RenderedImage image;
    private NumberFormat format = NumberFormat.getNumberInstance();
    private NumberFormat titleFormat = NumberFormat.getIntegerInstance();
    private int band;
    private transient int minX;
    private transient int minY;
    private transient int maxX;
    private transient int maxY;
    private transient int tileGridXOffset;
    private transient int tileGridYOffset;
    private transient int tileWidth;
    private transient int tileHeight;
    private transient int dataType;
    private transient Class type = Number.class;
    private transient String[] rowNames;
    private transient String[] columnNames;
    private transient Object pixel;
    static /* synthetic */ Class class$java$lang$String;

    public ImageTableModel() {
    }

    public ImageTableModel(RenderedImage image) {
        this.setRenderedImage(image);
    }

    public RenderedImage getRenderedImage() {
        return this.image;
    }

    public void setRenderedImage(RenderedImage image) {
        this.image = image;
        this.pixel = null;
        this.rowNames = null;
        this.columnNames = null;
        int digits = this.update();
        this.format.setMinimumFractionDigits(digits);
        this.format.setMaximumFractionDigits(digits);
        this.fireTableStructureChanged();
    }

    private int update() {
        int digits = 0;
        if (this.image != null) {
            this.minX = this.image.getMinX();
            this.minY = this.image.getMinY();
            this.maxX = this.image.getWidth() + this.minX;
            this.maxY = this.image.getHeight() + this.minY;
            this.tileGridXOffset = this.image.getTileGridXOffset();
            this.tileGridYOffset = this.image.getTileGridYOffset();
            this.tileWidth = this.image.getTileWidth();
            this.tileHeight = this.image.getTileHeight();
            this.dataType = this.image.getSampleModel().getDataType();
            switch (this.dataType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.type = Integer.class;
                    break;
                }
                case 4: {
                    this.type = Float.class;
                    digits = 2;
                    break;
                }
                case 5: {
                    this.type = Double.class;
                    digits = 3;
                    break;
                }
                default: {
                    this.type = Number.class;
                    break;
                }
            }
        } else {
            this.type = Number.class;
        }
        return digits;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.update();
    }

    public int getBand() {
        return this.band;
    }

    public void setBand(int band) {
        if (band < 0 || this.image != null && band >= this.image.getSampleModel().getNumBands()) {
            throw new IndexOutOfBoundsException();
        }
        this.band = band;
        this.fireTableDataChanged();
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    public void setNumberFormat(NumberFormat format) {
        this.format = format;
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.image != null ? this.image.getHeight() : 0;
    }

    public int getColumnCount() {
        return this.image != null ? this.image.getWidth() : 0;
    }

    public String getRowName(int row) {
        String candidate;
        if (this.rowNames == null) {
            this.rowNames = new String[this.image.getHeight()];
        }
        if ((candidate = this.rowNames[row]) == null) {
            this.rowNames[row] = candidate = this.titleFormat.format(this.minY + row);
        }
        return candidate;
    }

    public String getColumnName(int column) {
        String candidate;
        if (this.columnNames == null) {
            if (this.image == null) {
                return super.getColumnName(column);
            }
            this.columnNames = new String[this.image.getWidth()];
        }
        if ((candidate = this.columnNames[column]) == null) {
            this.columnNames[column] = candidate = this.titleFormat.format(this.minX + column);
        }
        return candidate;
    }

    public int findColumn(String name) {
        if (this.image != null) {
            try {
                return this.titleFormat.parse(name).intValue() - this.minX;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return super.findColumn(name);
    }

    public Class getColumnClass(int column) {
        return this.type;
    }

    private final Raster getRasterAt(int y, int x) {
        if (x < this.minX || x >= this.maxX || y < this.minY || y >= this.maxY) {
            return null;
        }
        int tx = x - this.tileGridXOffset;
        if (x < 0) {
            tx += 1 - this.tileWidth;
        }
        int ty = y - this.tileGridYOffset;
        if (y < 0) {
            ty += 1 - this.tileHeight;
        }
        return this.image.getTile(tx / this.tileWidth, ty / this.tileHeight);
    }

    public Object getValueAt(int y, int x) {
        Raster raster = this.getRasterAt(y += this.minY, x += this.minX);
        if (raster == null) {
            return null;
        }
        switch (this.dataType) {
            default: {
                return new Integer(raster.getSample(x, y, this.band));
            }
            case 4: {
                return new Float(raster.getSampleFloat(x, y, this.band));
            }
            case 5: 
        }
        return new Double(raster.getSampleDouble(x, y, this.band));
    }

    public Color getColorAt(int y, int x) {
        Raster raster = this.getRasterAt(y += this.minY, x += this.minX);
        if (raster == null) {
            return null;
        }
        this.pixel = raster.getDataElements(x, y, this.pixel);
        return new Color(this.image.getColorModel().getRGB(this.pixel), true);
    }

    public class RowHeaders
    extends AbstractTableModel
    implements TableModelListener {
        private static final long serialVersionUID = 5162324745024331522L;

        public RowHeaders() {
            ImageTableModel.this.addTableModelListener(this);
        }

        public int getRowCount() {
            return ImageTableModel.this.getRowCount();
        }

        public int getColumnCount() {
            return 1;
        }

        public Class getColumnClass(int column) {
            return class$java$lang$String == null ? (class$java$lang$String = ImageTableModel.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int row, int column) {
            return ImageTableModel.this.getRowName(row);
        }

        public void tableChanged(TableModelEvent event) {
            int firstRow = event.getFirstRow();
            int lastRow = event.getLastRow();
            int type = event.getType();
            if (type != 0 || lastRow == Integer.MAX_VALUE) {
                this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, 0, type));
            }
        }
    }
}

