/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.image;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.media.jai.KernelJAI;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.geotools.resources.SwingUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Vocabulary;

public class KernelEditor
extends JComponent {
    private final Model model = new Model();
    private final JComboBox categorySelector = new JComboBox();
    private final JComboBox kernelSelector = new JComboBox(this.model);
    private final JSpinner widthSelector = new JSpinner();
    private final JSpinner heightSelector = new JSpinner();
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$org$geotools$gui$swing$image$KernelEditor;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public KernelEditor() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        Vocabulary resources = Vocabulary.getResources((Locale)KernelEditor.getDefaultLocale());
        this.categorySelector.addItem(resources.getString(4));
        this.categorySelector.addItemListener(this.model);
        this.widthSelector.addChangeListener(this.model);
        this.heightSelector.addChangeListener(this.model);
        JTable matrixView = new JTable(this.model);
        matrixView.setTableHeader(null);
        matrixView.setRowSelectionAllowed(false);
        matrixView.setColumnSelectionAllowed(false);
        GridBagConstraints c = new GridBagConstraints();
        JPanel predefinedKernels = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.fill = 2;
        c.gridy = 2;
        predefinedKernels.add((Component)new JLabel(resources.getLabel(11), 4), c);
        c.gridy = 3;
        predefinedKernels.add((Component)new JLabel(resources.getLabel(83), 4), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets.left = 0;
        c.gridy = 2;
        predefinedKernels.add((Component)this.categorySelector, c);
        c.gridy = 3;
        predefinedKernels.add((Component)this.kernelSelector, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 0;
        this.add((Component)predefinedKernels, c);
        predefinedKernels.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(resources.getString(131)), BorderFactory.createEmptyBorder(3, 9, 6, 6)));
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.bottom = 3;
        c.gridy = 0;
        this.add((Component)new JLabel(resources.getLabel(151), 4), c);
        c.gridx = 2;
        this.add((Component)new JLabel(' ' + resources.getString(89).toLowerCase() + " \u00d7 ", 0), c);
        c.gridx = 4;
        this.add((Component)new JLabel(' ' + resources.getString(19).toLowerCase(), 2), c);
        c.weightx = 1.0;
        c.gridx = 1;
        this.add((Component)this.heightSelector, c);
        c.gridx = 3;
        this.add((Component)this.widthSelector, c);
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 1;
        c.insets.bottom = 9;
        c.gridy = 1;
        c.weighty = 1.0;
        c.insets.top = 6;
        this.add((Component)new JScrollPane(matrixView), c);
        this.setPreferredSize(new Dimension(300, 220));
    }

    final Vocabulary getResources() {
        Locale locale;
        try {
            locale = this.getLocale();
        }
        catch (IllegalComponentStateException exception) {
            locale = KernelEditor.getDefaultLocale();
        }
        return Vocabulary.getResources((Locale)locale);
    }

    public void addDefaultKernels() {
        Vocabulary resources = this.getResources();
        String ERROR_FILTERS = resources.getString(42);
        String GRADIENT_MASKS = resources.getString(63);
        this.addKernel(ERROR_FILTERS, "Floyd & Steinberg (1975)", KernelJAI.ERROR_FILTER_FLOYD_STEINBERG);
        this.addKernel(ERROR_FILTERS, "Jarvis, Judice & Ninke (1976)", KernelJAI.ERROR_FILTER_JARVIS);
        this.addKernel(ERROR_FILTERS, "Stucki (1981)", KernelJAI.ERROR_FILTER_STUCKI);
        this.addKernel(GRADIENT_MASKS, "Sobel horizontal", KernelJAI.GRADIENT_MASK_SOBEL_VERTICAL);
        this.addKernel(GRADIENT_MASKS, "Sobel vertical", KernelJAI.GRADIENT_MASK_SOBEL_HORIZONTAL);
        this.addKernel("Sharp 1", new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f});
        this.addKernel("Sharp 2", new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
        this.addKernel("Sharp 3", new float[]{1.0f, -2.0f, 1.0f, -2.0f, 5.0f, -2.0f, 1.0f, -2.0f, 1.0f});
        this.addKernel("Sharp 4", new float[]{-1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f});
        this.addKernel("Laplace 1", new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f});
        this.addKernel("Laplace 2", new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 8.0f, -1.0f, -1.0f, -1.0f, -1.0f});
        this.addKernel("Box", new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
        this.addKernel("Low pass", new float[]{1.0f, 2.0f, 1.0f, 2.0f, 4.0f, 2.0f, 1.0f, 2.0f, 1.0f});
        if (this.model.getRowCount() * this.model.getColumnCount() == 0) {
            this.setKernel("Box");
        }
    }

    private void addKernel(String name, float[] data) {
        int i;
        double sum = 0.0;
        for (i = 0; i < data.length; ++i) {
            sum += (double)data[i];
        }
        if (sum != 0.0) {
            i = 0;
            while (i < data.length) {
                int n = i++;
                data[n] = (float)((double)data[n] / sum);
            }
        }
        this.addKernel(null, name, new KernelJAI(3, 3, data));
    }

    public void addKernel(String category, String name, KernelJAI kernel) {
        if (category == null) {
            category = Vocabulary.getResources((Locale)this.getLocale()).getString(124);
        }
        this.model.addKernel(category, name, kernel);
    }

    private void addCategory(String category) {
        ComboBoxModel categories = this.categorySelector.getModel();
        int i = categories.getSize();
        while (--i >= 0) {
            if (!category.equals(categories.getElementAt(i))) continue;
            return;
        }
        this.categorySelector.addItem(category);
    }

    public void removeKernel(KernelJAI kernel) {
        this.model.removeKernel(kernel);
    }

    public void removeKernel(String kernel) {
        this.removeKernel(this.model.getKernel(kernel));
    }

    public void removeAllKernels() {
        this.model.removeAllKernels();
    }

    public void setKernel(KernelJAI kernel) {
        this.model.setKernel(kernel);
        this.model.findKernelName();
    }

    public void setKernel(String name) {
        this.kernelSelector.setSelectedItem(name);
        this.kernelSelector.repaint();
    }

    public void setKernelSize(int width, int height) {
        this.model.setKernelSize(height, width);
        this.model.findKernelName();
    }

    public KernelJAI getKernel() {
        return this.model.getKernel();
    }

    public String getKernelCategory() {
        return this.categorySelector.getSelectedIndex() <= 0 ? null : (String)this.categorySelector.getSelectedItem();
    }

    public void sortKernelNames(Comparator comparator) {
        this.model.sortKernelNames(comparator);
    }

    public String[] getKernelNames() {
        return (String[])this.model.getKernelNames().clone();
    }

    public ComboBoxModel getKernelListModel() {
        return this.model;
    }

    public TableModel getKernelTableModel() {
        return this.model;
    }

    public boolean showDialog(Component owner, String title) {
        return SwingUtilities.showOptionDialog((Component)owner, (Object)this, (String)title);
    }

    public static void main(String[] args) {
        KernelEditor editor = new KernelEditor();
        editor.addDefaultKernels();
        editor.showDialog(null, Utilities.getShortClassName((Object)editor));
    }

    private final class Model
    extends AbstractTableModel
    implements ComboBoxModel,
    ChangeListener,
    ItemListener {
        private final Map kernels = new HashMap();
        private final Map categories = new LinkedHashMap();
        private boolean sorted;
        private String[] names;
        private String name;
        private float[][] elements = new float[0][];
        static final /* synthetic */ boolean $assertionsDisabled;

        private Model() {
        }

        public int getSize() {
            return this.getKernelNames().length;
        }

        public int getRowCount() {
            return this.elements.length;
        }

        public int getColumnCount() {
            return this.elements.length != 0 ? this.elements[0].length : 0;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$Float == null ? (class$java$lang$Float = KernelEditor.class$("java.lang.Float")) : class$java$lang$Float;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return new Float(this.elements[rowIndex][columnIndex]);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.elements[rowIndex][columnIndex] = value != null ? ((Number)value).floatValue() : 0.0f;
            this.fireTableCellUpdated(rowIndex, columnIndex);
            this.findKernelName();
        }

        public Object getElementAt(int index) {
            return this.getKernelNames()[index];
        }

        public Object getSelectedItem() {
            return this.name != null ? this.name : this.getString(129);
        }

        public void setSelectedItem(Object item) {
            String newName = item.toString();
            if (!newName.equals(this.name)) {
                KernelJAI kernel = (KernelJAI)this.kernels.get(newName);
                if (kernel != null) {
                    this.setKernel(kernel);
                }
                KernelEditor.this.categorySelector.setSelectedItem(this.categories.get(newName));
                this.name = newName;
            }
        }

        public KernelJAI getKernel() {
            int height = this.elements.length;
            int width = height != 0 ? this.elements[0].length : 0;
            float[] data = new float[width * height];
            int c = 0;
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    data[c++] = this.elements[j][i];
                }
            }
            return new KernelJAI(width, height, data);
        }

        public void setKernel(KernelJAI kernel) {
            int rowCount = kernel.getHeight();
            int colCount = kernel.getWidth();
            this.setKernelSize(rowCount, colCount);
            for (int j = 0; j < rowCount; ++j) {
                for (int i = 0; i < colCount; ++i) {
                    this.elements[j][i] = kernel.getElement(i, j);
                }
            }
            this.fireTableDataChanged();
        }

        public void setKernelSize(int rowCount, int colCount) {
            int oldColCount;
            int oldRowCount = this.elements.length;
            int n = oldColCount = oldRowCount != 0 ? this.elements[0].length : 0;
            if (rowCount != oldRowCount || colCount != oldColCount) {
                this.elements = (float[][])XArray.resize((Object[])this.elements, (int)rowCount);
                for (int i = 0; i < this.elements.length; ++i) {
                    this.elements[i] = this.elements[i] == null ? new float[colCount] : XArray.resize((float[])this.elements[i], (int)colCount);
                }
                if (colCount != oldColCount) {
                    this.fireTableStructureChanged();
                } else if (rowCount > oldRowCount) {
                    this.fireTableRowsInserted(oldRowCount, rowCount - 1);
                } else if (rowCount < oldRowCount) {
                    this.fireTableRowsDeleted(rowCount, oldRowCount - 1);
                }
                KernelEditor.this.widthSelector.setValue(new Integer(colCount));
                KernelEditor.this.heightSelector.setValue(new Integer(rowCount));
            }
        }

        private int indexOf(String category, String toSearch) {
            int index = 0;
            Iterator it = this.categories.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                if (category == null || category.equals(entry.getValue())) {
                    if (toSearch.equals(name)) {
                        if (!$assertionsDisabled && this.sorted && Arrays.binarySearch(this.getKernelNames(), toSearch) != index) {
                            throw new AssertionError();
                        }
                        return index;
                    }
                    ++index;
                }
                if (!this.sorted || name.compareTo(toSearch) < 0) continue;
                break;
            }
            if (!$assertionsDisabled && this.sorted && Arrays.binarySearch(this.getKernelNames(), toSearch) >= 0) {
                throw new AssertionError();
            }
            return -1;
        }

        public void addKernel(String category, String name, KernelJAI kernel) {
            this.sorted = false;
            if (!category.equals(this.categories.put(name, category))) {
                KernelEditor.this.addCategory(category);
            }
            if (this.kernels.put(name, kernel) != null) {
                this.findKernelName();
            } else {
                String cc = KernelEditor.this.getKernelCategory();
                if (cc == null || category.equals(cc)) {
                    this.names = null;
                    int index = this.indexOf(cc, name);
                    if (!$assertionsDisabled && index < 0) {
                        throw new AssertionError((Object)name);
                    }
                    this.fireListChanged(1, index, index);
                }
            }
            if (!$assertionsDisabled && this.kernels.size() != this.categories.size()) {
                throw new AssertionError();
            }
        }

        public void removeKernel(KernelJAI kernel) {
            String cc = KernelEditor.this.getKernelCategory();
            Iterator it = this.kernels.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!kernel.equals(entry.getValue())) continue;
                String name = (String)entry.getKey();
                int index = this.indexOf(cc, name);
                String category = (String)this.categories.remove(name);
                if (!this.categories.values().contains(category)) {
                    KernelEditor.this.categorySelector.removeItem(category);
                }
                it.remove();
                if (index < 0) continue;
                this.names = null;
                this.fireListChanged(2, index, index);
            }
            if (!$assertionsDisabled && this.kernels.size() != this.categories.size()) {
                throw new AssertionError();
            }
        }

        public void removeAllKernels() {
            int size = this.kernels.size();
            this.kernels.clear();
            this.categories.clear();
            this.names = null;
            this.fireListChanged(2, 0, size - 1);
            KernelEditor.this.categorySelector.removeAllItems();
            KernelEditor.this.categorySelector.addItem(KernelEditor.this.getResources().getString(4));
        }

        public KernelJAI getKernel(String name) {
            return (KernelJAI)this.kernels.get(name);
        }

        public String[] getKernelNames() {
            if (this.names == null) {
                int count = 0;
                this.names = new String[this.kernels.size() + 1];
                String category = KernelEditor.this.getKernelCategory();
                Iterator it = this.categories.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (category != null && !category.equals(entry.getValue())) continue;
                    this.names[count++] = (String)entry.getKey();
                }
                this.names[count++] = this.getString(129);
                this.names = (String[])XArray.resize((Object[])this.names, (int)count);
            }
            return this.names;
        }

        protected void findKernelName() {
            String newName = null;
            int rowCount = this.elements.length;
            int colCount = rowCount != 0 ? this.elements[0].length : 0;
            Iterator it = this.kernels.entrySet().iterator();
            block0: while (it.hasNext()) {
                Map.Entry entry = it.next();
                KernelJAI kernel = (KernelJAI)entry.getValue();
                if (rowCount != kernel.getHeight() || colCount != kernel.getWidth()) continue;
                for (int j = 0; j < rowCount; ++j) {
                    for (int i = 0; i < colCount; ++i) {
                        if (this.elements[j][i] != kernel.getElement(i, j)) continue block0;
                    }
                }
                newName = (String)entry.getKey();
            }
            if (newName == null) {
                newName = this.getString(129);
            }
            if (!newName.equals(this.name)) {
                this.name = newName;
                KernelEditor.this.categorySelector.setSelectedItem(this.categories.get(newName));
                KernelEditor.this.kernelSelector.setSelectedItem(newName);
                KernelEditor.this.kernelSelector.repaint();
            }
        }

        public void sortKernelNames(Comparator comparator) {
            TreeMap sorted = new TreeMap(comparator);
            sorted.putAll(this.categories);
            this.categories.clear();
            this.categories.putAll(sorted);
            this.names = null;
            this.sorted = comparator == null;
            this.fireListChanged(0, 0, this.categories.size() - 1);
        }

        public void stateChanged(ChangeEvent event) {
            int rowCount = ((Number)KernelEditor.this.heightSelector.getValue()).intValue();
            int colCount = ((Number)KernelEditor.this.widthSelector.getValue()).intValue();
            this.setKernelSize(rowCount, colCount);
            this.findKernelName();
        }

        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                this.names = null;
                this.fireListChanged(0, 0, this.categories.size());
            }
        }

        private String getString(int key) {
            return KernelEditor.this.getResources().getString(key);
        }

        public void addListDataListener(ListDataListener listener) {
            this.listenerList.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = KernelEditor.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listener);
        }

        public void removeListDataListener(ListDataListener listener) {
            this.listenerList.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = KernelEditor.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listener);
        }

        private void fireListChanged(int type, int index0, int index1) {
            ListDataEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length;
            while ((i -= 2) >= 0) {
                if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? KernelEditor.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
                if (event == null) {
                    event = new ListDataEvent(this, type, index0, index1);
                }
                ListDataListener listener = (ListDataListener)listeners[i + 1];
                switch (type) {
                    case 0: {
                        listener.contentsChanged(event);
                        break;
                    }
                    case 1: {
                        listener.intervalAdded(event);
                        break;
                    }
                    case 2: {
                        listener.intervalRemoved(event);
                    }
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$geotools$gui$swing$image$KernelEditor == null ? (class$org$geotools$gui$swing$image$KernelEditor = KernelEditor.class$("org.geotools.gui.swing.image.KernelEditor")) : class$org$geotools$gui$swing$image$KernelEditor).desiredAssertionStatus();
        }
    }
}

