/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.image;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.jai.OperationNode;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.PropertySource;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.geotools.gui.swing.IconFactory;
import org.geotools.gui.swing.ParameterEditor;
import org.geotools.gui.swing.image.ImageProperties;
import org.geotools.gui.swing.tree.DefaultMutableTreeNode;
import org.geotools.gui.swing.tree.MutableTreeNode;
import org.geotools.gui.swing.tree.NamedTreeNode;
import org.geotools.resources.Arguments;
import org.geotools.resources.SwingUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;

public class OperationTreeBrowser
extends JPanel {
    private static final String IMAGE = "Image";
    private static final String PARAMETER = "Parameter";
    private ImageProperties imageProperties;
    private ParameterEditor parameterEditor;
    private final Container cards = new JPanel(new CardLayout());

    public OperationTreeBrowser(RenderedImage source) {
        this(OperationTreeBrowser.getTree(source, OperationTreeBrowser.getDefaultLocale()));
    }

    public OperationTreeBrowser(RenderableImage source) {
        this(OperationTreeBrowser.getTree(source, OperationTreeBrowser.getDefaultLocale()));
    }

    private OperationTreeBrowser(TreeModel model) {
        super(new BorderLayout());
        Listeners listeners = new Listeners();
        JTree tree = new JTree(model);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer(new CellRenderer());
        tree.setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 0));
        tree.addTreeSelectionListener(listeners);
        JSplitPane split = new JSplitPane(1, new JScrollPane(tree), this.cards);
        split.setDividerLocation(220);
        this.add((Component)split, "Center");
        this.setPreferredSize(new Dimension(600, 250));
    }

    public static void show(RenderedImage image) {
        new OperationTreeBrowser(image).showFrame(image);
    }

    public static void show(RenderableImage image) {
        new OperationTreeBrowser(image).showFrame(image);
    }

    private static String getName(Object image) {
        if (image instanceof OperationNode) {
            return ((OperationNode)image).getOperationName();
        }
        if (image instanceof CharSequence) {
            return image.toString();
        }
        return Utilities.getShortClassName((Object)image);
    }

    public static TreeModel getTree(RenderedImage image, Locale locale) {
        return new DefaultTreeModel(OperationTreeBrowser.getNode(image, locale));
    }

    public static TreeModel getTree(RenderableImage image, Locale locale) {
        return new DefaultTreeModel(OperationTreeBrowser.getNode(image, locale));
    }

    private static MutableTreeNode getNode(RenderedImage image, Locale locale) {
        NamedTreeNode root = new NamedTreeNode(OperationTreeBrowser.getName(image), image);
        Vector<RenderedImage> sources = image.getSources();
        if (sources != null) {
            int n = sources.size();
            for (int i = 0; i < n; ++i) {
                root.add(OperationTreeBrowser.getNode((RenderedImage)sources.get(i), locale));
            }
        }
        if (image instanceof OperationNode) {
            OperationTreeBrowser.addParameters(root, (OperationNode)image, locale);
        }
        return root;
    }

    private static MutableTreeNode getNode(RenderableImage image, Locale locale) {
        NamedTreeNode root = new NamedTreeNode(OperationTreeBrowser.getName(image), image);
        Vector<RenderableImage> sources = image.getSources();
        if (sources != null) {
            int n = sources.size();
            for (int i = 0; i < n; ++i) {
                root.add(OperationTreeBrowser.getNode((RenderableImage)sources.get(i), locale));
            }
        }
        if (image instanceof OperationNode) {
            OperationTreeBrowser.addParameters(root, (OperationNode)image, locale);
        }
        return root;
    }

    private static void addParameters(DefaultMutableTreeNode root, OperationNode operation, Locale locale) {
        ParameterListDescriptor descriptor;
        ParameterBlock param = operation.getParameterBlock();
        if (param instanceof ParameterList) {
            descriptor = ((ParameterList)param).getParameterListDescriptor();
        } else {
            String name = operation.getOperationName();
            String mode = operation.getRegistryModeName();
            descriptor = operation.getRegistry().getDescriptor(mode, name).getParameterListDescriptor(mode);
        }
        Vocabulary resources = null;
        String[] names = descriptor.getParamNames();
        int n = param.getNumParameters();
        for (int i = 0; i < n; ++i) {
            String name = null;
            if (names != null && i < names.length) {
                name = names[i];
            }
            if (name == null) {
                if (resources == null) {
                    resources = Vocabulary.getResources((Locale)locale);
                }
                name = resources.getString(127, (Object)new Integer(i));
            }
            root.add(new NamedTreeNode(name, param.getObjectParameter(i), false));
        }
    }

    protected boolean showSourceEditor(Object selection) {
        if (this.imageProperties == null) {
            this.imageProperties = new ImageProperties();
            this.cards.add((Component)this.imageProperties, IMAGE);
        }
        ((CardLayout)this.cards.getLayout()).show(this.cards, IMAGE);
        if (selection instanceof RenderedImage) {
            this.imageProperties.setImage((RenderedImage)selection);
            return true;
        }
        if (selection instanceof RenderableImage) {
            this.imageProperties.setImage((RenderableImage)selection);
            return true;
        }
        if (selection instanceof PropertySource) {
            this.imageProperties.setImage((PropertySource)selection);
            return true;
        }
        this.imageProperties.setImage((PropertySource)null);
        return false;
    }

    protected boolean showParameterEditor(Object selection) {
        if (this.parameterEditor == null) {
            this.parameterEditor = new ParameterEditor();
            this.cards.add((Component)this.parameterEditor, PARAMETER);
        }
        ((CardLayout)this.cards.getLayout()).show(this.cards, PARAMETER);
        this.parameterEditor.setParameterValue(selection);
        return true;
    }

    public boolean showDialog(Component owner, String title) {
        if (title == null) {
            title = Vocabulary.getResources((Locale)this.getLocale()).getString(117);
        }
        return SwingUtilities.showOptionDialog((Component)owner, (Object)this, (String)title);
    }

    private void showFrame(Object image) {
        JFrame frame = new JFrame(Utilities.getShortClassName((Object)this) + " - " + OperationTreeBrowser.getName(image));
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add(this);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) throws IOException {
        Arguments arguments = new Arguments(args);
        args = arguments.getRemainingArguments(Integer.MAX_VALUE);
        for (int i = 0; i < args.length; ++i) {
            BufferedImage image;
            File file = new File(args[i]);
            try {
                image = ImageIO.read(file);
            }
            catch (FileNotFoundException e) {
                arguments.out.println(Errors.format((int)36, (Object)file));
                continue;
            }
            new OperationTreeBrowser(image).showFrame(file.getName());
        }
    }

    private static final class CellRenderer
    extends DefaultTreeCellRenderer {
        private final Icon open = this.getDefaultOpenIcon();
        private final Icon closed = this.getDefaultClosedIcon();
        private static Icon image;
        private static Icon parameter;

        private CellRenderer() {
            if (image == null) {
                IconFactory icons = IconFactory.DEFAULT;
                image = icons.getIcon("toolbarButtonGraphics/general/Properties16.gif");
                parameter = icons.getIcon("toolbarButtonGraphics/general/Preferences16.gif");
            }
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (((org.geotools.gui.swing.tree.TreeNode)value).getUserObject() instanceof RenderedImage) {
                if (image != null) {
                    this.setOpenIcon(image);
                    this.setClosedIcon(image);
                    this.setLeafIcon(image);
                } else {
                    this.setLeafIcon(null);
                }
            } else if (parameter != null) {
                this.setOpenIcon(this.open);
                this.setClosedIcon(this.closed);
                this.setLeafIcon(parameter);
            }
            return super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, hasFocus);
        }
    }

    private final class Listeners
    implements TreeSelectionListener {
        private Listeners() {
        }

        public void valueChanged(TreeSelectionEvent event) {
            Object selection = null;
            boolean isSource = false;
            OperationNode operation = null;
            int paramIndex = -1;
            TreePath path = event.getPath();
            if (path != null) {
                selection = path.getLastPathComponent();
                if (selection instanceof TreeNode) {
                    Object candidate;
                    TreeNode node = (TreeNode)selection;
                    isSource = node.getAllowsChildren();
                    if ((node = node.getParent()) instanceof org.geotools.gui.swing.tree.TreeNode && (candidate = ((org.geotools.gui.swing.tree.TreeNode)node).getUserObject()) instanceof OperationNode) {
                        operation = (OperationNode)candidate;
                        int count = node.getChildCount();
                        int n = -1;
                        for (int i = 0; i < count; ++i) {
                            TreeNode leaf = node.getChildAt(i);
                            if (!leaf.getAllowsChildren()) {
                                ++n;
                            }
                            if (leaf != selection) continue;
                            paramIndex = n;
                            break;
                        }
                    }
                }
                if (selection instanceof org.geotools.gui.swing.tree.TreeNode) {
                    selection = ((org.geotools.gui.swing.tree.TreeNode)selection).getUserObject();
                }
            }
            if (isSource) {
                OperationTreeBrowser.this.showSourceEditor(selection);
            } else {
                OperationTreeBrowser.this.showParameterEditor(selection);
            }
            if (OperationTreeBrowser.this.parameterEditor != null) {
                OperationTreeBrowser.this.parameterEditor.setDescription(operation, paramIndex);
            }
        }
    }
}

