/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.image;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.RegistryElementDescriptor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geotools.gui.swing.IconFactory;
import org.geotools.gui.swing.tree.DefaultMutableTreeNode;
import org.geotools.gui.swing.tree.NamedTreeNode;
import org.geotools.gui.swing.tree.TreeNode;
import org.geotools.gui.swing.tree.Trees;
import org.geotools.resources.Arguments;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;

public class RegisteredOperationBrowser
extends JPanel {
    private final JLabel description = new JLabel(" ");
    private final JLabel version = new JLabel(" ");

    public RegisteredOperationBrowser() {
        this(RegisteredOperationBrowser.getTree());
    }

    public RegisteredOperationBrowser(OperationRegistry registry) {
        this(RegisteredOperationBrowser.getTree(registry, RegisteredOperationBrowser.getDefaultLocale()));
    }

    private RegisteredOperationBrowser(TreeModel model) {
        super(new BorderLayout());
        JTree tree = new JTree(model);
        tree.setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 0));
        this.add((Component)new JScrollPane(tree), "Center");
        Box labels = Box.createVerticalBox();
        labels.add(this.description);
        labels.add(this.version);
        labels.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 0));
        this.add((Component)labels, "South");
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                RegisteredOperationBrowser.this.selected(event.getNewLeadSelectionPath());
            }
        });
        tree.setCellRenderer(new CellRenderer());
    }

    private void selected(TreePath path) {
        if (path != null) {
            int i = path.getPathCount();
            while (--i >= 0) {
                Object component = path.getPathComponent(i);
                Object candidate = component;
                if (candidate instanceof TreeNode) {
                    candidate = ((TreeNode)candidate).getUserObject();
                }
                if (!(candidate instanceof OperationDescriptor)) continue;
                int index = -1;
                if (component instanceof javax.swing.tree.TreeNode) {
                    javax.swing.tree.TreeNode param;
                    javax.swing.tree.TreeNode node = (javax.swing.tree.TreeNode)component;
                    Object leaf = path.getLastPathComponent();
                    index = node.getChildCount();
                    while (--index >= 0 && ((param = node.getChildAt(index)) != leaf || param.getAllowsChildren())) {
                    }
                }
                this.selected((OperationDescriptor)candidate, index);
                return;
            }
        }
        this.selected(null, -1);
    }

    protected void selected(OperationDescriptor operation, int param) {
        String description = " ";
        String version = " ";
        if (operation != null) {
            Locale locale = this.getLocale();
            ResourceBundle resources = operation.getResourceBundle(locale);
            String key = param >= 0 ? "arg" + param + "Desc" : "Description";
            try {
                description = resources.getString(key);
                version = Vocabulary.getResources((Locale)locale).getString(183, (Object)resources.getString("Version")) + ", " + resources.getString("Vendor");
            }
            catch (MissingResourceException exception) {
                Logger.getLogger("org.geotools.gui.swing").log(Level.FINER, exception.getLocalizedMessage(), exception);
            }
        }
        this.description.setText(description);
        this.version.setText(version);
    }

    public static TreeModel getTree() {
        return RegisteredOperationBrowser.getTree(JAI.getDefaultInstance().getOperationRegistry(), RegisteredOperationBrowser.getDefaultLocale());
    }

    public static TreeModel getTree(OperationRegistry registry, Locale locale) {
        Vocabulary resources = Vocabulary.getResources((Locale)locale);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(resources.getString(117));
        Object[] modes = registry.getRegistryModes();
        Arrays.sort(modes);
        for (int i = 0; i < modes.length; ++i) {
            Object mode = modes[i];
            DefaultMutableTreeNode modeNode = new DefaultMutableTreeNode(mode);
            List descriptors = registry.getDescriptors((String)mode);
            Collections.sort(descriptors, new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    RegistryElementDescriptor desc1 = (RegistryElementDescriptor)obj1;
                    RegistryElementDescriptor desc2 = (RegistryElementDescriptor)obj2;
                    return desc1.getName().compareTo(desc2.getName());
                }
            });
            Iterator it = descriptors.iterator();
            while (it.hasNext()) {
                String operationName;
                Vector products;
                String[] names;
                RegistryElementDescriptor descriptor = (RegistryElementDescriptor)it.next();
                NamedTreeNode descriptorNode = new NamedTreeNode(RegisteredOperationBrowser.getName(descriptor, locale), descriptor);
                ParameterListDescriptor param = descriptor.getParameterListDescriptor((String)mode);
                if (param != null && (names = param.getParamNames()) != null) {
                    for (int j = 0; j < names.length; ++j) {
                        descriptorNode.add(new DefaultMutableTreeNode(names[j], false));
                    }
                }
                if ((products = registry.getOrderedProductList((String)mode, operationName = descriptor.getName())) != null) {
                    DefaultMutableTreeNode productsNode = new DefaultMutableTreeNode(resources.getString(75));
                    Iterator itp = products.iterator();
                    while (itp.hasNext()) {
                        String product = (String)itp.next();
                        DefaultMutableTreeNode productNode = new DefaultMutableTreeNode(product);
                        List factories = registry.getOrderedFactoryList((String)mode, operationName, product);
                        if (factories != null) {
                            Iterator itf = factories.iterator();
                            while (itf.hasNext()) {
                                Object factory = itf.next();
                                productNode.add(new NamedTreeNode(Utilities.getShortClassName(factory), factory, false));
                            }
                        }
                        productsNode.add(productNode);
                    }
                    descriptorNode.add(productsNode);
                }
                modeNode.add(descriptorNode);
            }
            root.add(modeNode);
        }
        return new DefaultTreeModel(root, true);
    }

    private static String getName(RegistryElementDescriptor descriptor, Locale locale) {
        ResourceBundle resources;
        if (descriptor instanceof OperationDescriptor && (resources = ((OperationDescriptor)descriptor).getResourceBundle(locale)) != null) {
            try {
                return resources.getString("LocalName");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return descriptor.getName();
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        Locale.setDefault(arguments.locale);
        if (arguments.getFlag("-print")) {
            arguments.out.println(Trees.toString(RegisteredOperationBrowser.getTree()));
        } else {
            JFrame frame = new JFrame(Vocabulary.format((int)117));
            frame.setDefaultCloseOperation(2);
            frame.getContentPane().add(new RegisteredOperationBrowser());
            frame.pack();
            frame.setVisible(true);
        }
    }

    private static final class CellRenderer
    extends DefaultTreeCellRenderer {
        private final Icon open = this.getDefaultOpenIcon();
        private final Icon closed = this.getDefaultClosedIcon();
        private static Icon operation;
        private static Icon parameter;
        private static Icon implementation;

        private CellRenderer() {
            if (operation == null) {
                IconFactory icons = IconFactory.DEFAULT;
                operation = icons.getIcon("toolbarButtonGraphics/general/Information16.gif");
                parameter = icons.getIcon("toolbarButtonGraphics/general/Preferences16.gif");
                implementation = icons.getIcon("toolbarButtonGraphics/general/About16.gif");
            }
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Icon icon;
            boolean isOp = ((TreeNode)value).getUserObject() instanceof RegistryElementDescriptor;
            Icon icon2 = icon = isOp ? operation : this.open;
            if (icon != null) {
                this.setOpenIcon(icon);
            }
            Icon icon3 = icon = isOp ? operation : this.closed;
            if (icon != null) {
                this.setClosedIcon(icon);
            }
            Icon icon4 = icon = value instanceof NamedTreeNode ? implementation : parameter;
            if (icon != null) {
                this.setLeafIcon(icon);
            }
            return super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, hasFocus);
        }
    }
}

