/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.referencing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.gui.swing.IconFactory;
import org.geotools.gui.swing.referencing.Code;
import org.geotools.gui.swing.referencing.CodeList;
import org.geotools.gui.swing.referencing.PropertiesSheet;
import org.geotools.referencing.FactoryFinder;
import org.geotools.resources.Arguments;
import org.geotools.resources.SwingUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AuthorityCodesComboBox
extends JComponent {
    private final AuthorityFactory factory;
    private final CodeList codeList;
    private Class type;
    private final JComboBox list;
    private final JTextField search;
    private final JPanel searchOrList;
    private final CardLayout cards;
    private final JButton showProperties;
    private PropertiesSheet properties;
    private Component propertiesWindow;

    public AuthorityCodesComboBox() throws FactoryRegistryException, FactoryException {
        this((AuthorityFactory)FactoryFinder.getCRSAuthorityFactory((String)"EPSG", null));
    }

    public AuthorityCodesComboBox(AuthorityFactory factory) throws FactoryException {
        this(factory, CoordinateReferenceSystem.class);
    }

    public AuthorityCodesComboBox(AuthorityFactory factory, Class type) throws FactoryException {
        this.factory = factory;
        this.type = type;
        Locale locale = SwingUtilities.getLocale((Component)this);
        Vocabulary resources = Vocabulary.getResources((Locale)locale);
        this.setLayout(new BorderLayout());
        this.cards = new CardLayout();
        this.searchOrList = new JPanel(this.cards);
        this.codeList = new CodeList(factory, type);
        this.list = new JComboBox(this.codeList);
        this.list.setPrototypeDisplayValue("Unknown datum based upon the Average Terrestrial System 1977 ellipsoid");
        this.search = new JTextField();
        this.search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AuthorityCodesComboBox.this.search(false);
            }
        });
        this.searchOrList.add((Component)this.list, "List");
        this.searchOrList.add((Component)this.search, "Search");
        this.add((Component)this.searchOrList, "Center");
        Dimension size = new Dimension(24, 20);
        IconFactory icons = IconFactory.DEFAULT;
        String label = resources.getString(78);
        JButton button = icons.getButton("toolbarButtonGraphics/general/Information16.gif", label, label);
        button.setFocusable(false);
        button.setPreferredSize(size);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AuthorityCodesComboBox.this.showProperties();
            }
        });
        this.add((Component)button, "West");
        this.showProperties = button;
        label = resources.getString(229);
        button = icons.getButton("toolbarButtonGraphics/general/Find16.gif", label, label);
        button.setFocusable(false);
        button.setPreferredSize(size);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AuthorityCodesComboBox.this.search(true);
            }
        });
        this.add((Component)button, "East");
    }

    public String getAuthority() {
        Locale locale = SwingUtilities.getLocale((Component)this);
        return this.factory.getAuthority().getTitle().toString(locale);
    }

    public String getSelectedCode() {
        Code code = (Code)this.list.getModel().getSelectedItem();
        return code != null ? code.code : null;
    }

    public IdentifiedObject getSelectedItem() throws FactoryException {
        String code = this.getSelectedCode();
        return code != null ? this.factory.createObject(code) : null;
    }

    public void showProperties() {
        IdentifiedObject item;
        if (this.properties == null) {
            this.properties = new PropertiesSheet();
        }
        try {
            item = this.getSelectedItem();
        }
        catch (FactoryException e) {
            String message = e.getLocalizedMessage();
            if (message == null) {
                message = Utilities.getShortClassName((Object)((Object)e));
            }
            this.properties.setErrorMessage(message);
            return;
        }
        String title = item.getName().getCode();
        if (this.propertiesWindow == null) {
            this.propertiesWindow = SwingUtilities.toFrame((Component)this, (JComponent)this.properties, (String)title, null);
            if (this.propertiesWindow instanceof JFrame) {
                ((JFrame)this.propertiesWindow).setDefaultCloseOperation(1);
            } else if (this.propertiesWindow instanceof JInternalFrame) {
                ((JInternalFrame)this.propertiesWindow).setDefaultCloseOperation(1);
            }
            this.propertiesWindow.setSize(600, 500);
        } else {
            SwingUtilities.setTitle((Component)this.propertiesWindow, (String)title);
        }
        this.properties.setIdentifiedObject(item);
        this.propertiesWindow.setVisible(true);
    }

    private void search(boolean enable) {
        String name;
        JComponent component;
        if (enable) {
            component = this.search;
            name = "Search";
        } else {
            component = this.list;
            name = "List";
            this.filter(this.search.getText());
        }
        this.showProperties.setEnabled(!enable);
        this.cards.show(this.searchOrList, name);
        component.requestFocus();
    }

    public void filter(String keywords) {
        Locale locale;
        String[] tokens;
        AbstractListModel model = this.codeList;
        if (keywords != null && (tokens = (keywords = keywords.toLowerCase(locale = SwingUtilities.getLocale((Component)this)).trim()).split("\\s+")).length != 0) {
            DefaultComboBoxModel<Code> filtered = new DefaultComboBoxModel<Code>();
            model = filtered;
            int size = this.codeList.getSize();
            block0: for (int i = 0; i < size; ++i) {
                Code code = (Code)this.codeList.getElementAt(i);
                String name = code.toString().toLowerCase(locale);
                for (int j = 0; j < tokens.length; ++j) {
                    if (name.indexOf(tokens[j]) < 0) continue block0;
                }
                filtered.addElement(code);
            }
        }
        this.list.setModel(model);
    }

    public static void main(String[] args) throws FactoryRegistryException, FactoryException {
        Arguments arguments = new Arguments(args);
        boolean prototype = arguments.getFlag("-prototype");
        args = arguments.getRemainingArguments(0);
        AuthorityCodesComboBox chooser = new AuthorityCodesComboBox();
        if (prototype) {
            System.out.println(((CodeList)chooser.list.getModel()).getPrototypeItem());
        }
        JFrame frame = new JFrame(chooser.getAuthority());
        frame.setDefaultCloseOperation(3);
        frame.add((Component)chooser, "Center");
        frame.pack();
        frame.setVisible(true);
    }
}

