/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.referencing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.EventListener;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.InternationalFormatter;
import org.geotools.gui.swing.referencing.SpinnerAngleModel;
import org.geotools.measure.Angle;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.resources.SwingUtilities;
import org.geotools.resources.geometry.XDimension2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;

public class CoordinateChooser
extends JPanel {
    public static final int GEOGRAPHIC_AREA = 1;
    public static final int TIME_RANGE = 2;
    public static final int RESOLUTION = 4;
    private final JComponent areaPanel;
    private final JComponent timePanel;
    private final JComponent resoPanel;
    private final JComboBox timezone;
    private final JSpinner tmin;
    private final JSpinner tmax;
    private final JSpinner xmin;
    private final JSpinner xmax;
    private final JSpinner ymin;
    private final JSpinner ymax;
    private final JSpinner xres;
    private final JSpinner yres;
    private final AbstractButton radioBestRes;
    private final AbstractButton radioPrefRes;
    private JComponent accessory;

    public CoordinateChooser() {
        this(new Date(0L), new Date());
    }

    public CoordinateChooser(Date minTime, Date maxTime) {
        super(new GridBagLayout());
        Locale locale = CoordinateChooser.getDefaultLocale();
        int timeField = 6;
        Vocabulary resources = Vocabulary.getResources((Locale)locale);
        this.radioBestRes = new JRadioButton(resources.getString(180), true);
        this.radioPrefRes = new JRadioButton(resources.getString(148));
        this.tmin = new JSpinner(new SpinnerDateModel(minTime, minTime, maxTime, 6));
        this.tmax = new JSpinner(new SpinnerDateModel(maxTime, minTime, maxTime, 6));
        this.xmin = new JSpinner(new SpinnerAngleModel((Angle)new Longitude(-180.0)));
        this.xmax = new JSpinner(new SpinnerAngleModel((Angle)new Longitude(180.0)));
        this.ymin = new JSpinner(new SpinnerAngleModel((Angle)new Latitude(-90.0)));
        this.ymax = new JSpinner(new SpinnerAngleModel((Angle)new Latitude(90.0)));
        this.xres = new JSpinner(new SpinnerNumberModel(1, 0, 21600, 1));
        this.yres = new JSpinner(new SpinnerNumberModel(1, 0, 10800, 1));
        AngleFormat angleFormat = new AngleFormat("D\u00b0MM.m'", locale);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, locale);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        this.xmin.setEditor(new SpinnerAngleModel.Editor(this.xmin, angleFormat));
        this.xmax.setEditor(new SpinnerAngleModel.Editor(this.xmax, angleFormat));
        this.ymin.setEditor(new SpinnerAngleModel.Editor(this.ymin, angleFormat));
        this.ymax.setEditor(new SpinnerAngleModel.Editor(this.ymax, angleFormat));
        CoordinateChooser.setup(this.tmin, 10, dateFormat);
        CoordinateChooser.setup(this.tmax, 10, dateFormat);
        CoordinateChooser.setup(this.xmin, 7, null);
        CoordinateChooser.setup(this.xmax, 7, null);
        CoordinateChooser.setup(this.ymin, 7, null);
        CoordinateChooser.setup(this.ymax, 7, null);
        CoordinateChooser.setup(this.xres, 3, numberFormat);
        CoordinateChooser.setup(this.yres, 3, numberFormat);
        Object[] timezones = TimeZone.getAvailableIDs();
        Arrays.sort(timezones);
        this.timezone = new JComboBox<Object>(timezones);
        this.timezone.setSelectedItem(dateFormat.getTimeZone().getID());
        JLabel labelSize1 = new JLabel(resources.getLabel(153));
        JLabel labelSize2 = new JLabel("\u00d7");
        ButtonGroup group = new ButtonGroup();
        group.add(this.radioBestRes);
        group.add(this.radioPrefRes);
        Listeners listeners = new Listeners(new JComponent[]{labelSize1, labelSize2, this.xres, this.yres});
        listeners.setEnabled(false);
        this.timezone.addActionListener(listeners);
        this.radioPrefRes.addChangeListener(listeners);
        this.areaPanel = CoordinateChooser.getPanel(resources.getString(59));
        this.timePanel = CoordinateChooser.getPanel(resources.getString(168));
        this.resoPanel = CoordinateChooser.getPanel(resources.getString(132));
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        this.areaPanel.add((Component)this.ymax, c);
        c.gridx = 0;
        c.gridy = 1;
        this.areaPanel.add((Component)this.xmin, c);
        c.gridx = 2;
        c.gridy = 1;
        this.areaPanel.add((Component)this.xmax, c);
        c.gridx = 1;
        c.gridy = 2;
        this.areaPanel.add((Component)this.ymin, c);
        c.gridx = 0;
        c.anchor = 17;
        c.insets.right = 3;
        c.weightx = 0.0;
        c.gridy = 0;
        JLabel label = new JLabel(resources.getLabel(158));
        this.timePanel.add((Component)label, c);
        label.setLabelFor(this.tmin);
        c.gridy = 1;
        label = new JLabel(resources.getLabel(39));
        this.timePanel.add((Component)label, c);
        label.setLabelFor(this.tmax);
        c.gridy = 2;
        label = new JLabel(resources.getLabel(169));
        this.timePanel.add((Component)label, c);
        label.setLabelFor(this.timezone);
        c.gridwidth = 4;
        c.gridy = 0;
        this.resoPanel.add((Component)this.radioBestRes, c);
        c.gridy = 1;
        this.resoPanel.add((Component)this.radioPrefRes, c);
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 13;
        c.insets.left = 1;
        c.insets.right = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        this.resoPanel.add((Component)labelSize1, c);
        labelSize1.setLabelFor(this.xres);
        c.weightx = 0.0;
        c.gridx = 1;
        this.resoPanel.add((Component)this.xres, c);
        c.gridx = 2;
        this.resoPanel.add((Component)labelSize2, c);
        labelSize2.setLabelFor(this.yres);
        c.gridx = 3;
        this.resoPanel.add((Component)this.yres, c);
        c.gridx = 1;
        c.fill = 2;
        c.insets.left = 0;
        c.insets.right = 0;
        c.weightx = 1.0;
        c.gridy = 0;
        this.timePanel.add((Component)this.tmin, c);
        c.gridy = 1;
        this.timePanel.add((Component)this.tmax, c);
        c.gridy = 2;
        this.timePanel.add((Component)this.timezone, c);
        c.insets.bottom = 3;
        c.insets.top = 3;
        c.insets.left = 3;
        c.insets.right = 3;
        c.gridx = 0;
        c.anchor = 10;
        c.fill = 1;
        c.weighty = 1.0;
        c.gridy = 0;
        this.add((Component)this.areaPanel, c);
        c.gridy = 1;
        this.add((Component)this.timePanel, c);
        c.gridy = 2;
        this.add((Component)this.resoPanel, c);
    }

    private static JPanel getPanel(String title) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        return panel;
    }

    private static void setup(JSpinner spinner, int width, Format format) {
        JFormattedTextField field = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
        field.setMargin(new Insets(0, 6, 0, 3));
        field.setColumns(width);
        if (format != null) {
            ((InternationalFormatter)field.getFormatter()).setFormat(format);
        }
    }

    public boolean isSelectorVisible(int selector) {
        switch (selector) {
            case 1: {
                return this.areaPanel.isVisible();
            }
            case 2: {
                return this.timePanel.isVisible();
            }
            case 4: {
                return this.resoPanel.isVisible();
            }
        }
        throw new IllegalArgumentException();
    }

    public void setSelectorVisible(int selectors, boolean visible) {
        CoordinateChooser.ensureValidSelectors(selectors);
        if ((selectors & 1) != 0) {
            this.areaPanel.setVisible(visible);
        }
        if ((selectors & 2) != 0) {
            this.timePanel.setVisible(visible);
        }
        if ((selectors & 4) != 0) {
            this.resoPanel.setVisible(visible);
        }
    }

    private static void ensureValidSelectors(int selectors) throws IllegalArgumentException {
        if ((selectors & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException(String.valueOf(selectors));
        }
    }

    private static double doubleValue(JSpinner spinner) {
        Object value = spinner.getValue();
        return value instanceof Number ? ((Number)value).doubleValue() : Double.NaN;
    }

    private static double degrees(JSpinner spinner, boolean expectLatitude) {
        Object value = spinner.getValue();
        if (value instanceof Angle) {
            if (expectLatitude ? value instanceof Longitude : value instanceof Latitude) {
                return Double.NaN;
            }
            return ((Angle)value).degrees();
        }
        return Double.NaN;
    }

    public Rectangle2D getGeographicArea() {
        double xmin = CoordinateChooser.degrees(this.xmin, false);
        double ymin = CoordinateChooser.degrees(this.ymin, true);
        double xmax = CoordinateChooser.degrees(this.xmax, false);
        double ymax = CoordinateChooser.degrees(this.ymax, true);
        return new Rectangle2D.Double(Math.min(xmin, xmax), Math.min(ymin, ymax), Math.abs(xmax - xmin), Math.abs(ymax - ymin));
    }

    public void setGeographicArea(Rectangle2D area) {
        this.xmin.setValue(new Longitude(area.getMinX()));
        this.xmax.setValue(new Longitude(area.getMaxX()));
        this.ymin.setValue(new Latitude(area.getMinY()));
        this.ymax.setValue(new Latitude(area.getMaxY()));
    }

    public Dimension2D getPreferredResolution() {
        if (this.radioPrefRes.isSelected()) {
            return new XDimension2D.Double(CoordinateChooser.doubleValue(this.xres), CoordinateChooser.doubleValue(this.yres));
        }
        return null;
    }

    public void setPreferredResolution(Dimension2D resolution) {
        if (resolution != null) {
            this.xres.setValue(new Double(resolution.getWidth() * 60.0));
            this.yres.setValue(new Double(resolution.getHeight() * 60.0));
            this.radioPrefRes.setSelected(true);
        } else {
            this.radioBestRes.setSelected(true);
        }
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.timezone.getSelectedItem().toString());
    }

    public void setTimeZone(TimeZone timezone) {
        this.timezone.setSelectedItem(timezone.getID());
    }

    private void update(TimeZone timezone) {
        boolean refresh = true;
        try {
            this.tmin.commitEdit();
            this.tmax.commitEdit();
        }
        catch (ParseException exception) {
            refresh = false;
        }
        ((JSpinner.DateEditor)this.tmin.getEditor()).getFormat().setTimeZone(timezone);
        ((JSpinner.DateEditor)this.tmax.getEditor()).getFormat().setTimeZone(timezone);
        if (refresh) {
            CoordinateChooser.fireStateChanged((AbstractSpinnerModel)this.tmin.getModel());
            CoordinateChooser.fireStateChanged((AbstractSpinnerModel)this.tmax.getModel());
        }
    }

    private static void fireStateChanged(AbstractSpinnerModel model) {
        ChangeEvent changeEvent = new ChangeEvent(model);
        EventListener[] listeners = model.getListeners(ChangeListener.class);
        int i = listeners.length;
        while (--i >= 0) {
            ((ChangeListener)listeners[i]).stateChanged(changeEvent);
        }
    }

    public Date getStartTime() {
        return (Date)this.tmin.getValue();
    }

    public Date getEndTime() {
        return (Date)this.tmax.getValue();
    }

    public void setTimeRange(Date startTime, Date endTime) {
        this.tmin.setValue(startTime);
        this.tmax.setValue(endTime);
    }

    public JComponent getAccessory() {
        return this.accessory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessory(JComponent accessory) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.accessory != null) {
                this.remove(this.accessory);
            }
            this.accessory = accessory;
            if (accessory != null) {
                GridBagConstraints c = new GridBagConstraints();
                c.insets.bottom = 3;
                c.insets.top = 3;
                c.insets.left = 3;
                c.insets.right = 3;
                c.gridx = 1;
                c.weightx = 1.0;
                c.gridwidth = 1;
                c.gridy = 0;
                c.weighty = 1.0;
                c.gridheight = 3;
                c.anchor = 10;
                c.fill = 1;
                this.add((Component)accessory, c);
            }
            this.validate();
        }
    }

    private void checkAngle(JSpinner field, boolean expectLatitude) throws ParseException {
        Object angle = field.getValue();
        if (expectLatitude ? angle instanceof Longitude : angle instanceof Latitude) {
            throw new ParseException(Errors.getResources((Locale)this.getLocale()).getString(7, angle), 0);
        }
    }

    public void commitEdit() throws ParseException {
        JSpinner focus = null;
        try {
            focus = this.tmin;
            focus.commitEdit();
            focus = this.tmax;
            focus.commitEdit();
            focus = this.xmin;
            focus.commitEdit();
            focus = this.xmax;
            focus.commitEdit();
            focus = this.ymin;
            focus.commitEdit();
            focus = this.ymax;
            focus.commitEdit();
            focus = this.xres;
            focus.commitEdit();
            focus = this.yres;
            focus.commitEdit();
            focus = this.xmin;
            this.checkAngle(focus, false);
            focus = this.xmax;
            this.checkAngle(focus, false);
            focus = this.ymin;
            this.checkAngle(focus, true);
            focus = this.ymax;
            this.checkAngle(focus, true);
        }
        catch (ParseException exception) {
            focus.requestFocus();
            throw exception;
        }
    }

    private boolean commitEdit(Component owner) {
        try {
            this.commitEdit();
        }
        catch (ParseException exception) {
            SwingUtilities.showMessageDialog((Component)owner, (Object)exception.getLocalizedMessage(), (String)Errors.getResources((Locale)this.getLocale()).getString(8), (int)0);
            return false;
        }
        return true;
    }

    public void addChangeListener(int selectors, ChangeListener listener) {
        CoordinateChooser.ensureValidSelectors(selectors);
        if ((selectors & 1) != 0) {
            this.xmin.getModel().addChangeListener(listener);
            this.xmax.getModel().addChangeListener(listener);
            this.ymin.getModel().addChangeListener(listener);
            this.ymax.getModel().addChangeListener(listener);
        }
        if ((selectors & 2) != 0) {
            this.tmin.getModel().addChangeListener(listener);
            this.tmax.getModel().addChangeListener(listener);
        }
        if ((selectors & 4) != 0) {
            this.xres.getModel().addChangeListener(listener);
            this.yres.getModel().addChangeListener(listener);
            this.radioPrefRes.getModel().addChangeListener(listener);
        }
    }

    public void removeChangeListener(int selectors, ChangeListener listener) {
        CoordinateChooser.ensureValidSelectors(selectors);
        if ((selectors & 1) != 0) {
            this.xmin.getModel().removeChangeListener(listener);
            this.xmax.getModel().removeChangeListener(listener);
            this.ymin.getModel().removeChangeListener(listener);
            this.ymax.getModel().removeChangeListener(listener);
        }
        if ((selectors & 2) != 0) {
            this.tmin.getModel().removeChangeListener(listener);
            this.tmax.getModel().removeChangeListener(listener);
        }
        if ((selectors & 4) != 0) {
            this.xres.getModel().removeChangeListener(listener);
            this.yres.getModel().removeChangeListener(listener);
            this.radioPrefRes.getModel().removeChangeListener(listener);
        }
    }

    public boolean showDialog(Component owner) {
        return this.showDialog(owner, Vocabulary.getResources((Locale)this.getLocale()).getString(22));
    }

    public boolean showDialog(Component owner, String title) {
        while (SwingUtilities.showOptionDialog((Component)owner, (Object)this, (String)title)) {
            if (!this.commitEdit(owner)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new CoordinateChooser().showDialog(null);
    }

    private final class Listeners
    implements ActionListener,
    ChangeListener {
        private final JComponent[] toggle;

        public Listeners(JComponent[] toggle) {
            this.toggle = toggle;
        }

        public void actionPerformed(ActionEvent event) {
            CoordinateChooser.this.update(CoordinateChooser.this.getTimeZone());
        }

        public void stateChanged(ChangeEvent event) {
            this.setEnabled(CoordinateChooser.this.radioPrefRes.isSelected());
        }

        final void setEnabled(boolean state) {
            for (int i = 0; i < this.toggle.length; ++i) {
                this.toggle[i].setEnabled(state);
            }
        }
    }
}

