/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.referencing;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.TransformedDirectPosition;
import org.geotools.resources.CRSUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;

public class CoordinateTableModel
extends AbstractTableModel {
    private final CoordinateReferenceSystem crs;
    private final String[] columnNames;
    private final List positions = new ArrayList();
    private final List unmodifiablePositions = Collections.unmodifiableList(this.positions);
    private final GeneralEnvelope validArea;
    private final TransformedDirectPosition toWGS84 = new TransformedDirectPosition();

    public CoordinateTableModel(CoordinateReferenceSystem crs) {
        this.crs = crs;
        CoordinateSystem cs = crs.getCoordinateSystem();
        this.columnNames = new String[cs.getDimension()];
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columnNames[i] = crs.getCoordinateSystem().getAxis(i).getName().getCode();
        }
        this.validArea = new GeneralEnvelope(CRSUtilities.getEnvelope((CoordinateReferenceSystem)crs));
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public List getPositions() {
        return this.unmodifiablePositions;
    }

    public int getRowCount() {
        return this.positions.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.columnNames.length) {
            return this.columnNames[columnIndex];
        }
        return super.getColumnName(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return Double.class;
    }

    public void add(DirectPosition newPosition) {
        int index = this.positions.size();
        this.positions.add(newPosition);
        this.fireTableRowsInserted(index, index);
    }

    public void add(Collection newPositions) {
        int lower = this.positions.size();
        this.positions.addAll(newPositions);
        int upper = this.positions.size();
        this.fireTableRowsInserted(lower, upper - 1);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        double ordinate;
        DirectPosition position;
        if (rowIndex >= 0 && rowIndex < this.positions.size() && (position = (DirectPosition)this.positions.get(rowIndex)) != null && columnIndex >= 0 && columnIndex < position.getDimension() && !Double.isNaN(ordinate = position.getOrdinate(columnIndex))) {
            return new Double(ordinate);
        }
        return null;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        double ordinate = ((Number)value).doubleValue();
        ((DirectPosition)this.positions.get(rowIndex)).setOrdinate(columnIndex, ordinate);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int colIndex) {
        return true;
    }

    public boolean isValidCoordinate(int rowIndex) {
        DirectPosition position = (DirectPosition)this.positions.get(rowIndex);
        try {
            this.toWGS84.transform(position);
        }
        catch (TransformException e) {
            return false;
        }
        return this.validArea.contains((DirectPosition)this.toWGS84);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator", "\n");
        int size = this.positions.size();
        for (int i = 0; i < size; ++i) {
            buffer.append(this.positions.get(i));
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    public static class CellRenderer
    extends DefaultTableCellRenderer {
        private Color foreground;
        private Color background;
        private Color invalidForeground = Color.RED;
        private Color invalidBackground;

        public CellRenderer() {
            this.foreground = super.getForeground();
            this.background = super.getBackground();
        }

        public void setForeground(Color foreground) {
            this.foreground = foreground;
            super.setForeground(foreground);
        }

        public void setBackground(Color background) {
            this.background = background;
            super.setBackground(background);
        }

        public void setInvalidColor(Color foreground, Color background) {
            this.invalidForeground = foreground;
            this.invalidBackground = background;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            CoordinateTableModel model;
            Color foreground = this.foreground;
            Color background = this.background;
            TableModel candidate = table.getModel();
            if (candidate instanceof CoordinateTableModel && !(model = (CoordinateTableModel)candidate).isValidCoordinate(row)) {
                if (this.invalidForeground != null) {
                    foreground = this.invalidForeground;
                }
                if (this.invalidBackground != null) {
                    background = this.invalidBackground;
                }
            }
            super.setBackground(background);
            super.setForeground(foreground);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

