/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.referencing;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.referencing.IdentifiedObject;

public class PropertiesSheet
extends JComponent {
    private final JTabbedPane tabs = new JTabbedPane();
    private final JTextArea wktArea = new JTextArea();

    public PropertiesSheet() {
        this.wktArea.setEditable(false);
        this.tabs.addTab("WKT", new JScrollPane(this.wktArea));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
    }

    public void setIdentifiedObject(IdentifiedObject item) {
        String text;
        try {
            text = item.toWKT();
        }
        catch (UnsupportedOperationException e) {
            text = e.getLocalizedMessage();
            if (text == null) {
                text = Utilities.getShortClassName((Object)e);
            }
            String lineSeparator = System.getProperty("line.separator", "\n");
            text = e instanceof UnformattableObjectException ? Vocabulary.format((int)186) + ": " + text + lineSeparator + lineSeparator + item + lineSeparator : Vocabulary.format((int)40) + ": " + text + lineSeparator;
        }
        this.wktArea.setText(text);
    }

    public void setErrorMessage(String message) {
        this.wktArea.setText(Vocabulary.format((int)41, (Object)message));
    }
}

