/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.referencing;

import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import org.geotools.measure.Angle;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;

final class SpinnerAngleModel
extends AbstractSpinnerModel
implements Serializable {
    private Angle value;
    private double minimum;
    private double maximum;
    private double stepSize = 1.0;
    static /* synthetic */ Class class$org$geotools$measure$Longitude;
    static /* synthetic */ Class class$org$geotools$measure$Latitude;
    static /* synthetic */ Class class$org$geotools$measure$Angle;

    public SpinnerAngleModel(Angle value) {
        this.value = value;
        if (value instanceof Longitude) {
            this.minimum = -180.0;
            this.maximum = 180.0;
        } else if (value instanceof Latitude) {
            this.minimum = -90.0;
            this.maximum = 90.0;
        } else if (value != null) {
            this.minimum = 0.0;
            this.maximum = 360.0;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setMinimum(double minimum) {
        if (this.minimum != minimum) {
            this.minimum = minimum;
            this.fireStateChanged();
        }
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMaximum(double maximum) {
        if (this.maximum != maximum) {
            this.maximum = maximum;
            this.fireStateChanged();
        }
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setStepSize(double stepSize) {
        if (this.stepSize != stepSize) {
            this.stepSize = stepSize;
            this.fireStateChanged();
        }
    }

    public double getStepSize() {
        return this.stepSize;
    }

    final Angle toAngle(double newValue) {
        if (this.value instanceof Longitude) {
            return new Longitude(newValue);
        }
        if (this.value instanceof Latitude) {
            return new Latitude(newValue);
        }
        return new Angle(newValue);
    }

    private Angle getNextValue(int factor) {
        double newValue = this.value.degrees() + this.stepSize * (double)factor;
        if (!(newValue >= this.minimum) || !(newValue <= this.maximum)) {
            return null;
        }
        return this.toAngle(newValue);
    }

    public Object getNextValue() {
        return this.getNextValue(1);
    }

    public Object getPreviousValue() {
        return this.getNextValue(-1);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (!(value instanceof Angle)) {
            throw new IllegalArgumentException(Errors.format((int)42, (Object)"value", (Object)value));
        }
        if (!Utilities.equals((Object)value, (Object)this.value)) {
            this.value = (Angle)value;
            this.fireStateChanged();
        }
    }

    static final class Editor
    extends JSpinner.DefaultEditor {
        public Editor(JSpinner spinner, AngleFormat format) {
            super(spinner);
            SpinnerModel genericModel = spinner.getModel();
            if (!(genericModel instanceof SpinnerAngleModel)) {
                throw new IllegalArgumentException();
            }
            SpinnerAngleModel model = (SpinnerAngleModel)genericModel;
            EditorFormatter formatter = new EditorFormatter(model, format);
            DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
            JFormattedTextField field = this.getTextField();
            field.setEditable(true);
            field.setFormatterFactory(factory);
            field.setHorizontalAlignment(4);
            try {
                String maxString = formatter.valueToString(formatter.getMinimum());
                String minString = formatter.valueToString(formatter.getMaximum());
                field.setColumns(Math.max(maxString.length(), minString.length()));
            }
            catch (ParseException exception) {
                // empty catch block
            }
        }
    }

    private static class EditorFormatter
    extends InternationalFormatter {
        private final SpinnerAngleModel model;

        EditorFormatter(SpinnerAngleModel model, AngleFormat format) {
            super((Format)format);
            this.model = model;
            this.setAllowsInvalid(true);
            this.setCommitsOnValidEdit(false);
            this.setOverwriteMode(false);
            Object value = model.getValue();
            Class classe = value instanceof Longitude ? (class$org$geotools$measure$Longitude == null ? (class$org$geotools$measure$Longitude = SpinnerAngleModel.class$("org.geotools.measure.Longitude")) : class$org$geotools$measure$Longitude) : (value instanceof Latitude ? (class$org$geotools$measure$Latitude == null ? (class$org$geotools$measure$Latitude = SpinnerAngleModel.class$("org.geotools.measure.Latitude")) : class$org$geotools$measure$Latitude) : (class$org$geotools$measure$Angle == null ? (class$org$geotools$measure$Angle = SpinnerAngleModel.class$("org.geotools.measure.Angle")) : class$org$geotools$measure$Angle));
            this.setValueClass(classe);
        }

        public Object stringToValue(String text) throws ParseException {
            Object value = super.stringToValue(text);
            if (value instanceof Longitude) {
                return value;
            }
            if (value instanceof Latitude) {
                return value;
            }
            if (value instanceof Angle) {
                Class<?> valueClass;
                if ((class$org$geotools$measure$Longitude == null ? (class$org$geotools$measure$Longitude = SpinnerAngleModel.class$("org.geotools.measure.Longitude")) : class$org$geotools$measure$Longitude).isAssignableFrom(valueClass = this.getValueClass())) {
                    return new Longitude(((Angle)value).degrees());
                }
                if ((class$org$geotools$measure$Latitude == null ? (class$org$geotools$measure$Latitude = SpinnerAngleModel.class$("org.geotools.measure.Latitude")) : class$org$geotools$measure$Latitude).isAssignableFrom(valueClass)) {
                    return new Latitude(((Angle)value).degrees());
                }
            }
            return value;
        }

        public void setMinimum(Comparable min) {
            this.model.setMinimum(((Angle)min).degrees());
        }

        public Comparable getMinimum() {
            return this.model.toAngle(this.model.getMinimum());
        }

        public void setMaximum(Comparable max) {
            this.model.setMaximum(((Angle)max).degrees());
        }

        public Comparable getMaximum() {
            return this.model.toAngle(this.model.getMaximum());
        }
    }
}

