/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.table;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;

public class FeatureTableModel
extends AbstractTableModel
implements TableModel {
    private FeatureCollection featureTable;
    private transient Feature[] featureArray;

    public FeatureTableModel() {
    }

    public FeatureTableModel(FeatureCollection features) {
        this.setFeatureCollection(features);
    }

    public void setFeatureCollection(FeatureCollection features) {
        this.featureArray = null;
        this.featureTable = features;
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        if (this.featureTable == null || this.featureTable.isEmpty()) {
            return 0;
        }
        return this.featureTable.features().next().getNumberOfAttributes();
    }

    public int getRowCount() {
        if (this.featureTable == null) {
            return 0;
        }
        return this.featureTable.size();
    }

    public String getColumnName(int col) {
        if (this.featureTable == null || this.featureTable.isEmpty()) {
            return null;
        }
        Feature firstFeature = this.featureTable.features().next();
        FeatureType firstType = firstFeature.getFeatureType();
        return firstType.getAttributeType(col).getName();
    }

    public Object getValueAt(int row, int col) {
        if (this.featureArray == null) {
            this.featureArray = this.featureTable.toArray(new Feature[this.featureTable.size()]);
        }
        return this.featureArray[row].getAttribute(col);
    }
}

