/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geotools.gui.swing.tree.TreeNode;
import org.geotools.resources.XArray;

public final class Trees {
    private Trees() {
    }

    public static TreePath[] getPathsToUserObject(TreeModel model, Object value) {
        ArrayList paths = new ArrayList(8);
        Object[] path = new Object[8];
        path[0] = model.getRoot();
        Trees.getPathsToUserObject(model, value, path, 1, paths);
        return paths.toArray(new TreePath[paths.size()]);
    }

    private static Object[] getPathsToUserObject(TreeModel model, Object value, Object[] path, int length, List list) {
        Object nodeValue;
        Object parent = path[length - 1];
        if (parent instanceof TreeNode && ((nodeValue = ((TreeNode)parent).getUserObject()) == value || value != null && value.equals(nodeValue))) {
            list.add(new TreePath(XArray.resize((Object[])path, (int)length)));
        }
        int count = model.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            if (length >= path.length) {
                path = XArray.resize((Object[])path, (int)(length << 1));
            }
            path[length] = model.getChild(parent, i);
            path = Trees.getPathsToUserObject(model, value, path, length + 1, list);
        }
        return path;
    }

    private static boolean[] toString(TreeModel model, Object node, StringBuffer buffer, int level, boolean[] last) {
        for (int i = 0; i < level; ++i) {
            if (i != level - 1) {
                buffer.append(last[i] ? (char)'\u00a0' : '\u2502');
                buffer.append("\u00a0\u00a0\u00a0");
                continue;
            }
            buffer.append(last[i] ? (char)'\u2514' : '\u251c');
            buffer.append("\u2500\u2500\u2500");
        }
        buffer.append(node);
        buffer.append('\n');
        if (level >= last.length) {
            last = XArray.resize((boolean[])last, (int)(level * 2));
        }
        int count = model.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            last[level] = i == count - 1;
            last = Trees.toString(model, model.getChild(node, i), buffer, level + 1, last);
        }
        return last;
    }

    private static String toString(TreeModel tree, Object root) {
        if (root == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Trees.toString(tree, root, buffer, 0, new boolean[64]);
        return buffer.toString();
    }

    public static String toString(TreeModel tree) {
        return Trees.toString(tree, tree.getRoot());
    }

    public static String toString(javax.swing.tree.TreeNode node) {
        return Trees.toString(new DefaultTreeModel(node, true));
    }
}

