/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Properties;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.epsg.DataSource;
import org.geotools.referencing.factory.epsg.FactoryUsingAnsiSQL;
import org.geotools.resources.Utilities;
import org.postgresql.jdbc3.Jdbc3SimpleDataSource;

public class PostgreDataSource
extends Jdbc3SimpleDataSource
implements DataSource {
    public static final String CONFIGURATION_FILE = "EPSG-DataSource.properties";
    private final String schema;

    public PostgreDataSource() {
        this("localhost", "EPSG", null, "Geotools", "Geotools");
    }

    public PostgreDataSource(String server, String database, String schema, String user, String password) {
        int port;
        Properties p = new Properties();
        try {
            PostgreDataSource.load(p);
        }
        catch (IOException exception) {
            Utilities.unexpectedException((String)"org.geotools.referencing.factory", (String)"DataSource", (String)"<init>", (Throwable)exception);
        }
        try {
            port = Integer.parseInt(p.getProperty("portNumber", "5432"));
        }
        catch (NumberFormatException exception) {
            port = 5432;
            Utilities.unexpectedException((String)"org.geotools.referencing.factory", (String)"DataSource", (String)"<init>", (Throwable)exception);
        }
        this.setPortNumber(port);
        this.setServerName(p.getProperty("serverName", server));
        this.setDatabaseName(p.getProperty("databaseName", database));
        this.setUser(p.getProperty("user", user));
        this.setPassword(p.getProperty("password", password));
        this.schema = p.getProperty("schema", schema);
    }

    private static void load(Properties p) throws IOException {
        File file = new File(CONFIGURATION_FILE);
        if (!file.isFile() && !(file = new File(System.getProperty("user.home", "."), CONFIGURATION_FILE)).isFile()) {
            return;
        }
        FileInputStream in = new FileInputStream(file);
        p.load(in);
        ((InputStream)in).close();
    }

    public int getPriority() {
        return 0;
    }

    public AbstractAuthorityFactory createFactory(Hints hints) throws SQLException {
        FactoryUsingAnsiSQL factory = new FactoryUsingAnsiSQL(hints, this.getConnection());
        if (this.schema != null) {
            factory.setSchema(this.schema);
        }
        return factory;
    }
}

