/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureType;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.image.imageio.GeoToolsWriteParams;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class ImageMosaicFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER;
    public static final DefaultParameterDescriptor DONT_CREATE_EMPTY_TILES;
    public static final DefaultParameterDescriptor FADING;
    public static final DefaultParameterDescriptor INPUT_TRANSPARENT_COLOR;
    public static final DefaultParameterDescriptor OUTPUT_TRANSPARENT_COLOR;
    public static final DefaultParameterDescriptor INPUT_IMAGE_THRESHOLD_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ImageMosaicFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImageMosaic");
        info.put("description", "Image mosaicking plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, INPUT_IMAGE_THRESHOLD_VALUE, OUTPUT_TRANSPARENT_COLOR}));
        this.writeParameters = null;
    }

    public GridCoverageReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean accepts(Object source) {
        try {
            String[] pair;
            URL sourceURL;
            if (source instanceof File) {
                sourceURL = ((File)source).toURL();
            } else if (source instanceof URL) {
                sourceURL = (URL)source;
            } else {
                if (!(source instanceof String)) return false;
                File tempFile = new File((String)source);
                if (tempFile.exists()) {
                    sourceURL = tempFile.toURL();
                } else {
                    try {
                        sourceURL = new URL(URLDecoder.decode((String)source, "UTF8"));
                        if (sourceURL.getProtocol() != "file") {
                            return false;
                        }
                    }
                    catch (MalformedURLException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) return false;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        return false;
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) return false;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        return false;
                    }
                }
            }
            ShapefileDataStore tileIndexStore = new ShapefileDataStore(sourceURL);
            String[] typeNames = tileIndexStore.getTypeNames();
            if (typeNames.length <= 0) {
                return false;
            }
            String typeName = typeNames[0];
            FeatureSource featureSource = tileIndexStore.getFeatureSource(typeName);
            FeatureType schema = featureSource.getSchema();
            if (schema.getAttributeType("location") == null) {
                return false;
            }
            String temp = URLDecoder.decode(sourceURL.getFile(), "UTF8");
            int index = temp.lastIndexOf(".");
            if (index != -1) {
                temp = temp.substring(0, index);
            }
            File propertiesFile = new File(temp + ".properties");
            if (!($assertionsDisabled || propertiesFile.exists() && propertiesFile.isFile())) {
                throw new AssertionError();
            }
            Properties properties = new Properties();
            properties.load(new BufferedInputStream(new FileInputStream(propertiesFile)));
            String envelope = properties.getProperty("Envelope2D");
            String[] pairs = envelope.split(" ");
            double[][] cornersV = new double[2][2];
            for (int i = 0; i < 2; ++i) {
                pair = pairs[i].split(",");
                cornersV[i][0] = Double.parseDouble(pair[0]);
                cornersV[i][1] = Double.parseDouble(pair[1]);
            }
            Integer.parseInt(properties.getProperty("LevelsNum"));
            String levels = properties.getProperty("Levels");
            pairs = levels.split(" ");
            pair = pairs[0].split(",");
            Double.parseDouble(pair[0]);
            Double.parseDouble(pair[1]);
            properties.getProperty("Name");
            try {
                properties.getProperty("ExpandToRGB").equalsIgnoreCase("true");
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
            return true;
        }
        catch (IOException e) {
            if (!LOGGER.isLoggable(Level.FINE)) return false;
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public GridCoverageReader getReader(Object source, Hints hints) {
        try {
            return new ImageMosaicReader(source, hints);
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    static {
        $assertionsDisabled = !ImageMosaicFormat.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger("org.geotools.gce.imagemosaic");
        DONT_CREATE_EMPTY_TILES = new DefaultParameterDescriptor("GenerateEmptyTiles", Boolean.class, null, (Object)Boolean.FALSE);
        FADING = new DefaultParameterDescriptor("Fading", Boolean.class, null, (Object)Boolean.FALSE);
        INPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("InputTransparentColor", Color.class, null, null);
        OUTPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("OutputTransparentColor", Color.class, null, null);
        INPUT_IMAGE_THRESHOLD_VALUE = new DefaultParameterDescriptor("InputImageThresholdValue", Double.class, null, (Object)new Double(Double.NaN));
    }
}

