/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.PatternDescriptor;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.feature.Feature;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.MemorySpatialIndex;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridRange;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public final class ImageMosaicReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER;
    private final URL sourceURL;
    private final AbstractDataStore tileIndexStore;
    private SoftReference index;
    private final String typeName;
    private final FeatureSource featureSource;
    private final BufferedImage unavailableImage;
    private boolean expandMe;
    public static final int MAX_TILES = 1000000;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageMosaicReader(Object source, Hints uHints) throws IOException {
        Object tempCRS;
        String[] typeNames;
        if (uHints != null) {
            this.hints.add((RenderingHints)uHints);
        }
        if (source == null) {
            IOException ex = new IOException("ImageMosaicReader:No source set to read this coverage.");
            if (!LOGGER.isLoggable(Level.WARNING)) throw new DataSourceException((Throwable)ex);
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            throw new DataSourceException((Throwable)ex);
        }
        this.source = source;
        if (source instanceof File) {
            this.sourceURL = ((File)source).toURL();
        } else if (source instanceof URL) {
            this.sourceURL = (URL)source;
        } else {
            if (!(source instanceof String)) throw new IllegalArgumentException("This plugin accepts only File, URL and String pointing to a file");
            File tempFile = new File((String)source);
            if (tempFile.exists()) {
                this.sourceURL = tempFile.toURL();
            } else {
                try {
                    this.sourceURL = new URL(URLDecoder.decode((String)source, "UTF8"));
                    if (this.sourceURL.getProtocol() != "file") {
                        throw new IllegalArgumentException("This plugin accepts only File,  URL and String pointing to a file");
                    }
                }
                catch (MalformedURLException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) throw new IllegalArgumentException("This plugin accepts only File,  URL and String pointing to a file");
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    throw new IllegalArgumentException("This plugin accepts only File,  URL and String pointing to a file");
                }
                catch (UnsupportedEncodingException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) throw new IllegalArgumentException("This plugin accepts only File,  URL and String pointing to a file");
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    throw new IllegalArgumentException("This plugin accepts only File,  URL and String pointing to a file");
                }
            }
        }
        this.tileIndexStore = new ShapefileDataStore(this.sourceURL);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Connected mosaic reader to its data store " + this.sourceURL.toString());
        }
        if ((typeNames = this.tileIndexStore.getTypeNames()).length <= 0) {
            throw new IllegalArgumentException("Problems when opening the index, no typenames for the schema are defined");
        }
        this.typeName = typeNames[0];
        this.featureSource = this.tileIndexStore.getFeatureSource(this.typeName);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to create index");
        }
        this.index = new SoftReference<MemorySpatialIndex>(new MemorySpatialIndex(this.featureSource.getFeatures()));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Created index");
        }
        if ((tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM)) != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            LOGGER.log(Level.WARNING, "Using forced coordinate reference system " + this.crs.toWKT());
        } else {
            CoordinateReferenceSystem tempcrs = this.featureSource.getSchema().getDefaultGeometry().getCoordinateSystem();
            if (tempcrs == null) {
                this.crs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.WARNING, "Unable to find a CRS for this coverage, using a default one: " + this.crs.toWKT());
            } else {
                this.crs = tempcrs;
            }
        }
        this.loadProperties();
        this.unavailableImage = ImageIO.read(((Object)((Object)this)).getClass().getResource("unav.png"));
    }

    private void loadProperties() throws UnsupportedEncodingException, IOException, FileNotFoundException {
        String[] pair;
        String temp = URLDecoder.decode(this.sourceURL.getFile(), "UTF8");
        int index = temp.lastIndexOf(".");
        if (index != -1) {
            temp = temp.substring(0, index);
        }
        File propertiesFile = new File(temp + ".properties");
        if (!($assertionsDisabled || propertiesFile.exists() && propertiesFile.isFile())) {
            throw new AssertionError();
        }
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(propertiesFile)));
        String envelope = properties.getProperty("Envelope2D");
        String[] pairs = envelope.split(" ");
        double[][] cornersV = new double[2][2];
        for (int i = 0; i < 2; ++i) {
            pair = pairs[i].split(",");
            cornersV[i][0] = Double.parseDouble(pair[0]);
            cornersV[i][1] = Double.parseDouble(pair[1]);
        }
        this.originalEnvelope = new GeneralEnvelope(cornersV[0], cornersV[1]);
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        this.numOverviews = Integer.parseInt(properties.getProperty("LevelsNum")) - 1;
        String levels = properties.getProperty("Levels");
        pairs = levels.split(" ");
        this.overViewResolutions = this.numOverviews > 1 ? new double[this.numOverviews][2] : (double[][])null;
        pair = pairs[0].split(",");
        this.highestRes = new double[2];
        this.highestRes[0] = Double.parseDouble(pair[0]);
        this.highestRes[1] = Double.parseDouble(pair[1]);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Highest res " + this.highestRes[0] + " " + this.highestRes[1]);
        }
        for (int i = 1; i < this.numOverviews + 1; ++i) {
            pair = pairs[i].split(",");
            this.overViewResolutions[i - 1][0] = Double.parseDouble(pair[0]);
            this.overViewResolutions[i - 1][1] = Double.parseDouble(pair[1]);
        }
        this.coverageName = properties.getProperty("Name");
        try {
            this.expandMe = properties.getProperty("ExpandToRGB").equalsIgnoreCase("true");
        }
        catch (Exception e) {
            this.expandMe = false;
        }
        this.originalGridRange = new GeneralGridRange(new Rectangle((int)Math.round(this.originalEnvelope.getLength(0) / this.highestRes[0]), (int)Math.round(this.originalEnvelope.getLength(1) / this.highestRes[1])));
    }

    public ImageMosaicReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImageMosaicFormat();
    }

    public GridCoverage read(GeneralParameterValue[] params) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading mosaic from " + this.sourceURL.toString());
            LOGGER.fine("Highest res " + this.highestRes[0] + " " + this.highestRes[1]);
        }
        Color inputTransparentColor = (Color)ImageMosaicFormat.INPUT_TRANSPARENT_COLOR.getDefaultValue();
        Color outputTransparentColor = (Color)ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getDefaultValue();
        double inputImageThreshold = (Double)ImageMosaicFormat.INPUT_IMAGE_THRESHOLD_VALUE.getDefaultValue();
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        boolean blend = false;
        boolean skipEmptyAreas = false;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                Parameter param = (Parameter)params[i];
                if (param.getDescriptor().getName().getCode().equals(ImageMosaicFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    requestedEnvelope = (GeneralEnvelope)gg.getEnvelope();
                    dim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (param.getDescriptor().getName().getCode().equals(ImageMosaicFormat.INPUT_TRANSPARENT_COLOR.getName().toString())) {
                    inputTransparentColor = (Color)param.getValue();
                    continue;
                }
                if (param.getDescriptor().getName().getCode().equals(ImageMosaicFormat.INPUT_IMAGE_THRESHOLD_VALUE.getName().toString())) {
                    inputImageThreshold = (Double)param.getValue();
                    continue;
                }
                if (param.getDescriptor().getName().getCode().equals(ImageMosaicFormat.FADING.getName().toString())) {
                    blend = (Boolean)param.getValue();
                    continue;
                }
                if (param.getDescriptor().getName().getCode().equals(ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName().toString())) {
                    outputTransparentColor = (Color)param.getValue();
                    continue;
                }
                if (!param.getDescriptor().getName().getCode().equals(ImageMosaicFormat.DONT_CREATE_EMPTY_TILES.getName().toString())) continue;
                skipEmptyAreas = (Boolean)param.getValue();
            }
        }
        return this.loadTiles(requestedEnvelope, inputTransparentColor, outputTransparentColor, inputImageThreshold, dim, blend, skipEmptyAreas);
    }

    private GridCoverage loadTiles(GeneralEnvelope requestedOriginalEnvelope, Color transparentColor, Color outputTransparentColor, double inputImageThresholdValue, Rectangle pixelDimension, boolean fading, boolean skipEmptyAreas) throws IOException {
        List features;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating mosaic to comply with envelope " + (requestedOriginalEnvelope != null ? requestedOriginalEnvelope.toString() : null) + " crs " + this.crs.toWKT() + " dim " + (pixelDimension == null ? " null" : pixelDimension.toString()));
        }
        GeneralEnvelope intersectionEnvelope = null;
        if (requestedOriginalEnvelope != null) {
            if (!CRS.equalsIgnoreMetadata((Object)requestedOriginalEnvelope.getCoordinateReferenceSystem(), (Object)this.crs)) {
                try {
                    MathTransform transform = operationFactory.createOperation(requestedOriginalEnvelope.getCoordinateReferenceSystem(), this.crs).getMathTransform();
                    if (!transform.isIdentity()) {
                        requestedOriginalEnvelope = CRSUtilities.transform((MathTransform)transform, (Envelope)requestedOriginalEnvelope);
                        requestedOriginalEnvelope.setCoordinateReferenceSystem(this.crs);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Reprojected envelope " + requestedOriginalEnvelope.toString() + " crs " + this.crs.toWKT());
                        }
                    }
                }
                catch (TransformException e) {
                    throw new DataSourceException("Unable to create a coverage for this source", (Throwable)e);
                }
                catch (FactoryException e) {
                    throw new DataSourceException("Unable to create a coverage for this source", (Throwable)e);
                }
            }
            if (!requestedOriginalEnvelope.intersects((Envelope)this.originalEnvelope, true)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("The requested envelope does not intersect the envelope of this mosaic, we will return a null coverage.");
                }
                return null;
            }
            intersectionEnvelope = new GeneralEnvelope((Envelope)requestedOriginalEnvelope);
            intersectionEnvelope.intersect((Envelope)this.originalEnvelope);
        } else {
            intersectionEnvelope = requestedOriginalEnvelope = new GeneralEnvelope((Envelope)this.originalEnvelope);
        }
        requestedOriginalEnvelope.setCoordinateReferenceSystem(this.crs);
        intersectionEnvelope.setCoordinateReferenceSystem(this.crs);
        ReferencedEnvelope intersectionJTSEnvelope = new ReferencedEnvelope((Envelope)intersectionEnvelope, this.crs);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("loading tile for envelope " + intersectionJTSEnvelope.toString());
        }
        if ((features = this.getFeaturesFromIndex((com.vividsolutions.jts.geom.Envelope)intersectionJTSEnvelope)) == null) {
            return this.fakeMosaic(requestedOriginalEnvelope, pixelDimension);
        }
        Iterator it = features.iterator();
        if (!it.hasNext()) {
            if (skipEmptyAreas) {
                return null;
            }
            return this.fakeMosaic(requestedOriginalEnvelope, pixelDimension);
        }
        int size = features.size();
        if (size > 1000000) {
            LOGGER.warning("We can load at most " + 1000000 + " tiles while there were requested " + features + "\nI am going to print out a fake coverage, sorry about it!");
            return this.fakeMosaic(requestedOriginalEnvelope, pixelDimension);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("We have " + size + " tiles to load");
        }
        try {
            return this.loadRequestedTiles(requestedOriginalEnvelope, intersectionEnvelope, transparentColor, outputTransparentColor, (com.vividsolutions.jts.geom.Envelope)intersectionJTSEnvelope, features, it, inputImageThresholdValue, pixelDimension, size, fading);
        }
        catch (DataSourceException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (TransformException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return null;
    }

    private GridCoverage fakeMosaic(GeneralEnvelope requestedEnvelope, Rectangle dim) {
        return coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)PatternDescriptor.create((RenderedImage)this.unavailableImage, (Integer)new Integer(dim.width), (Integer)new Integer(dim.height), (RenderingHints)ImageUtilities.NOCACHE_HINT), (Envelope)requestedEnvelope);
    }

    private GridCoverage loadRequestedTiles(GeneralEnvelope requestedOriginalEnvelope, GeneralEnvelope intersectionEnvelope, Color transparentColor, Color outputTransparentColor, com.vividsolutions.jts.geom.Envelope requestedJTSEnvelope, List features, Iterator it, double inputImageThresholdValue, Rectangle dim, int numImages, boolean blend) throws DataSourceException, TransformException {
        try {
            RenderedOp loadedImage;
            String location;
            double[] res;
            ParameterBlockJAI pbjMosaic = new ParameterBlockJAI("Mosaic");
            pbjMosaic.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
            ImageReadParam readP = new ImageReadParam();
            Integer imageChoice = dim != null ? this.setReadParams(readP, requestedOriginalEnvelope, dim) : new Integer(0);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Loading level " + imageChoice.toString() + " with subsampling factors " + readP.getSourceXSubsampling() + " " + readP.getSourceYSubsampling());
            }
            if (imageChoice == 0) {
                res = new double[this.highestRes.length];
                res[0] = this.highestRes[0];
                res[1] = this.highestRes[1];
            } else {
                double[] temp = this.overViewResolutions[imageChoice - 1];
                res = new double[temp.length];
                res[0] = temp[0];
                res[1] = temp[1];
            }
            res[0] = res[0] * (double)readP.getSourceXSubsampling();
            res[1] = res[1] * (double)readP.getSourceYSubsampling();
            com.vividsolutions.jts.geom.Envelope loadedDataSetBound = this.getLoadedDataSetBoud(features);
            Point2D.Double ULC = new Point2D.Double(loadedDataSetBound.getMinX(), loadedDataSetBound.getMaxY());
            File tempFile = new File(this.sourceURL.getFile());
            String parentLocation = tempFile.getParent();
            ROI[] rois = new ROI[numImages];
            PlanarImage[] alphaChannels = new PlanarImage[numImages];
            Area finalLayout = new Area();
            boolean alphaIn = false;
            boolean doTransparentColor = false;
            boolean doInputImageThreshold = false;
            int[] alphaIndex = null;
            int i = 0;
            Boolean readMetadata = Boolean.FALSE;
            Boolean readThumbnails = Boolean.FALSE;
            Boolean verifyInput = Boolean.FALSE;
            do {
                Feature feature = (Feature)it.next();
                location = (String)feature.getAttribute("location");
                com.vividsolutions.jts.geom.Envelope bound = feature.getBounds();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("About to read image number " + i);
                }
                File imageFile = new File(parentLocation + File.separatorChar + location);
                ParameterBlock pbjImageRead = new ParameterBlock();
                pbjImageRead.add(ImageIO.createImageInputStream(imageFile));
                pbjImageRead.add(imageChoice);
                pbjImageRead.add(readMetadata);
                pbjImageRead.add(readThumbnails);
                pbjImageRead.add(verifyInput);
                pbjImageRead.add(null);
                pbjImageRead.add(null);
                pbjImageRead.add(readP);
                pbjImageRead.add(null);
                loadedImage = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Just read image number " + i);
                }
                if (i == 0) {
                    ColorModel model = loadedImage.getColorModel();
                    alphaIn = model.hasAlpha();
                    if (alphaIn) {
                        alphaIndex = new int[]{model.getNumComponents() - 1};
                    }
                    doInputImageThreshold = this.checkIfThresholdIsNeeded((PlanarImage)loadedImage, inputImageThresholdValue);
                    if (transparentColor != null) {
                        int oldTransparentColor;
                        IndexColorModel icm;
                        int transparentPixel;
                        transparentColor = new Color(transparentColor.getRed(), transparentColor.getGreen(), transparentColor.getBlue());
                        doTransparentColor = true;
                        if (model instanceof IndexColorModel && alphaIn && model.getTransparency() == 2 && (transparentPixel = (icm = (IndexColorModel)model).getTransparentPixel()) != -1 && (oldTransparentColor = icm.getRGB(transparentPixel)) == transparentColor.getRGB()) {
                            doTransparentColor = false;
                        }
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding to mosaic image number " + i);
                }
                this.addToMosaic(pbjMosaic, bound, ULC, res, (PlanarImage)loadedImage, doInputImageThreshold, rois, i, inputImageThresholdValue, alphaIn, alphaIndex, alphaChannels, finalLayout, imageFile, doTransparentColor, transparentColor);
            } while (++i < numImages);
            double th = this.getThreshold(loadedImage.getSampleModel().getDataType());
            pbjMosaic.setParameter("sourceThreshold", (Object)new double[][]{{th}});
            if (doInputImageThreshold) {
                pbjMosaic.setParameter("sourceROI", (Object)rois);
            } else if (alphaIn || doTransparentColor) {
                pbjMosaic.setParameter("sourceAlpha", (Object)alphaChannels);
            }
            if (blend) {
                pbjMosaic.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_BLEND);
            }
            return this.prepareMosaic(location, requestedOriginalEnvelope, intersectionEnvelope, res, loadedDataSetBound, pbjMosaic, finalLayout, outputTransparentColor);
        }
        catch (IOException e) {
            throw new DataSourceException("Unable to create this mosaic", (Throwable)e);
        }
    }

    private boolean checkIfThresholdIsNeeded(PlanarImage loadedImage, double thresholdValue) {
        if (Double.isNaN(thresholdValue) || Double.isInfinite(thresholdValue)) {
            return false;
        }
        switch (loadedImage.getSampleModel().getDataType()) {
            case 0: {
                int bTh = (int)thresholdValue;
                if (bTh <= 0 || bTh >= 255) {
                    return false;
                }
            }
            case 1: {
                int usTh = (int)thresholdValue;
                if (usTh <= 0 || usTh >= 65535) {
                    return false;
                }
            }
            case 2: {
                int sTh = (int)thresholdValue;
                if (sTh <= Short.MIN_VALUE || sTh >= Short.MAX_VALUE) {
                    return false;
                }
            }
            case 3: {
                int iTh = (int)thresholdValue;
                if (iTh <= Integer.MIN_VALUE || iTh >= Integer.MAX_VALUE) {
                    return false;
                }
            }
            case 4: {
                float fTh = (float)thresholdValue;
                if (fTh <= -3.4028235E38f || fTh >= Float.MAX_VALUE || Float.isInfinite(fTh) || Float.isNaN(fTh)) {
                    return false;
                }
            }
            case 5: {
                double dTh = thresholdValue;
                if (!(dTh <= -1.7976931348623157E308) && !(dTh >= Double.MAX_VALUE) && !Double.isInfinite(dTh) && !Double.isNaN(dTh)) break;
                return false;
            }
        }
        return true;
    }

    private double getThreshold(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: {
                return 1.0;
            }
            case 3: {
                return -2.147483648E9;
            }
            case 2: {
                return -32768.0;
            }
            case 5: {
                return -1.7976931348623157E308;
            }
            case 4: {
                return -3.4028234663852886E38;
            }
        }
        return 0.0;
    }

    private com.vividsolutions.jts.geom.Envelope getLoadedDataSetBoud(List features) throws IOException {
        com.vividsolutions.jts.geom.Envelope loadedULC = new com.vividsolutions.jts.geom.Envelope();
        Iterator it = features.iterator();
        while (it.hasNext()) {
            loadedULC.expandToInclude(((Feature)it.next()).getDefaultGeometry().getEnvelopeInternal());
        }
        return loadedULC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFeaturesFromIndex(com.vividsolutions.jts.geom.Envelope envelope) throws IOException {
        Object o;
        List features = null;
        SoftReference softReference = this.index;
        synchronized (softReference) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Trying to  use the index...");
            }
            if ((o = this.index.get()) != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Index does not need to be created...");
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Index needa to be recreated...");
                }
                o = new MemorySpatialIndex(this.featureSource.getFeatures());
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
        }
        features = ((MemorySpatialIndex)o).findFeatures(envelope);
        return features;
    }

    private GridCoverage prepareMosaic(String location, GeneralEnvelope requestedOriginalEnvelope, GeneralEnvelope intersectionEnvelope, double[] res, com.vividsolutions.jts.geom.Envelope loadedTilesEnvelope, ParameterBlockJAI pbjMosaic, Area finalLayout, Color outputTransparentColor) throws DataSourceException {
        RenderedOp preparationImage;
        GeneralEnvelope finalenvelope = null;
        Rectangle loadedTilePixelsBound = finalLayout.getBounds();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Loaded bbox " + loadedTilesEnvelope.toString() + " while requested bbox " + requestedOriginalEnvelope.toString());
        }
        GeneralEnvelope loadedTilesBoundEnv = new GeneralEnvelope(new double[]{loadedTilesEnvelope.getMinX(), loadedTilesEnvelope.getMinY()}, new double[]{loadedTilesEnvelope.getMaxX(), loadedTilesEnvelope.getMaxY()});
        loadedTilesBoundEnv.setCoordinateReferenceSystem(this.crs);
        double loadedTilesEnvelopeDim0 = loadedTilesBoundEnv.getLength(0);
        double loadedTilesEnvelopeDim1 = loadedTilesBoundEnv.getLength(1);
        if (!intersectionEnvelope.equals((Envelope)loadedTilesBoundEnv, Math.min(loadedTilesEnvelopeDim0 / loadedTilePixelsBound.getWidth() / 2.0, loadedTilesEnvelopeDim1 / loadedTilePixelsBound.getHeight() / 2.0), false)) {
            GeneralEnvelope intersection = new GeneralEnvelope((Envelope)intersectionEnvelope);
            intersection.intersect((Envelope)loadedTilesBoundEnv);
            try {
                GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper((GridRange)new GeneralGridRange(loadedTilePixelsBound), (Envelope)loadedTilesBoundEnv);
                gridToEnvelopeMapper.setGridType(PixelInCell.CELL_CORNER);
                MathTransform transform = gridToEnvelopeMapper.createTransform().inverse();
                GeneralGridRange finalRange = new GeneralGridRange((Envelope)CRSUtilities.transform((MathTransform)transform, (Envelope)intersection));
                finalLayout.intersect(new Area(finalRange.toRectangle()));
                Rectangle tempRect = finalLayout.getBounds();
                preparationImage = JAI.create((String)"Mosaic", (ParameterBlock)pbjMosaic, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(tempRect.x, tempRect.y, tempRect.width, tempRect.height)));
                finalenvelope = intersection;
            }
            catch (MismatchedDimensionException e) {
                throw new DataSourceException("Problem when creating this mosaic.", (Throwable)e);
            }
            catch (NoninvertibleTransformException e) {
                throw new DataSourceException("Problem when creating this mosaic.", (Throwable)e);
            }
            catch (TransformException e) {
                throw new DataSourceException("Problem when creating this mosaic.", (Throwable)e);
            }
        } else {
            preparationImage = JAI.create((String)"Mosaic", (ParameterBlock)pbjMosaic);
            finalenvelope = new GeneralEnvelope((Envelope)intersectionEnvelope);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Mosaic created ");
        }
        if (outputTransparentColor != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha");
            }
            ImageWorker w = new ImageWorker((RenderedImage)preparationImage);
            preparationImage = preparationImage.getColorModel() instanceof IndexColorModel ? w.maskIndexColorModelByte(outputTransparentColor).getPlanarImage() : w.maskComponentColorModelByte(outputTransparentColor).getPlanarImage();
            return coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)preparationImage, (Envelope)finalenvelope);
        }
        return coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)preparationImage, (Envelope)finalenvelope);
    }

    private void addToMosaic(ParameterBlockJAI pbjMosaic, com.vividsolutions.jts.geom.Envelope bound, Point2D ulc, double[] res, PlanarImage loadedImage, boolean doInputImageThreshold, ROI[] rois, int i, double inputImageThresholdValue, boolean alphaIn, int[] alphaIndex, PlanarImage[] alphaChannels, Area finalLayout, File imageFile, boolean doTransparentColor, Color transparentColor) {
        ImageWorker w;
        PlanarImage readyToMosaicImage = this.scaleAndTranslate(bound, ulc, res, loadedImage);
        if (this.expandMe && readyToMosaicImage.getColorModel() instanceof IndexColorModel) {
            readyToMosaicImage = new ImageWorker((RenderedImage)readyToMosaicImage).forceComponentColorModel().getPlanarImage();
        }
        if (doTransparentColor) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on input image number " + i);
            }
            w = new ImageWorker((RenderedImage)readyToMosaicImage);
            readyToMosaicImage = readyToMosaicImage.getColorModel() instanceof IndexColorModel ? w.maskIndexColorModelByte(transparentColor).getPlanarImage() : w.maskComponentColorModelByte(transparentColor).getPlanarImage();
            alphaIndex = new int[]{readyToMosaicImage.getColorModel().getNumComponents() - 1};
        }
        if (doInputImageThreshold) {
            w = new ImageWorker((RenderedImage)readyToMosaicImage);
            w.tileCacheEnabled(false).intensity().binarize(inputImageThresholdValue);
            rois[i] = w.getImageAsROI();
        } else if (alphaIn || doTransparentColor) {
            w = new ImageWorker((RenderedImage)readyToMosaicImage);
            alphaChannels[i] = readyToMosaicImage.getColorModel() instanceof IndexColorModel ? w.forceComponentColorModel().retainLastBand().getPlanarImage() : w.retainBands(alphaIndex).getPlanarImage();
        }
        pbjMosaic.addSource((Object)readyToMosaicImage);
        finalLayout.add(new Area(readyToMosaicImage.getBounds()));
    }

    private PlanarImage scaleAndTranslate(com.vividsolutions.jts.geom.Envelope bound, Point2D ulc, double[] res, PlanarImage image) {
        double resX = (bound.getMaxX() - bound.getMinX()) / (double)image.getWidth();
        double resY = (bound.getMaxY() - bound.getMinY()) / (double)image.getHeight();
        double scaleX = 1.0;
        double scaleY = 1.0;
        double xTrans = 0.0;
        double yTrans = 0.0;
        if (Math.abs((resX - res[0]) / resX) > 1.0E-6 || Math.abs(resY - res[1]) > 1.0E-6) {
            scaleX = res[0] / resX;
            scaleY = res[1] / resY;
        }
        xTrans = (bound.getMinX() - ulc.getX()) / res[0];
        yTrans = (ulc.getY() - bound.getMaxY()) / res[1];
        ParameterBlock pbjAffine = new ParameterBlock();
        if (Math.abs(xTrans - (double)((int)xTrans)) < Math.pow(10.0, -3.0) && Math.abs(yTrans - (double)((int)yTrans)) < Math.pow(10.0, -3.0) && Math.abs(scaleX - 1.0) < Math.pow(10.0, -6.0) && Math.abs(scaleY - 1.0) < Math.pow(10.0, -6.0)) {
            if (Math.abs(xTrans) < Math.pow(10.0, -3.0) && Math.abs(yTrans) < Math.pow(10.0, -3.0)) {
                return image;
            }
            pbjAffine.addSource(image).add(new Float(xTrans)).add(new Float(yTrans)).add(ImageUtilities.NN_INTERPOLATION_HINT.get(JAI.KEY_INTERPOLATION));
            return JAI.create((String)"Translate", (ParameterBlock)pbjAffine, (RenderingHints)ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        }
        pbjAffine.addSource(image).add(new AffineTransform(scaleX, 0.0, 0.0, scaleY, xTrans, yTrans)).add(ImageUtilities.NN_INTERPOLATION_HINT.get(JAI.KEY_INTERPOLATION));
        RenderingHints hints = (RenderingHints)ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL.clone();
        hints.add(ImageUtilities.EXTEND_BORDER_BY_COPYING);
        return JAI.create((String)"Affine", (ParameterBlock)pbjAffine, (RenderingHints)hints);
    }

    static {
        $assertionsDisabled = !ImageMosaicReader.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger("org.geotools.gce.imagemosaic");
    }
}

