/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;

public final class MemorySpatialIndex {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gce.imagemosaic");
    private final STRtree index;

    public MemorySpatialIndex(FeatureCollection features) {
        if (features == null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The provided FeatureCollection is null, it's impossible to create an index!");
            }
            throw new IllegalArgumentException("The provided FeatureCollection is null, it's impossible to create an index!");
        }
        FeatureIterator it = features.features();
        if (!it.hasNext()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The provided FeatureCollection  or empty, it's impossible to create an index!");
            }
            throw new IllegalArgumentException("The provided FeatureCollection  or empty, it's impossible to create an index!");
        }
        this.index = new STRtree();
        while (it.hasNext()) {
            Feature f = it.next();
            Geometry g = f.getDefaultGeometry();
            this.index.insert(g.getEnvelopeInternal(), (Object)f);
        }
        features.close(it);
        this.index.build();
    }

    public List findFeatures(Envelope envelope) {
        return this.index.query(envelope);
    }
}

