/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.util.Arrays;
import java.util.Map;
import org.geotools.coverage.Category;
import org.geotools.coverage.ScaledColorSpace;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.ComponentColorModelJAI;
import org.geotools.util.SoftValueHashMap;

final class ColorModelFactory {
    private static final Map colors = new SoftValueHashMap();
    private final Category[] categories;
    private final int visibleBand;
    private final int numBands;
    private final int type;

    private ColorModelFactory(Category[] categories, int type, int visibleBand, int numBands) {
        this.categories = categories;
        this.visibleBand = visibleBand;
        this.numBands = numBands;
        this.type = type;
        if (visibleBand < 0 || visibleBand >= numBands) {
            throw new IllegalArgumentException(Errors.format(5, new Integer(visibleBand)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorModel getColorModel(Category[] categories, int type, int visibleBand, int numBands) {
        Map map = colors;
        synchronized (map) {
            ColorModelFactory key = new ColorModelFactory(categories, type, visibleBand, numBands);
            ColorModel model = (ColorModel)colors.get(key);
            if (model == null) {
                model = key.getColorModel();
                colors.put(key, model);
            }
            return model;
        }
    }

    private ColorModel getColorModel() {
        int categoryCount = this.categories.length;
        if (this.type != 0 && this.type != 1) {
            double min = 0.0;
            double max = 1.0;
            if (categoryCount != 0) {
                min = this.categories[0].minimum;
                int i = categoryCount;
                while (--i >= 0) {
                    double val = this.categories[i].maximum;
                    if (Double.isNaN(val)) continue;
                    max = val;
                    break;
                }
            }
            boolean transparency = true;
            ScaledColorSpace colors = new ScaledColorSpace(this.visibleBand, this.numBands, min, max);
            return new ComponentColorModelJAI(colors, false, false, 1, this.type);
        }
        if (this.numBands == 1 && categoryCount == 0) {
            ColorSpace cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{DataBuffer.getDataTypeSize(this.type)};
            return new ComponentColorModel(cs, nBits, false, true, 1, this.type);
        }
        int mapSize = (int)Math.round(this.categories[categoryCount - 1].maximum) + 1;
        int[] ARGB = new int[mapSize];
        for (int i = 0; i < categoryCount; ++i) {
            Category category = this.categories[i];
            ColorUtilities.expand(category.getColors(), ARGB, (int)Math.round(category.minimum), (int)Math.round(category.maximum) + 1);
        }
        return ColorUtilities.getIndexColorModel(ARGB, this.numBands, this.visibleBand);
    }

    public int hashCode() {
        int categoryCount = this.categories.length;
        int code = 962745549 + (this.numBands * 37 + this.visibleBand) * 37 + categoryCount;
        for (int i = 0; i < categoryCount; ++i) {
            code += this.categories[i].hashCode();
        }
        return code;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ColorModelFactory) {
            ColorModelFactory that = (ColorModelFactory)other;
            return this.numBands == that.numBands && this.visibleBand == that.visibleBand && Arrays.equals(this.categories, that.categories);
        }
        return false;
    }
}

