/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Color;
import org.geotools.coverage.Category;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.NumberRange;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

final class GeophysicsCategory
extends Category {
    private static final long serialVersionUID = -7164422654831370784L;
    static final /* synthetic */ boolean $assertionsDisabled;

    GeophysicsCategory(Category inverse, boolean isQuantitative) throws TransformException {
        super(inverse, isQuantitative);
    }

    public InternationalString getName() {
        if (!$assertionsDisabled && this.inverse instanceof GeophysicsCategory) {
            throw new AssertionError();
        }
        return this.inverse.getName();
    }

    public Color[] getColors() {
        if (!$assertionsDisabled && this.inverse instanceof GeophysicsCategory) {
            throw new AssertionError();
        }
        return this.inverse.getColors();
    }

    public NumberRange getRange() throws IllegalStateException {
        if (this.range == null) {
            try {
                MathTransform1D tr = this.inverse.transform;
                NumberRange r = this.inverse.range;
                boolean minIncluded = r.isMinIncluded();
                boolean maxIncluded = r.isMaxIncluded();
                double min = tr.transform(r.getMinimum());
                double max = tr.transform(r.getMaximum());
                double min2 = tr.transform(r.getMinimum(!minIncluded));
                double max2 = tr.transform(r.getMaximum(!maxIncluded));
                double d = minIncluded ? min2 : min;
                double d2 = maxIncluded ? max2 : max;
                if (d > d2) {
                    double tmp = min;
                    double tmp2 = min2;
                    boolean tmpIncluded = minIncluded;
                    min = max;
                    min2 = max2;
                    minIncluded = maxIncluded;
                    max = tmp;
                    max2 = tmp2;
                    maxIncluded = tmpIncluded;
                }
                if (!$assertionsDisabled && Double.doubleToLongBits(this.minimum) != Double.doubleToLongBits(minIncluded ? min : min2)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && Double.doubleToLongBits(this.maximum) != Double.doubleToLongBits(maxIncluded ? max : max2)) {
                    throw new AssertionError();
                }
                this.range = new Range(min, minIncluded, max, maxIncluded, min2, max2);
            }
            catch (TransformException cause) {
                IllegalStateException exception = new IllegalStateException(Errors.format(15, Utilities.getShortClassName(this.inverse.transform)));
                exception.initCause(cause);
                throw exception;
            }
        }
        return this.range;
    }

    public MathTransform1D getSampleToGeophysics() {
        return this.isQuantitative() ? LinearTransform1D.IDENTITY : null;
    }

    public boolean isQuantitative() {
        if (!$assertionsDisabled && this.inverse instanceof GeophysicsCategory) {
            throw new AssertionError(this.inverse);
        }
        return this.inverse.isQuantitative();
    }

    public Category recolor(Color[] colors) {
        if (!$assertionsDisabled && this.inverse instanceof GeophysicsCategory) {
            throw new AssertionError(this.inverse);
        }
        return this.inverse.recolor((Color[])colors).inverse;
    }

    public Category rescale(MathTransform1D sampleToGeophysics) {
        if (sampleToGeophysics.isIdentity()) {
            return this;
        }
        sampleToGeophysics = (MathTransform1D)ConcatenatedTransform.create((MathTransform)this.inverse.getSampleToGeophysics(), (MathTransform)sampleToGeophysics);
        return this.inverse.rescale((MathTransform1D)sampleToGeophysics).inverse;
    }

    public Category geophysics(boolean toGeophysics) {
        if (!$assertionsDisabled && this.inverse instanceof GeophysicsCategory) {
            throw new AssertionError(this.inverse);
        }
        return this.inverse.geophysics(toGeophysics);
    }

    static {
        $assertionsDisabled = !GeophysicsCategory.class.desiredAssertionStatus();
    }

    private static final class Range
    extends NumberRange {
        private static final long serialVersionUID = -1416908614729956928L;
        private final double minimum2;
        private final double maximum2;

        public Range(double minimum, boolean isMinIncluded, double maximum, boolean isMaxIncluded, double minimum2, double maximum2) {
            super(minimum, isMinIncluded, maximum, isMaxIncluded);
            this.minimum2 = minimum2;
            this.maximum2 = maximum2;
        }

        public double getMinimum(boolean inclusive) {
            return inclusive == this.isMinIncluded() ? this.getMinimum() : this.minimum2;
        }

        public double getMaximum(boolean inclusive) {
            return inclusive == this.isMaxIncluded() ? this.getMaximum() : this.maximum2;
        }
    }
}

