/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import javax.units.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.CategoryList;
import org.geotools.resources.Utilities;
import org.geotools.resources.XMath;

final class GeophysicsCategoryList
extends CategoryList {
    private static final long serialVersionUID = 98602310176453958L;
    private static final int MAX_DIGITS = 6;
    private final Unit unit;
    private final int ndigits;
    private transient Locale locale;
    private transient NumberFormat format;
    private transient FieldPosition dummy;
    static final /* synthetic */ boolean $assertionsDisabled;

    GeophysicsCategoryList(Category[] categories, Unit unit, CategoryList inverse) {
        super(categories, unit, true, inverse);
        this.unit = unit;
        this.ndigits = GeophysicsCategoryList.getFractionDigitCount(categories);
        if (!$assertionsDisabled && !this.isScaled(true)) {
            throw new AssertionError();
        }
    }

    private static int getFractionDigitCount(Category[] categories) {
        int ndigits = 0;
        double EPS = 1.0E-6;
        int length = categories.length;
        for (int i = 0; i < length; ++i) {
            int n;
            Category geophysics = categories[i].geophysics(true);
            Category samples = categories[i].geophysics(false);
            double ln = XMath.log10((geophysics.maximum - geophysics.minimum) / (samples.maximum - samples.minimum));
            if (Double.isNaN(ln) || (n = -((int)Math.floor(ln + 1.0E-6))) <= ndigits) continue;
            ndigits = Math.min(n, 6);
        }
        return ndigits;
    }

    public CategoryList geophysics(boolean toGeophysics) {
        CategoryList scaled;
        CategoryList categoryList = scaled = toGeophysics ? this : this.inverse;
        if (!$assertionsDisabled && !scaled.isScaled(toGeophysics)) {
            throw new AssertionError();
        }
        return scaled;
    }

    public Unit getUnits() {
        return this.unit;
    }

    synchronized StringBuffer format(double value, boolean writeUnits, Locale locale, StringBuffer buffer) {
        if (this.format == null || !Utilities.equals(this.locale, locale)) {
            this.locale = locale;
            this.format = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance();
            this.format.setMinimumFractionDigits(this.ndigits);
            this.format.setMaximumFractionDigits(this.ndigits);
            this.dummy = new FieldPosition(0);
        }
        buffer = this.format.format(value, buffer, this.dummy);
        if (writeUnits && this.unit != null) {
            int position = buffer.length();
            buffer.append('\u00a0');
            buffer.append(this.unit);
            if (buffer.length() == position + 1) {
                buffer.setLength(position);
            }
        }
        return buffer;
    }

    public boolean equals(Object object) {
        if (object instanceof GeophysicsCategoryList) {
            GeophysicsCategoryList that = (GeophysicsCategoryList)object;
            return this.ndigits == that.ndigits && Utilities.equals(this.unit, that.unit) && super.equals(that);
        }
        return this.ndigits == 0 && this.unit == null && super.equals(object);
    }

    static {
        $assertionsDisabled = !GeophysicsCategoryList.class.desiredAssertionStatus();
    }
}

