/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.io.Serializable;
import java.util.Arrays;
import org.opengis.coverage.grid.GridCoordinates;

public class GeneralGridCoordinates
implements GridCoordinates,
Serializable {
    private static final long serialVersionUID = 8146318677770695383L;
    private final int[] coordinates;

    public GeneralGridCoordinates(int dimension) {
        this.coordinates = new int[dimension];
    }

    public GeneralGridCoordinates(int[] coordinates) {
        this.coordinates = (int[])coordinates.clone();
    }

    GeneralGridCoordinates(int[] coordinates, int lower, int upper) {
        int length = upper - lower;
        this.coordinates = new int[length];
        System.arraycopy(coordinates, lower, this.coordinates, 0, length);
    }

    public int getDimension() {
        return this.coordinates.length;
    }

    public int[] getCoordinateValues() {
        return (int[])this.coordinates.clone();
    }

    public int getCoordinateValue(int i) {
        return this.coordinates[i];
    }

    public void setCoordinateValue(int i, int value) throws UnsupportedOperationException {
        this.coordinates[i] = value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("GridCoordinates");
        for (int i = 0; i < this.coordinates.length; ++i) {
            buffer.append(i == 0 ? (char)'[' : ',');
            buffer.append(this.coordinates[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public int hashCode() {
        int code = 665252567;
        for (int i = 0; i < this.coordinates.length; ++i) {
            code = code * 37 + this.coordinates[i];
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            GeneralGridCoordinates that = (GeneralGridCoordinates)object;
            return Arrays.equals(this.coordinates, that.coordinates);
        }
        return false;
    }

    public Object clone() {
        return new GeneralGridCoordinates(this.coordinates);
    }

    static final class Immutable
    extends GeneralGridCoordinates {
        private static final long serialVersionUID = -7723383411061425866L;

        Immutable(int[] coordinates, int lower, int upper) {
            super(coordinates, lower, upper);
        }

        public void setCoordinateValue(int i, int value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

