/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.io.Serializable;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridRange;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class GeneralGridGeometry
implements GridGeometry,
Serializable {
    private static final long serialVersionUID = 124700383873732132L;
    public static final int CRS = 1;
    public static final int ENVELOPE = 2;
    public static final int GRID_RANGE = 4;
    public static final int GRID_TO_CRS = 8;
    private static final MathTransform[] translations;
    protected final GridRange gridRange;
    final GeneralEnvelope envelope;
    protected final MathTransform gridToCRS;
    static final /* synthetic */ boolean $assertionsDisabled;

    GeneralGridGeometry(GeneralGridGeometry gm, CoordinateReferenceSystem crs) {
        this.gridRange = gm.gridRange;
        this.gridToCRS = gm.gridToCRS;
        this.envelope = new GeneralEnvelope(gm.envelope);
        this.envelope.setCoordinateReferenceSystem(crs);
    }

    public GeneralGridGeometry(GridRange gridRange, MathTransform gridToCRS, CoordinateReferenceSystem crs) throws MismatchedDimensionException, IllegalArgumentException {
        this.gridRange = gridRange;
        this.gridToCRS = gridToCRS;
        if (gridRange != null && gridToCRS != null) {
            this.envelope = new GeneralEnvelope(gridRange, PixelInCell.CELL_CENTER, gridToCRS, crs);
        } else if (crs != null) {
            this.envelope = new GeneralEnvelope(crs);
            this.envelope.setToNull();
        } else {
            this.envelope = null;
        }
    }

    public GeneralGridGeometry(GridRange gridRange, Envelope userRange) throws MismatchedDimensionException {
        this(gridRange, userRange, null, false, true);
    }

    public GeneralGridGeometry(GridRange gridRange, Envelope userRange, boolean[] reverse, boolean swapXY) throws MismatchedDimensionException {
        this(gridRange, userRange, reverse, swapXY, false);
    }

    GeneralGridGeometry(GridRange gridRange, Envelope userRange, boolean[] reverse, boolean swapXY, boolean automatic) throws MismatchedDimensionException {
        this.gridRange = gridRange;
        this.envelope = new GeneralEnvelope(userRange);
        GridToEnvelopeMapper mapper = new GridToEnvelopeMapper(gridRange, userRange);
        if (!automatic) {
            mapper.setReverseAxis(reverse);
            mapper.setSwapXY(swapXY);
        }
        this.gridToCRS = mapper.createTransform();
    }

    public static MathTransform getTransform(GridRange gridRange, Envelope userRange, boolean[] reverse, boolean swapXY, boolean halfPix) throws MismatchedDimensionException {
        GridToEnvelopeMapper mapper = new GridToEnvelopeMapper(gridRange, userRange);
        mapper.setGridType(halfPix ? PixelInCell.CELL_CENTER : PixelInCell.CELL_CORNER);
        mapper.setReverseAxis(reverse);
        mapper.setSwapXY(swapXY);
        return mapper.createTransform();
    }

    public static MathTransform getTransform(GridRange gridRange, Envelope userRange, boolean halfPix) throws MismatchedDimensionException {
        GridToEnvelopeMapper mapper = new GridToEnvelopeMapper(gridRange, userRange);
        mapper.setGridType(halfPix ? PixelInCell.CELL_CENTER : PixelInCell.CELL_CORNER);
        return mapper.createTransform();
    }

    public static boolean[] reverse(CoordinateSystem cs) {
        if (cs == null) {
            return null;
        }
        int dimension = cs.getDimension();
        boolean[] reverse = new boolean[dimension];
        for (int i = 0; i < dimension; ++i) {
            AxisDirection direction = cs.getAxis(i).getDirection();
            AxisDirection absolute = direction.absolute();
            reverse[i] = direction.equals(absolute.opposite());
            if (!AxisDirection.NORTH.equals(absolute)) continue;
            reverse[i] = !reverse[i];
        }
        return reverse;
    }

    public static boolean swapXY(CoordinateSystem cs) {
        boolean swapXY = false;
        if (cs != null && cs.getDimension() >= 2) {
            swapXY = AxisDirection.NORTH.equals(cs.getAxis(0).getDirection().absolute()) && AxisDirection.EAST.equals(cs.getAxis(1).getDirection().absolute());
        }
        return swapXY;
    }

    public int getDimension() {
        if (this.gridToCRS != null) {
            return this.gridToCRS.getSourceDimensions();
        }
        return this.getGridRange().getDimension();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() throws InvalidGridGeometryException {
        CoordinateReferenceSystem crs;
        if (this.envelope != null && (crs = this.envelope.getCoordinateReferenceSystem()) != null) {
            if (!$assertionsDisabled && !this.isDefined(1)) {
                throw new AssertionError();
            }
            return crs;
        }
        if (!$assertionsDisabled && this.isDefined(1)) {
            throw new AssertionError();
        }
        throw new InvalidGridGeometryException(Errors.format(140));
    }

    public Envelope getEnvelope() throws InvalidGridGeometryException {
        if (this.envelope != null && !this.envelope.isNull()) {
            if (!$assertionsDisabled && !this.isDefined(2)) {
                throw new AssertionError();
            }
            return (Envelope)this.envelope.clone();
        }
        if (!$assertionsDisabled && this.isDefined(2)) {
            throw new AssertionError();
        }
        throw new InvalidGridGeometryException(Errors.format(this.gridToCRS == null ? 178 : 141));
    }

    public static GeneralEnvelope getEnvelope(GridRange gridRange, MathTransform gridToCRS, CoordinateReferenceSystem crs, boolean halfPix) throws MismatchedDimensionException, IllegalArgumentException {
        return new GeneralEnvelope(gridRange, halfPix ? PixelInCell.CELL_CENTER : PixelInCell.CELL_CORNER, gridToCRS, crs);
    }

    public GridRange getGridRange() throws InvalidGridGeometryException {
        if (this.gridRange != null) {
            if (!$assertionsDisabled && !this.isDefined(4)) {
                throw new AssertionError();
            }
            return this.gridRange;
        }
        if (!$assertionsDisabled && this.isDefined(4)) {
            throw new AssertionError();
        }
        throw new InvalidGridGeometryException(Errors.format(141));
    }

    public MathTransform getGridToCoordinateSystem() throws InvalidGridGeometryException {
        return this.getGridToCRS();
    }

    public MathTransform getGridToCRS() throws InvalidGridGeometryException {
        if (this.gridToCRS != null) {
            if (!$assertionsDisabled && !this.isDefined(8)) {
                throw new AssertionError();
            }
            return this.gridToCRS;
        }
        if (!$assertionsDisabled && this.isDefined(8)) {
            throw new AssertionError();
        }
        throw new InvalidGridGeometryException(Errors.format(178));
    }

    public MathTransform getGridToCRS(PixelInCell halfPixel) throws InvalidGridGeometryException {
        MathTransform gridToCRS = this.getGridToCoordinateSystem();
        if (PixelInCell.CELL_CENTER.equals(halfPixel)) {
            return gridToCRS;
        }
        if (!PixelInCell.CELL_CORNER.equals(halfPixel)) {
            throw new IllegalArgumentException(Errors.format(42, "halfPixel", halfPixel));
        }
        return ConcatenatedTransform.create(GeneralGridGeometry.getHalfPixelTranslation(gridToCRS.getSourceDimensions()), gridToCRS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MathTransform getHalfPixelTranslation(int dimension) {
        MathTransform[] mathTransformArray = translations;
        synchronized (translations) {
            MathTransform candidate;
            if (dimension < translations.length && (candidate = translations[dimension]) != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return candidate;
            }
            LinearTransform mt = ProjectiveTransform.createTranslation(dimension, -0.5);
            if (dimension < translations.length) {
                GeneralGridGeometry.translations[dimension] = mt;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mt;
        }
    }

    public boolean isDefined(int bitmask) throws IllegalArgumentException {
        if ((bitmask & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(Errors.format(42, "bitmask", new Integer(bitmask)));
        }
        return !((bitmask & 1) != 0 && (this.envelope == null || this.envelope.getCoordinateReferenceSystem() == null) || (bitmask & 2) != 0 && (this.envelope == null || this.envelope.isNull()) || (bitmask & 4) != 0 && this.gridRange == null || (bitmask & 8) != 0 && this.gridToCRS == null);
    }

    public int hashCode() {
        int code = -1541009884;
        if (this.gridToCRS != null) {
            code += this.gridToCRS.hashCode();
        }
        if (this.gridRange != null) {
            code += this.gridRange.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GeneralGridGeometry that = (GeneralGridGeometry)object;
            return Utilities.equals(this.gridRange, that.gridRange) && Utilities.equals(this.gridToCRS, that.gridToCRS) && Utilities.equals(this.envelope, that.envelope);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        buffer.append('[');
        buffer.append(this.gridRange);
        buffer.append(", ");
        buffer.append(this.gridToCRS);
        buffer.append(']');
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !GeneralGridGeometry.class.desiredAssertionStatus();
        translations = new MathTransform[8];
    }
}

