/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.coverage.grid.GeneralGridCoordinates;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.grid.GridCoordinates;
import org.opengis.coverage.grid.GridRange;
import org.opengis.spatialschema.geometry.Envelope;

public class GeneralGridRange
implements GridRange,
Serializable {
    private static final long serialVersionUID = 1452569710967224145L;
    private final int[] index;

    private void checkCoherence() throws IllegalArgumentException {
        int dimension = this.index.length / 2;
        for (int i = 0; i < dimension; ++i) {
            int lower = this.index[i];
            int upper = this.index[dimension + i];
            if (lower <= upper) continue;
            throw new IllegalArgumentException(Errors.format(9, new Integer(i), new Integer(lower), new Integer(upper)));
        }
    }

    private GeneralGridRange(int dimension) {
        this.index = new int[dimension * 2];
    }

    public GeneralGridRange(int lower, int upper) {
        this.index = new int[]{lower, upper};
        this.checkCoherence();
    }

    public GeneralGridRange(int[] lower, int[] upper) {
        if (lower.length != upper.length) {
            throw new IllegalArgumentException(Errors.format(68, new Integer(lower.length), new Integer(upper.length)));
        }
        this.index = new int[lower.length + upper.length];
        System.arraycopy(lower, 0, this.index, 0, lower.length);
        System.arraycopy(upper, 0, this.index, lower.length, upper.length);
        this.checkCoherence();
    }

    public GeneralGridRange(Rectangle rect) {
        this.index = new int[]{rect.x, rect.y, rect.x + rect.width, rect.y + rect.height};
        this.checkCoherence();
    }

    public GeneralGridRange(Raster raster) {
        int x = raster.getMinX();
        int y = raster.getMinY();
        this.index = new int[]{x, y, x + raster.getWidth(), y + raster.getHeight()};
        this.checkCoherence();
    }

    public GeneralGridRange(RenderedImage image) {
        this(image, 2);
    }

    GeneralGridRange(RenderedImage image, int dimension) {
        this.index = new int[dimension * 2];
        int x = image.getMinX();
        int y = image.getMinY();
        this.index[0] = x;
        this.index[1] = y;
        this.index[dimension + 0] = x + image.getWidth();
        this.index[dimension + 1] = y + image.getHeight();
        Arrays.fill(this.index, dimension + 2, this.index.length, 1);
        this.checkCoherence();
    }

    public GeneralGridRange(Envelope envelope) {
        int dimension = envelope.getDimension();
        this.index = new int[dimension * 2];
        for (int i = 0; i < dimension; ++i) {
            this.index[i] = (int)Math.round(envelope.getMinimum(i));
            this.index[i + dimension] = (int)Math.round(envelope.getMaximum(i));
        }
    }

    public int getDimension() {
        return this.index.length / 2;
    }

    public GridCoordinates getLower() {
        return new GeneralGridCoordinates(this.index, 0, this.index.length / 2);
    }

    public int getLower(int dimension) {
        if (dimension < this.index.length / 2) {
            return this.index[dimension];
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    public GridCoordinates getUpper() {
        return new GeneralGridCoordinates(this.index, this.index.length / 2, this.index.length);
    }

    public int getUpper(int dimension) {
        if (dimension >= 0) {
            return this.index[dimension + this.index.length / 2];
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    public int getLength(int dimension) {
        return this.index[dimension + this.index.length / 2] - this.index[dimension];
    }

    public int[] getLowers() {
        int[] lo = new int[this.index.length / 2];
        System.arraycopy(this.index, 0, lo, 0, lo.length);
        return lo;
    }

    public int[] getUppers() {
        int[] hi = new int[this.index.length / 2];
        System.arraycopy(this.index, this.index.length / 2, hi, 0, hi.length);
        return hi;
    }

    public GeneralGridRange getSubGridRange(int lower, int upper) {
        int curDim = this.index.length / 2;
        int newDim = upper - lower;
        if (lower < 0 || lower > curDim) {
            throw new IndexOutOfBoundsException(Errors.format(42, "lower", new Integer(lower)));
        }
        if (newDim < 0 || upper > curDim) {
            throw new IndexOutOfBoundsException(Errors.format(42, "upper", new Integer(upper)));
        }
        GeneralGridRange gridRange = new GeneralGridRange(newDim);
        System.arraycopy(this.index, lower, gridRange.index, 0, newDim);
        System.arraycopy(this.index, lower + curDim, gridRange.index, newDim, newDim);
        return gridRange;
    }

    public Rectangle toRectangle() throws IllegalStateException {
        if (this.index.length == 4) {
            return new Rectangle(this.index[0], this.index[1], this.index[2] - this.index[0], this.index[3] - this.index[1]);
        }
        throw new IllegalStateException(Errors.format(93, new Integer(this.getDimension())));
    }

    public int hashCode() {
        int code = -1045334191;
        if (this.index != null) {
            int i = this.index.length;
            while (--i >= 0) {
                code = code * 31 + this.index[i];
            }
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object instanceof GeneralGridRange) {
            GeneralGridRange that = (GeneralGridRange)object;
            return Arrays.equals(this.index, that.index);
        }
        return false;
    }

    public String toString() {
        int dimension = this.index.length / 2;
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        buffer.append('[');
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.index[i]);
            buffer.append("..");
            buffer.append(this.index[i + dimension]);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

