/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.units.Unit;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.Grid2DSampleDimension;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.LookupTableFactory;
import org.geotools.coverage.grid.RenderedCoverage;
import org.geotools.coverage.processing.AbstractProcessor;
import org.geotools.geometry.Envelope2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.geotools.resources.image.CoverageUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.NumberRange;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridRange;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class GridCoverage2D
extends AbstractGridCoverage
implements RenderedCoverage {
    private static final long serialVersionUID = 667472989475027853L;
    private static final float EPS = 1.0E-5f;
    private static final boolean CONSERVATIVE_PIECEWISE = true;
    private transient GridCoverage2D inverse;
    protected final transient PlanarImage image;
    private RenderedImage serializedImage;
    protected final GridGeometry2D gridGeometry;
    private final GridSampleDimension[] sampleDimensions;
    private final boolean isGeophysics;
    transient String tileEncoding;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected GridCoverage2D(CharSequence name, GridCoverage2D coverage) {
        super(name, coverage);
        this.image = coverage.image;
        this.gridGeometry = coverage.gridGeometry;
        this.sampleDimensions = coverage.sampleDimensions;
        this.isGeophysics = coverage.isGeophysics;
        this.tileEncoding = coverage.tileEncoding;
    }

    protected GridCoverage2D(CharSequence name, PlanarImage image, GridGeometry2D gridGeometry, GridSampleDimension[] bands, GridCoverage[] sources, Map properties) throws IllegalArgumentException {
        super(name, gridGeometry.getCoordinateReferenceSystem(), sources, (PropertySource)image, properties);
        this.image = image;
        this.sampleDimensions = new GridSampleDimension[image.getNumBands()];
        this.isGeophysics = Grid2DSampleDimension.create(name, (RenderedImage)image, bands, this.sampleDimensions);
        int dimension = this.crs.getCoordinateSystem().getDimension();
        if (!gridGeometry.isDefined(4)) {
            GeneralGridRange r = new GeneralGridRange((RenderedImage)image, dimension);
            gridGeometry = gridGeometry.isDefined(8) ? new GridGeometry2D(r, gridGeometry.getGridToCoordinateSystem(), this.crs) : new GridGeometry2D(r, gridGeometry.getEnvelope());
        } else {
            gridGeometry.getGridToCoordinateSystem();
        }
        this.gridGeometry = gridGeometry;
        if (!$assertionsDisabled && !gridGeometry.isDefined(15)) {
            throw new AssertionError();
        }
        String error = GridCoverage2D.checkConsistency((RenderedImage)image, gridGeometry);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        if (dimension <= Math.max(gridGeometry.axisDimensionX, gridGeometry.axisDimensionY) || !(gridGeometry.envelope.getLength(gridGeometry.axisDimensionX) > 0.0) || !(gridGeometry.envelope.getLength(gridGeometry.axisDimensionY) > 0.0)) {
            throw new IllegalArgumentException(Errors.format(34));
        }
    }

    private static String checkConsistency(RenderedImage image, GridGeometry2D grid) {
        GridRange range = grid.getGridRange();
        int dimension = range.getDimension();
        for (int i = 0; i < dimension; ++i) {
            Object label;
            int length;
            int min;
            if (i == grid.gridDimensionX) {
                min = image.getMinX();
                length = image.getWidth();
                label = "\"X\"";
            } else if (i == grid.gridDimensionY) {
                min = image.getMinY();
                length = image.getHeight();
                label = "\"Y\"";
            } else {
                min = range.getLower(i);
                length = Math.min(Math.max(range.getUpper(i), 0), 1);
                label = new Integer(i);
            }
            if (range.getLower(i) == min && range.getLength(i) == length) continue;
            return Errors.format(9, label, new Integer(min), new Integer(min + length));
        }
        return null;
    }

    public boolean isDataEditable() {
        return this.image instanceof WritableRenderedImage;
    }

    public GridGeometry getGridGeometry() {
        String error = GridCoverage2D.checkConsistency((RenderedImage)this.image, this.gridGeometry);
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return this.gridGeometry;
    }

    public Envelope getEnvelope() {
        return this.gridGeometry.getEnvelope();
    }

    public Envelope2D getEnvelope2D() {
        return this.gridGeometry.getEnvelope2D();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem2D() {
        return this.gridGeometry.getCoordinateReferenceSystem2D();
    }

    public int getNumSampleDimensions() {
        return this.sampleDimensions.length;
    }

    public SampleDimension getSampleDimension(int index) {
        return this.sampleDimensions[index];
    }

    public GridSampleDimension[] getSampleDimensions() {
        return (GridSampleDimension[])this.sampleDimensions.clone();
    }

    public Interpolation getInterpolation() {
        return Interpolation.getInstance((int)0);
    }

    public Object evaluate(DirectPosition point) throws CannotEvaluateException {
        int dataType = this.image.getSampleModel().getDataType();
        switch (dataType) {
            case 0: {
                return this.evaluate(point, (byte[])null);
            }
            case 1: 
            case 2: 
            case 3: {
                return this.evaluate(point, (int[])null);
            }
            case 4: {
                return this.evaluate(point, (float[])null);
            }
            case 5: {
                return this.evaluate(point, (double[])null);
            }
        }
        throw new CannotEvaluateException();
    }

    public byte[] evaluate(DirectPosition coord, byte[] dest) throws CannotEvaluateException {
        int[] array = this.evaluate(coord, (int[])null);
        if (dest == null) {
            dest = new byte[array.length];
        }
        for (int i = 0; i < array.length; ++i) {
            dest[i] = (byte)array[i];
        }
        return dest;
    }

    public int[] evaluate(DirectPosition coord, int[] dest) throws CannotEvaluateException {
        return this.evaluate(this.toPoint2D(coord), dest);
    }

    public float[] evaluate(DirectPosition coord, float[] dest) throws CannotEvaluateException {
        return this.evaluate(this.toPoint2D(coord), dest);
    }

    public double[] evaluate(DirectPosition coord, double[] dest) throws CannotEvaluateException {
        return this.evaluate(this.toPoint2D(coord), dest);
    }

    private Point2D toPoint2D(DirectPosition point) throws MismatchedDimensionException {
        int expected;
        int actual = point.getDimension();
        if (actual != (expected = this.crs.getCoordinateSystem().getDimension())) {
            throw new MismatchedDimensionException(Errors.format(68, new Integer(actual), new Integer(expected)));
        }
        if (point instanceof Point2D) {
            return (Point2D)point;
        }
        return new Point2D.Double(point.getOrdinate(this.gridGeometry.axisDimensionX), point.getOrdinate(this.gridGeometry.axisDimensionY));
    }

    public int[] evaluate(Point2D coord, int[] dest) throws CannotEvaluateException {
        Point2D pixel = this.gridGeometry.inverseTransform(coord);
        double fx = pixel.getX();
        double fy = pixel.getY();
        if (!Double.isNaN(fx) && !Double.isNaN(fy)) {
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (this.image.getBounds().contains(x, y)) {
                return this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y)).getPixel(x, y, dest);
            }
        }
        throw new PointOutsideCoverageException(this.pointOutsideCoverage(coord));
    }

    public float[] evaluate(Point2D coord, float[] dest) throws CannotEvaluateException {
        Point2D pixel = this.gridGeometry.inverseTransform(coord);
        double fx = pixel.getX();
        double fy = pixel.getY();
        if (!Double.isNaN(fx) && !Double.isNaN(fy)) {
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (this.image.getBounds().contains(x, y)) {
                return this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y)).getPixel(x, y, dest);
            }
        }
        throw new PointOutsideCoverageException(this.pointOutsideCoverage(coord));
    }

    public double[] evaluate(Point2D coord, double[] dest) throws CannotEvaluateException {
        Point2D pixel = this.gridGeometry.inverseTransform(coord);
        double fx = pixel.getX();
        double fy = pixel.getY();
        if (!Double.isNaN(fx) && !Double.isNaN(fy)) {
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (this.image.getBounds().contains(x, y)) {
                return this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y)).getPixel(x, y, dest);
            }
        }
        throw new PointOutsideCoverageException(this.pointOutsideCoverage(coord));
    }

    public synchronized String getDebugString(DirectPosition coord) {
        Point2D pixel = this.toPoint2D(coord);
        pixel = this.gridGeometry.inverseTransform(pixel);
        int x = (int)Math.round(pixel.getX());
        int y = (int)Math.round(pixel.getY());
        if (this.image.getBounds().contains(x, y)) {
            int numBands = this.image.getNumBands();
            Raster raster = this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y));
            int datatype = this.image.getSampleModel().getDataType();
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            buffer.append(x);
            buffer.append(',');
            buffer.append(y);
            buffer.append(")=[");
            for (int band = 0; band < numBands; ++band) {
                if (band != 0) {
                    buffer.append(";\u00a0");
                }
                double sample = raster.getSampleDouble(x, y, band);
                switch (datatype) {
                    case 5: {
                        buffer.append(sample);
                        break;
                    }
                    case 4: {
                        buffer.append((float)sample);
                        break;
                    }
                    default: {
                        buffer.append((int)sample);
                    }
                }
                String formatted = this.sampleDimensions[band].getLabel(sample, null);
                if (formatted == null) continue;
                buffer.append("\u00a0(");
                buffer.append(formatted);
                buffer.append(')');
            }
            buffer.append(']');
            return buffer.toString();
        }
        return null;
    }

    public int[] getOptimalDataBlockSizes() {
        int[] size = new int[this.getDimension()];
        Arrays.fill(size, 1);
        size[this.gridGeometry.gridDimensionX] = this.image.getTileWidth();
        size[this.gridGeometry.gridDimensionY] = this.image.getTileHeight();
        return size;
    }

    public RenderedImage getRenderedImage() {
        return this.image;
    }

    public RenderableImage getRenderableImage(int xAxis, int yAxis) {
        if (xAxis == this.gridGeometry.axisDimensionX && yAxis == this.gridGeometry.axisDimensionY) {
            return new Renderable();
        }
        return super.getRenderableImage(xAxis, yAxis);
    }

    public void show(String title, int xAxis, int yAxis) {
        GridCoverage2D displayable = this.geophysics(false);
        if (displayable != this) {
            displayable.show(title, xAxis, yAxis);
            return;
        }
        if (title == null || (title = title.trim()).length() == 0) {
            StringBuffer buffer = new StringBuffer(String.valueOf(this.getName()));
            int visibleBandIndex = CoverageUtilities.getVisibleBand(this);
            SampleDimension visibleBand = this.getSampleDimension(visibleBandIndex);
            Unit unit = visibleBand.getUnits();
            buffer.append(" - ").append(String.valueOf(visibleBand.getDescription()));
            if (unit != null) {
                buffer.append(" (").append(unit).append(')');
            }
            title = buffer.toString();
        }
        super.show(title, xAxis, yAxis);
    }

    public void show(String title) {
        this.show(title, this.gridGeometry.axisDimensionX, this.gridGeometry.axisDimensionY);
    }

    public void prefetch(Rectangle2D area) {
        Point[] tileIndices = this.image.getTileIndices(this.gridGeometry.inverseTransform(area));
        if (tileIndices != null) {
            this.image.prefetchTiles(tileIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage2D geophysics(boolean geo) {
        if (geo == this.isGeophysics) {
            return this;
        }
        if (this.inverse != null) {
            return this.inverse;
        }
        if (!CoverageUtilities.hasTransform(this.sampleDimensions)) {
            this.inverse = this;
            return this.inverse;
        }
        GridCoverage2D gridCoverage2D = this;
        synchronized (gridCoverage2D) {
            this.inverse = this.createGeophysics(geo);
            if (this.inverse.inverse == null) {
                this.inverse.inverse = this;
            } else if (this.inverse.inverse != this) {
                Locale locale = this.getLocale();
                throw new RasterFormatException(Errors.getResources(locale).getString(28, "geophysics", this.inverse.inverse.getName().toString(locale)));
            }
            return this.inverse;
        }
    }

    protected GridCoverage2D createGeophysics(boolean geo) {
        NullOpImage op;
        PlanarImage image = this.image;
        while (image instanceof NullOpImage && (op = (NullOpImage)image).getNumSources() == 1) {
            image = op.getSourceImage(0);
        }
        int numBands = image.getNumBands();
        int visibleBand = CoverageUtilities.getVisibleBand(image);
        GridSampleDimension[] targetBands = (GridSampleDimension[])this.sampleDimensions.clone();
        int length = targetBands.length;
        if (!$assertionsDisabled && length != numBands) {
            throw new AssertionError(length);
        }
        for (int i = 0; i < length; ++i) {
            targetBands[i] = targetBands[i].geophysics(geo);
        }
        ImageLayout layout = ImageUtilities.getImageLayout((RenderedImage)image);
        ColorModel colors = targetBands[visibleBand].getColorModel(visibleBand, numBands);
        SampleModel model = colors.createCompatibleSampleModel(layout.getTileWidth((RenderedImage)image), layout.getTileHeight((RenderedImage)image));
        if (colors instanceof IndexColorModel && model.getClass().equals(ComponentSampleModel.class)) {
            int w = model.getWidth();
            int h = model.getHeight();
            model = new PixelInterleavedSampleModel(colors.getTransferType(), w, h, 1, w, new int[1]);
        }
        layout = layout.setSampleModel(model).setColorModel(colors);
        ParameterBlock param = new ParameterBlock().addSource(image);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        hints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        String operation = null;
        try {
            int sourceType = image.getSampleModel().getDataType();
            int targetType = model.getDataType();
            MathTransform1D[] transforms = new MathTransform1D[numBands];
            for (int i = 0; i < numBands; ++i) {
                transforms[i] = this.sampleDimensions[i].geophysics(false).getSampleToGeophysics();
                if (transforms[i] == null || geo) continue;
                transforms[i] = (MathTransform1D)transforms[i].inverse();
            }
            LookupTableJAI table = LookupTableFactory.create(sourceType, targetType, transforms);
            if (table != null) {
                operation = "Lookup";
                param = param.add(table);
            }
        }
        catch (TransformException exception) {
            // empty catch block
        }
        if (operation == null) {
            try {
                boolean canRescale = true;
                boolean canPiecewise = true;
                double[] scales = null;
                double[] offsets = null;
                Object breakpoints = null;
                block7: for (int i = 0; i < numBands; ++i) {
                    GridSampleDimension sd = this.sampleDimensions[i];
                    List categories = sd.getCategories();
                    int numCategories = categories.size();
                    float[] sourceBreakpoints = null;
                    float[] targetBreakpoints = null;
                    double expectedSource = Double.NaN;
                    double expectedTarget = Double.NaN;
                    int jbp = 0;
                    for (int j = 0; j < numCategories; ++j) {
                        Category category = (Category)categories.get(j);
                        MathTransform1D transform = category.geophysics(false).getSampleToGeophysics();
                        if (transform == null) {
                            canPiecewise = false;
                            canRescale = false;
                            break block7;
                        }
                        if (!geo) {
                            transform = (MathTransform1D)transform.inverse();
                        }
                        double offset = transform.transform(0.0);
                        double scale = transform.derivative(Double.NaN);
                        if (Double.isNaN(scale) || Double.isNaN(offset)) {
                            canRescale = false;
                            canPiecewise = false;
                            break block7;
                        }
                        if (j == 0) {
                            if (i == 0) {
                                scales = new double[numBands];
                                offsets = new double[numBands];
                                breakpoints = new float[numBands][][];
                            }
                            sourceBreakpoints = new float[numCategories * 2];
                            targetBreakpoints = new float[numCategories * 2];
                            breakpoints[i] = new float[][]{sourceBreakpoints, targetBreakpoints};
                            offsets[i] = offset;
                            scales[i] = scale;
                        }
                        if (offset != offsets[i] || scale != scales[i]) {
                            canRescale = false;
                        }
                        NumberRange range = category.getRange();
                        double minimum = range.getMinimum(true);
                        double maximum = range.getMaximum(true);
                        float sourceMin = (float)minimum;
                        float sourceMax = (float)maximum;
                        float targetMin = (float)(minimum * scale + offset);
                        float targetMax = (float)(maximum * scale + offset);
                        if (!$assertionsDisabled && !(sourceMin <= sourceMax)) {
                            throw new AssertionError((Object)range);
                        }
                        if (Math.abs(minimum - expectedSource) <= (double)1.0E-5f) {
                            if (Math.abs((double)targetMin - expectedTarget) <= (double)1.0E-5f) {
                                --jbp;
                            } else {
                                if (!$assertionsDisabled && !(sourceBreakpoints[jbp - 1] < sourceMin)) {
                                    throw new AssertionError(expectedSource);
                                }
                                canPiecewise = false;
                            }
                        } else if (j != 0) {
                            if (!$assertionsDisabled && expectedSource > (double)sourceMin) {
                                throw new AssertionError(expectedSource);
                            }
                            canPiecewise = false;
                        }
                        sourceBreakpoints[jbp] = sourceMin;
                        sourceBreakpoints[jbp + 1] = sourceMax;
                        targetBreakpoints[jbp] = targetMin;
                        targetBreakpoints[jbp + 1] = targetMax;
                        jbp += 2;
                        expectedSource = range.getMaximum(false);
                        expectedTarget = expectedSource * scale + offset;
                    }
                    canPiecewise = false;
                }
                if (canRescale && scales != null) {
                    operation = "Rescale";
                    param = param.add(scales).add(offsets);
                } else if (canPiecewise && breakpoints != null) {
                    operation = "Piecewise";
                    param = param.add(breakpoints);
                }
            }
            catch (TransformException exception) {
                // empty catch block
            }
        }
        if (operation == null) {
            param = param.add(this.sampleDimensions);
            operation = "org.geotools.SampleTranscode";
        }
        if (LOGGER.isLoggable(AbstractProcessor.OPERATION)) {
            int index = operation.lastIndexOf(46);
            String shortName = index >= 0 ? operation.substring(index + 1) : operation;
            Locale locale = this.getLocale();
            LogRecord record = Logging.getResources(locale).getLogRecord(AbstractProcessor.OPERATION, 16, new Object[]{this.getName().toString(locale), new Integer(geo ? 1 : 0), shortName});
            record.setSourceClassName("GridCoverage");
            record.setSourceMethodName("geophysics");
            LOGGER.log(record);
        }
        RenderedOp view = JAI.create((String)operation, (ParameterBlock)param, (RenderingHints)hints);
        GridCoverage[] sources = new GridCoverage[]{this};
        return new GridCoverage2D((CharSequence)this.getName(), (PlanarImage)view, this.gridGeometry, targetBands, sources, null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Field field = GridCoverage2D.class.getDeclaredField("image");
            field.setAccessible(true);
            field.set(this, PlanarImage.wrapRenderedImage((RenderedImage)this.serializedImage));
        }
        catch (NoSuchFieldException cause) {
            InvalidClassException e = new InvalidClassException(cause.getLocalizedMessage());
            e.initCause(cause);
            throw e;
        }
        catch (IllegalAccessException cause) {
            InvalidObjectException e = new InvalidObjectException(cause.getLocalizedMessage());
            e.initCause(cause);
            throw e;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.serializedImage == null) {
            Object source = this.image;
            while (source instanceof RenderedImageAdapter) {
                source = ((RenderedImageAdapter)source).getWrappedImage();
            }
            if (source instanceof SerializableRenderedImage) {
                this.serializedImage = (SerializableRenderedImage)source;
            } else {
                if (this.tileEncoding == null) {
                    this.tileEncoding = "gzip";
                }
                this.serializedImage = new SerializableRenderedImage((RenderedImage)source, false, null, this.tileEncoding, null, null);
                LogRecord record = Logging.format(Level.FINE, 35, this.getName(), this.tileEncoding);
                record.setSourceClassName("GridCoverage2D");
                record.setSourceMethodName("writeObject");
                LOGGER.log(record);
            }
        }
        out.defaultWriteObject();
    }

    static {
        $assertionsDisabled = !GridCoverage2D.class.desiredAssertionStatus();
    }

    protected class Renderable
    extends AbstractCoverage.Renderable {
        public Renderable() {
            super(GridCoverage2D.this, GridCoverage2D.this.gridGeometry.axisDimensionX, GridCoverage2D.this.gridGeometry.axisDimensionY);
        }

        public RenderedImage createDefaultRendering() {
            if (this.xAxis == GridCoverage2D.this.gridGeometry.axisDimensionX && this.yAxis == GridCoverage2D.this.gridGeometry.axisDimensionY) {
                return GridCoverage2D.this.getRenderedImage();
            }
            return super.createDefaultRendering();
        }
    }
}

