/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.grid.GridRange;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class GridGeometry2D
extends GeneralGridGeometry {
    private static final long serialVersionUID = -3989363771504614419L;
    private static FactoryGroup FACTORY_GROUP;
    private static Map ORIENTATIONS;
    private final CoordinateReferenceSystem crs2D;
    public final int gridDimensionX;
    public final int gridDimensionY;
    public final int axisDimensionX;
    public final int axisDimensionY;
    private final MathTransform2D gridToCRS2D;
    private final MathTransform2D gridFromCRS2D;
    static final /* synthetic */ boolean $assertionsDisabled;

    GridGeometry2D(GridGeometry2D gm, CoordinateReferenceSystem crs) {
        super(gm, crs);
        this.gridDimensionX = gm.gridDimensionX;
        this.gridDimensionY = gm.gridDimensionY;
        this.axisDimensionX = gm.axisDimensionX;
        this.axisDimensionY = gm.axisDimensionY;
        this.gridFromCRS2D = gm.gridFromCRS2D;
        this.gridToCRS2D = gm.gridToCRS2D;
        this.crs2D = this.createCRS2D();
    }

    public GridGeometry2D(GridRange gridRange, MathTransform gridToCRS, CoordinateReferenceSystem crs) throws IllegalArgumentException, MismatchedDimensionException {
        super(gridRange, gridToCRS, crs);
        int[] dimensions = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(gridToCRS, gridRange, dimensions);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
        this.crs2D = this.createCRS2D();
    }

    public GridGeometry2D(GridRange gridRange, Envelope userRange) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridRange, userRange, null, false, true);
    }

    public GridGeometry2D(GridRange gridRange, Envelope userRange, boolean[] reverse, boolean swapXY) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridRange, userRange, reverse, swapXY, false);
    }

    private GridGeometry2D(GridRange gridRange, Envelope userRange, boolean[] reverse, boolean swapXY, boolean automatic) throws IllegalArgumentException, MismatchedDimensionException {
        super(gridRange, userRange, reverse, swapXY, automatic);
        int[] dimensions = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, gridRange, dimensions);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
        this.crs2D = this.createCRS2D();
    }

    public GridGeometry2D(Rectangle gridRange, Rectangle2D userRange) {
        this(new GeneralGridRange(gridRange), GridGeometry2D.getMathTransform(gridRange, userRange), null);
    }

    private static MathTransform getMathTransform(Rectangle gridRange, Rectangle2D userRange) {
        double scaleX = userRange.getWidth() / gridRange.getWidth();
        double scaleY = userRange.getHeight() / gridRange.getHeight();
        double transX = userRange.getMinX() - (double)gridRange.x * scaleX;
        double transY = userRange.getMaxY() + (double)gridRange.y * scaleY;
        AffineTransform tr = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, transX, transY);
        tr.translate(0.5, 0.5);
        return ProjectiveTransform.create(tr);
    }

    private static MathTransform2D getMathTransform2D(MathTransform transform, GridRange gridRange, int[] axis) throws IllegalArgumentException {
        axis[3] = 1;
        axis[1] = 1;
        if (transform == null || transform instanceof MathTransform2D) {
            return (MathTransform2D)transform;
        }
        DimensionFilter filter = new DimensionFilter();
        if (gridRange != null) {
            int dimension = gridRange.getDimension();
            for (int i = 0; i < dimension; ++i) {
                if (gridRange.getLength(i) <= 1) continue;
                filter.addSourceDimension(i);
            }
        } else {
            filter.addSourceDimensionRange(0, 2);
        }
        Throwable cause = null;
        int[] dimensions = filter.getSourceDimensions();
        if (dimensions.length == 2) {
            System.arraycopy(dimensions, 0, axis, 0, 2);
            try {
                MathTransform candidate = filter.separate(transform);
                if (candidate.getTargetDimensions() != 2) {
                    filter.clear();
                    filter.addSourceDimensions(dimensions);
                    filter.addTargetDimensions(dimensions);
                    candidate = filter.separate(transform);
                }
                dimensions = filter.getTargetDimensions();
                System.arraycopy(dimensions, 0, axis, 2, 2);
                try {
                    return (MathTransform2D)candidate;
                }
                catch (ClassCastException exception) {
                    cause = exception;
                }
            }
            catch (FactoryException exception) {
                cause = exception;
            }
        }
        IllegalArgumentException e = new IllegalArgumentException(Errors.format(101));
        e.initCause(cause);
        throw e;
    }

    private static MathTransform2D inverse(MathTransform2D gridToCRS2D) throws IllegalArgumentException {
        if (gridToCRS2D == null) {
            return null;
        }
        try {
            return (MathTransform2D)gridToCRS2D.inverse();
        }
        catch (NoninvertibleTransformException exception) {
            IllegalArgumentException e = new IllegalArgumentException(Errors.format(15, Utilities.getShortClassName(gridToCRS2D)));
            e.initCause(exception);
            throw e;
        }
    }

    private CoordinateReferenceSystem createCRS2D() {
        CoordinateReferenceSystem crs2D;
        if (!super.isDefined(1)) {
            return null;
        }
        CoordinateReferenceSystem crs = super.getCoordinateReferenceSystem();
        if (FACTORY_GROUP == null) {
            FACTORY_GROUP = FactoryGroup.createInstance(null);
        }
        try {
            crs2D = FACTORY_GROUP.separate(crs, new int[]{this.axisDimensionX, this.axisDimensionY});
        }
        catch (FactoryException exception) {
            InvalidGridGeometryException e = new InvalidGridGeometryException(Errors.format(42, "crs", crs.getName()));
            e.initCause(exception);
            throw e;
        }
        if (!$assertionsDisabled && crs2D.getCoordinateSystem().getDimension() != 2) {
            throw new AssertionError(crs2D);
        }
        return crs2D;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem2D() throws InvalidGridGeometryException {
        if (this.crs2D != null) {
            if (!$assertionsDisabled && !this.isDefined(1)) {
                throw new AssertionError();
            }
            return this.crs2D;
        }
        if (!$assertionsDisabled && this.isDefined(1)) {
            throw new AssertionError();
        }
        throw new InvalidGridGeometryException(Errors.format(140));
    }

    public Envelope2D getEnvelope2D() throws InvalidGridGeometryException {
        if (this.envelope != null && !this.envelope.isNull()) {
            if (!$assertionsDisabled && !this.isDefined(2)) {
                throw new AssertionError();
            }
            return new Envelope2D(this.crs2D, this.envelope.getMinimum(this.axisDimensionX), this.envelope.getMinimum(this.axisDimensionY), this.envelope.getLength(this.axisDimensionX), this.envelope.getLength(this.axisDimensionY));
        }
        if (!$assertionsDisabled && this.isDefined(2)) {
            throw new AssertionError();
        }
        throw new InvalidGridGeometryException(Errors.format(this.gridToCRS == null ? 178 : 141));
    }

    public Rectangle getGridRange2D() throws InvalidGridGeometryException {
        if (this.gridRange != null) {
            if (!$assertionsDisabled && !this.isDefined(4)) {
                throw new AssertionError();
            }
            return new Rectangle(this.gridRange.getLower(this.gridDimensionX), this.gridRange.getLower(this.gridDimensionY), this.gridRange.getLength(this.gridDimensionX), this.gridRange.getLength(this.gridDimensionY));
        }
        if (!$assertionsDisabled && this.isDefined(4)) {
            throw new AssertionError();
        }
        throw new InvalidGridGeometryException(Errors.format(141));
    }

    public MathTransform2D getGridToCoordinateSystem2D() throws InvalidGridGeometryException {
        return this.getGridToCRS2D();
    }

    public MathTransform2D getGridToCRS2D() throws InvalidGridGeometryException {
        if (this.gridToCRS2D != null) {
            return this.gridToCRS2D;
        }
        throw new InvalidGridGeometryException(Errors.format(101));
    }

    public MathTransform2D getGridToCRS2D(PixelOrientation orientation) {
        int xdim = this.gridDimensionX < this.gridDimensionY ? 0 : 1;
        return (MathTransform2D)GridGeometry2D.translate((MathTransform)this.getGridToCRS2D(), orientation, xdim, xdim ^ 1);
    }

    public MathTransform getGridToCRS(PixelOrientation orientation) {
        return GridGeometry2D.translate(this.getGridToCRS(), orientation, this.gridDimensionX, this.gridDimensionY);
    }

    private static MathTransform translate(MathTransform gridToCRS, PixelOrientation orientation, int gridDimensionX, int gridDimensionY) {
        if (PixelOrientation.CENTER.equals(orientation)) {
            return gridToCRS;
        }
        Point2D.Double offset = (Point2D.Double)ORIENTATIONS.get(orientation);
        if (offset == null) {
            throw new IllegalArgumentException(Errors.format(42, "orientation", orientation));
        }
        int dimension = gridToCRS.getSourceDimensions();
        XMatrix matrix = MatrixFactory.create(dimension + 1);
        matrix.setElement(gridDimensionX, dimension, offset.x);
        matrix.setElement(gridDimensionY, dimension, offset.y);
        return ConcatenatedTransform.create(ProjectiveTransform.create(matrix), gridToCRS);
    }

    final Point2D inverseTransform(Point2D point) throws InvalidGridGeometryException {
        if (this.gridFromCRS2D != null) {
            try {
                return this.gridFromCRS2D.transform(point, null);
            }
            catch (TransformException exception) {
                throw new CannotEvaluateException(Errors.format(23, AbstractGridCoverage.toString(point, Locale.getDefault()), (Object)exception));
            }
        }
        throw new InvalidGridGeometryException(Errors.format(101));
    }

    final Rectangle inverseTransform(Rectangle2D bounds) {
        if (bounds != null && this.gridFromCRS2D != null) {
            try {
                bounds = CRSUtilities.transform(this.gridFromCRS2D, bounds, null);
                int xmin = (int)Math.floor(bounds.getMinX() - 0.5);
                int ymin = (int)Math.floor(bounds.getMinY() - 0.5);
                int xmax = (int)Math.ceil(bounds.getMaxX() - 0.5);
                int ymax = (int)Math.ceil(bounds.getMaxY() - 0.5);
                return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            GridGeometry2D that = (GridGeometry2D)object;
            return this.gridDimensionX == that.gridDimensionX && this.gridDimensionY == that.gridDimensionY && this.axisDimensionX == that.axisDimensionX && this.axisDimensionY == that.axisDimensionY;
        }
        return false;
    }

    static {
        $assertionsDisabled = !GridGeometry2D.class.desiredAssertionStatus();
        ORIENTATIONS = new HashMap(8);
        ORIENTATIONS.put(PixelOrientation.CENTER, new Point2D.Double(0.0, 0.0));
        ORIENTATIONS.put(PixelOrientation.UPPER_LEFT, new Point2D.Double(-0.5, -0.5));
        ORIENTATIONS.put(PixelOrientation.UPPER_RIGHT, new Point2D.Double(0.5, -0.5));
        ORIENTATIONS.put(PixelOrientation.LOWER_LEFT, new Point2D.Double(-0.5, 0.5));
        ORIENTATIONS.put(PixelOrientation.LOWER_RIGHT, new Point2D.Double(0.5, 0.5));
    }
}

