/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.io.LineWriter;
import org.geotools.io.TableWriter;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridRange;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.Envelope;

public abstract class AbstractGridCoverageReader {
    static Logger LOGGER;
    static final int MIN_TILE_SIZE = 524288;
    public final String formatName;
    protected ImageReader reader;
    private Object input;
    private ImageInputStream stream;
    private Locale locale;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$javax$imageio$stream$ImageInputStream;

    public AbstractGridCoverageReader(String formatName) {
        this.formatName = formatName;
    }

    public synchronized void reset() throws IOException {
        this.clear();
        this.locale = null;
        if (this.reader != null) {
            this.reader.reset();
            this.reader.dispose();
            this.reader = null;
        }
    }

    private void clear() throws IOException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.input = null;
        if (this.reader != null) {
            this.reader.setInput(null);
        }
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    public synchronized void setInput(Object input, boolean seekForwardOnly) throws IOException {
        this.clear();
        if (input != null) {
            ImageReader reader = this.reader;
            boolean reuseLast = reader != null;
            Iterator it = this.getImageReaders(input);
            while (it.hasNext()) {
                if (!reuseLast) {
                    reader = (ImageReader)it.next();
                    this.setReaderLocale(this.locale);
                }
                reuseLast = false;
                Class[] types = reader.getOriginatingProvider().getInputTypes();
                if (AbstractGridCoverageReader.contains(types, input.getClass())) {
                    reader.setInput(input, seekForwardOnly);
                    this.input = input;
                    this.reader = reader;
                    return;
                }
                if (!AbstractGridCoverageReader.contains(types, class$javax$imageio$stream$ImageInputStream == null ? AbstractGridCoverageReader.class$("javax.imageio.stream.ImageInputStream") : class$javax$imageio$stream$ImageInputStream)) continue;
                if (!$assertionsDisabled && this.stream != null) {
                    throw new AssertionError();
                }
                this.stream = ImageIO.createImageInputStream(input);
                if (this.stream == null) continue;
                reader.setInput(this.stream, seekForwardOnly);
                this.input = input;
                this.reader = reader;
                return;
            }
            throw new IllegalArgumentException(this.getString(98));
        }
    }

    private static boolean contains(Class[] types, Class type) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException(this.getString(97));
        }
        return this.reader.getNumImages(allowSearch);
    }

    final void checkImageIndex(int imageIndex) throws IOException, IndexOutOfBoundsException {
        if (this.reader == null) {
            throw new IllegalStateException(this.getString(97));
        }
        int numImages = this.getNumImages(false);
        if (imageIndex < this.reader.getMinIndex() || imageIndex >= numImages && numImages >= 0) {
            throw new IndexOutOfBoundsException(String.valueOf(imageIndex));
        }
    }

    public String getName(int index) throws IOException {
        this.checkImageIndex(index);
        if (this.input instanceof File) {
            return ((File)this.input).getName();
        }
        if (this.input instanceof URL) {
            return new File(((URL)this.input).getPath()).getName();
        }
        return Vocabulary.getResources(this.locale).getString(178);
    }

    public abstract CoordinateReferenceSystem getCoordinateReferenceSystem(int var1) throws IOException;

    public abstract Envelope getEnvelope(int var1) throws IOException;

    public synchronized GridRange getGridRange(int index) throws IOException {
        this.checkImageIndex(index);
        int dimension = this.getCoordinateReferenceSystem(index).getCoordinateSystem().getDimension();
        int[] lower = new int[dimension];
        int[] upper = new int[dimension];
        Arrays.fill(upper, 1);
        upper[0] = this.reader.getWidth(index);
        upper[1] = this.reader.getHeight(index);
        return new GeneralGridRange(lower, upper);
    }

    public synchronized SampleDimension[] getSampleDimensions(int index) throws IOException {
        this.checkImageIndex(index);
        return null;
    }

    public synchronized GridCoverage getGridCoverage(int index) throws IOException {
        int i;
        this.checkImageIndex(index);
        ImageReadParam param = this.reader.getDefaultReadParam();
        String name = this.getName(index);
        Envelope envelope = this.getEnvelope(index);
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem(index);
        SampleDimension[] sd = this.getSampleDimensions(index);
        RenderedImage image = this.reader.readAsRenderedImage(index, param);
        if (LOGGER.isLoggable(Level.FINE)) {
            StringWriter buffer = new StringWriter();
            LineWriter trimer = new LineWriter(buffer);
            TableWriter table = new TableWriter((Writer)trimer, 1);
            PrintWriter out = new PrintWriter(table);
            buffer.write("Creating GridCoverage[\"");
            buffer.write(name);
            buffer.write("\"] with:");
            buffer.write(trimer.getLineSeparator());
            table.setMultiLinesCells(true);
            int sdCount = sd != null ? sd.length : 0;
            for (i = -3; i < sdCount; ++i) {
                RenderedImage value;
                String key = "";
                switch (i) {
                    case -3: {
                        key = "RenderedImage";
                        value = image;
                        break;
                    }
                    case -2: {
                        key = "CoordinateReferenceSystem";
                        value = crs;
                        break;
                    }
                    case -1: {
                        key = "Envelope";
                        value = envelope;
                        break;
                    }
                    case 0: {
                        key = "SampleDimensions";
                    }
                    default: {
                        value = sd[i];
                    }
                }
                out.print("    ");
                out.print(key);
                table.nextColumn();
                out.print('=');
                table.nextColumn();
                out.print(value);
                table.nextLine();
            }
            out.flush();
            LOGGER.fine(buffer.toString());
        }
        ImageLayout layout = new ImageLayout(image);
        int tileHeight = layout.getTileHeight(image);
        int tileWidth = layout.getTileWidth(image);
        int[] sizes = image.getSampleModel().getSampleSize();
        int totalSize = 0;
        for (i = 0; i < sizes.length; ++i) {
            totalSize += sizes[i];
        }
        if (tileHeight * tileWidth * totalSize < 524288) {
            int tileMult = 524288 / (totalSize * tileWidth * tileHeight);
            layout.setTileHeight(tileHeight * tileMult);
        }
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        ParameterBlockJAI pbj = new ParameterBlockJAI("Format");
        pbj.addSource((Object)image);
        pbj.setParameter("dataType", image.getSampleModel().getDataType());
        RenderedOp pi = JAI.create((String)"Format", (ParameterBlock)pbj, (RenderingHints)hints);
        throw new UnsupportedOperationException("Port from legacy code not yet finished");
    }

    protected Iterator getImageReaders(Object input) {
        return ImageIO.getImageReadersByFormatName(this.formatName);
    }

    final String getString(int key) {
        return Errors.getResources(this.locale).getString(key);
    }

    public synchronized void setLocale(Locale locale) {
        this.locale = locale;
        this.setReaderLocale(locale);
    }

    private void setReaderLocale(Locale locale) {
        if (this.reader != null) {
            Locale[] list = this.reader.getAvailableLocales();
            int i = list.length;
            while (--i >= 0) {
                if (!locale.equals(list[i])) continue;
                this.reader.setLocale(locale);
                return;
            }
            String language = AbstractGridCoverageReader.getISO3Language(locale);
            if (language != null) {
                int i2 = list.length;
                while (--i2 >= 0) {
                    if (!language.equals(AbstractGridCoverageReader.getISO3Language(list[i2]))) continue;
                    this.reader.setLocale(list[i2]);
                    return;
                }
            }
            this.reader.setLocale(null);
        }
    }

    private static String getISO3Language(Locale locale) {
        try {
            return locale.getISO3Language();
        }
        catch (MissingResourceException exception) {
            return null;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    static {
        $assertionsDisabled = !AbstractGridCoverageReader.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger("org.geotools.coverage.io");
    }
}

