/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.geotools.coverage.io.AbstractGridCoverageReader;
import org.geotools.coverage.io.MetadataBuilder;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridRange;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.Envelope;

public class ExoreferencedGridCoverageReader
extends AbstractGridCoverageReader {
    protected MetadataBuilder metadata;
    private final String extension;

    public ExoreferencedGridCoverageReader(String formatName, MetadataBuilder parser) {
        this(formatName, formatName, parser);
    }

    public ExoreferencedGridCoverageReader(String formatName, String extension, MetadataBuilder parser) {
        super(formatName);
        this.metadata = parser;
        if (parser == null) {
            throw new IllegalArgumentException();
        }
        this.extension = extension;
    }

    public synchronized void reset() throws IOException {
        this.metadata.clear();
        super.reset();
    }

    public synchronized void setInput(Object input, boolean seekForwardOnly) throws IOException {
        if (!(input instanceof File)) {
            if (input instanceof URL) {
                URL url = (URL)input;
                this.metadata.clear();
                this.metadata.load(url);
                throw new UnsupportedOperationException("URL support not yet implemented");
            }
            throw new IllegalArgumentException(this.getString(98));
        }
        File file = (File)input;
        this.metadata.clear();
        this.metadata.load(file);
        input = new File(file.getParent(), this.toImageFileName(file.getName()));
        super.setInput(input, seekForwardOnly);
    }

    protected String toImageFileName(String filename) {
        int ext = filename.lastIndexOf(46);
        if (ext < 0) {
            ext = filename.length();
        }
        return filename.substring(0, ext) + '.' + this.extension;
    }

    public synchronized CoordinateReferenceSystem getCoordinateReferenceSystem(int index) throws IOException {
        this.checkImageIndex(index);
        return this.metadata.getCoordinateReferenceSystem();
    }

    public synchronized Envelope getEnvelope(int index) throws IOException {
        this.checkImageIndex(index);
        return this.metadata.getEnvelope();
    }

    public synchronized GridRange getGridRange(int index) throws IOException {
        this.checkImageIndex(index);
        return this.metadata.getGridRange();
    }

    public synchronized SampleDimension[] getSampleDimensions(int index) throws IOException {
        this.checkImageIndex(index);
        return this.metadata.getSampleDimensions();
    }

    public synchronized void setLocale(Locale locale) {
        super.setLocale(locale);
        this.metadata.setUserLocale(locale);
    }
}

