/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.IIOException;
import javax.media.jai.DeferredData;
import javax.media.jai.DeferredProperty;
import javax.media.jai.PropertySource;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.io.AbstractGridCoverageReader;
import org.geotools.coverage.io.AmbiguousMetadataException;
import org.geotools.coverage.io.MetadataException;
import org.geotools.coverage.io.MissingMetadataException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.io.TableWriter;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.crs.DefaultTemporalCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridRange;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.util.Cloneable;

public class MetadataBuilder {
    private static final String[] METRES;
    private static final String[] DEGREES;
    private static final double EPS = 1.0E-6;
    public static final Key COORDINATE_REFERENCE_SYSTEM;
    public static final Key UNITS;
    public static final Key DATUM;
    public static final Key ELLIPSOID;
    public static final Key OPERATION_METHOD;
    public static final Key PROJECTION;
    public static final Key SEMI_MAJOR;
    public static final Key SEMI_MINOR;
    public static final Key LATITUDE_OF_ORIGIN;
    public static final Key CENTRAL_MERIDIAN;
    public static final Key FALSE_EASTING;
    public static final Key FALSE_NORTHING;
    public static final Key X_MINIMUM;
    public static final Key Y_MINIMUM;
    public static final Key Z_MINIMUM;
    public static final Key X_MAXIMUM;
    public static final Key Y_MAXIMUM;
    public static final Key Z_MAXIMUM;
    public static final Key X_RESOLUTION;
    public static final Key Y_RESOLUTION;
    public static final Key Z_RESOLUTION;
    public static final Key WIDTH;
    public static final Key HEIGHT;
    public static final Key DEPTH;
    private String source;
    private String separator = " = ";
    private String trimSeparator = "=";
    private String numberPattern;
    private String datePattern;
    private Map metadata;
    private Map naming;
    private transient String lastAlias;
    private transient Map cache;
    private final FactoryGroup factories;
    private Locale userLocale;
    private static boolean emittedWarning;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MetadataBuilder() {
        this(FactoryGroup.createInstance(null));
    }

    public MetadataBuilder(FactoryGroup factories) {
        this.factories = factories;
    }

    public String getSeparator() {
        return this.separator;
    }

    public synchronized void setSeparator(String separator) {
        this.trimSeparator = separator.trim();
        this.separator = separator;
    }

    public String getFormatPattern(Class type) {
        if (Date.class.isAssignableFrom(type)) {
            return this.datePattern;
        }
        if (Number.class.isAssignableFrom(type)) {
            return this.numberPattern;
        }
        throw new IllegalArgumentException(Utilities.getShortName(type));
    }

    public synchronized void setFormatPattern(Class type, String pattern) {
        if (Date.class.isAssignableFrom(type)) {
            this.datePattern = pattern;
            this.cache = null;
            return;
        }
        if (Number.class.isAssignableFrom(type)) {
            this.numberPattern = pattern;
            this.cache = null;
            return;
        }
        throw new IllegalArgumentException(Utilities.getShortName(type));
    }

    public synchronized void clear() {
        this.source = null;
        this.metadata = null;
        this.cache = null;
    }

    public synchronized void load(File header) throws IOException {
        this.source = header.getPath();
        BufferedReader in = new BufferedReader(new FileReader(header));
        this.load(in);
        in.close();
    }

    public synchronized void load(URL header) throws IOException {
        this.source = header.getPath();
        BufferedReader in = new BufferedReader(new InputStreamReader(header.openStream()));
        this.load(in);
        in.close();
    }

    protected void load(BufferedReader in) throws IOException {
        String line;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        HashSet<String> previousComments = new HashSet<String>();
        StringBuffer comments = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator", "\n");
        while ((line = in.readLine()) != null) {
            if (line.trim().length() == 0 || this.parseLine(line) || !previousComments.add(line)) continue;
            comments.append(line);
            comments.append(lineSeparator);
        }
        if (comments.length() != 0) {
            this.add((String)null, (Object)comments.toString());
        }
    }

    protected boolean parseLine(String line) throws IIOException {
        int index = line.indexOf(this.trimSeparator);
        if (index >= 0) {
            this.add(line.substring(0, index), (Object)line.substring(index + 1));
            return true;
        }
        return false;
    }

    public synchronized void add(GridCoverage coverage) throws AmbiguousMetadataException {
        if (this.naming == null) {
            return;
        }
        Iterator it = this.naming.entrySet().iterator();
        while (it.hasNext()) {
            Set alias;
            Map.Entry entry = it.next();
            Key key = (Key)entry.getKey();
            if (key instanceof AliasKey || (alias = (Set)entry.getValue()) == null || alias.isEmpty()) continue;
            AliasKey keyAsAlias = (AliasKey)alias.iterator().next();
            this.add(keyAsAlias, key.getValue(coverage));
        }
    }

    public synchronized void add(RenderedImage image) throws AmbiguousMetadataException {
        if (image instanceof PropertySource) {
            this.add((PropertySource)image, null);
        } else {
            String[] names = image.getPropertyNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    this.add(name, image.getProperty(name));
                }
            }
        }
    }

    public synchronized void add(PropertySource properties, String prefix) throws AmbiguousMetadataException {
        String[] names;
        String[] stringArray = names = prefix != null ? properties.getPropertyNames(prefix) : properties.getPropertyNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                Class classe = properties.getPropertyClass(name);
                this.add(name, (Object)new DeferredProperty(properties, name, classe));
            }
        }
    }

    public synchronized void add(String alias, Object value) throws AmbiguousMetadataException {
        AliasKey aliasAsKey;
        if (alias != null) {
            alias = alias.trim();
            aliasAsKey = new AliasKey(alias);
        } else {
            aliasAsKey = null;
        }
        this.add(aliasAsKey, value);
    }

    private void add(AliasKey aliasAsKey, Object value) throws AmbiguousMetadataException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        if (value == null || value == Image.UndefinedProperty) {
            return;
        }
        if (value instanceof CharSequence) {
            String text = MetadataBuilder.trim(value.toString().trim(), " ");
            if (text.length() == 0) {
                return;
            }
            value = text;
        }
        if (this.metadata == null) {
            this.metadata = new LinkedHashMap();
        }
        Object oldValue = this.getMetadata(aliasAsKey);
        Key checkKey = null;
        Iterator iterator = null;
        while (true) {
            if (oldValue != null && !oldValue.equals(value)) {
                String alias = aliasAsKey.toString();
                throw new AmbiguousMetadataException(Errors.getResources(this.userLocale).getString(55, alias), checkKey, alias);
            }
            if (iterator == null) {
                Set keySet;
                if (this.naming == null || (keySet = (Set)this.naming.get(aliasAsKey)) == null) break;
                iterator = keySet.iterator();
            }
            if (!iterator.hasNext()) break;
            checkKey = (Key)iterator.next();
            oldValue = this.getOptional(checkKey);
        }
        this.cache = null;
        this.metadata.put(aliasAsKey, value);
    }

    public synchronized void addAlias(Key key, String alias) throws AmbiguousMetadataException {
        Object value;
        AliasKey aliasAsKey = new AliasKey(alias = MetadataBuilder.trim(alias.trim(), " "));
        Object metadata = this.getMetadata(aliasAsKey);
        if (metadata != null && (value = this.getOptional(key)) != null && !value.equals(metadata)) {
            throw new AmbiguousMetadataException(Errors.getResources(this.userLocale).getString(55, alias), key, alias);
        }
        if (this.naming == null) {
            this.naming = new LinkedHashMap();
        }
        this.cache = null;
        Set<Key> set = (LinkedHashSet<AliasKey>)this.naming.get(key);
        if (set == null) {
            set = new LinkedHashSet<AliasKey>(4);
            this.naming.put(key, set);
        }
        set.add(aliasAsKey);
        set = (Set)this.naming.get(aliasAsKey);
        if (set == null) {
            set = new LinkedHashSet(4);
            this.naming.put(aliasAsKey, set);
        }
        set.add(key);
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
    }

    private boolean isValid() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.naming != null) {
            Iterator it = this.naming.values().iterator();
            while (it.hasNext()) {
                if (this.naming.keySet().containsAll((Set)it.next())) continue;
                return false;
            }
        }
        return true;
    }

    private String toString(Object value, Key key, String alias) throws MetadataException {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof IdentifiedObject) {
            return ((IdentifiedObject)value).getName().getCode();
        }
        throw new MetadataException(Errors.getResources(this.userLocale).getString(21, Utilities.getShortClassName(value)), key, alias);
    }

    private Object getMetadata(AliasKey alias) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.metadata != null) {
            Object value = this.metadata.get(alias);
            if (value instanceof DeferredData) {
                value = ((DeferredData)value).getData();
            }
            if (value != null && value != Image.UndefinedProperty) {
                return value;
            }
        }
        return null;
    }

    private Object getOptional(Key key) {
        Set alias;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.lastAlias = null;
        if (this.naming != null && (alias = (Set)this.naming.get(key)) != null) {
            Iterator it = alias.iterator();
            while (it.hasNext()) {
                AliasKey aliasAsKey = (AliasKey)it.next();
                Object value = this.getMetadata(aliasAsKey);
                if (value == null) continue;
                this.lastAlias = aliasAsKey.toString();
                return value;
            }
        }
        return null;
    }

    public synchronized boolean contains(Key key) {
        return this.getOptional(key) != null;
    }

    public synchronized Object get(Key key) throws MissingMetadataException {
        Object value = this.getOptional(key);
        if (value != null && value != Image.UndefinedProperty) {
            return value;
        }
        throw new MissingMetadataException(Errors.getResources(this.userLocale).getString(126, key), key, this.lastAlias);
    }

    private double getAsDouble(Key key, CoordinateReferenceSystem crs) throws MetadataException {
        if (crs instanceof TemporalCRS) {
            return DefaultTemporalCRS.wrap((TemporalCRS)crs).toValue(this.getAsDate(key));
        }
        return this.getAsDouble(key);
    }

    public synchronized double getAsDouble(Key key) throws MetadataException {
        Object value = this.get(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return this.getNumberFormat().parse(this.toString(value, key, this.lastAlias)).doubleValue();
        }
        catch (ParseException exception) {
            throw new MetadataException(exception, key, this.lastAlias);
        }
    }

    public synchronized int getAsInt(Key key) throws MetadataException {
        int integer;
        double value = this.getAsDouble(key);
        if (value != (double)(integer = (int)value)) {
            throw new MetadataException(Errors.getResources(this.userLocale).getString(11, this.lastAlias, new Double(value)), key, this.lastAlias);
        }
        return integer;
    }

    public synchronized Date getAsDate(Key key) throws MetadataException {
        Object value = this.get(key);
        if (value instanceof Date) {
            return (Date)((Date)value).clone();
        }
        try {
            return this.getDateFormat().parse(this.toString(value, key, this.lastAlias));
        }
        catch (ParseException exception) {
            throw new MetadataException(exception, key, this.lastAlias);
        }
    }

    private NumberFormat getNumberFormat() throws MetadataException {
        Object candidate;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String CACHE_KEY = "NumberFormat";
        if (this.cache != null && (candidate = this.cache.get("NumberFormat")) instanceof NumberFormat) {
            return (NumberFormat)candidate;
        }
        NumberFormat format = NumberFormat.getNumberInstance(this.getLocale());
        if (this.numberPattern != null && format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern(this.numberPattern);
        }
        this.cache("NumberFormat", format);
        return format;
    }

    private DateFormat getDateFormat() throws MetadataException {
        Object candidate;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String CACHE_KEY = "DateFormat";
        if (this.cache != null && (candidate = this.cache.get("DateFormat")) instanceof DateFormat) {
            return (DateFormat)candidate;
        }
        DateFormat format = DateFormat.getDateTimeInstance(3, 3, this.getLocale());
        if (this.datePattern != null && format instanceof SimpleDateFormat) {
            ((SimpleDateFormat)format).applyPattern(this.datePattern);
        }
        this.cache("DateFormat", format);
        return format;
    }

    private void cache(String key, Object object) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        this.cache.put(key, object);
    }

    public synchronized String[] getAlias(Key key) {
        Set alias;
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        if (this.naming != null && (alias = (Set)this.naming.get(key)) != null) {
            int index = 0;
            String[] list = new String[alias.size()];
            Iterator it = alias.iterator();
            while (it.hasNext()) {
                list[index++] = it.next().toString();
            }
            if (!$assertionsDisabled && index != list.length) {
                throw new AssertionError();
            }
            return list;
        }
        return null;
    }

    public String getSource() throws MetadataException {
        return this.source;
    }

    public Locale getLocale() throws MetadataException {
        return Locale.US;
    }

    private Unit getUnit(Unit defaultValue) {
        try {
            return this.getUnit();
        }
        catch (MetadataException exception) {
            return defaultValue;
        }
    }

    public synchronized Unit getUnit() throws MetadataException {
        Object value = this.get(UNITS);
        if (value instanceof Unit) {
            return (Unit)value;
        }
        String text = this.toString(value, UNITS, this.lastAlias);
        if (MetadataBuilder.contains(text, METRES)) {
            return SI.METER;
        }
        if (MetadataBuilder.contains(text, DEGREES)) {
            return NonSI.DEGREE_ANGLE;
        }
        throw new MetadataException("Unknow unit: " + text, UNITS, this.lastAlias);
    }

    private static boolean contains(String toSearch, String[] list) {
        int i = list.length;
        while (--i >= 0) {
            if (!toSearch.equalsIgnoreCase(list[i])) continue;
            return true;
        }
        return false;
    }

    public synchronized GeodeticDatum getGeodeticDatum() throws MetadataException {
        Object value = this.get(DATUM);
        if (value instanceof GeodeticDatum) {
            return (GeodeticDatum)value;
        }
        String text = this.toString(value, DATUM, this.lastAlias);
        MetadataBuilder.checkEllipsoid(text, "getGeodeticDatum");
        return DefaultGeodeticDatum.WGS84;
    }

    public synchronized Ellipsoid getEllipsoid() throws MetadataException {
        Object value = this.get(ELLIPSOID);
        if (value instanceof Ellipsoid) {
            return (Ellipsoid)value;
        }
        String text = this.toString(value, ELLIPSOID, this.lastAlias);
        MetadataBuilder.checkEllipsoid(text, "getEllipsoid");
        return DefaultEllipsoid.WGS84;
    }

    private static synchronized void checkEllipsoid(String text, String source) {
        if (!((text = MetadataBuilder.trim(text, " ").replace('_', ' ')).equalsIgnoreCase("WGS 1984") || text.equalsIgnoreCase("WGS1984") || text.equalsIgnoreCase("WGS84") || emittedWarning)) {
            emittedWarning = true;
            String message = '\"' + text + "\" ellipsoid not yet implemented. Default to WGS 1984.";
            LogRecord record = new LogRecord(Level.WARNING, message);
            record.setSourceMethodName(source);
            record.setSourceClassName("MetadataBuilder");
            AbstractGridCoverageReader.LOGGER.log(record);
        }
    }

    private static void setValue(ParameterValue parameter, double value, Unit unit) {
        Unit expected;
        if (unit != null && (expected = ((ParameterDescriptor)parameter.getDescriptor()).getUnit()) != null && unit.isCompatible(expected)) {
            parameter.setValue(value, unit);
            return;
        }
        parameter.setValue(value);
    }

    public synchronized Conversion getProjection() throws MetadataException {
        ParameterValueGroup parameters;
        Object operationMethod;
        Object candidate;
        String CACHE_KEY = "Projection";
        if (this.cache != null && (candidate = this.cache.get("Projection")) instanceof Conversion) {
            return (Conversion)candidate;
        }
        Object projection = this.getOptional(PROJECTION);
        if (projection instanceof Conversion) {
            return (Conversion)projection;
        }
        String projectionAlias = this.lastAlias;
        if (projection == null) {
            projection = operationMethod = this.get(OPERATION_METHOD);
            projectionAlias = this.lastAlias;
        } else {
            operationMethod = this.getOptional(OPERATION_METHOD);
            if (operationMethod == null) {
                operationMethod = projection;
            }
        }
        boolean semiMajorAxisDefined = false;
        boolean semiMinorAxisDefined = false;
        MathTransformFactory factory = this.factories.getMathTransformFactory();
        try {
            parameters = factory.getDefaultParameters(this.toString(operationMethod, OPERATION_METHOD, this.lastAlias));
        }
        catch (NoSuchIdentifierException exception) {
            throw new MetadataException((Exception)((Object)exception), OPERATION_METHOD, this.lastAlias);
        }
        Unit unit = this.getUnit(null);
        Iterator it = ((ParameterDescriptorGroup)parameters.getDescriptor()).descriptors().iterator();
        while (it.hasNext()) {
            double paramValue;
            GeneralParameterDescriptor descriptor = (GeneralParameterDescriptor)it.next();
            if (!(descriptor instanceof ParameterDescriptor)) continue;
            String name = descriptor.getName().getCode();
            ParameterValue param = parameters.parameter(name);
            try {
                paramValue = this.getAsDouble(new Key(name));
            }
            catch (MissingMetadataException exception) {
                continue;
            }
            MetadataBuilder.setValue(param, paramValue, unit);
            if (name.equalsIgnoreCase("semi_major")) {
                semiMajorAxisDefined = true;
            }
            if (!name.equalsIgnoreCase("semi_minor")) continue;
            semiMinorAxisDefined = true;
        }
        if (!semiMajorAxisDefined || !semiMinorAxisDefined) {
            Ellipsoid ellipsoid = this.getEllipsoid();
            double semiMajor = ellipsoid.getSemiMajorAxis();
            double semiMinor = ellipsoid.getSemiMinorAxis();
            Unit axisUnit = ellipsoid.getAxisUnit();
            if (semiMajorAxisDefined && parameters.parameter("semi_major").doubleValue(axisUnit) != semiMajor || semiMinorAxisDefined && parameters.parameter("semi_minor").doubleValue(axisUnit) != semiMinor) {
                throw new AmbiguousMetadataException(Errors.getResources(this.userLocale).getString(0), PROJECTION, projectionAlias);
            }
            parameters.parameter("semi_major").setValue(semiMajor, axisUnit);
            parameters.parameter("semi_minor").setValue(semiMinor, axisUnit);
        }
        DefiningConversion defining = new DefiningConversion(this.toString(projection, PROJECTION, projectionAlias), parameters);
        this.cache("Projection", defining);
        return defining;
    }

    public synchronized CoordinateReferenceSystem getCoordinateReferenceSystem() throws MetadataException {
        Object candidate;
        String CACHE_KEY = "CoordinateReferenceSystem";
        if (this.cache != null && (candidate = this.cache.get("CoordinateReferenceSystem")) instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)candidate;
        }
        Object value = this.getOptional(COORDINATE_REFERENCE_SYSTEM);
        if (value instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)value;
        }
        if (value == null) {
            value = "Generated";
        }
        String crsAlias = this.lastAlias;
        String crsName = this.toString(value, COORDINATE_REFERENCE_SYSTEM, crsAlias);
        Unit unit = this.getUnit();
        GeodeticDatum datum = this.getGeodeticDatum();
        boolean isGeographic = NonSI.DEGREE_ANGLE.isCompatible(unit);
        Unit angularUnit = isGeographic ? unit : NonSI.DEGREE_ANGLE;
        Unit linearUnit = SI.METER.isCompatible(unit) ? unit : SI.METER;
        DefaultEllipsoidalCS geoCS = DefaultEllipsoidalCS.GEODETIC_2D.usingUnit(angularUnit);
        Map<String, String> properties = Collections.singletonMap("name", crsName);
        try {
            GeographicCRS crs;
            GeographicCRS geographicCRS = this.factories.getCRSFactory().createGeographicCRS(properties, datum, (EllipsoidalCS)geoCS);
            if (isGeographic) {
                crs = geographicCRS;
            } else {
                DefaultCartesianCS cs = DefaultCartesianCS.PROJECTED.usingUnit(linearUnit);
                Conversion projection = this.getProjection();
                crs = this.factories.createProjectedCRS(properties, geographicCRS, projection, cs);
            }
            this.cache("CoordinateReferenceSystem", crs);
            return crs;
        }
        catch (FactoryException exception) {
            throw new MetadataException((Exception)((Object)exception), COORDINATE_REFERENCE_SYSTEM, crsAlias);
        }
    }

    public synchronized GeographicBoundingBox getGeographicBoundingBox() throws MetadataException {
        GeographicBoundingBox box;
        Object candidate;
        String CACHE_KEY = "GeographicBoundingBox";
        if (this.cache != null && (candidate = this.cache.get("GeographicBoundingBox")) instanceof GeographicBoundingBox) {
            return (GeographicBoundingBox)candidate;
        }
        try {
            box = (GeographicBoundingBox)new GeographicBoundingBoxImpl(this.getEnvelope()).unmodifiable();
        }
        catch (TransformException exception) {
            throw new MetadataException((Exception)((Object)exception), null, null);
        }
        this.cache("GeographicBoundingBox", box);
        return box;
    }

    public synchronized Envelope getEnvelope() throws MetadataException {
        Object candidate;
        String CACHE_KEY = "Envelope";
        if (this.cache != null && (candidate = this.cache.get("Envelope")) instanceof Envelope) {
            if (candidate instanceof Cloneable) {
                candidate = ((Cloneable)candidate).clone();
            }
            return (Envelope)candidate;
        }
        GridRange range = this.getGridRange();
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        GeneralEnvelope envelope = new GeneralEnvelope(crs);
        switch (envelope.getDimension()) {
            default: {
                this.setRange(Z_MINIMUM, Z_MAXIMUM, Z_RESOLUTION, envelope, 2, range, crs);
            }
            case 2: {
                this.setRange(Y_MINIMUM, Y_MAXIMUM, Y_RESOLUTION, envelope, 1, range, crs);
            }
            case 1: {
                this.setRange(X_MINIMUM, X_MAXIMUM, X_RESOLUTION, envelope, 0, range, crs);
            }
            case 0: 
        }
        this.cache("Envelope", envelope);
        return (Envelope)envelope.clone();
    }

    private void setRange(Key minKey, Key maxKey, Key resKey, GeneralEnvelope envelope, int dimension, GridRange gridRange, CoordinateReferenceSystem crs) throws MetadataException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        crs = CRSUtilities.getSubCRS(crs, dimension, dimension + 1);
        if (!this.contains(resKey)) {
            envelope.setRange(dimension, this.getAsDouble(minKey, crs), this.getAsDouble(maxKey, crs));
            return;
        }
        double resolution = this.getAsDouble(resKey, crs);
        String lastAlias = this.lastAlias;
        int range = gridRange.getLength(dimension);
        if (!this.contains(maxKey)) {
            double min = this.getAsDouble(minKey, crs);
            envelope.setRange(dimension, min, min + resolution * (double)range);
            return;
        }
        if (!this.contains(minKey)) {
            double max = this.getAsDouble(maxKey, crs);
            envelope.setRange(dimension, max - resolution * (double)range, max);
            return;
        }
        double min = this.getAsDouble(minKey, crs);
        double max = this.getAsDouble(maxKey, crs);
        envelope.setRange(dimension, min, max);
        if (Math.abs((min - max) / resolution - (double)range) > 1.0E-6) {
            throw new AmbiguousMetadataException(Errors.getResources(this.userLocale).getString(55, resKey), resKey, lastAlias);
        }
    }

    public synchronized GridRange getGridRange() throws MetadataException {
        Object candidate;
        String CACHE_KEY = "GridRange";
        if (this.cache != null && (candidate = this.cache.get("GridRange")) instanceof GridRange) {
            return (GridRange)candidate;
        }
        int dimension = this.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        int[] lower = new int[dimension];
        int[] upper = new int[dimension];
        Arrays.fill(upper, 1);
        switch (dimension) {
            default: {
                upper[2] = this.getAsInt(DEPTH);
            }
            case 2: {
                upper[1] = this.getAsInt(HEIGHT);
            }
            case 1: {
                upper[0] = this.getAsInt(WIDTH);
            }
            case 0: 
        }
        GeneralGridRange range = new GeneralGridRange(lower, upper);
        this.cache("GridRange", range);
        return range;
    }

    public SampleDimension[] getSampleDimensions() throws MetadataException {
        return null;
    }

    final synchronized void setUserLocale(Locale locale) {
        this.userLocale = locale;
    }

    public synchronized void listMetadata(Writer out) throws IOException {
        String lineSeparator = System.getProperty("line.separator", "\n");
        String comments = (String)this.getMetadata(null);
        if (comments != null) {
            int stop = comments.length();
            while (--stop >= 0 && Character.isSpaceChar(comments.charAt(stop))) {
            }
            out.write(comments.substring(0, stop + 1));
            out.write(lineSeparator);
            out.write(lineSeparator);
        }
        if (this.metadata != null) {
            int maxLength = 1;
            Iterator<Object> it = this.metadata.keySet().iterator();
            while (it.hasNext()) {
                int length;
                Object key = it.next();
                if (key == null || (length = key.toString().length()) <= maxLength) continue;
                maxLength = length;
            }
            it = this.metadata.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                Key key = (Key)entry.getKey();
                if (key == null) continue;
                Object value = entry.getValue();
                if (value instanceof Number) {
                    value = this.getNumberFormat().format(value);
                } else if (value instanceof Date) {
                    value = this.getDateFormat().format(value);
                } else if (value instanceof Formattable) {
                    try {
                        value = ((Formattable)value).toWKT(0);
                    }
                    catch (UnformattableObjectException exception) {
                        // empty catch block
                    }
                }
                boolean isKnow = this.naming != null && this.naming.containsKey(key);
                out.write(isKnow ? "  " : "? ");
                out.write(String.valueOf(key));
                out.write(Utilities.spaces(maxLength - key.toString().length()));
                out.write(this.separator);
                out.write(String.valueOf(value));
                out.write(lineSeparator);
            }
        }
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringWriter buffer = new StringWriter();
        if (this.source != null) {
            buffer.write("[\"");
            buffer.write(this.source);
            buffer.write("\"]");
        }
        buffer.write(lineSeparator);
        try {
            GeographicBoundingBox box = this.getGeographicBoundingBox();
            buffer.write(GeographicBoundingBoxImpl.toString(box, "DD\u00b0MM'SS\"", null));
            buffer.write(lineSeparator);
        }
        catch (MetadataException exception) {
            // empty catch block
        }
        buffer.write(123);
        buffer.write(lineSeparator);
        try {
            TableWriter table = new TableWriter((Writer)buffer, 2);
            table.setMultiLinesCells(true);
            table.nextColumn();
            this.listMetadata(table);
            table.flush();
        }
        catch (IOException exception) {
            buffer.write(exception.getLocalizedMessage());
        }
        buffer.write(125);
        buffer.write(lineSeparator);
        return buffer.toString();
    }

    static String trim(String str, String separator) {
        if (str != null) {
            str = str.trim();
            StringBuffer buffer = null;
            int i = str.length();
            block0: while (--i >= 0) {
                if (!Character.isSpaceChar(str.charAt(i))) continue;
                int upper = i;
                while (--i >= 0) {
                    if (Character.isSpaceChar(str.charAt(i))) continue;
                    if (buffer == null) {
                        buffer = new StringBuffer(str);
                    }
                    buffer.replace(i + 1, upper + 1, separator);
                    continue block0;
                }
                break block0;
            }
            if (buffer != null) {
                return buffer.toString();
            }
        }
        return str;
    }

    static {
        $assertionsDisabled = !MetadataBuilder.class.desiredAssertionStatus();
        METRES = new String[]{"meter", "meters", "metre", "metres", "m"};
        DEGREES = new String[]{"degree", "degrees", "deg", "\u00b0"};
        COORDINATE_REFERENCE_SYSTEM = new Key("CoordinateReferenceSystem"){

            public Object getValue(GridCoverage coverage) {
                return coverage.getCoordinateReferenceSystem();
            }
        };
        UNITS = new Key("Unit"){

            public Object getValue(GridCoverage coverage) {
                CoordinateSystem cs;
                Unit unit = null;
                CoordinateReferenceSystem crs = coverage.getCoordinateReferenceSystem();
                if (crs != null && (cs = crs.getCoordinateSystem()) != null) {
                    int i = cs.getDimension();
                    while (--i >= 0) {
                        Unit candidate = cs.getAxis(i).getUnit();
                        if (candidate == null) continue;
                        if (unit == null) {
                            unit = candidate;
                            continue;
                        }
                        if (unit.equals(candidate)) continue;
                        return null;
                    }
                }
                return unit;
            }
        };
        DATUM = new Key("Datum"){

            public Object getValue(GridCoverage coverage) {
                return CRSUtilities.getDatum(coverage.getCoordinateReferenceSystem());
            }
        };
        ELLIPSOID = new Key("Ellipsoid"){

            public Object getValue(GridCoverage coverage) {
                return CRSUtilities.getEllipsoid(coverage.getCoordinateReferenceSystem());
            }
        };
        OPERATION_METHOD = new Key("OperationMethod"){

            public Object getValue(GridCoverage coverage) {
                Projection projection = (Projection)PROJECTION.getValue(coverage);
                return projection != null ? projection.getName().getCode() : null;
            }
        };
        PROJECTION = new Key("Projection"){

            public Object getValue(GridCoverage coverage) {
                ProjectedCRS crs = CRSUtilities.getProjectedCRS(coverage.getCoordinateReferenceSystem());
                return crs != null ? crs.getConversionFromBase() : null;
            }
        };
        SEMI_MAJOR = new ProjectionKey("semi_major");
        SEMI_MINOR = new ProjectionKey("semi_minor");
        LATITUDE_OF_ORIGIN = new ProjectionKey("latitude_of_origin");
        CENTRAL_MERIDIAN = new ProjectionKey("central_meridian");
        FALSE_EASTING = new ProjectionKey("false_easting");
        FALSE_NORTHING = new ProjectionKey("false_northing");
        X_MINIMUM = new EnvelopeKey("XMinimum", 0, 5);
        Y_MINIMUM = new EnvelopeKey("YMinimum", 1, 5);
        Z_MINIMUM = new EnvelopeKey("ZMinimum", 2, 5);
        X_MAXIMUM = new EnvelopeKey("XMaximum", 0, 6);
        Y_MAXIMUM = new EnvelopeKey("YMaximum", 1, 6);
        Z_MAXIMUM = new EnvelopeKey("ZMaximum", 2, 6);
        X_RESOLUTION = new EnvelopeKey("XResolution", 0, 12);
        Y_RESOLUTION = new EnvelopeKey("YResolution", 1, 12);
        Z_RESOLUTION = new EnvelopeKey("ZResolution", 2, 12);
        WIDTH = new EnvelopeKey("Width", 0, 8);
        HEIGHT = new EnvelopeKey("Height", 1, 8);
        DEPTH = new EnvelopeKey("Depth", 2, 8);
    }

    private static final class AliasKey
    extends Key {
        private static final long serialVersionUID = 4546899841215386795L;

        public AliasKey(String name) {
            super(name);
        }

        public int hashCode() {
            return ~super.hashCode();
        }
    }

    private static final class ProjectionKey
    extends Key {
        private static final long serialVersionUID = -6913177345764406058L;

        public ProjectionKey(String name) {
            super(name);
        }

        public Object getValue(GridCoverage coverage) {
            ProjectedCRS crs = CRSUtilities.getProjectedCRS(coverage.getCoordinateReferenceSystem());
            if (crs != null) {
                ParameterValueGroup parameters = crs.getConversionFromBase().getParameterValues();
                try {
                    return parameters.parameter(this.toString()).getValue();
                }
                catch (ParameterNotFoundException exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static final class EnvelopeKey
    extends Key {
        private static final long serialVersionUID = -7928870614384957795L;
        public static final byte LENGTH = 4;
        public static final byte MINIMUM = 5;
        public static final byte MAXIMUM = 6;
        public static final byte SIZE = 8;
        public static final byte LOWER = 9;
        public static final byte UPPER = 10;
        public static final byte RESOLUTION = 12;
        private final byte dimension;
        private final byte method;

        public EnvelopeKey(String name, byte dimension, byte method) {
            super(name);
            this.dimension = dimension;
            this.method = method;
        }

        public Object getValue(GridCoverage coverage) {
            Envelope envelope = null;
            GridRange range = null;
            if ((this.method & 4) != 0 && ((envelope = coverage.getEnvelope()) == null || envelope.getDimension() <= this.dimension)) {
                return null;
            }
            if ((this.method & 8) != 0 && ((range = coverage.getGridGeometry().getGridRange()) == null || range.getDimension() <= this.dimension)) {
                return null;
            }
            switch (this.method) {
                default: {
                    throw new AssertionError(this.method);
                }
                case 4: {
                    return new Double(envelope.getLength((int)this.dimension));
                }
                case 5: {
                    return this.getValue(coverage, envelope.getMinimum((int)this.dimension));
                }
                case 6: {
                    return this.getValue(coverage, envelope.getMaximum((int)this.dimension));
                }
                case 8: {
                    return new Integer(range.getLength((int)this.dimension));
                }
                case 9: {
                    return new Integer(range.getLower((int)this.dimension));
                }
                case 10: {
                    return new Integer(range.getUpper((int)this.dimension));
                }
                case 12: 
            }
            return new Double(envelope.getLength((int)this.dimension) / (double)range.getLength((int)this.dimension));
        }

        private Object getValue(GridCoverage coverage, double value) {
            CoordinateReferenceSystem crs = coverage.getCoordinateReferenceSystem();
            if (crs != null && (crs = CRSUtilities.getSubCRS(crs, this.dimension, this.dimension + 1)) instanceof TemporalCRS) {
                return DefaultTemporalCRS.wrap((TemporalCRS)crs).toDate(value);
            }
            return new Double(value);
        }

        public boolean equals(Object object) {
            if (super.equals(object)) {
                EnvelopeKey that = (EnvelopeKey)object;
                return this.dimension == that.dimension && this.method == that.method;
            }
            return false;
        }
    }

    public static class Key
    implements Serializable {
        private static final long serialVersionUID = -6197070349689520675L;
        private final String name;
        private final String key;

        public Key(String name) {
            this.name = name = name.trim();
            this.key = MetadataBuilder.trim(name, "_").toLowerCase();
        }

        public Object getValue(GridCoverage coverage) {
            return null;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            return object != null && object.getClass().equals(this.getClass()) && this.key.equals(((Key)object).key);
        }
    }
}

