/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import javax.imageio.IIOException;
import org.geotools.coverage.io.MetadataBuilder;

public class MetadataException
extends IIOException {
    private static final long serialVersionUID = -3146379152278866037L;
    private final MetadataBuilder.Key key;
    private final String alias;

    public MetadataException(String message) {
        super(message);
        this.key = null;
        this.alias = null;
    }

    public MetadataException(String message, Throwable cause) {
        super(message, cause);
        this.key = null;
        this.alias = null;
    }

    public MetadataException(String message, MetadataBuilder.Key key, String alias) {
        super(message);
        this.key = key;
        this.alias = alias;
    }

    public MetadataException(Exception cause, MetadataBuilder.Key key, String alias) {
        super(cause.getLocalizedMessage(), cause);
        this.key = key;
        this.alias = alias;
    }

    public MetadataBuilder.Key getMetadataKey() {
        return this.key;
    }

    public String getMetadataAlias() {
        return this.alias;
    }

    public String toString() {
        MetadataBuilder.Key key = this.getMetadataKey();
        String alias = this.getMetadataAlias();
        if (key == null && alias == null) {
            return super.toString();
        }
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append('[');
        if (key != null) {
            buffer.append("key=\"");
            buffer.append(key);
            buffer.append('\"');
            if (alias != null) {
                buffer.append(", ");
            }
        }
        if (alias != null) {
            buffer.append("alias=\"");
            buffer.append(alias);
            buffer.append('\"');
        }
        buffer.append(']');
        String message = this.getLocalizedMessage();
        if (message != null) {
            buffer.append(':');
            buffer.append(System.getProperty("line.separator", "\n"));
            buffer.append(message);
        }
        return buffer.toString();
    }
}

