/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.coverage.grid.Interpolator2D;
import org.geotools.coverage.processing.AbstractOperation;
import org.geotools.coverage.processing.BufferedProcessor;
import org.geotools.coverage.processing.CoverageParameterWriter;
import org.geotools.resources.Arguments;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public abstract class AbstractProcessor {
    public static final Logger LOGGER = Logger.getLogger("org.geotools.coverage.processing");
    public static final Level OPERATION = new LogLevel("OPERATION", 780);
    private static AbstractProcessor DEFAULT;

    public static synchronized AbstractProcessor getInstance() {
        if (DEFAULT == null) {
            DEFAULT = new BufferedProcessor((RenderingHints)null);
            DEFAULT.setAsDefault();
        }
        return DEFAULT;
    }

    void setAsDefault() {
    }

    public abstract Collection getOperations();

    public abstract Operation getOperation(String var1) throws OperationNotFoundException;

    public abstract Coverage doOperation(ParameterValueGroup var1) throws OperationNotFoundException;

    public Locale getLocale() {
        return Locale.getDefault();
    }

    final void log(Coverage source, Coverage result, String operationName, boolean fromCache) {
        if (source != result) {
            String interp = "Nearest";
            if (result instanceof Interpolator2D) {
                interp = ImageUtilities.getInterpolationName(((Interpolator2D)result).getInterpolation());
            }
            Locale locale = this.getLocale();
            LogRecord record = Logging.getResources(locale).getLogRecord(OPERATION, 2, AbstractProcessor.getName(source != null ? source : result, locale), operationName, interp, new Integer(fromCache ? 1 : 0));
            record.setSourceClassName("DefaultProcessor");
            record.setSourceMethodName("doOperation");
            LOGGER.log(record);
        }
    }

    static Coverage getPrimarySource(ParameterValueGroup parameters) {
        try {
            return (Coverage)parameters.parameter("Source").getValue();
        }
        catch (ParameterNotFoundException exception) {
            return null;
        }
    }

    static String getOperationName(ParameterValueGroup parameters) {
        return parameters.getDescriptor().getName().getCode().trim();
    }

    private static String getName(Coverage coverage, Locale locale) {
        if (coverage instanceof AbstractCoverage) {
            return ((AbstractCoverage)coverage).getName().toString(locale);
        }
        return Vocabulary.getResources(locale).getString(178);
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(105, name));
        }
    }

    public void listOperations(Writer out) throws IOException {
        Collection operations = this.getOperations();
        CoverageParameterWriter writer = new CoverageParameterWriter(out);
        ArrayList<ParameterDescriptorGroup> descriptors = new ArrayList<ParameterDescriptorGroup>(operations.size());
        Iterator it = operations.iterator();
        while (it.hasNext()) {
            Operation operation = (Operation)it.next();
            if (!(operation instanceof AbstractOperation)) continue;
            descriptors.add(((AbstractOperation)operation).descriptor);
        }
        writer.summary(descriptors, null);
    }

    public void printOperations(Writer out, String[] names) throws OperationNotFoundException, IOException {
        CoverageParameterWriter writer = new CoverageParameterWriter(out);
        String lineSeparator = System.getProperty("line.separator", "\n");
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                Operation operation = this.getOperation(names[i]);
                if (!(operation instanceof AbstractOperation)) continue;
                out.write(lineSeparator);
                writer.format(((AbstractOperation)operation).descriptor);
            }
        } else {
            Collection operations = this.getOperations();
            Iterator it = operations.iterator();
            while (it.hasNext()) {
                Operation operation = (Operation)it.next();
                if (!(operation instanceof AbstractOperation)) continue;
                out.write(lineSeparator);
                writer.format(((AbstractOperation)operation).descriptor);
            }
        }
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        boolean all = arguments.getFlag("-all");
        args = arguments.getRemainingArguments(Integer.MAX_VALUE);
        AbstractProcessor processor = AbstractProcessor.getInstance();
        try {
            if (args.length == 0) {
                processor.listOperations(arguments.out);
            } else {
                processor.printOperations(arguments.out, all ? null : args);
            }
        }
        catch (OperationNotFoundException exception) {
            arguments.out.println(exception.getLocalizedMessage());
        }
        catch (IOException exception) {
            exception.printStackTrace(arguments.out);
        }
        arguments.out.flush();
    }

    private static final class LogLevel
    extends Level {
        protected LogLevel(String name, int level) {
            super(name, level);
        }
    }
}

