/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.Interpolator2D;
import org.geotools.coverage.processing.AbstractOperation;
import org.geotools.coverage.processing.AbstractProcessor;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class DefaultProcessor
extends AbstractProcessor {
    private static final Comparator COMPARATOR;
    private final Map operations = new TreeMap(COMPARATOR);
    private final Hints hints;
    private final FactoryRegistry registry = new FactoryRegistry(Collections.singleton(Operation.class));

    public DefaultProcessor(RenderingHints hints) {
        this.hints = new Hints((Map)hints);
        this.hints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        this.hints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
        this.hints.put(Hints.GRID_COVERAGE_PROCESSOR, this);
    }

    final void setProcessor(AbstractProcessor processor) {
        this.hints.put(Hints.GRID_COVERAGE_PROCESSOR, processor);
    }

    void setAsDefault() {
        this.hints.remove(Hints.GRID_COVERAGE_PROCESSOR);
    }

    protected synchronized void addOperation(Operation operation) throws IllegalStateException {
        DefaultProcessor.ensureNonNull("operation", operation);
        if (this.operations.isEmpty()) {
            this.scanForPlugins();
        }
        this.addOperation0(operation);
    }

    private void addOperation0(Operation operation) throws IllegalStateException {
        String name = operation.getName().trim();
        Operation old = this.operations.put(name, operation);
        if (old != null && !old.equals(operation)) {
            this.operations.put(old.getName().trim(), old);
            throw new IllegalStateException(Errors.getResources(this.getLocale()).getString(111, operation.getName()));
        }
    }

    public synchronized Collection getOperations() {
        if (this.operations.isEmpty()) {
            this.scanForPlugins();
        }
        return this.operations.values();
    }

    public synchronized Operation getOperation(String name) throws OperationNotFoundException {
        Operation operation;
        DefaultProcessor.ensureNonNull("name", name);
        name = name.trim();
        if (this.operations.isEmpty()) {
            this.scanForPlugins();
        }
        if ((operation = (Operation)this.operations.get(name)) != null) {
            return operation;
        }
        throw new OperationNotFoundException(Errors.getResources(this.getLocale()).getString(112, name));
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public synchronized Coverage doOperation(ParameterValueGroup parameters) throws OperationNotFoundException {
        AbstractOperation op;
        Coverage source = DefaultProcessor.getPrimarySource(parameters);
        String operationName = DefaultProcessor.getOperationName(parameters);
        Operation operation = this.getOperation(operationName);
        Object[] interpolations = null;
        if (!operationName.equalsIgnoreCase("Interpolate")) {
            Iterator it = parameters.values().iterator();
            while (it.hasNext()) {
                Object value;
                GeneralParameterValue param = (GeneralParameterValue)it.next();
                if (!(param instanceof ParameterValue) || !((value = ((ParameterValue)param).getValue()) instanceof Interpolator2D)) continue;
                Object[] interp = ((Interpolator2D)value).getInterpolations();
                if (interpolations == null) {
                    interpolations = interp;
                    continue;
                }
                if (Arrays.equals(interpolations, interp)) continue;
                interpolations = null;
                break;
            }
        }
        try {
            op = (AbstractOperation)operation;
        }
        catch (ClassCastException cause) {
            OperationNotFoundException exception = new OperationNotFoundException(Errors.getResources(this.getLocale()).getString(112, operationName));
            exception.initCause((Throwable)cause);
            throw exception;
        }
        Coverage coverage = op.doOperation(parameters, this.hints);
        if (interpolations != null && coverage instanceof GridCoverage2D && !(coverage instanceof Interpolator2D)) {
            coverage = Interpolator2D.create((GridCoverage2D)coverage, interpolations);
        }
        this.log(source, coverage, operationName, false);
        return coverage;
    }

    public synchronized void scanForPlugins() {
        Iterator it = this.registry.getServiceProviders(Operation.class);
        while (it.hasNext()) {
            Operation operation = (Operation)it.next();
            String name = operation.getName().trim();
            if (this.operations.containsKey(name)) continue;
            this.addOperation0(operation);
        }
    }

    static {
        long targetCapacity = 0x4000000L;
        long maxMemory = Runtime.getRuntime().maxMemory();
        TileCache cache = JAI.getDefaultInstance().getTileCache();
        if (maxMemory >= 0x8000000L && cache.getMemoryCapacity() < 0x4000000L) {
            cache.setMemoryCapacity(0x4000000L);
        }
        LOGGER.config("Java Advanced Imaging: " + JAI.getBuildVersion() + ", TileCache capacity=" + (float)(cache.getMemoryCapacity() / 0x100000L) + " Mb");
        if (cache.getMemoryCapacity() + 0x400000L >= maxMemory) {
            LOGGER.log(Logging.format(Level.SEVERE, 8, new Double((double)maxMemory / 1048576.0)));
        }
        COMPARATOR = new Comparator(){

            public int compare(Object name1, Object name2) {
                return ((String)name1).toLowerCase().compareTo(((String)name2).toLowerCase());
            }
        };
    }
}

