/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.KernelJAI;
import org.geotools.coverage.processing.AbstractProcessor;
import org.geotools.coverage.processing.BufferedProcessor;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.Envelope;

public class Operations {
    public static final Operations DEFAULT = new Operations(null);
    private AbstractProcessor processor;

    public Operations(RenderingHints hints) {
        if (hints != null && !hints.isEmpty()) {
            this.processor = new BufferedProcessor(hints);
        }
    }

    public Coverage add(Coverage source, double[] constants) throws CoverageProcessingException {
        return this.doOperation("AddConst", source, "constants", constants);
    }

    public Coverage subtract(Coverage source, double[] constants) throws CoverageProcessingException {
        return this.doOperation("SubtractConst", source, "constants", constants);
    }

    public Coverage subtractFrom(Coverage source, double[] constants) throws CoverageProcessingException {
        return this.doOperation("SubtractFromConst", source, "constants", constants);
    }

    public Coverage multiply(Coverage source, double[] constants) throws CoverageProcessingException {
        return this.doOperation("MultiplyConst", source, "constants", constants);
    }

    public Coverage divideBy(Coverage source, double[] constants) throws CoverageProcessingException {
        return this.doOperation("DivideByConst", source, "constants", constants);
    }

    public Coverage rescale(Coverage source, double[] constants, double[] offsets) throws CoverageProcessingException {
        return this.doOperation("Rescale", source, "constants", constants, "offsets", offsets);
    }

    public Coverage invert(Coverage source) throws CoverageProcessingException {
        return this.doOperation("Invert", source);
    }

    public Coverage absolute(Coverage source) throws CoverageProcessingException {
        return this.doOperation("Absolute", source);
    }

    public Coverage log(Coverage source) throws CoverageProcessingException {
        return this.doOperation("Log", source);
    }

    public Coverage exp(Coverage source) throws CoverageProcessingException {
        return this.doOperation("Exp", source);
    }

    public GridCoverage nodataFilter(GridCoverage source) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("NodataFilter", (Coverage)source);
    }

    public GridCoverage nodataFilter(GridCoverage source, int padding, int validityThreshold) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("NodataFilter", (Coverage)source, "padding", new Integer(padding), "validityThreshold", new Integer(validityThreshold));
    }

    public GridCoverage interpolate(GridCoverage source, String type) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Interpolate", (Coverage)source, "Type", type);
    }

    public GridCoverage interpolate(GridCoverage source, Interpolation type) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Interpolate", (Coverage)source, "Type", type);
    }

    public GridCoverage interpolate(GridCoverage source, Interpolation[] types) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Interpolate", (Coverage)source, "Type", types);
    }

    public GridCoverage recolor(GridCoverage source, Map[] colorMaps) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Recolor", (Coverage)source, "ColorMaps", colorMaps);
    }

    public Coverage selectSampleDimension(Coverage source, int[] sampleDimensions) throws CoverageProcessingException {
        return this.doOperation("SelectSampleDimension", source, "SampleDimensions", sampleDimensions);
    }

    public Coverage resample(Coverage source, CoordinateReferenceSystem crs) throws CoverageProcessingException {
        return this.doOperation("Resample", source, "CoordinateReferenceSystem", crs);
    }

    public Coverage resample(GridCoverage source, CoordinateReferenceSystem crs, GridGeometry gridGeometry, Interpolation interpolationType) throws CoverageProcessingException {
        return this.doOperation("Resample", (Coverage)source, "CoordinateReferenceSystem", crs, "GridGeometry", gridGeometry, "InterpolationType", interpolationType);
    }

    public Coverage crop(Coverage Source, Envelope envelope) throws CoverageProcessingException {
        return this.doOperation("CoverageCrop", Source, "Envelope", envelope);
    }

    public GridCoverage scale(GridCoverage source, double xScale, double yScale, double xTrans, double yTrans) throws CoverageProcessingException {
        return this.scale(source, xScale, yScale, xTrans, yTrans, null, null);
    }

    public GridCoverage scale(GridCoverage source, double xScale, double yScale, double xTrans, double yTrans, Interpolation interpolation) throws CoverageProcessingException {
        return this.scale(source, xScale, yScale, xTrans, yTrans, interpolation, null);
    }

    public GridCoverage scale(GridCoverage source, double xScale, double yScale, double xTrans, double yTrans, Interpolation interpolation, BorderExtender extender) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Scale", (Coverage)source, "xScale", new Float(xScale), "yScale", new Float(yScale), "xTrans", new Float(xTrans), "yTrans", new Float(yTrans), "Interpolation", interpolation, "BorderExtender", extender);
    }

    public GridCoverage SubsampleAverage(GridCoverage source, double scaleX, double scaleY, Interpolation interpolation, BorderExtender be) throws CoverageProcessingException {
        return this.subsampleAverage(source, scaleX, scaleY, interpolation, be);
    }

    public GridCoverage subsampleAverage(GridCoverage source, double scaleX, double scaleY, Interpolation interpolation, BorderExtender be) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("SubsampleAverage", (Coverage)source, "scaleX", new Double(scaleX), "scaleY", new Double(scaleY), "Interpolation", interpolation, "BorderExtender", be);
    }

    public GridCoverage filteredSubsample(GridCoverage source) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("FilteredSubsample", (Coverage)source);
    }

    public GridCoverage filteredSubsample(GridCoverage source, int scaleX, int scaleY, float[] qsFilter) throws CoverageProcessingException {
        return this.filteredSubsample(source, scaleX, scaleY, qsFilter, null, null);
    }

    public GridCoverage filteredSubsample(GridCoverage source, int scaleX, int scaleY, float[] qsFilter, Interpolation interpolation) throws CoverageProcessingException {
        return this.filteredSubsample(source, scaleX, scaleY, qsFilter, interpolation, null);
    }

    public GridCoverage filteredSubsample(GridCoverage source, int scaleX, int scaleY, float[] qsFilter, Interpolation interpolation, BorderExtender be) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("FilteredSubsample", (Coverage)source, "scaleX", new Integer(scaleX), "scaleY", new Integer(scaleY), "qsFilterArray", qsFilter, "Interpolation", interpolation, "BorderExtender", be);
    }

    public Coverage gradientMagnitude(Coverage source) throws CoverageProcessingException {
        return this.doOperation("GradientMagnitude", source);
    }

    public Coverage gradientMagnitude(Coverage source, KernelJAI mask1, KernelJAI mask2) throws CoverageProcessingException {
        return this.doOperation("GradientMagnitude", source, "mask1", mask1, "mask2", mask2);
    }

    private AbstractProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = AbstractProcessor.getInstance();
        }
        return this.processor;
    }

    protected final Coverage doOperation(String operationName, Coverage source) throws OperationNotFoundException, CoverageProcessingException {
        AbstractProcessor processor = this.getProcessor();
        Operation operation = processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        return processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        AbstractProcessor processor = this.getProcessor();
        Operation operation = processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        return processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        AbstractProcessor processor = this.getProcessor();
        Operation operation = processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        Operations.setParameterValue(parameters, argumentName2, argumentValue2);
        return processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2, String argumentName3, Object argumentValue3) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        AbstractProcessor processor = this.getProcessor();
        Operation operation = processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        Operations.setParameterValue(parameters, argumentName2, argumentValue2);
        Operations.setParameterValue(parameters, argumentName3, argumentValue3);
        return processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2, String argumentName3, Object argumentValue3, String argumentName4, Object argumentValue4) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        AbstractProcessor processor = this.getProcessor();
        Operation operation = processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        Operations.setParameterValue(parameters, argumentName2, argumentValue2);
        Operations.setParameterValue(parameters, argumentName3, argumentValue3);
        Operations.setParameterValue(parameters, argumentName4, argumentValue4);
        return processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2, String argumentName3, Object argumentValue3, String argumentName4, Object argumentValue4, String argumentName5, Object argumentValue5) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        AbstractProcessor processor = this.getProcessor();
        Operation operation = processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        Operations.setParameterValue(parameters, argumentName2, argumentValue2);
        Operations.setParameterValue(parameters, argumentName3, argumentValue3);
        Operations.setParameterValue(parameters, argumentName4, argumentValue4);
        Operations.setParameterValue(parameters, argumentName5, argumentValue5);
        return processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2, String argumentName3, Object argumentValue3, String argumentName4, Object argumentValue4, String argumentName5, Object argumentValue5, String argumentName6, Object argumentValue6) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        AbstractProcessor processor = this.getProcessor();
        Operation operation = processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        Operations.setParameterValue(parameters, argumentName2, argumentValue2);
        Operations.setParameterValue(parameters, argumentName3, argumentValue3);
        Operations.setParameterValue(parameters, argumentName4, argumentValue4);
        Operations.setParameterValue(parameters, argumentName5, argumentValue5);
        Operations.setParameterValue(parameters, argumentName6, argumentValue6);
        return processor.doOperation(parameters);
    }

    private static void setParameterValue(ParameterValueGroup parameters, String name, Object value) throws InvalidParameterNameException {
        if (value != null) {
            try {
                parameters.parameter(name).setValue(value);
            }
            catch (ParameterNotFoundException cause) {
                InvalidParameterNameException exception = new InvalidParameterNameException(Errors.format(134, name), name);
                exception.initCause((Throwable)cause);
                throw exception;
            }
        }
    }
}

