/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.CoverageUtilities;
import org.opengis.parameter.ParameterValueGroup;

final class BandSelector2D
extends GridCoverage2D {
    private final int[] bandIndices;
    static final /* synthetic */ boolean $assertionsDisabled;

    private BandSelector2D(GridCoverage2D source, PlanarImage image, GridSampleDimension[] bands, int[] bandIndices) {
        super((CharSequence)source.getName(), image, (GridGeometry2D)source.getGridGeometry(), bands, new GridCoverage2D[]{source}, null);
        this.bandIndices = bandIndices;
        if (!$assertionsDisabled && bandIndices != null && bandIndices.length != bands.length) {
            throw new AssertionError();
        }
    }

    static GridCoverage2D create(ParameterValueGroup parameters, RenderingHints hints) {
        int visibleTargetBand;
        int visibleSourceBand;
        RenderedImage sourceImage;
        GridSampleDimension[] targetBands;
        GridSampleDimension[] sourceBands;
        GridCoverage2D source = (GridCoverage2D)parameters.parameter("Source").getValue();
        int[] bandIndices = parameters.parameter("SampleDimensions").intValueList();
        if (bandIndices != null) {
            bandIndices = (int[])bandIndices.clone();
        }
        Integer visibleBand = (Integer)parameters.parameter("VisibleSampleDimension").getValue();
        while (true) {
            targetBands = sourceBands = source.getSampleDimensions();
            if (bandIndices != null) {
                int bandIndicesLength = bandIndices.length;
                if (bandIndices.length != bandIndicesLength || !BandSelector2D.isIdentity(bandIndices)) {
                    targetBands = new GridSampleDimension[bandIndices.length];
                    for (int i = 0; i < bandIndicesLength; ++i) {
                        targetBands[i] = sourceBands[bandIndices[i]];
                    }
                } else {
                    bandIndices = null;
                }
            }
            sourceImage = source.getRenderedImage();
            visibleSourceBand = CoverageUtilities.getVisibleBand(sourceImage);
            int n = visibleBand != null ? visibleBand : (visibleTargetBand = bandIndices != null ? bandIndices[visibleSourceBand] : visibleSourceBand);
            if (bandIndices == null && visibleSourceBand == visibleTargetBand) {
                return source;
            }
            if (!(source instanceof BandSelector2D)) break;
            int[] parentIndices = ((BandSelector2D)source).bandIndices;
            if (parentIndices != null) {
                if (bandIndices != null) {
                    int bandIndicesLength = bandIndices.length;
                    for (int i = 0; i < bandIndicesLength; ++i) {
                        bandIndices[i] = parentIndices[bandIndices[i]];
                    }
                } else {
                    bandIndices = (int[])parentIndices.clone();
                }
            }
            if (!$assertionsDisabled && source.getSources().size() != 1) {
                throw new AssertionError(source);
            }
            source = (GridCoverage2D)source.getSources().get(0);
        }
        String operation = "Null";
        ImageLayout layout = null;
        if (hints != null) {
            layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        }
        if (layout == null) {
            layout = new ImageLayout();
        }
        if (visibleBand != null || !layout.isValid(512)) {
            ColorModel colors = sourceImage.getColorModel();
            if (colors instanceof IndexColorModel && sourceBands[visibleSourceBand].equals(targetBands[visibleTargetBand])) {
                IndexColorModel indexed = (IndexColorModel)colors;
                int[] ARGB = new int[indexed.getMapSize()];
                indexed.getRGBs(ARGB);
                colors = ColorUtilities.getIndexColorModel(ARGB, targetBands.length, visibleTargetBand);
            } else {
                colors = targetBands[visibleTargetBand].getColorModel(visibleTargetBand, targetBands.length);
            }
            layout.setColorModel(colors);
            if (hints != null) {
                hints = (RenderingHints)hints.clone();
                hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            } else {
                hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            }
        }
        if (visibleBand == null) {
            visibleBand = new Integer(visibleTargetBand);
        }
        ParameterBlock params = new ParameterBlock().addSource(sourceImage);
        if (targetBands != sourceBands) {
            operation = "BandSelect";
            params = params.add(bandIndices);
        }
        RenderedOp image = OperationJAI.getJAI(hints).createNS(operation, params, hints);
        image.setProperty("GC_VisibleBand", (Object)visibleBand);
        return new BandSelector2D(source, (PlanarImage)image, targetBands, bandIndices);
    }

    private static boolean isIdentity(int[] bands) {
        int length = bands.length;
        for (int i = 0; i < length; ++i) {
            if (bands[i] == i) continue;
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !BandSelector2D.class.desiredAssertionStatus();
    }
}

