/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.geom.AffineTransform;
import java.util.Map;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CannotCropException;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.coverage.processing.operation.CroppedCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.Coverage;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.Envelope;

public class Crop
extends Operation2D {
    private static final long serialVersionUID = 4466072819239413456L;
    public static final ParameterDescriptor CROP_ENVELOPE = new DefaultParameterDescriptor(Citations.GEOTOOLS, "Envelope", GeneralEnvelope.class, null, null, null, null, null, false);
    public static final ParameterDescriptor CONSERVE_ENVELOPE = new DefaultParameterDescriptor(Citations.GEOTOOLS, "ConserveEnvelope", Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.FALSE, null, null, null, true);

    public Crop() {
        super(new DefaultParameterDescriptorGroup(Citations.GEOTOOLS, "CoverageCrop", (GeneralParameterDescriptor[])new ParameterDescriptor[]{SOURCE_0, CROP_ENVELOPE, CONSERVE_ENVELOPE}));
    }

    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        ParameterValue sourceParameter = parameters.parameter("Source");
        if (sourceParameter == null || !(sourceParameter.getValue() instanceof GridCoverage2D)) {
            throw new CannotCropException(Errors.format(185, "Source", GridCoverage2D.class.toString()));
        }
        ParameterValue envelopeParameter = parameters.parameter("Envelope");
        if (envelopeParameter == null || !(envelopeParameter.getValue() instanceof Envelope)) {
            throw new CannotCropException(Errors.format(185, "Envelope", GeneralEnvelope.class.toString()));
        }
        ParameterValue conserveEnvelopeParameter = parameters.parameter("ConserveEnvelope");
        if (conserveEnvelopeParameter == null || !(conserveEnvelopeParameter.getValue() instanceof Boolean)) {
            throw new CannotCropException(Errors.format(185, "ConserveEnvelope", Double.class.toString()));
        }
        GridCoverage2D source = (GridCoverage2D)sourceParameter.getValue();
        Envelope sourceEnvelope = source.getEnvelope();
        Envelope destinationEnvelope = (Envelope)envelopeParameter.getValue();
        CoordinateReferenceSystem sourceCRS = GeneralEnvelope.getCoordinateReferenceSystem(sourceEnvelope);
        CoordinateReferenceSystem destinationCRS = GeneralEnvelope.getCoordinateReferenceSystem(destinationEnvelope);
        if (destinationCRS == null) {
            GeneralEnvelope ge = new GeneralEnvelope(destinationEnvelope);
            destinationCRS = source.getCoordinateReferenceSystem2D();
            ge.setCoordinateReferenceSystem(destinationCRS);
            destinationEnvelope = ge;
        }
        if (!CRSUtilities.equalsIgnoreMetadata(sourceCRS, destinationCRS)) {
            throw new CannotCropException(Errors.format(186, sourceCRS.getName().getCode(), destinationCRS.getName().getCode()));
        }
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope(destinationEnvelope);
        intersectionEnvelope.setCoordinateReferenceSystem(source.getCoordinateReferenceSystem());
        intersectionEnvelope.intersect(sourceEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            return null;
        }
        if (!intersectionEnvelope.equals(sourceEnvelope, XAffineTransform.getScale((AffineTransform)((GridGeometry2D)source.getGridGeometry()).getGridToCRS2D()) / 2.0, false)) {
            envelopeParameter.setValue(intersectionEnvelope.clone());
            return CroppedCoverage2D.create(parameters, hints instanceof Hints ? hints : new Hints((Map)hints));
        }
        return source;
    }
}

