/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CannotCropException;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridRange;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

final class CroppedCoverage2D
extends GridCoverage2D {
    private static final long serialVersionUID = -501742139906901754L;

    private CroppedCoverage2D(InternationalString name, PlanarImage translatedImage, GridGeometry2D croppedGeometry, GridCoverage2D source, int actionTaken) {
        super(name.toString(), translatedImage, croppedGeometry, (GridSampleDimension[])(actionTaken == 1 ? null : source.getSampleDimensions().clone()), new GridCoverage[]{source}, null);
    }

    static GridCoverage2D create(ParameterValueGroup parameters, RenderingHints hints) {
        GridCoverage2D sourceCoverage = (GridCoverage2D)parameters.parameter("Source").getValue();
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        RenderingHints targetHints = ImageUtilities.getRenderingHints(sourceImage);
        if (targetHints == null) {
            targetHints = new RenderingHints(hints);
        } else if (hints != null) {
            targetHints.add(hints);
        }
        Interpolation interpolation = (Interpolation)targetHints.get(JAI.KEY_INTERPOLATION);
        if (interpolation == null) {
            interpolation = (Interpolation)ImageUtilities.NN_INTERPOLATION_HINT.get(JAI.KEY_INTERPOLATION);
        }
        int actionTaken = 0;
        ImageLayout layout = (ImageLayout)targetHints.get(JAI.KEY_IMAGE_LAYOUT);
        if (layout != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        JAI processor = OperationJAI.getJAI(targetHints);
        boolean useProvidedProcessor = !processor.equals(JAI.getDefaultInstance());
        try {
            GeneralEnvelope intersectionEnvelope = (GeneralEnvelope)parameters.parameter("Envelope").getValue();
            Boolean conserveEnvelope = (Boolean)parameters.parameter("ConserveEnvelope").getValue();
            GridGeometry2D croppedGeometry = CroppedCoverage2D.getCroppedGridGeometry(intersectionEnvelope, sourceCoverage, conserveEnvelope);
            if (croppedGeometry == null) {
                throw new CannotCropException(Errors.format(187));
            }
            GridRange croppedRange = croppedGeometry.getGridRange();
            int xAxis = croppedGeometry.gridDimensionX;
            int yAxis = croppedGeometry.gridDimensionY;
            double minX = croppedRange.getLower(xAxis);
            double minY = croppedRange.getLower(yAxis);
            double width = croppedRange.getLength(xAxis);
            double height = croppedRange.getLength(yAxis);
            ParameterBlock pbjCrop = new ParameterBlock();
            pbjCrop.addSource(sourceImage);
            pbjCrop.add(new Float(minX));
            pbjCrop.add(new Float(minY));
            pbjCrop.add(new Float(width));
            pbjCrop.add(new Float(height));
            RenderedOp croppedImage = !useProvidedProcessor ? JAI.create((String)"Crop", (ParameterBlock)pbjCrop, (RenderingHints)targetHints) : processor.createNS("Crop", pbjCrop, targetHints);
            CroppedCoverage2D gc = new CroppedCoverage2D(sourceCoverage.getName(), (PlanarImage)croppedImage, croppedGeometry, sourceCoverage, actionTaken);
            return gc;
        }
        catch (TransformException e) {
            throw new CannotCropException(Errors.format(187), e);
        }
        catch (NoninvertibleTransformException e) {
            throw new CannotCropException(Errors.format(187), e);
        }
    }

    private static GridGeometry2D getCroppedGridGeometry(GeneralEnvelope intersectionEnvelope, GridCoverage gridCoverage, boolean conserveEnvelope) throws NoninvertibleTransformException, TransformException {
        GridGeometry2D oldGG = (GridGeometry2D)gridCoverage.getGridGeometry();
        GeneralGridRange oldGR = (GeneralGridRange)oldGG.getGridRange();
        GeneralEnvelope oldEnvelope = (GeneralEnvelope)gridCoverage.getEnvelope();
        MathTransform2D oldMathTr = oldGG.getGridToCRS2D();
        double scaleFactor = XAffineTransform.getScale((AffineTransform)oldMathTr);
        if (intersectionEnvelope.isEmpty()) {
            return null;
        }
        if (intersectionEnvelope.equals(oldEnvelope, scaleFactor / 2.0, false)) {
            return new GridGeometry2D(oldGR, oldEnvelope);
        }
        AffineTransform gridToWorld = new AffineTransform((AffineTransform)oldMathTr);
        gridToWorld.translate(-0.5, -0.5);
        LinearTransform worldToGridTransform = ProjectiveTransform.create(gridToWorld.createInverse());
        GeneralEnvelope finalGridRange = CRSUtilities.transform(worldToGridTransform, intersectionEnvelope);
        finalGridRange.intersect(new GeneralEnvelope(oldGR.toRectangle()));
        GeneralGridRange newRange = new GeneralGridRange(finalGridRange);
        if (conserveEnvelope) {
            return new GridGeometry2D(newRange, intersectionEnvelope);
        }
        return new GridGeometry2D(newRange, (MathTransform)oldMathTr, gridCoverage.getCoordinateReferenceSystem());
    }
}

