/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.factory.Hints;
import org.geotools.resources.image.CoverageUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.ParameterValueGroup;

final class FilteredSubsampledGridCoverage2D
extends GridCoverage2D {
    private static final long serialVersionUID = 5274708130300017804L;

    FilteredSubsampledGridCoverage2D(PlanarImage image, GridCoverage2D sourceCoverage, int actionTaken) {
        super((CharSequence)sourceCoverage.getName(), image, new GridGeometry2D(new GeneralGridRange((RenderedImage)image), sourceCoverage.getEnvelope()), (GridSampleDimension[])(actionTaken == 1 ? null : sourceCoverage.getSampleDimensions().clone()), new GridCoverage[]{sourceCoverage}, sourceCoverage.getProperties());
    }

    static Coverage create(ParameterValueGroup parameters, Hints hints) {
        Integer scaleX = (Integer)parameters.parameter("scaleX").getValue();
        Integer scaleY = (Integer)parameters.parameter("scaleY").getValue();
        float[] qsFilter = (float[])parameters.parameter("qsFilterArray").getValue();
        Interpolation interpolation = (Interpolation)parameters.parameter("Interpolation").getValue();
        GridCoverage2D sourceCoverage = (GridCoverage2D)parameters.parameter("Source").getValue();
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        boolean isFilterPassEverything = qsFilter.length == 1 && qsFilter[0] == 1.0f;
        int actionTaken = CoverageUtilities.prepareSourcesForGCOperation(sourceCoverage, interpolation, !isFilterPassEverything, hints);
        switch (actionTaken) {
            case 2: {
                sourceCoverage = sourceCoverage.geophysics(true);
                sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceCoverage.getRenderedImage());
                break;
            }
            case 3: {
                sourceCoverage = sourceCoverage.geophysics(false);
                sourceImage = sourceCoverage.getRenderedImage();
            }
        }
        RenderingHints targetHints = ImageUtilities.getRenderingHints(sourceImage);
        if (targetHints == null) {
            targetHints = new RenderingHints(hints);
        } else if (hints != null) {
            targetHints.add(hints);
        }
        ImageLayout layout = (ImageLayout)targetHints.get(JAI.KEY_IMAGE_LAYOUT);
        if (layout != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        if (actionTaken != 1) {
            targetHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        } else {
            targetHints.add(ImageUtilities.REPLACE_INDEX_COLOR_MODEL);
            layout.unsetValid(512);
            layout.unsetValid(256);
        }
        ParameterBlock pbjFilteredSubsample = new ParameterBlock();
        pbjFilteredSubsample.addSource(sourceImage);
        pbjFilteredSubsample.add(scaleX).add(scaleY).add(qsFilter).add(interpolation).add(sourceImage);
        targetHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, parameters.parameter("BorderExtender").getValue()));
        targetHints.add(new RenderingHints(JAI.KEY_INTERPOLATION, interpolation));
        JAI processor = OperationJAI.getJAI(targetHints);
        FilteredSubsampledGridCoverage2D result = !processor.equals(JAI.getDefaultInstance()) ? new FilteredSubsampledGridCoverage2D((PlanarImage)processor.createNS("FilteredSubsample", pbjFilteredSubsample, targetHints), sourceCoverage, actionTaken) : new FilteredSubsampledGridCoverage2D((PlanarImage)JAI.create((String)"FilteredSubsample", (ParameterBlock)pbjFilteredSubsample, (RenderingHints)targetHints), sourceCoverage, actionTaken);
        if (actionTaken == 2) {
            return result.geophysics(false);
        }
        if (actionTaken == 3) {
            return result.geophysics(true);
        }
        return result;
    }
}

