/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import javax.media.jai.ImageLayout;
import javax.media.jai.NullOpImage;
import javax.media.jai.OpImage;
import org.geotools.coverage.FactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.factory.Hints;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.CoverageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.ParameterValueGroup;

abstract class IndexColorOperation
extends Operation2D {
    public IndexColorOperation(DefaultParameterDescriptorGroup descriptor) {
        super(descriptor);
    }

    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        GridCoverage2D source = (GridCoverage2D)parameters.parameter("Source").getValue();
        GridCoverage2D visual = source.geophysics(false);
        RenderedImage image = visual.getRenderedImage();
        GridSampleDimension[] bands = visual.getSampleDimensions();
        int visibleBand = CoverageUtilities.getVisibleBand(image);
        ColorModel model = image.getColorModel();
        boolean colorChanged = false;
        int numBands = bands.length;
        for (int i = 0; i < numBands; ++i) {
            ColorModel candidate;
            GridSampleDimension band = bands[i];
            ColorModel colorModel = candidate = i == visibleBand ? image.getColorModel() : band.getColorModel();
            if (!(candidate instanceof IndexColorModel)) {
                throw new IllegalArgumentException("Current implementation requires IndexColorModel");
            }
            IndexColorModel colors = (IndexColorModel)candidate;
            int mapSize = colors.getMapSize();
            int[] ARGB = new int[mapSize];
            colors.getRGBs(ARGB);
            band = this.transformColormap(ARGB, i, band, parameters);
            if (!bands[i].equals(band)) {
                bands[i] = band;
                colorChanged = true;
            } else if (!colorChanged) {
                int[] original = new int[mapSize];
                colors.getRGBs(original);
                colorChanged = Arrays.equals(original, ARGB);
            }
            if (i != visibleBand) continue;
            model = ColorUtilities.getIndexColorModel(ARGB, numBands, visibleBand);
        }
        if (!colorChanged) {
            return source;
        }
        int computeType = image instanceof OpImage ? ((OpImage)image).getOperationComputeType() : 1;
        ImageLayout layout = new ImageLayout().setColorModel(model);
        NullOpImage newImage = new NullOpImage(image, layout, null, computeType);
        GridCoverage2D target = FactoryFinder.getGridCoverageFactory(null).create((CharSequence)visual.getName(), (RenderedImage)newImage, visual.getCoordinateReferenceSystem2D(), visual.getGridGeometry().getGridToCoordinateSystem(), bands, new GridCoverage[]{visual}, null);
        if (source != visual) {
            return target.geophysics(true);
        }
        return target;
    }

    protected abstract GridSampleDimension transformColormap(int[] var1, int var2, GridSampleDimension var3, ParameterValueGroup var4);
}

