/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import [Ljava.util.Map;;
import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.processing.operation.IndexColorOperation;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.util.NumberRange;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

public final class Recolor
extends IndexColorOperation {
    public static final ParameterDescriptor COLOR_MAPS = new DefaultParameterDescriptor(Citations.GEOTOOLS, "ColorMaps", Map;.class, null, new Map[]{Collections.singletonMap(null, new Color[]{new Color(16, 16, 16), new Color(240, 240, 240)})}, null, null, null, true);

    public Recolor() {
        super(new DefaultParameterDescriptorGroup(Citations.GEOTOOLS, "Recolor", (GeneralParameterDescriptor[])new ParameterDescriptor[]{SOURCE_0, COLOR_MAPS}));
    }

    protected GridSampleDimension transformColormap(int[] ARGB, int band, GridSampleDimension sampleDimension, ParameterValueGroup parameters) {
        Map[] colorMaps = (Map[])parameters.parameter("ColorMaps").getValue();
        if (colorMaps == null || colorMaps.length == 0) {
            return sampleDimension;
        }
        boolean changed = false;
        Map colorMap = colorMaps[Math.min(band, colorMaps.length - 1)];
        Category[] categories = (Category[])sampleDimension.getCategories().toArray();
        int j = categories.length;
        while (--j >= 0) {
            Category category = categories[j];
            InternationalString name = category.getName();
            Color[] colors = (Color[])colorMap.get(name);
            if (colors == null && (colors = (Color[])colorMap.get(name.toString(null))) == null && (!category.isQuantitative() || (colors = (Color[])colorMap.get(null)) == null)) continue;
            NumberRange range = category.getRange();
            int lower = ((Number)((Object)range.getMinValue())).intValue();
            int upper = ((Number)((Object)range.getMaxValue())).intValue();
            if (!range.isMinIncluded()) {
                ++lower;
            }
            if (range.isMaxIncluded()) {
                ++upper;
            }
            ColorUtilities.expand(colors, ARGB, lower, upper);
            if (categories[j].equals(category = category.recolor(colors))) continue;
            categories[j] = category;
            changed = true;
        }
        return changed ? new GridSampleDimension((CharSequence)sampleDimension.getDescription(), categories, sampleDimension.getUnits()) : sampleDimension;
    }
}

