/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.util.Map;
import javax.media.jai.Interpolation;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CannotReprojectException;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.coverage.processing.operation.Resampler2D;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class Resample
extends Operation2D {
    private static final long serialVersionUID = -2022393087647420577L;
    public static final ParameterDescriptor INTERPOLATION_TYPE = new DefaultParameterDescriptor(Citations.OGC, "InterpolationType", Object.class, null, "NearestNeighbor", null, null, null, false);
    public static final ParameterDescriptor COORDINATE_REFERENCE_SYSTEM = new DefaultParameterDescriptor(Citations.OGC, "CoordinateReferenceSystem", CoordinateReferenceSystem.class, null, null, null, null, null, false);
    public static final ParameterDescriptor GRID_GEOMETRY = new DefaultParameterDescriptor(Citations.OGC, "GridGeometry", GridGeometry2D.class, null, null, null, null, null, false);

    public Resample() {
        super(new DefaultParameterDescriptorGroup(Citations.OGC, "Resample", (GeneralParameterDescriptor[])new ParameterDescriptor[]{SOURCE_0, INTERPOLATION_TYPE, COORDINATE_REFERENCE_SYSTEM, GRID_GEOMETRY}));
    }

    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        GridCoverage2D coverage;
        GridCoverage2D source = (GridCoverage2D)parameters.parameter("Source").getValue();
        Interpolation interp = ImageUtilities.toInterpolation(parameters.parameter("InterpolationType").getValue());
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)parameters.parameter("CoordinateReferenceSystem").getValue();
        GridGeometry2D gridGeom = (GridGeometry2D)parameters.parameter("GridGeometry").getValue();
        if (crs == null) {
            crs = source.getCoordinateReferenceSystem();
        }
        try {
            coverage = Resampler2D.reproject(source, crs, gridGeom, interp, hints instanceof Hints ? hints : new Hints((Map)hints));
        }
        catch (FactoryException exception) {
            throw new CannotReprojectException(Errors.format(25, source.getName()), exception);
        }
        catch (TransformException exception) {
            throw new CannotReprojectException(Errors.format(25, source.getName()), exception);
        }
        return coverage;
    }
}

