/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.AbstractProcessor;
import org.geotools.coverage.processing.CannotReprojectException;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.WarpTransform2D;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.geotools.resources.image.CoverageUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.grid.GridRange;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

final class Resampler2D
extends GridCoverage2D {
    private static final long serialVersionUID = 9041232489182064339L;
    private static final Level LOGGING_LEVEL;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Resampler2D(GridCoverage2D source, PlanarImage image, GridGeometry2D geometry, GridSampleDimension[] sampleDimensions) {
        super((CharSequence)source.getName(), image, geometry, sampleDimensions, new GridCoverage2D[]{source}, null);
    }

    public static GridCoverage2D reproject(GridCoverage2D sourceCoverage, CoordinateReferenceSystem targetCRS, GridGeometry2D targetGG, Interpolation interpolation, Hints hints) throws FactoryException, TransformException {
        LinearTransform allSteps;
        boolean sameCRS;
        CoordinateReferenceSystem sourceCRS;
        GridGeometry2D sourceGG;
        int actionTaken = 0;
        if (targetGG != null && !targetGG.isDefined(4) && !targetGG.isDefined(8)) {
            targetGG = null;
        }
        boolean automaticGG = targetGG == null;
        boolean automaticGR = automaticGG || !targetGG.isDefined(4);
        while (true) {
            sourceGG = (GridGeometry2D)sourceCoverage.getGridGeometry();
            sourceCRS = sourceCoverage.getCoordinateReferenceSystem();
            if (targetCRS == null) {
                targetCRS = sourceCRS;
            }
            boolean sameGG = targetGG == null || Resampler2D.equivalent(targetGG, sourceGG);
            sameCRS = CRS.equalsIgnoreMetadata(targetCRS, sourceCRS);
            if (sameGG && sameCRS) {
                return sourceCoverage;
            }
            if (!(sourceCoverage instanceof Resampler2D)) break;
            List sources = sourceCoverage.getSources();
            if (sources.size() != 1) {
                throw new AssertionError(sources);
            }
            sourceCoverage = (GridCoverage2D)sources.get(0);
        }
        PlanarImage sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceCoverage.getRenderedImage());
        actionTaken = CoverageUtilities.prepareSourcesForGCOperation(sourceCoverage, interpolation, false, hints);
        ParameterBlock paramBlk = new ParameterBlock();
        switch (actionTaken) {
            case 1: {
                sourceImage = new ImageWorker((RenderedImage)sourceImage).forceComponentColorModel().getPlanarImage();
                break;
            }
            case 2: {
                sourceCoverage = sourceCoverage.geophysics(true);
                sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceCoverage.getRenderedImage());
                break;
            }
            case 3: {
                sourceCoverage = sourceCoverage.geophysics(false);
            }
        }
        paramBlk.addSource(sourceImage);
        RenderingHints targetHints = ImageUtilities.getRenderingHints((RenderedImage)sourceImage);
        if (targetHints == null) {
            targetHints = new RenderingHints(hints);
        } else if (hints != null) {
            targetHints.add(hints);
        }
        Object property = hints != null ? hints.get(Hints.JAI_INSTANCE) : null;
        JAI processor = property instanceof JAI ? (JAI)property : JAI.getDefaultInstance();
        CoordinateOperationFactory factory = FactoryFinder.getCoordinateOperationFactory(hints);
        MathTransformFactory mtFactory = FactoryFinder.getMathTransformFactory(hints);
        if (sameCRS) {
            if (!targetGG.isDefined(8)) {
                MathTransform step1 = sourceGG.getGridToCRS();
                LinearTransform step2 = IdentityTransform.create(step1.getTargetDimensions());
                MathTransform step3 = step1.inverse();
                allSteps = IdentityTransform.create(step1.getSourceDimensions());
                targetGG = new GridGeometry2D(targetGG.getGridRange(), step1, targetCRS);
            } else {
                MathTransform step1 = targetGG.getGridToCRS();
                LinearTransform step2 = IdentityTransform.create(step1.getTargetDimensions());
                MathTransform step3 = sourceGG.getGridToCRS().inverse();
                allSteps = mtFactory.createConcatenatedTransform(step1, step3);
                if (!targetGG.isDefined(4)) {
                    Envelope gridRange = Resampler2D.toEnvelope(sourceGG.getGridRange());
                    gridRange = CRSUtilities.transform(allSteps.inverse(), gridRange);
                    targetGG = new GridGeometry2D(new GeneralGridRange(gridRange), step1, targetCRS);
                }
            }
        } else {
            MathTransform step1;
            if (sourceCRS == null) {
                throw new CannotReprojectException(Errors.format(140));
            }
            MathTransform step2 = factory.createOperation(targetCRS, sourceCRS).getMathTransform();
            MathTransform step3 = sourceGG.getGridToCRS().inverse();
            Envelope sourceEnvelope = sourceCoverage.getEnvelope();
            GeneralEnvelope targetEnvelope = CRSUtilities.transform(step2.inverse(), sourceEnvelope);
            targetEnvelope.setCoordinateReferenceSystem(targetCRS);
            if (targetGG == null) {
                targetGG = new GridGeometry2D(sourceGG.getGridRange(), targetEnvelope);
                step1 = targetGG.getGridToCRS();
            } else if (!targetGG.isDefined(8)) {
                targetGG = new GridGeometry2D(targetGG.getGridRange(), targetEnvelope);
                step1 = targetGG.getGridToCRS();
            } else {
                step1 = targetGG.getGridToCRS();
                if (!targetGG.isDefined(4)) {
                    GeneralEnvelope gridRange = CRSUtilities.transform(step1.inverse(), targetEnvelope);
                    int i = gridRange.getDimension();
                    while (--i >= 0) {
                        gridRange.setRange(i, gridRange.getMinimum(i) + 0.5, gridRange.getMaximum(i) + 0.5);
                    }
                    targetGG = new GridGeometry2D(new GeneralGridRange(gridRange), step1, targetCRS);
                }
            }
            allSteps = step1.equals(step3.inverse()) ? step2 : mtFactory.createConcatenatedTransform(mtFactory.createConcatenatedTransform(step1, step2), step3);
        }
        MathTransform2D allSteps2D = Resampler2D.getMathTransform2D(allSteps, mtFactory, targetGG);
        if (!(allSteps2D instanceof MathTransform2D)) {
            throw new TransformException(Errors.format(101));
        }
        GridRange targetGR = targetGG.getGridRange();
        int xAxis = targetGG.gridDimensionX;
        int yAxis = targetGG.gridDimensionY;
        int xmin = targetGR.getLower(xAxis);
        int xmax = targetGR.getUpper(xAxis);
        int ymin = targetGR.getLower(yAxis);
        int ymax = targetGR.getUpper(yAxis);
        GridRange sourceGR = sourceGG.getGridRange();
        int xminS = sourceGR.getLower(xAxis);
        int xmaxS = sourceGR.getUpper(xAxis);
        int yminS = sourceGR.getLower(yAxis);
        int ymaxS = sourceGR.getUpper(yAxis);
        ImageLayout layout = (ImageLayout)targetHints.get(JAI.KEY_IMAGE_LAYOUT);
        if (layout != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout((RenderedImage)sourceImage);
            layout.unsetImageBounds();
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF) == 0) {
            layout.setMinX(targetGR.getLower(xAxis));
            layout.setMinY(targetGR.getLower(yAxis));
            layout.setWidth(targetGR.getLength(xAxis));
            layout.setHeight(targetGR.getLength(yAxis));
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX((RenderedImage)sourceImage));
            layout.setTileGridYOffset(layout.getMinY((RenderedImage)sourceImage));
            int width = layout.getWidth((RenderedImage)sourceImage);
            int height = layout.getHeight((RenderedImage)sourceImage);
            if (layout.getTileWidth((RenderedImage)sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight((RenderedImage)sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        if (actionTaken != 1) {
            targetHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        } else {
            targetHints.add(ImageUtilities.REPLACE_INDEX_COLOR_MODEL);
            layout.unsetValid(512);
            layout.unsetValid(256);
        }
        String operation = null;
        if (allSteps instanceof AffineTransform && XAffineTransform.isIdentity((AffineTransform)((Object)allSteps), 0.1) || allSteps.isIdentity()) {
            if (xmin > xminS && xmax < xmaxS && ymin > yminS && ymax < ymaxS) {
                operation = "Crop";
                paramBlk = paramBlk.add((float)xmin).add((float)ymin).add((float)(xmax - xmin)).add((float)(ymax - ymin));
            } else if (xmin == xminS && xmax == xmaxS && ymin == yminS && ymax == ymaxS) {
                GridCoverage2D targetCoverage = new Resampler2D(sourceCoverage, sourceImage, targetGG, actionTaken == 1 ? null : sourceCoverage.getSampleDimensions());
                if (actionTaken == 3) {
                    targetCoverage = targetCoverage.geophysics(true);
                } else if (actionTaken == 2) {
                    targetCoverage = targetCoverage.geophysics(false);
                }
                return targetCoverage;
            }
        }
        double[] background = null;
        if (operation == null) {
            if (allSteps instanceof AffineTransform && (automaticGG || automaticGR)) {
                if (automaticGG) {
                    background = null;
                    MathTransform mtr = sourceGG.getGridToCRS();
                    mtr = mtFactory.createConcatenatedTransform(mtr, allSteps.inverse());
                    targetGG = new GridGeometry2D(sourceGG.getGridRange(), mtr, targetCRS);
                    GridCoverage2D targetCoverage = new Resampler2D(sourceCoverage, sourceImage, targetGG, actionTaken == 1 ? null : sourceCoverage.getSampleDimensions());
                    if (actionTaken == 3) {
                        targetCoverage = targetCoverage.geophysics(true);
                    } else if (actionTaken == 2) {
                        targetCoverage = targetCoverage.geophysics(false);
                    }
                    return targetCoverage;
                }
                if (automaticGR) {
                    operation = "Affine";
                    background = CoverageUtilities.getBackgroundValues(sourceCoverage);
                    AffineTransform affine = (AffineTransform)allSteps.inverse();
                    paramBlk = paramBlk.add(affine).add(interpolation).add(background);
                }
            } else {
                operation = "Warp";
                Warp warp = WarpTransform2D.getWarp((CharSequence)sourceCoverage.getName(), allSteps2D);
                background = CoverageUtilities.getBackgroundValues(sourceCoverage);
                paramBlk = paramBlk.add(warp).add(interpolation).add(background);
            }
        }
        RenderedOp targetImage = processor.createNS(operation, paramBlk, targetHints);
        Locale locale = sourceCoverage.getLocale();
        int[] lower = targetGR.getLower().getCoordinateValues();
        int[] upper = targetGR.getUpper().getCoordinateValues();
        lower[xAxis] = targetImage.getMinX();
        lower[yAxis] = targetImage.getMinY();
        upper[xAxis] = targetImage.getMaxX();
        upper[yAxis] = targetImage.getMaxY();
        GeneralGridRange actualGR = new GeneralGridRange(lower, upper);
        if (!targetGR.equals(actualGR)) {
            MathTransform gridToCRS = targetGG.getGridToCRS();
            targetGG = new GridGeometry2D(actualGR, gridToCRS, targetCRS);
            if (!automaticGR) {
                Resampler2D.log(Logging.getResources(locale).getLogRecord(Level.WARNING, 0, sourceCoverage.getName().toString(locale)));
            }
        }
        GridCoverage2D targetCoverage = new Resampler2D(sourceCoverage, (PlanarImage)targetImage, targetGG, actionTaken == 1 ? null : sourceCoverage.getSampleDimensions());
        if (actionTaken == 3) {
            targetCoverage = targetCoverage.geophysics(true);
        } else if (actionTaken == 2) {
            targetCoverage = targetCoverage.geophysics(false);
        }
        if (!$assertionsDisabled && !CRS.equalsIgnoreMetadata(targetCoverage.getCoordinateReferenceSystem(), targetCRS)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((GridGeometry2D)targetCoverage.getGridGeometry()).getGridRange2D().equals(targetImage.getBounds())) {
            throw new AssertionError(targetGG);
        }
        if (AbstractProcessor.LOGGER.isLoggable(LOGGING_LEVEL)) {
            Object[] objectArray = new Object[11];
            objectArray[0] = sourceCoverage.getName().toString(locale);
            objectArray[1] = sourceCoverage.getCoordinateReferenceSystem().getName().getCode();
            objectArray[2] = new Integer(sourceImage.getWidth());
            objectArray[3] = new Integer(sourceImage.getHeight());
            objectArray[4] = targetCoverage.getCoordinateReferenceSystem().getName().getCode();
            objectArray[5] = new Integer(targetImage.getWidth());
            objectArray[6] = new Integer(targetImage.getHeight());
            objectArray[7] = targetImage.getOperationName();
            objectArray[8] = new Integer(sourceCoverage == sourceCoverage.geophysics(true) ? 1 : 0);
            objectArray[9] = ImageUtilities.getInterpolationName(interpolation);
            objectArray[10] = background != null ? (background.length == 1 ? (Double.isNaN(background[0]) ? "NaN" : new Double(background[0])) : XArray.toString(background, locale)) : "No background used";
            Resampler2D.log(Logging.getResources(locale).getLogRecord(LOGGING_LEVEL, 3, objectArray));
        }
        return targetCoverage;
    }

    private static MathTransform2D getMathTransform2D(MathTransform transform, MathTransformFactory mtFactory, GridGeometry2D sourceGG) throws FactoryException {
        DimensionFilter filter = new DimensionFilter(mtFactory);
        filter.addSourceDimension(sourceGG.axisDimensionX);
        filter.addSourceDimension(sourceGG.axisDimensionY);
        MathTransform candidate = filter.separate(transform);
        if (candidate instanceof MathTransform2D) {
            return (MathTransform2D)candidate;
        }
        filter.addTargetDimension(sourceGG.axisDimensionX);
        filter.addTargetDimension(sourceGG.axisDimensionY);
        candidate = filter.separate(transform);
        if (candidate instanceof MathTransform2D) {
            return (MathTransform2D)candidate;
        }
        throw new FactoryException(Errors.format(101));
    }

    private static boolean equivalent(GridGeometry2D geom1, GridGeometry2D geom2) {
        if (geom1.equals(geom2)) {
            return true;
        }
        if (geom1.isDefined(4) && geom2.isDefined(4) && !geom1.getGridRange().equals(geom2.getGridRange())) {
            return false;
        }
        return !geom1.isDefined(8) || !geom2.isDefined(8) || geom1.getGridToCRS().equals(geom2.getGridToCRS());
    }

    private static Envelope toEnvelope(GridRange gridRange) {
        int dimension = gridRange.getDimension();
        double[] lower = new double[dimension];
        double[] upper = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            lower[i] = gridRange.getLower(i);
            upper[i] = gridRange.getUpper(i);
        }
        return new GeneralEnvelope(lower, upper);
    }

    static void log(LogRecord record) {
        record.setSourceClassName("Resample");
        record.setSourceMethodName("doOperation");
        AbstractProcessor.LOGGER.log(record);
    }

    static {
        $assertionsDisabled = !Resampler2D.class.desiredAssertionStatus();
        LOGGING_LEVEL = Level.FINE;
    }
}

