/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.factory.Hints;
import org.geotools.image.jai.Registry;
import org.geotools.resources.image.CoverageUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.ParameterValueGroup;

final class ScaledGridCoverage2D
extends GridCoverage2D {
    private static final long serialVersionUID = 2521916272257997635L;
    private static final int[] lock = new int[1];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Coverage create(ParameterValueGroup parameters, Hints hints) throws NoninvertibleTransformException {
        RenderedOp image;
        Float xScale = (Float)parameters.parameter("xScale").getValue();
        Float yScale = (Float)parameters.parameter("yScale").getValue();
        Float xTrans = (Float)parameters.parameter("xTrans").getValue();
        Float yTrans = (Float)parameters.parameter("yTrans").getValue();
        Interpolation interpolation = (Interpolation)parameters.parameter("Interpolation").getValue();
        GridCoverage2D sourceCoverage = (GridCoverage2D)parameters.parameter("Source").getValue();
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        int actionTaken = CoverageUtilities.prepareSourcesForGCOperation(sourceCoverage, interpolation, false, hints);
        switch (actionTaken) {
            case 1: {
                break;
            }
            case 2: {
                sourceCoverage = sourceCoverage.geophysics(true);
                sourceImage = sourceCoverage.getRenderedImage();
                break;
            }
            case 3: {
                sourceCoverage = sourceCoverage.geophysics(false);
                sourceImage = sourceCoverage.getRenderedImage();
            }
        }
        RenderingHints targetHints = ImageUtilities.getRenderingHints(sourceImage);
        if (targetHints == null) {
            targetHints = new RenderingHints(hints);
        } else if (hints != null) {
            targetHints.add(hints);
        }
        ImageLayout layout = (ImageLayout)targetHints.get(JAI.KEY_IMAGE_LAYOUT);
        if (layout != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        Object be = parameters.parameter("BorderExtender").getValue();
        if (be != null) {
            targetHints.put(JAI.KEY_BORDER_EXTENDER, be);
        }
        if (actionTaken != 1) {
            targetHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        } else {
            targetHints.add(ImageUtilities.REPLACE_INDEX_COLOR_MODEL);
            layout.unsetValid(512);
            layout.unsetValid(256);
        }
        int transferType = sourceImage.getSampleModel().getDataType();
        ParameterBlock pbjScale = new ParameterBlock();
        pbjScale.add(xScale);
        pbjScale.add(yScale);
        pbjScale.add(xTrans);
        pbjScale.add(yTrans);
        pbjScale.add(interpolation);
        pbjScale.addSource(sourceImage);
        JAI processor = OperationJAI.getJAI(targetHints);
        if (!(interpolation instanceof InterpolationNearest || transferType != 4 && transferType != 5)) {
            int[] nArray = lock;
            synchronized (lock) {
                Registry.setNativeAccelerationAllowed("Scale", false);
                image = !processor.equals(JAI.getDefaultInstance()) ? OperationJAI.getJAI(targetHints).createNS("Scale", pbjScale, targetHints).getRendering() : JAI.create((String)"Scale", (ParameterBlock)pbjScale, (RenderingHints)targetHints).getRendering();
                Registry.setNativeAccelerationAllowed("Scale", true);
                // ** MonitorExit[var17_17] (shouldn't be in output)
            }
        } else {
            image = !processor.equals(JAI.getDefaultInstance()) ? OperationJAI.getJAI(targetHints).createNS("Scale", pbjScale, targetHints) : JAI.create((String)"Scale", (ParameterBlock)pbjScale, (RenderingHints)targetHints);
        }
        {
            ScaledGridCoverage2D result = !processor.equals(JAI.getDefaultInstance()) ? new ScaledGridCoverage2D((PlanarImage)image, sourceCoverage, actionTaken) : new ScaledGridCoverage2D((PlanarImage)image, sourceCoverage, actionTaken);
            if (actionTaken == 2) {
                return result.geophysics(false);
            }
            if (actionTaken == 3) {
                return result.geophysics(true);
            }
            return result;
        }
    }

    private ScaledGridCoverage2D(PlanarImage image, GridCoverage2D sourceCoverage, int actionTaken) {
        super((CharSequence)sourceCoverage.getName(), image, new GridGeometry2D(new GeneralGridRange((RenderedImage)image), sourceCoverage.getEnvelope()), (GridSampleDimension[])(actionTaken == 1 ? null : sourceCoverage.getSampleDimensions().clone()), new GridCoverage[]{sourceCoverage}, sourceCoverage.getProperties());
    }
}

