/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.factory.Hints;
import org.geotools.resources.image.CoverageUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.ParameterValueGroup;

final class SubsampleAveragedCoverage
extends GridCoverage2D {
    private static final long serialVersionUID = 5274708130300017804L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private SubsampleAveragedCoverage(PlanarImage image, GridCoverage2D sourceCoverage, int actionTaken) {
        super((CharSequence)sourceCoverage.getName(), image, new GridGeometry2D(new GeneralGridRange((RenderedImage)image), sourceCoverage.getEnvelope()), (GridSampleDimension[])(actionTaken == 1 ? null : sourceCoverage.getSampleDimensions().clone()), new GridCoverage[]{sourceCoverage}, sourceCoverage.getProperties());
    }

    static Coverage create(ParameterValueGroup parameters, Hints hints) {
        Double scaleX = (Double)parameters.parameter("scaleX").getValue();
        Double scaleY = (Double)parameters.parameter("scaleY").getValue();
        Interpolation interpolation = (Interpolation)parameters.parameter("Interpolation").getValue();
        GridCoverage2D sourceCoverage = (GridCoverage2D)parameters.parameter("Source").getValue();
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        int actionTaken = CoverageUtilities.prepareSourcesForGCOperation(sourceCoverage, interpolation, true, hints);
        switch (actionTaken) {
            case 2: {
                sourceCoverage = sourceCoverage.geophysics(true);
                sourceImage = sourceCoverage.getRenderedImage();
                break;
            }
            case 3: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        RenderingHints targetHints = ImageUtilities.getRenderingHints(sourceImage);
        if (targetHints == null) {
            targetHints = new RenderingHints(hints);
        } else if (hints != null) {
            targetHints.add(hints);
        }
        ImageLayout layout = (ImageLayout)targetHints.get(JAI.KEY_IMAGE_LAYOUT);
        if (layout != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        if (actionTaken != 1) {
            targetHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        } else {
            targetHints.add(ImageUtilities.REPLACE_INDEX_COLOR_MODEL);
            layout.unsetValid(512);
            layout.unsetValid(256);
        }
        ParameterBlock pbjSubsampleAverage = new ParameterBlock();
        pbjSubsampleAverage.addSource(sourceImage);
        pbjSubsampleAverage.add(scaleX).add(scaleY).add(interpolation).add(sourceImage);
        targetHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, parameters.parameter("BorderExtender").getValue()));
        targetHints.add(new RenderingHints(JAI.KEY_INTERPOLATION, interpolation));
        JAI processor = OperationJAI.getJAI(targetHints);
        SubsampleAveragedCoverage result = !processor.equals(JAI.getDefaultInstance()) ? new SubsampleAveragedCoverage((PlanarImage)processor.createNS("SubsampleAverage", pbjSubsampleAverage, targetHints), sourceCoverage, actionTaken) : new SubsampleAveragedCoverage((PlanarImage)JAI.create((String)"SubsampleAverage", (ParameterBlock)pbjSubsampleAverage, (RenderingHints)targetHints), sourceCoverage, actionTaken);
        if (actionTaken == 2) {
            return result.geophysics(false);
        }
        return result;
    }

    static {
        $assertionsDisabled = !SubsampleAveragedCoverage.class.desiredAssertionStatus();
    }
}

