/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image;

import com.sun.media.imageioimpl.plugins.gif.GIFImageWriter;
import com.sun.media.imageioimpl.plugins.gif.GIFImageWriterSpi;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.ColorCube;
import javax.media.jai.IHSColorSpace;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.AddConstDescriptor;
import javax.media.jai.operator.AddDescriptor;
import javax.media.jai.operator.AndDescriptor;
import javax.media.jai.operator.BandCombineDescriptor;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.BinarizeDescriptor;
import javax.media.jai.operator.ColorConvertDescriptor;
import javax.media.jai.operator.ErrorDiffusionDescriptor;
import javax.media.jai.operator.ExtremaDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.InvertDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.MultiplyConstDescriptor;
import javax.media.jai.operator.MultiplyDescriptor;
import javax.media.jai.operator.NotDescriptor;
import javax.media.jai.operator.NullDescriptor;
import javax.media.jai.operator.OrderedDitherDescriptor;
import javax.media.jai.operator.RescaleDescriptor;
import javax.media.jai.operator.XorConstDescriptor;
import org.geotools.factory.Hints;
import org.geotools.resources.Arguments;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.ImageUtilities;

public class ImageWorker {
    private static final Logger LOGGER;
    public static final Hints.Key TILING_ALLOWED;
    private static final String EXTREMA = "extrema";
    private RenderedImage inheritanceStopPoint;
    protected RenderedImage image;
    private ROI roi;
    private RenderingHints commonHints;
    private int tileCacheDisabled = 0;
    private static final GIFImageWriterSpi gifSPI;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$javax$imageio$stream$ImageOutputStream;

    public ImageWorker(RenderedImage image) {
        this.inheritanceStopPoint = this.image = image;
    }

    public final ImageWorker setImage(RenderedImage image) {
        this.inheritanceStopPoint = this.image = image;
        return this;
    }

    public static PlanarImage loadPlanarImageImage(String source, RenderingHints hints, int imageChoice, boolean readMetadata) {
        ParameterBlockJAI pbj = new ParameterBlockJAI("ImageRead");
        pbj.setParameter("Input", (Object)source);
        pbj.setParameter("ImageChoice", (Object)new Integer(imageChoice));
        pbj.setParameter("ReadMetadata", (Object)new Boolean(readMetadata));
        pbj.setParameter("VerifyInput", (Object)Boolean.TRUE);
        return JAI.create((String)"ImageRead", (ParameterBlock)pbj, (RenderingHints)hints).createInstance();
    }

    public ImageWorker(File input) throws IOException {
        this(ImageIO.read(input));
    }

    public ImageWorker() {
        this.image = null;
        this.inheritanceStopPoint = null;
    }

    private ImageWorker fork(RenderedImage image) {
        ImageWorker worker = new ImageWorker(image);
        if (this.commonHints != null && !this.commonHints.isEmpty()) {
            worker.commonHints = new RenderingHints(this.commonHints);
        }
        return worker;
    }

    public final RenderedImage getRenderedImage() {
        return this.image;
    }

    public final PlanarImage getPlanarImage() {
        return PlanarImage.wrapRenderedImage((RenderedImage)this.getRenderedImage());
    }

    public final RenderedOp getRenderedOperation() {
        RenderedImage image = this.getRenderedImage();
        if (image instanceof RenderedOp) {
            return (RenderedOp)image;
        }
        return NullDescriptor.create((RenderedImage)image, (RenderingHints)this.getRenderingHints());
    }

    public final ROI getImageAsROI() {
        this.binarize();
        return new ROI(this.getRenderedImage());
    }

    public final ROI getROI() {
        return this.roi;
    }

    public final ImageWorker setROI(ROI roi) {
        this.roi = roi;
        this.invalidateStatistics();
        return this;
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.commonHints != null ? this.commonHints.get(key) : null;
    }

    public final ImageWorker setRenderingHint(RenderingHints.Key key, Object value) {
        if (this.commonHints == null) {
            this.commonHints = new RenderingHints(null);
        }
        this.commonHints.add(new RenderingHints(key, value));
        return this;
    }

    public final ImageWorker removeRenderingHint(RenderingHints.Key key) {
        if (this.commonHints != null) {
            this.commonHints.remove(key);
        }
        return this;
    }

    public final RenderingHints getRenderingHints() {
        RenderingHints hints = ImageUtilities.getRenderingHints(this.image);
        if (hints == null) {
            hints = new RenderingHints(this.commonHints);
        } else if (this.commonHints != null) {
            hints.putAll((Map<?, ?>)this.commonHints);
        }
        if (Boolean.FALSE.equals(hints.get(TILING_ALLOWED))) {
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            if (this.commonHints == null || layout != this.commonHints.get(JAI.KEY_IMAGE_LAYOUT)) {
                layout.setTileWidth(this.image.getWidth());
                layout.setTileHeight(this.image.getHeight());
                layout.setTileGridXOffset(this.image.getMinX());
                layout.setTileGridYOffset(this.image.getMinY());
                hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            }
        }
        if (this.tileCacheDisabled != 0 && this.commonHints != null && !this.commonHints.containsKey(JAI.KEY_TILE_CACHE)) {
            hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, null));
        }
        return hints;
    }

    private final RenderingHints getRenderingHints(int type) {
        RenderingHints hints = this.getRenderingHints();
        ImageLayout layout = ImageWorker.getImageLayout(hints);
        if (layout.isValid(512)) {
            return hints;
        }
        ColorModel oldCm = this.image.getColorModel();
        ComponentColorModel newCm = new ComponentColorModel(oldCm.getColorSpace(), oldCm.hasAlpha(), oldCm.isAlphaPremultiplied(), oldCm.getTransparency(), type);
        layout.setColorModel((ColorModel)newCm);
        layout.setSampleModel(((ColorModel)newCm).createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight()));
        hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        return hints;
    }

    private static ImageLayout getImageLayout(RenderingHints hints) {
        Object candidate = hints.get(JAI.KEY_IMAGE_LAYOUT);
        if (candidate instanceof ImageLayout) {
            return (ImageLayout)candidate;
        }
        return new ImageLayout();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageWorker tileCacheEnabled(boolean status) {
        if (status) {
            if (this.tileCacheDisabled == 0) throw new IllegalStateException();
            --this.tileCacheDisabled;
            return this;
        } else {
            ++this.tileCacheDisabled;
        }
        return this;
    }

    public final int getNumBands() {
        return this.image.getSampleModel().getNumBands();
    }

    public final int getTransparentPixel() {
        ColorModel cm = this.image.getColorModel();
        return cm instanceof IndexColorModel ? ((IndexColorModel)cm).getTransparentPixel() : -1;
    }

    private Object getComputedProperty(String name) {
        Object value = this.image.getProperty(name);
        return value == this.inheritanceStopPoint.getProperty(name) ? Image.UndefinedProperty : value;
    }

    private double[][] getExtremas() {
        Object extrema = this.getComputedProperty(EXTREMA);
        if (!(extrema instanceof double[][])) {
            Integer ONE = new Integer(1);
            this.image = ExtremaDescriptor.create((RenderedImage)this.image, (ROI)this.roi, (Integer)ONE, (Integer)ONE, null, (Integer)ONE, (RenderingHints)this.getRenderingHints());
            extrema = this.getComputedProperty(EXTREMA);
        }
        return (double[][])extrema;
    }

    private ImageWorker invalidateStatistics() {
        this.inheritanceStopPoint = this.image;
        return this;
    }

    public final double[] getMinimums() {
        return this.getExtremas()[0];
    }

    public double[] getMaximums() {
        return this.getExtremas()[1];
    }

    public final boolean isBytes() {
        return this.image.getSampleModel().getDataType() == 0;
    }

    public final boolean isBinary() {
        return ImageUtil.isBinary((SampleModel)this.image.getSampleModel());
    }

    public final boolean isIndexed() {
        return this.image.getColorModel() instanceof IndexColorModel;
    }

    public final boolean isColorSpaceRGB() {
        return this.image.getColorModel().getColorSpace().getType() == 5;
    }

    public final boolean isColorSpaceGRAYScale() {
        return this.image.getColorModel().getColorSpace().getType() == 6;
    }

    public final boolean isTranslucent() {
        return this.image.getColorModel().getTransparency() == 3;
    }

    public final ImageWorker rescaleToBytes() {
        if (this.isBytes()) {
            return this;
        }
        if (this.isIndexed()) {
            throw new UnsupportedOperationException("Rescaling not yet implemented for IndexColorModel.");
        }
        double[][] extrema = this.getExtremas();
        int length = extrema[0].length;
        double[] scale = new double[length];
        double[] offset = new double[length];
        for (int i = 0; i < length; ++i) {
            double delta = extrema[1][i] - extrema[0][i];
            scale[i] = 255.0 / delta;
            offset[i] = -scale[i] * extrema[0][i];
        }
        RenderingHints hints = this.getRenderingHints(0);
        this.image = RescaleDescriptor.create((RenderedImage)this.image, (double[])scale, (double[])offset, (RenderingHints)hints);
        this.invalidateStatistics();
        if (!$assertionsDisabled && !this.isBytes()) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker forceIndexColorModel(boolean error) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            return this;
        }
        this.tileCacheEnabled(false);
        if (this.getNumBands() % 2 == 0) {
            this.retainBands(this.getNumBands() - 1);
        }
        this.forceColorSpaceRGB();
        RenderingHints hints = this.getRenderingHints();
        if (error) {
            KernelJAI ditherMask = KernelJAI.ERROR_FILTER_FLOYD_STEINBERG;
            ColorCube colorMap = ColorCube.BYTE_496;
            this.image = ErrorDiffusionDescriptor.create((RenderedImage)this.image, (LookupTableJAI)colorMap, (KernelJAI)ditherMask, (RenderingHints)hints);
        } else {
            KernelJAI[] ditherMask = KernelJAI.DITHER_MASK_443;
            ColorCube colorMap = ColorCube.BYTE_496;
            this.image = OrderedDitherDescriptor.create((RenderedImage)this.image, (ColorCube)colorMap, (KernelJAI[])ditherMask, (RenderingHints)hints);
        }
        this.tileCacheEnabled(true);
        this.invalidateStatistics();
        if (!$assertionsDisabled && !this.isIndexed()) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker forceBitmaskIndexColorModel() {
        this.forceBitmaskIndexColorModel(this.getTransparentPixel(), true);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ImageWorker forceBitmaskIndexColorModel(int transparent, boolean errorDiffusion) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            void var8_14;
            LookupTableJAI lookupTable;
            int i;
            Object[] table;
            IndexColorModel oldCM = (IndexColorModel)cm;
            switch (oldCM.getTransparency()) {
                case 1: {
                    return this;
                }
                case 2: {
                    if (oldCM.getTransparentPixel() != transparent) break;
                    return this;
                }
            }
            int pixelSize = oldCM.getPixelSize();
            int mapSize = oldCM.getMapSize();
            int newSize = Math.max(mapSize, (transparent &= (1 << pixelSize) - 1) + 1);
            if (newSize <= 255) {
                table = new byte[mapSize];
                for (i = 0; i < mapSize; ++i) {
                    table[i] = (byte)(oldCM.getAlpha(i) == 0 ? transparent : i);
                }
                lookupTable = new LookupTableJAI(table);
            } else if (newSize <= 65535) {
                table = new short[mapSize];
                for (i = 0; i < mapSize; ++i) {
                    table[i] = (short)(oldCM.getAlpha(i) == 0 ? transparent : i);
                }
                lookupTable = new LookupTableJAI((short[])table, true);
            } else {
                throw new AssertionError(mapSize);
            }
            byte[][] rgb = new byte[3][newSize];
            oldCM.getReds(rgb[0]);
            oldCM.getGreens(rgb[1]);
            oldCM.getBlues(rgb[2]);
            IndexColorModel newCM = new IndexColorModel(pixelSize, newSize, rgb[0], rgb[1], rgb[2], transparent);
            RenderingHints hints = this.getRenderingHints();
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            layout.setColorModel((ColorModel)newCM);
            hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            hints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            this.image = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)var8_14, (RenderingHints)hints);
        } else {
            RenderedOp alphaChannel = null;
            if (cm.hasAlpha()) {
                this.tileCacheEnabled(false);
                int numBands = this.getNumBands();
                RenderingHints hints = this.getRenderingHints();
                alphaChannel = BandSelectDescriptor.create((RenderedImage)this.image, (int[])new int[]{--numBands}, (RenderingHints)hints);
                this.retainBands(numBands);
                this.forceIndexColorModel(errorDiffusion);
                this.tileCacheEnabled(true);
            }
            this.addTransparencyToIndexColorModel((RenderedImage)alphaChannel, false, transparent, errorDiffusion);
        }
        if (!$assertionsDisabled && !this.isIndexed()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isTranslucent()) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker forceIndexColorModelForGIF(boolean errorDiffusion) {
        this.tileCacheEnabled(false);
        if (this.image.getColorModel() instanceof PackedColorModel) {
            this.forceComponentColorModel();
        }
        this.rescaleToBytes();
        this.tileCacheEnabled(true);
        if (this.isTranslucent()) {
            this.forceBitmaskIndexColorModel(255, errorDiffusion);
        } else {
            this.forceIndexColorModel(errorDiffusion);
        }
        if (!$assertionsDisabled && !this.isBytes()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isIndexed()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isTranslucent()) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker forceComponentColorModel() {
        return this.forceComponentColorModel(false);
    }

    public final ImageWorker forceComponentColorModel(boolean checkTransparent) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof ComponentColorModel) {
            return this;
        }
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            boolean gray = ColorUtilities.isGrayPalette(icm, checkTransparent);
            boolean alpha = icm.hasAlpha();
            int numBands = icm.getNumComponents();
            byte[][] data = new byte[cm.getNumComponents()][icm.getMapSize()];
            icm.getReds(data[0]);
            icm.getGreens(data[1]);
            icm.getBlues(data[2]);
            if (numBands == 4) {
                icm.getAlphas(data[3]);
            }
            LookupTableJAI lut = new LookupTableJAI(data);
            RenderingHints hints = this.getRenderingHints();
            this.image = JAI.create((String)"Lookup", (RenderedImage)this.image, (Object)lut, (Object)hints);
            if (gray && !alpha) {
                this.retainBands(1);
            } else if (gray && alpha) {
                this.retainBands(new int[]{0, 3});
            }
        } else {
            int type = this.image.getSampleModel().getTransferType();
            RenderingHints hints = this.getRenderingHints(cm instanceof DirectColorModel ? 0 : type);
            this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)new Integer(cm instanceof DirectColorModel ? 0 : type), (RenderingHints)hints);
        }
        this.invalidateStatistics();
        if (!$assertionsDisabled && !(this.image.getColorModel() instanceof ComponentColorModel)) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker forceColorSpaceRGB() {
        if (!this.isColorSpaceRGB()) {
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
            this.image = ColorConvertDescriptor.create((RenderedImage)this.image, (ColorModel)cm, (RenderingHints)this.getRenderingHints());
            this.invalidateStatistics();
        }
        if (!$assertionsDisabled && !this.isColorSpaceRGB()) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker bandMerge(int writeband) {
        ParameterBlock pb = new ParameterBlock();
        PlanarImage sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)this.getRenderedImage());
        int numBands = sourceImage.getSampleModel().getNumBands();
        RenderedOp firstBand = JAI.create((String)"bandSelect", (RenderedImage)sourceImage, (Object)new int[]{0});
        int length = writeband - numBands;
        for (int i = 0; i < length; ++i) {
            pb.removeParameters();
            pb.removeSources();
            pb.addSource(sourceImage);
            pb.addSource(firstBand);
            sourceImage = JAI.create((String)"bandmerge", (ParameterBlock)pb);
            pb.removeParameters();
            pb.removeSources();
        }
        this.image = sourceImage;
        if (!$assertionsDisabled && this.image.getSampleModel().getNumBands() != writeband) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker forceColorSpaceGRAYScale() {
        if (!this.isColorSpaceRGB()) {
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
            this.image = ColorConvertDescriptor.create((RenderedImage)this.image, (ColorModel)cm, (RenderingHints)this.getRenderingHints());
            this.invalidateStatistics();
        }
        if (!$assertionsDisabled && !this.isColorSpaceGRAYScale()) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker intensity() {
        ColorModel cm = this.image.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        if (cs.getType() == 6 || cs instanceof IHSColorSpace) {
            this.retainFirstBand();
            return this;
        }
        if (cm instanceof IndexColorModel) {
            this.forceComponentColorModel();
            cm = this.image.getColorModel();
        }
        int numBands = cm.getNumComponents();
        int numColorBands = cm.getNumColorComponents();
        boolean hasAlpha = cm.hasAlpha();
        if (numBands == 1) {
            return this;
        }
        if (numColorBands == 1 && hasAlpha) {
            this.retainFirstBand();
            return this;
        }
        double[][] coeff = new double[1][numBands + 1];
        Arrays.fill(coeff[0], 0, numColorBands, 1.0 / (double)numColorBands);
        this.image = BandCombineDescriptor.create((RenderedImage)this.image, (double[][])coeff, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        if (!$assertionsDisabled && this.getNumBands() != 1) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker retainFirstBand() {
        this.retainBands(1);
        if (!$assertionsDisabled && this.getNumBands() != 1) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker retainLastBand() {
        this.retainBands(new int[]{this.getNumBands() - 1});
        if (!$assertionsDisabled && this.getNumBands() != 1) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker retainBands(int numBands) {
        if (this.getNumBands() > numBands) {
            int[] bands = new int[numBands];
            int length = bands.length;
            for (int i = 0; i < length; ++i) {
                bands[i] = i;
            }
            this.image = BandSelectDescriptor.create((RenderedImage)this.image, (int[])bands, (RenderingHints)this.getRenderingHints());
        }
        if (!$assertionsDisabled && this.getNumBands() > numBands) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker format(int dataType) {
        this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)new Integer(dataType), (RenderingHints)this.getRenderingHints());
        if (!$assertionsDisabled && this.image.getSampleModel().getDataType() != dataType) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker retainBands(int[] bands) {
        this.image = BandSelectDescriptor.create((RenderedImage)this.image, (int[])bands, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public final ImageWorker binarize() {
        this.binarize(Double.NaN);
        if (!$assertionsDisabled && !this.isBinary()) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker binarize(double threshold) {
        if (!this.isBinary()) {
            if (Double.isNaN(threshold)) {
                if (this.getNumBands() != 1) {
                    this.tileCacheEnabled(false);
                    this.intensity();
                    this.tileCacheEnabled(true);
                }
                double[][] extremas = this.getExtremas();
                threshold = 0.5 * (extremas[0][0] + extremas[1][0]);
            }
            RenderingHints hints = this.getRenderingHints();
            this.image = BinarizeDescriptor.create((RenderedImage)this.image, (Double)new Double(threshold), (RenderingHints)hints);
            this.invalidateStatistics();
        }
        if (!$assertionsDisabled && !this.isBinary()) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker binarize(int value0, int value1) {
        int max;
        this.tileCacheEnabled(false);
        this.binarize();
        this.tileCacheEnabled(true);
        int min = Math.min(value0, value1);
        LookupTableJAI table = min >= 0 ? ((max = Math.max(value0, value1)) < 256 ? new LookupTableJAI(new byte[]{(byte)value0, (byte)value1}) : (max < 65536 ? new LookupTableJAI(new short[]{(short)value0, (short)value1}, true) : new LookupTableJAI(new int[]{value0, value1}))) : new LookupTableJAI(new int[]{value0, value1});
        this.image = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)table, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public ImageWorker maskIndexColorModelByte(Color transparentColor) {
        int found;
        int transpColor;
        if (!$assertionsDisabled && !(this.image.getColorModel() instanceof IndexColorModel)) {
            throw new AssertionError();
        }
        if (transparentColor == null || this.image == null) {
            throw new IllegalArgumentException("One of the input arguments was null.");
        }
        transparentColor = new Color(transparentColor.getRed(), transparentColor.getGreen(), transparentColor.getBlue());
        IndexColorModel cm = (IndexColorModel)this.image.getColorModel();
        int numComponents = cm.getNumComponents();
        int transparency = cm.getTransparency();
        int transparencyIndex = cm.getTransparentPixel();
        int mapSize = cm.getMapSize();
        int tempTransparentColor = transparentColor.getRGB();
        if (transparency == 2 && transparencyIndex != -1 && (transpColor = ColorUtilities.getIntFromColor(cm.getRed(transparencyIndex), cm.getGreen(transparencyIndex), cm.getBlue(transparencyIndex), 255)) == tempTransparentColor) {
            return this;
        }
        ArrayList<Integer> transparentPixelsIndexes = new ArrayList<Integer>(10);
        for (int i = 0; i < mapSize; ++i) {
            Integer color = new Integer(ColorUtilities.getIntFromColor(cm.getRed(i), cm.getGreen(i), cm.getBlue(i), 255));
            if (tempTransparentColor != color) continue;
            transparentPixelsIndexes.add(new Integer(i));
            if (2 == transparency) break;
        }
        if ((found = transparentPixelsIndexes.size()) == 1) {
            transparencyIndex = (Integer)transparentPixelsIndexes.get(0);
            transparency = 2;
        } else {
            if (found <= 0) {
                return this;
            }
            transparencyIndex = -1;
            transparency = 3;
        }
        byte[][] rgb = new byte[4][mapSize];
        Arrays.fill(rgb[3], (byte)-1);
        cm.getReds(rgb[0]);
        cm.getGreens(rgb[1]);
        cm.getBlues(rgb[2]);
        if (numComponents == 4) {
            cm.getAlphas(rgb[3]);
        }
        if (transparency != 3) {
            cm = new IndexColorModel(cm.getPixelSize(), mapSize, rgb[0], rgb[1], rgb[2], transparencyIndex);
        } else {
            for (int k = 0; k < found; ++k) {
                rgb[3][((Integer)transparentPixelsIndexes.get((int)k)).intValue()] = 0;
            }
            cm = new IndexColorModel(cm.getPixelSize(), mapSize, rgb[0], rgb[1], rgb[2], rgb[3]);
        }
        ImageLayout layout = new ImageLayout(this.image);
        layout.setColorModel((ColorModel)cm);
        RenderingHints hints = this.getRenderingHints();
        hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
        this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)new Integer(this.image.getSampleModel().getDataType()), (RenderingHints)hints);
        this.invalidateStatistics();
        return this;
    }

    public ImageWorker maskComponentColorModelByte(Color transparentColor) {
        if (!$assertionsDisabled && !(this.image.getColorModel() instanceof ComponentColorModel)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.image.getSampleModel().getDataType() != 0) {
            throw new AssertionError();
        }
        int numBands = this.image.getSampleModel().getNumBands();
        int numColorBands = this.image.getColorModel().getNumColorComponents();
        RenderedOp transparentBand = null;
        if (numColorBands != numBands) {
            transparentBand = BandSelectDescriptor.create((RenderedImage)this.image, (int[])new int[]{numBands - 1}, (RenderingHints)this.getRenderingHints());
            this.image = numBands == 2 ? BandSelectDescriptor.create((RenderedImage)this.image, (int[])new int[]{0}, (RenderingHints)this.getRenderingHints()) : BandSelectDescriptor.create((RenderedImage)this.image, (int[])new int[]{0, 1, 2}, (RenderingHints)this.getRenderingHints());
        }
        boolean singleStep = numColorBands == 1;
        int numDestinationBands = numColorBands;
        byte[][] tableData = new byte[numDestinationBands][256];
        int r = transparentColor.getRed();
        int g = transparentColor.getGreen();
        int b = transparentColor.getBlue();
        for (int i = 0; i < 256; ++i) {
            block6: for (int j = 0; j < numDestinationBands; ++j) {
                tableData[j][i] = -1;
                switch (j) {
                    case 0: {
                        if (i == r) {
                            tableData[j][i] = 0;
                            continue block6;
                        }
                        if (singleStep) continue block6;
                        tableData[j][i] = (byte)i;
                        continue block6;
                    }
                    case 1: {
                        if (!$assertionsDisabled && singleStep) {
                            throw new AssertionError();
                        }
                        if (i == g) {
                            tableData[j][i] = 0;
                            continue block6;
                        }
                        tableData[j][i] = 0;
                        continue block6;
                    }
                    case 2: {
                        if (!$assertionsDisabled && singleStep) {
                            throw new AssertionError();
                        }
                        if (i != b) continue block6;
                        tableData[j][i] = 0;
                    }
                }
            }
        }
        LookupTableJAI table = new LookupTableJAI(tableData);
        PlanarImage luImage = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)table, (RenderingHints)this.getRenderingHints()).getRendering();
        if (!singleStep) {
            double[][] matrix = new double[1][4];
            matrix[0][0] = 1.0;
            matrix[0][1] = 1.0;
            matrix[0][2] = 1.0;
            matrix[0][3] = 0.0;
            luImage = BandCombineDescriptor.create((RenderedImage)luImage, (double[][])matrix, (RenderingHints)this.getRenderingHints());
            if (transparentBand != null) {
                luImage = new ImageWorker((RenderedImage)luImage).binarize(254.0).forceComponentColorModel().retainBands(1).getPlanarImage();
                luImage = MultiplyDescriptor.create((RenderedImage)transparentBand, (RenderedImage)luImage, (RenderingHints)this.getRenderingHints());
            }
        }
        this.image = BandMergeDescriptor.create((RenderedImage)this.image, (RenderedImage)luImage, (RenderingHints)this.getRenderingHints()).getRendering();
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker invert() {
        this.image = InvertDescriptor.create((RenderedImage)this.image, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker mask(RenderedImage mask, boolean maskValue, int newValue) {
        this.tileCacheEnabled(false);
        this.forceIndexColorModel(true);
        RenderingHints hints = new RenderingHints(JAI.KEY_TILE_CACHE, null);
        if (newValue == 255 && !maskValue) {
            byte[] lutData = new byte[256];
            Arrays.fill(lutData, (byte)0);
            lutData[0] = -1;
            LookupTableJAI lut = new LookupTableJAI(lutData);
            mask = LookupDescriptor.create((RenderedImage)mask, (LookupTableJAI)lut, (RenderingHints)hints);
            this.image = AddDescriptor.create((RenderedImage)this.image, (RenderedImage)mask, (RenderingHints)this.getRenderingHints());
            this.tileCacheEnabled(true);
            this.invalidateStatistics();
            return this;
        }
        if (!this.isBinary()) {
            this.binarize();
        }
        if (maskValue) {
            mask = NotDescriptor.create((RenderedImage)mask, (RenderingHints)new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
        }
        this.tileCacheEnabled(false);
        this.image = AndDescriptor.create((RenderedImage)mask, (RenderedImage)this.image, (RenderingHints)this.getRenderingHints());
        mask = AddConstDescriptor.create((RenderedImage)mask, (double[])new double[]{newValue}, (RenderingHints)new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
        this.image = AddDescriptor.create((RenderedImage)mask, (RenderedImage)this.image, (RenderingHints)this.getRenderingHints());
        this.tileCacheEnabled(true);
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker addImage(RenderedImage renderedImage) {
        this.image = AddDescriptor.create((RenderedImage)this.image, (RenderedImage)renderedImage, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker multiplyConst(double[] inValues) {
        this.image = MultiplyConstDescriptor.create((RenderedImage)this.image, (double[])inValues, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker xorConst(int[] values) {
        this.image = XorConstDescriptor.create((RenderedImage)this.image, (int[])values, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public ImageWorker addTransparencyToIndexColorModel(RenderedImage alphaChannel, boolean errorDiffusion) {
        this.addTransparencyToIndexColorModel(alphaChannel, true, this.getTransparentPixel(), errorDiffusion);
        return this;
    }

    public final ImageWorker addTransparencyToIndexColorModel(RenderedImage alphaChannel, boolean translucent, int transparent, boolean errorDiffusion) {
        boolean forceBitmask;
        this.tileCacheEnabled(false);
        this.forceIndexColorModel(errorDiffusion);
        this.tileCacheEnabled(true);
        ImageWorker worker = this.fork(this.image);
        RenderingHints hints = worker.getRenderingHints();
        IndexColorModel oldCM = (IndexColorModel)this.image.getColorModel();
        int pixelSize = oldCM.getPixelSize();
        boolean bl = forceBitmask = !translucent && oldCM.getTransparency() == 3;
        if (forceBitmask || oldCM.getTransparentPixel() != (transparent &= (1 << pixelSize) - 1)) {
            IndexColorModel newCM;
            int mapSize = Math.max(oldCM.getMapSize(), transparent + 1);
            byte[][] RGBA = new byte[translucent ? 4 : 3][mapSize];
            oldCM.getReds(RGBA[0]);
            oldCM.getGreens(RGBA[1]);
            oldCM.getBlues(RGBA[2]);
            if (translucent) {
                oldCM.getAlphas(RGBA[3]);
                RGBA[3][transparent] = 0;
                newCM = new IndexColorModel(pixelSize, mapSize, RGBA[0], RGBA[1], RGBA[2], RGBA[3]);
            } else {
                newCM = new IndexColorModel(pixelSize, mapSize, RGBA[0], RGBA[1], RGBA[2], transparent);
            }
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            layout.setColorModel((ColorModel)newCM);
            worker.setRenderingHint(JAI.KEY_IMAGE_LAYOUT, layout);
        }
        worker.setRenderingHint(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        worker.mask(alphaChannel, false, transparent);
        this.image = worker.image;
        this.invalidateStatistics();
        if (!$assertionsDisabled && !this.isIndexed()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !translucent && this.isTranslucent()) {
            throw new AssertionError(translucent);
        }
        if (!$assertionsDisabled && ((IndexColorModel)this.image.getColorModel()).getAlpha(transparent) != 0) {
            throw new AssertionError();
        }
        return this;
    }

    public final ImageWorker tile() {
        RenderingHints hints = this.getRenderingHints();
        ImageLayout layout = ImageWorker.getImageLayout(hints);
        if (layout.isValid(64) || layout.isValid(128)) {
            int type = this.image.getSampleModel().getDataType();
            this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)new Integer(type), (RenderingHints)hints);
        }
        return this;
    }

    public final ImageWorker write(File output) throws IOException {
        String filename = output.getName();
        int dot = filename.lastIndexOf(46);
        if (dot < 0) {
            throw new IIOException(Errors.format(192));
        }
        String extension = filename.substring(dot + 1).trim();
        this.write(output, ImageIO.getImageWritersBySuffix(extension));
        return this;
    }

    public final ImageWorker writeGIF(Object destination, String compression, float compressionRate) throws IOException {
        this.tileCacheEnabled(false);
        this.forceIndexColorModelForGIF(true);
        this.tileCacheEnabled(true);
        ImageOutputStream ios = ImageIO.createImageOutputStream(destination);
        GIFImageWriter gifWriter = new GIFImageWriter(gifSPI);
        ImageWriteParam iwp = gifWriter.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionType(compression);
        iwp.setCompressionQuality(compressionRate);
        gifWriter.setOutput(ios);
        gifWriter.write(null, new IIOImage(this.image, null, null), iwp);
        ios.flush();
        gifWriter.dispose();
        return this;
    }

    public final void writeJPEG(Object destination, String compression, float compressionRate, boolean nativeAcc) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Encoding input image to write out as JPEG.");
        }
        this.tileCacheEnabled(false);
        ColorModel cm = this.image.getColorModel();
        boolean indexColorModel = this.image.getColorModel() instanceof IndexColorModel;
        int numBands = this.image.getSampleModel().getNumBands();
        boolean hasAlpha = cm.hasAlpha();
        if (indexColorModel || hasAlpha) {
            if (indexColorModel) {
                this.forceComponentColorModel();
            }
            if (hasAlpha) {
                this.retainBands(numBands - 1);
            }
        }
        this.tileCacheEnabled(true);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting a JPEG writer and configuring it.");
        }
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("JPEG");
        ImageWriter writer = null;
        if (!it.hasNext()) {
            throw new IllegalStateException("No JPEG ImageWriter found");
        }
        writer = it.next();
        if (writer.getClass().getName().equals("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter") && !nativeAcc) {
            writer = it.next();
        }
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        ImageOutputStream outStream = ImageIO.createImageOutputStream(destination);
        iwp.setCompressionMode(2);
        iwp.setCompressionType(compression);
        iwp.setCompressionQuality(compressionRate);
        writer.setOutput(outStream);
        if (iwp instanceof JPEGImageWriteParam) {
            ((JPEGImageWriteParam)iwp).setOptimizeHuffmanTables(true);
            try {
                ((JPEGImageWriteParam)iwp).setProgressiveMode(1);
            }
            catch (UnsupportedOperationException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                throw (IOException)new IOException().initCause(e);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing out...");
        }
        writer.write(null, new IIOImage(this.image, null, null), iwp);
        outStream.flush();
        writer.dispose();
        outStream.close();
    }

    private ImageWorker write(Object output, Iterator encoders) throws IOException {
        if (encoders != null) {
            while (encoders.hasNext()) {
                ImageOutputStream stream;
                Class[] outputTypes;
                ImageWriter writer = (ImageWriter)encoders.next();
                ImageWriterSpi spi = writer.getOriginatingProvider();
                if (spi == null) {
                    outputTypes = ImageWriterSpi.STANDARD_OUTPUT_TYPE;
                } else {
                    String[] formats = spi.getFormatNames();
                    if (ImageWorker.containsFormatName(formats, "gif")) {
                        this.forceIndexColorModelForGIF(true);
                    } else {
                        this.tile();
                    }
                    if (!spi.canEncodeImage(this.image)) continue;
                    outputTypes = spi.getOutputTypes();
                }
                if (ImageWorker.acceptInputType(outputTypes, output.getClass())) {
                    writer.setOutput(output);
                    stream = null;
                } else {
                    if (!ImageWorker.acceptInputType(outputTypes, class$javax$imageio$stream$ImageOutputStream == null ? ImageWorker.class$("javax.imageio.stream.ImageOutputStream") : class$javax$imageio$stream$ImageOutputStream)) continue;
                    stream = ImageIO.createImageOutputStream(output);
                    writer.setOutput(stream);
                }
                writer.write(this.image);
                writer.dispose();
                if (stream != null) {
                    stream.close();
                }
                return this;
            }
        }
        throw new IIOException(Errors.format(192));
    }

    private static boolean acceptInputType(Class[] types, Class searchFor) {
        int length;
        int i = length = types.length;
        while (--i >= 0) {
            if (!searchFor.isAssignableFrom(types[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFormatName(String[] formats, String searchFor) {
        int length;
        int i = length = formats.length;
        while (--i >= 0) {
            if (!searchFor.equalsIgnoreCase(formats[i])) continue;
            return true;
        }
        return false;
    }

    public final ImageWorker show() throws HeadlessException {
        Class<?> c;
        try {
            c = Class.forName("org.geotools.gui.swing.image.OperationTreeBrowser");
        }
        catch (ClassNotFoundException cause) {
            HeadlessException e = new HeadlessException("The \"gt2-widgets-swing.jar\" file is required.");
            e.initCause(cause);
            throw e;
        }
        try {
            c.getMethod("show", RenderedImage.class).invoke(null, this.image);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new AssertionError((Object)e);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        String operation = arguments.getOptionalString("-operation");
        args = arguments.getRemainingArguments(1);
        if (args.length != 0) {
            try {
                ImageWorker worker = new ImageWorker(new File(args[0]));
                worker.setRenderingHint(JAI.KEY_TILE_CACHE, JAI.getDefaultInstance().getTileCache());
                if (operation != null) {
                    worker.getClass().getMethod(operation, null).invoke((Object)worker, null);
                }
                worker.show();
            }
            catch (FileNotFoundException e) {
                arguments.printSummary(e);
            }
            catch (NoSuchMethodException e) {
                arguments.printSummary(e);
            }
            catch (Exception e) {
                e.printStackTrace(arguments.err);
            }
        }
    }

    public final void writePNG(Object destination, String compression, float compressionRate, boolean nativeAcc, boolean paletted) throws IOException {
        this.tileCacheEnabled(false);
        if (!paletted) {
            this.forceComponentColorModel();
        } else {
            this.forceIndexColorModelForGIF(true);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Encoded input image for png writer");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting a writer");
        }
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("PNG");
        ImageWriter writer = null;
        if (!it.hasNext()) {
            throw new IllegalStateException("No PNG ImageWriter found");
        }
        writer = it.next();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Setting write parameters for this writer");
        }
        ImageWriteParam iwp = null;
        ImageOutputStream memOutStream = ImageIO.createImageOutputStream(destination);
        if (writer.getClass().getName().equals("com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter") && nativeAcc) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Writer is native");
            }
            iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionType(compression);
            iwp.setCompressionQuality(compressionRate);
            iwp.setDestinationType(new ImageTypeSpecifier(this.image.getColorModel(), this.image.getSampleModel()));
        } else {
            if (writer.getClass().getName().equals("com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter") && nativeAcc) {
                writer = it.next();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Writer is NOT native");
            }
            iwp = new PNGImageWriteParam();
            iwp.setCompressionMode(1);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to write png image");
        }
        writer.setOutput(memOutStream);
        writer.write(null, new IIOImage(this.image, null, null), iwp);
        this.tileCacheEnabled(true);
        memOutStream.flush();
        writer.dispose();
        memOutStream.close();
    }

    static {
        $assertionsDisabled = !ImageWorker.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger("org.geotools.image");
        TILING_ALLOWED = new Hints.Key(Boolean.class);
        gifSPI = new GIFImageWriterSpi();
    }

    public static final class PNGImageWriteParam
    extends ImageWriteParam {
        public PNGImageWriteParam() {
            this.canWriteProgressive = true;
            this.canWriteCompressed = true;
            this.locale = Locale.getDefault();
        }
    }
}

